/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.DebuggerRecents;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerEditorImpl
extends CompletionEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.DebuggerEditorImpl");
    public static final char SEPARATOR = '\r';
    private final Project myProject;
    private PsiElement myContext;
    private final String myRecentsId;
    private final List<DocumentListener> myDocumentListeners = new ArrayList<DocumentListener>();
    private Document myCurrentDocument;
    private final PsiTreeChangeListener myPsiListener = new PsiTreeChangeAdapter(){

        public void childRemoved(PsiTreeChangeEvent event) {
            this.checkContext();
        }

        public void childReplaced(PsiTreeChangeEvent event) {
            this.checkContext();
        }

        public void childMoved(PsiTreeChangeEvent event) {
            this.checkContext();
        }

        private void checkContext() {
            PsiElement contextElement = DebuggerEditorImpl.this.getContext();
            if (contextElement == null || !contextElement.isValid()) {
                DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(DebuggerEditorImpl.this.myProject).getContextManager().getContext();
                PsiElement newContextElement = PositionUtil.getContextElement((StackFrameContext)context);
                DebuggerEditorImpl.this.setContext(newContextElement != null && newContextElement.isValid() ? newContextElement : null);
            }
        }
    };
    protected CodeFragmentFactory myFactory;

    public DebuggerEditorImpl(Project project, PsiElement context, String recentsId, CodeFragmentFactory factory) {
        this.myProject = project;
        this.myContext = context;
        this.myRecentsId = recentsId;
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener(this.myPsiListener);
        this.myFactory = factory;
    }

    protected TextWithImports createItem(Document document, Project project) {
        if (document != null) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                return this.createText(psiFile.getText(), ((JavaCodeFragment)psiFile).importsToString());
            }
        }
        return this.createText("");
    }

    protected TextWithImports createText(String text) {
        return this.createText(text, "");
    }

    protected abstract TextWithImports createText(String var1, String var2);

    public abstract JComponent getPreferredFocusedComponent();

    @Override
    public void setContext(PsiElement context) {
        TextWithImports text = this.getText();
        this.myContext = context;
        this.setText(text);
    }

    @Override
    public PsiElement getContext() {
        return this.myContext;
    }

    protected Project getProject() {
        return this.myProject;
    }

    @Override
    public void requestFocus() {
        this.getPreferredFocusedComponent().requestFocus();
    }

    @Nullable
    protected Document createDocument(TextWithImports item) {
        PsiClass contextClass;
        LOG.assertTrue(this.myContext == null || this.myContext.isValid());
        if (item == null) {
            item = this.createText("");
        }
        JavaCodeFragment codeFragment = this.myFactory.createPresentationCodeFragment(item, this.myContext, this.getProject());
        codeFragment.forceResolveScope(GlobalSearchScope.allScope((Project)this.myProject));
        if (this.myContext != null && (contextClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myContext, (Class[])new Class[]{PsiClass.class})) != null) {
            PsiClassType contextType = JavaPsiFacade.getInstance((Project)codeFragment.getProject()).getElementFactory().createType(contextClass);
            codeFragment.setThisType((PsiType)contextType);
        }
        if (this.myCurrentDocument != null) {
            for (DocumentListener documentListener : this.myDocumentListeners) {
                this.myCurrentDocument.removeDocumentListener(documentListener);
            }
        }
        this.myCurrentDocument = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument((PsiFile)codeFragment);
        if (this.myCurrentDocument != null) {
            for (DocumentListener documentListener : this.myDocumentListeners) {
                this.myCurrentDocument.addDocumentListener(documentListener);
            }
        }
        return this.myCurrentDocument;
    }

    @Override
    public String getRecentsId() {
        return this.myRecentsId;
    }

    public void addRecent(TextWithImports text) {
        if (this.getRecentsId() != null && text != null && !"".equals(text.getText())) {
            DebuggerRecents.getInstance(this.getProject()).addRecent(this.getRecentsId(), text);
        }
    }

    public void addDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.add(listener);
        if (this.myCurrentDocument != null) {
            this.myCurrentDocument.addDocumentListener(listener);
        }
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.remove(listener);
        if (this.myCurrentDocument != null) {
            this.myCurrentDocument.removeDocumentListener(listener);
        }
    }

    @Override
    public void dispose() {
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener(this.myPsiListener);
    }

    public void setFactory(CodeFragmentFactory factory) {
        this.myFactory = factory;
    }

    @Override
    public void revalidate() {
        this.setText(this.getText());
    }
}

