/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameReturnValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.GlobalJavaInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameReturnValueInspection
extends GlobalJavaInspectionTool {
    @Nullable
    public CommonProblemDescriptor[] checkElement(RefEntity refEntity, AnalysisScope scope, InspectionManager manager, GlobalInspectionContext globalContext, ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isConstructor()) {
                return null;
            }
            if (refMethod.hasSuperMethods()) {
                return null;
            }
            String returnValue = refMethod.getReturnValueIfSame();
            if (returnValue != null) {
                String message = refMethod.getDerivedMethods().isEmpty() ? InspectionsBundle.message((String)"inspection.same.return.value.problem.descriptor", (Object[])new Object[]{"<code>" + returnValue + "</code>"}) : (refMethod.hasBody() ? InspectionsBundle.message((String)"inspection.same.return.value.problem.descriptor1", (Object[])new Object[]{"<code>" + returnValue + "</code>"}) : InspectionsBundle.message((String)"inspection.same.return.value.problem.descriptor2", (Object[])new Object[]{"<code>" + returnValue + "</code>"}));
                return new ProblemDescriptor[]{manager.createProblemDescriptor(refMethod.getElement().getNavigationElement(), message, false, (LocalQuickFix[])null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
            }
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(RefManager manager, final GlobalJavaInspectionContext globalContext, final ProblemDescriptionsProcessor processor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (refEntity instanceof RefElement && processor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final RefMethod refMethod) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                public boolean process(PsiMethod derivedMethod) {
                                    processor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.same.return.value.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("SameReturnValue" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/sameReturnValue/SameReturnValueInspection.getShortName must not return null");
        }
        return "SameReturnValue";
    }
}

