/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.redundantCast;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RedundantCastInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.redundantCast.RedundantCastInspection");
    private final LocalQuickFix myQuickFixAction = new AcceptSuggested();
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.redundant.cast.display.name", (Object[])new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "RedundantCast";

    @Override
    public ProblemDescriptor[] getDescriptions(PsiElement where, InspectionManager manager, boolean isOnTheFly) {
        List redundantCasts = RedundantCastUtil.getRedundantCastsInside((PsiElement)where);
        if (redundantCasts.isEmpty()) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptions = new ArrayList<ProblemDescriptor>(redundantCasts.size());
        for (PsiTypeCastExpression redundantCast : redundantCasts) {
            ProblemDescriptor descriptor = this.createDescription(redundantCast, manager, isOnTheFly);
            if (descriptor == null) continue;
            descriptions.add(descriptor);
        }
        if (descriptions.isEmpty()) {
            return null;
        }
        return descriptions.toArray(new ProblemDescriptor[descriptions.size()]);
    }

    private ProblemDescriptor createDescription(@NotNull PsiTypeCastExpression cast, @NotNull InspectionManager manager, boolean onTheFly) {
        if (cast == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/redundantCast/RedundantCastInspection.createDescription must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/redundantCast/RedundantCastInspection.createDescription must not be null");
        }
        PsiExpression operand = cast.getOperand();
        PsiTypeElement castType = cast.getCastType();
        if (operand == null || castType == null) {
            return null;
        }
        String message = InspectionsBundle.message((String)"inspection.redundant.cast.problem.descriptor", (Object[])new Object[]{"<code>" + operand.getText() + "</code>", "<code>#ref</code> #loc"});
        return manager.createProblemDescriptor((PsiElement)castType, message, this.myQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly);
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/redundantCast/RedundantCastInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/redundantCast/RedundantCastInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/redundantCast/RedundantCastInspection.getShortName must not return null");
        }
        return SHORT_NAME;
    }

    private static void removeCast(PsiTypeCastExpression castExpression) {
        if (castExpression == null) {
            return;
        }
        PsiExpression operand = castExpression.getOperand();
        if (operand instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parExpr = (PsiParenthesizedExpression)operand;
            operand = parExpr.getExpression();
        }
        if (operand == null) {
            return;
        }
        PsiTypeCastExpression toBeReplaced = castExpression;
        PsiElement parent = castExpression.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            toBeReplaced = parent;
            parent = parent.getParent();
        }
        try {
            toBeReplaced.replace((PsiElement)operand);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private AcceptSuggested() {
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.cast.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested.getName must not return null");
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiTypeCastExpression cast;
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested.applyFix must not be null");
            }
            if (!CodeInsightUtilBase.preparePsiElementForWrite(descriptor.getPsiElement())) {
                return;
            }
            PsiElement castTypeElement = descriptor.getPsiElement();
            PsiTypeCastExpression psiTypeCastExpression = cast = castTypeElement == null ? null : (PsiTypeCastExpression)castTypeElement.getParent();
            if (cast != null) {
                RedundantCastInspection.removeCast(cast);
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInspection/redundantCast/RedundantCastInspection$AcceptSuggested.getFamilyName must not return null");
            }
            return string;
        }
    }
}

