/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorComposer;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalQuickFixWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jetbrains.annotations.Nullable;

public abstract class DescriptorProviderInspection
extends InspectionTool
implements ProblemDescriptionsProcessor {
    private Map<RefEntity, CommonProblemDescriptor[]> myProblemElements;
    private com.intellij.util.containers.HashMap<String, Set<RefEntity>> myContents = null;
    private HashSet<RefModule> myModulesProblems = null;
    private Map<CommonProblemDescriptor, RefEntity> myProblemToElements;
    private DescriptorComposer myComposer;
    private Map<RefEntity, Set<QuickFix>> myQuickFixActions;
    private Map<RefEntity, CommonProblemDescriptor[]> myIgnoredElements;
    private com.intellij.util.containers.HashMap<RefEntity, CommonProblemDescriptor[]> myOldProblemElements = null;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.DescriptorProviderInspection");

    public void addProblemElement(RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        this.addProblemElement(refElement, true, descriptions);
    }

    protected void addProblemElement(RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptions) {
        if (refElement == null) {
            return;
        }
        if (descriptions == null || descriptions.length == 0) {
            return;
        }
        if (filterSuppressed) {
            if (ourOutputPath == null || !(this instanceof LocalInspectionToolWrapper)) {
                Object[] problems = this.getProblemElements().get(refElement);
                problems = problems == null ? descriptions : (CommonProblemDescriptor[])ArrayUtil.mergeArrays((Object[])problems, (Object[])descriptions, CommonProblemDescriptor.class);
                this.getProblemElements().put(refElement, (CommonProblemDescriptor[])problems);
                for (CommonProblemDescriptor description : descriptions) {
                    this.getProblemToElements().put(description, refElement);
                    this.collectQuickFixes(description.getFixes(), refElement);
                }
            } else {
                this.writeOutput(descriptions, refElement);
            }
        } else {
            for (CommonProblemDescriptor description : descriptions) {
                this.getProblemToElements().put(description, refElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(CommonProblemDescriptor[] descriptions, RefEntity refElement) {
        Element parentNode = new Element(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0]));
        this.exportResults(descriptions, refElement, parentNode);
        List list = parentNode.getChildren();
        String ext = ".xml";
        String fileName = ourOutputPath + File.separator + this.getShortName() + ".xml";
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)this.getContext().getProject());
        PrintWriter printWriter = null;
        try {
            new File(ourOutputPath).mkdirs();
            File file = new File(fileName);
            CharArrayWriter writer = new CharArrayWriter();
            if (!file.exists()) {
                writer.append("<").append(InspectionsBundle.message((String)"inspection.problems", (Object[])new Object[0])).append(" is_local_tool=\"").append(Boolean.toString(this instanceof LocalInspectionToolWrapper)).append("\">\n");
            }
            for (Object o : list) {
                Element element = (Element)o;
                pathMacroManager.collapsePaths(element);
                JDOMUtil.writeElement((Element)element, (Writer)writer, (String)"\n");
            }
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            printWriter.append("\n");
            printWriter.append(writer.toString());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        return this.getProblemToElements().keySet();
    }

    private void collectQuickFixes(QuickFix[] fixes, RefEntity refEntity) {
        if (fixes != null) {
            HashSet localQuickFixes = this.getQuickFixActions().get(refEntity);
            if (localQuickFixes == null) {
                localQuickFixes = new HashSet();
                this.getQuickFixActions().put(refEntity, (Set<QuickFix>)localQuickFixes);
            }
            localQuickFixes.addAll(Arrays.asList(fixes));
        }
    }

    public void ignoreElement(RefEntity refEntity) {
        if (refEntity == null) {
            return;
        }
        this.getProblemElements().remove(refEntity);
        this.getQuickFixActions().remove(refEntity);
    }

    @Override
    public void ignoreCurrentElement(RefEntity refEntity) {
        if (refEntity == null) {
            return;
        }
        this.getIgnoredElements().put(refEntity, this.getProblemElements().get(refEntity));
    }

    @Override
    public void amnesty(RefEntity refEntity) {
        this.getIgnoredElements().remove(refEntity);
    }

    public void ignoreProblem(RefEntity refEntity, CommonProblemDescriptor problem, int idx) {
        if (refEntity == null) {
            return;
        }
        Set<QuickFix> localQuickFixes = this.getQuickFixActions().get(refEntity);
        QuickFix[] fixes = problem.getFixes();
        if (DescriptorProviderInspection.isIgnoreProblem(fixes, localQuickFixes, idx)) {
            this.getProblemToElements().remove(problem);
            CommonProblemDescriptor[] descriptors = this.getProblemElements().get(refEntity);
            if (descriptors != null) {
                ArrayList<CommonProblemDescriptor> newDescriptors = new ArrayList<CommonProblemDescriptor>(Arrays.asList(descriptors));
                newDescriptors.remove(problem);
                this.getQuickFixActions().put(refEntity, null);
                if (!newDescriptors.isEmpty()) {
                    this.getProblemElements().put(refEntity, newDescriptors.toArray(new CommonProblemDescriptor[newDescriptors.size()]));
                    for (CommonProblemDescriptor descriptor : newDescriptors) {
                        this.collectQuickFixes(descriptor.getFixes(), refEntity);
                    }
                } else {
                    this.ignoreProblemElement(refEntity);
                }
            }
        }
    }

    private void ignoreProblemElement(RefEntity refEntity) {
        CommonProblemDescriptor[] problemDescriptors = this.getProblemElements().remove(refEntity);
        this.getIgnoredElements().put(refEntity, problemDescriptors);
    }

    private static boolean isIgnoreProblem(QuickFix[] problemFixes, Set<QuickFix> fixes, int idx) {
        if (problemFixes == null || fixes == null) {
            return true;
        }
        if (problemFixes.length <= idx) {
            return true;
        }
        for (QuickFix fix : problemFixes) {
            if (fix == problemFixes[idx] || fixes.contains(fix)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        GlobalInspectionContextImpl context = this.getContext();
        if (context != null && context.getUIOptions().SHOW_DIFF_WITH_PREVIOUS_RUN) {
            if (this.myOldProblemElements == null) {
                this.myOldProblemElements = new com.intellij.util.containers.HashMap();
            }
            this.myOldProblemElements.clear();
            this.myOldProblemElements.putAll(this.getIgnoredElements());
            this.myOldProblemElements.putAll(this.getProblemElements());
        } else {
            this.myOldProblemElements = null;
        }
        this.myProblemElements = null;
        this.myProblemToElements = null;
        this.myQuickFixActions = null;
        this.myIgnoredElements = null;
        this.myContents = null;
        this.myModulesProblems = null;
    }

    @Override
    public void finalCleanup() {
        super.finalCleanup();
        this.myOldProblemElements = null;
    }

    @Nullable
    public CommonProblemDescriptor[] getDescriptions(RefEntity refEntity) {
        CommonProblemDescriptor[] problems = this.getProblemElements().get(refEntity);
        if (problems == null) {
            return null;
        }
        if (!refEntity.isValid()) {
            this.ignoreElement(refEntity);
            return null;
        }
        return problems;
    }

    @Override
    public HTMLComposerImpl getComposer() {
        if (this.myComposer == null) {
            this.myComposer = new DescriptorComposer(this);
        }
        return this.myComposer;
    }

    @Override
    public void exportResults(final Element parentNode) {
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(RefEntity refEntity) {
                if (DescriptorProviderInspection.this.getProblemElements().containsKey(refEntity)) {
                    CommonProblemDescriptor[] descriptions = DescriptorProviderInspection.this.getDescriptions(refEntity);
                    DescriptorProviderInspection.this.exportResults(descriptions, refEntity, parentNode);
                }
            }
        });
    }

    private void exportResults(CommonProblemDescriptor[] descriptions, RefEntity refEntity, Element parentNode) {
        for (CommonProblemDescriptor description : descriptions) {
            String template = description.getDescriptionTemplate();
            int line = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getLineNumber() : -1;
            String text = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getPsiElement().getText() : "";
            String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)StringUtil.quoteReplacement((String)text)), (String)" #loc ", (String)" ");
            Element element = refEntity.getRefManager().export(refEntity, parentNode, line);
            Element problemClassElement = new Element(InspectionsBundle.message((String)"inspection.export.results.problem.element.tag", (Object[])new Object[0]));
            problemClassElement.addContent(this.getDisplayName());
            if (refEntity instanceof RefElement) {
                RefElement refElement = (RefElement)refEntity;
                HighlightSeverity severity = this.getCurrentSeverity(refElement);
                ProblemHighlightType problemHighlightType = description instanceof ProblemDescriptor ? ((ProblemDescriptor)description).getHighlightType() : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                String attributeKey = DescriptorProviderInspection.getTextAttributeKey(refElement.getElement().getProject(), severity, problemHighlightType);
                problemClassElement.setAttribute("severity", severity.myName);
                problemClassElement.setAttribute("attribute_key", attributeKey);
            }
            element.addContent(problemClassElement);
            if (this instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionTool globalInspectionTool = ((GlobalInspectionToolWrapper)this).getTool();
                QuickFix[] fixes = description.getFixes();
                if (fixes != null) {
                    Element hintsElement = new Element("hints");
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        Element hintElement = new Element("hint");
                        hintElement.setAttribute("value", hint);
                        hintsElement.addContent(hintElement);
                    }
                    element.addContent(hintsElement);
                }
            }
            try {
                Element descriptionElement = new Element(InspectionsBundle.message((String)"inspection.export.results.description.tag", (Object[])new Object[0]));
                descriptionElement.addContent(problemText);
                element.addContent(descriptionElement);
            }
            catch (IllegalDataException e) {
                System.out.println("Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.getShortName());
            }
        }
    }

    @Override
    public boolean isGraphNeeded() {
        return false;
    }

    @Override
    public boolean hasReportedProblems() {
        GlobalInspectionContextImpl context = this.getContext();
        if (context != null && context.getUIOptions().SHOW_ONLY_DIFF) {
            for (CommonProblemDescriptor descriptor : this.getProblemToElements().keySet()) {
                if (this.getProblemStatus(descriptor) == FileStatus.NOT_CHANGED) continue;
                return true;
            }
            if (this.myOldProblemElements != null) {
                for (RefEntity entity : this.myOldProblemElements.keySet()) {
                    if (this.getElementStatus(entity) == FileStatus.NOT_CHANGED) continue;
                    return true;
                }
            }
            return false;
        }
        if (!this.getProblemElements().isEmpty()) {
            return true;
        }
        return context != null && context.getUIOptions().SHOW_DIFF_WITH_PREVIOUS_RUN && this.myOldProblemElements != null && !this.myOldProblemElements.isEmpty();
    }

    @Override
    public void updateContent() {
        this.myContents = new com.intellij.util.containers.HashMap();
        this.myModulesProblems = new HashSet();
        Set<RefEntity> elements = this.getProblemElements().keySet();
        for (RefEntity element : elements) {
            if (this.getContext().getUIOptions().FILTER_RESOLVED_ITEMS && this.getIgnoredElements().containsKey(element)) continue;
            if (element instanceof RefModule) {
                this.myModulesProblems.add((Object)((RefModule)element));
                continue;
            }
            String groupName = element instanceof RefElement ? element.getRefManager().getGroupName((RefElement)element) : null;
            Set content = (Set)this.myContents.get((Object)groupName);
            if (content == null) {
                content = new HashSet();
                this.myContents.put((Object)groupName, (Object)content);
            }
            content.add(element);
        }
    }

    @Override
    public Map<String, Set<RefEntity>> getContent() {
        return this.myContents;
    }

    @Override
    public Map<String, Set<RefEntity>> getOldContent() {
        if (this.myOldProblemElements == null) {
            return null;
        }
        com.intellij.util.containers.HashMap oldContents = new com.intellij.util.containers.HashMap();
        Set elements = this.myOldProblemElements.keySet();
        for (RefEntity element : elements) {
            HashSet currentElements;
            String groupName = element instanceof RefElement ? element.getRefManager().getGroupName((RefElement)element) : element.getName();
            Set collection = (Set)this.myContents.get((Object)groupName);
            if (collection != null && DescriptorProviderInspection.contains(element, (Collection<RefEntity>)(currentElements = new HashSet((Collection)collection)))) continue;
            Set oldContent = (Set)oldContents.get((Object)groupName);
            if (oldContent == null) {
                oldContent = new HashSet();
                oldContents.put((Object)groupName, (Object)oldContent);
            }
            oldContent.add(element);
        }
        return oldContents;
    }

    @Override
    public Set<RefModule> getModuleProblems() {
        return this.myModulesProblems;
    }

    @Override
    public QuickFixAction[] getQuickFixes(RefEntity[] refElements) {
        return this.extractActiveFixes(refElements, this.getQuickFixActions());
    }

    public QuickFixAction[] extractActiveFixes(RefEntity[] refElements, Map<RefEntity, Set<QuickFix>> actions) {
        if (refElements == null) {
            return null;
        }
        HashMap result = new HashMap();
        for (RefEntity refElement : refElements) {
            Set<QuickFix> localQuickFixes = actions.get(refElement);
            if (localQuickFixes == null) continue;
            for (QuickFix fix : localQuickFixes) {
                if (fix == null) continue;
                Class<?> klass = fix.getClass();
                QuickFixAction quickFixAction = (QuickFixAction)((Object)result.get(klass));
                if (quickFixAction != null) {
                    try {
                        String familyName = fix.getFamilyName();
                        familyName = familyName != null && familyName.length() > 0 ? "'" + familyName + "'" : familyName;
                        ((LocalQuickFixWrapper)quickFixAction).setText(InspectionsBundle.message((String)"inspection.descriptor.provider.apply.fix", (Object[])new Object[]{familyName}));
                    }
                    catch (AbstractMethodError e) {
                        ((LocalQuickFixWrapper)quickFixAction).setText(InspectionsBundle.message((String)"inspection.descriptor.provider.apply.fix", (Object[])new Object[]{""}));
                    }
                    continue;
                }
                LocalQuickFixWrapper quickFixWrapper = new LocalQuickFixWrapper(fix, this);
                result.put(klass, quickFixWrapper);
            }
        }
        return result.values().isEmpty() ? null : result.values().toArray(new QuickFixAction[result.size()]);
    }

    public RefEntity getElement(CommonProblemDescriptor descriptor) {
        return this.getProblemToElements().get(descriptor);
    }

    public void ignoreProblem(CommonProblemDescriptor descriptor, QuickFix fix) {
        RefEntity refElement = this.getProblemToElements().get(descriptor);
        if (refElement != null) {
            QuickFix[] fixes = descriptor.getFixes();
            for (int i = 0; i < fixes.length; ++i) {
                if (fixes[i] != fix) continue;
                this.ignoreProblem(refElement, descriptor, i);
                return;
            }
        }
    }

    @Override
    public boolean isElementIgnored(RefEntity element) {
        if (this.getIgnoredElements() == null) {
            return false;
        }
        for (RefEntity entity : this.getIgnoredElements().keySet()) {
            if (!Comparing.equal((Object)entity, (Object)element)) continue;
            return true;
        }
        return false;
    }

    public FileStatus getProblemStatus(CommonProblemDescriptor descriptor) {
        GlobalInspectionContextImpl context = this.getContext();
        if (context != null && context.getUIOptions().SHOW_DIFF_WITH_PREVIOUS_RUN && this.myOldProblemElements != null) {
            HashSet allAvailable = new HashSet();
            for (CommonProblemDescriptor[] descriptors : this.myOldProblemElements.values()) {
                if (descriptors == null) continue;
                allAvailable.addAll(Arrays.asList(descriptors));
            }
            boolean old = DescriptorProviderInspection.contains(descriptor, (Collection<CommonProblemDescriptor>)allAvailable);
            boolean current = DescriptorProviderInspection.contains(descriptor, this.getProblemToElements().keySet());
            return DescriptorProviderInspection.calcStatus(old, current);
        }
        return FileStatus.NOT_CHANGED;
    }

    private static boolean contains(CommonProblemDescriptor descriptor, Collection<CommonProblemDescriptor> descriptors) {
        PsiElement element = null;
        if (descriptor instanceof ProblemDescriptor) {
            element = ((ProblemDescriptor)descriptor).getPsiElement();
        }
        for (CommonProblemDescriptor problemDescriptor : descriptors) {
            if (problemDescriptor instanceof ProblemDescriptor && !Comparing.equal((Object)element, (Object)((ProblemDescriptor)problemDescriptor).getPsiElement()) || !Comparing.strEqual((String)problemDescriptor.getDescriptionTemplate(), (String)descriptor.getDescriptionTemplate())) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileStatus getElementStatus(RefEntity element) {
        GlobalInspectionContextImpl context = this.getContext();
        if (context != null && context.getUIOptions().SHOW_DIFF_WITH_PREVIOUS_RUN && this.myOldProblemElements != null) {
            boolean old = DescriptorProviderInspection.contains(element, this.myOldProblemElements.keySet());
            boolean current = DescriptorProviderInspection.contains(element, this.getProblemElements().keySet());
            return DescriptorProviderInspection.calcStatus(old, current);
        }
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public Collection<RefEntity> getIgnoredRefElements() {
        return this.getIgnoredElements().keySet();
    }

    public Map<RefEntity, CommonProblemDescriptor[]> getProblemElements() {
        if (this.myProblemElements == null) {
            this.myProblemElements = Collections.synchronizedMap(new THashMap());
        }
        return this.myProblemElements;
    }

    @Nullable
    public com.intellij.util.containers.HashMap<RefEntity, CommonProblemDescriptor[]> getOldProblemElements() {
        return this.myOldProblemElements;
    }

    private Map<CommonProblemDescriptor, RefEntity> getProblemToElements() {
        if (this.myProblemToElements == null) {
            this.myProblemToElements = Collections.synchronizedMap(new THashMap());
        }
        return this.myProblemToElements;
    }

    private Map<RefEntity, Set<QuickFix>> getQuickFixActions() {
        if (this.myQuickFixActions == null) {
            this.myQuickFixActions = Collections.synchronizedMap(new com.intellij.util.containers.HashMap());
        }
        return this.myQuickFixActions;
    }

    private Map<RefEntity, CommonProblemDescriptor[]> getIgnoredElements() {
        if (this.myIgnoredElements == null) {
            this.myIgnoredElements = Collections.synchronizedMap(new com.intellij.util.containers.HashMap());
        }
        return this.myIgnoredElements;
    }
}

