/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CommentUtil;
import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentByBlockCommentHandler
implements CodeInsightActionHandler {
    private Project myProject;
    private Editor myEditor;
    private PsiFile myFile;
    private Document myDocument;
    private CommenterDataHolder mySelfManagedCommenterData;

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        String suffix;
        String prefix;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/CommentByBlockCommentHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/generation/CommentByBlockCommentHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/generation/CommentByBlockCommentHandler.invoke must not be null");
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file;
        this.myDocument = editor.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(this.myDocument, project)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.comment.block");
        Commenter commenter = CommentByBlockCommentHandler.findCommenter(this.myFile, this.myEditor);
        if (commenter == null) {
            return;
        }
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            this.mySelfManagedCommenterData = selfManagingCommenter.createBlockCommentingState(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), this.myDocument, this.myFile);
            if (this.mySelfManagedCommenterData == null) {
                this.mySelfManagedCommenterData = SelfManagingCommenter.EMPTY_STATE;
            }
            prefix = selfManagingCommenter.getBlockCommentPrefix(selectionModel.getSelectionStart(), this.myDocument, this.mySelfManagedCommenterData);
            suffix = selfManagingCommenter.getBlockCommentSuffix(selectionModel.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            prefix = commenter.getBlockCommentPrefix();
            suffix = commenter.getBlockCommentSuffix();
        }
        if (prefix == null || suffix == null) {
            return;
        }
        TextRange commentedRange = this.findCommentedRange(commenter);
        if (commentedRange != null) {
            int commentStart = commentedRange.getStartOffset();
            int commentEnd = commentedRange.getEndOffset();
            int selectionStart = commentStart;
            int selectionEnd = commentEnd;
            if (selectionModel.hasSelection()) {
                selectionStart = selectionModel.getSelectionStart();
                selectionEnd = selectionModel.getSelectionEnd();
            }
            if (!(commentStart >= selectionStart && commentStart < selectionEnd || commentEnd > selectionStart && commentEnd <= selectionEnd)) {
                this.commentRange(selectionStart, selectionEnd, prefix, suffix, commenter);
            } else {
                this.uncommentRange(commentedRange, CommentByBlockCommentHandler.trim(prefix), CommentByBlockCommentHandler.trim(suffix), commenter);
            }
        } else if (selectionModel.hasBlockSelection()) {
            int i;
            LogicalPosition start = selectionModel.getBlockStart();
            LogicalPosition end = selectionModel.getBlockEnd();
            assert (start != null);
            assert (end != null);
            int startColumn = Math.min(start.column, end.column);
            int endColumn = Math.max(start.column, end.column);
            int startLine = Math.min(start.line, end.line);
            int endLine = Math.max(start.line, end.line);
            for (i = startLine; i <= endLine; ++i) {
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, endColumn));
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)suffix, (boolean)true, (boolean)true);
            }
            for (i = startLine; i <= endLine; ++i) {
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, startColumn));
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)prefix, (boolean)true, (boolean)true);
            }
        } else if (selectionModel.hasSelection()) {
            int selectionStart = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            this.commentRange(selectionStart, selectionEnd, prefix, suffix, commenter);
        } else {
            EditorUtil.fillVirtualSpaceUntilCaret(editor);
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            this.myDocument.insertString(caretOffset, (CharSequence)(prefix + suffix));
            this.myEditor.getCaretModel().moveToOffset(caretOffset + prefix.length());
        }
    }

    @Nullable
    private static String trim(String s) {
        return s == null ? null : s.trim();
    }

    private boolean testSelectionForNonComments() {
        SelectionModel model = this.myEditor.getSelectionModel();
        if (!model.hasSelection()) {
            return true;
        }
        TextRange range = new TextRange(model.getSelectionStart(), model.getSelectionEnd() - 1);
        for (PsiElement element = this.myFile.findElementAt(range.getStartOffset()); element != null && range.intersects(element.getTextRange()); element = element.getNextSibling()) {
            if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private TextRange findCommentedRange(Commenter commenter) {
        TextRange commentedRange;
        String suffix;
        String prefix;
        CharSequence text = this.myDocument.getCharsSequence();
        FileType fileType = this.myFile.getFileType();
        if (fileType instanceof AbstractFileType) {
            CustomFileTypeLexer lexer = new CustomFileTypeLexer(((AbstractFileType)fileType).getSyntaxTable());
            int caretOffset = this.myEditor.getCaretModel().getOffset();
            int commentStart = CharArrayUtil.lastIndexOf((CharSequence)text, (String)commenter.getBlockCommentPrefix(), (int)caretOffset);
            if (commentStart == -1) {
                return null;
            }
            lexer.start(text, commentStart, text.length());
            if (lexer.getTokenType() == CustomHighlighterTokenType.MULTI_LINE_COMMENT && lexer.getTokenEnd() >= caretOffset) {
                return new TextRange(commentStart, lexer.getTokenEnd());
            }
            return null;
        }
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            prefix = selfManagingCommenter.getBlockCommentPrefix(selectionModel.getSelectionStart(), this.myDocument, this.mySelfManagedCommenterData);
            suffix = selfManagingCommenter.getBlockCommentSuffix(selectionModel.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            prefix = CommentByBlockCommentHandler.trim(commenter.getBlockCommentPrefix());
            suffix = CommentByBlockCommentHandler.trim(commenter.getBlockCommentSuffix());
        }
        if (prefix == null || suffix == null) {
            return null;
        }
        if (commenter instanceof SelfManagingCommenter) {
            commentedRange = ((SelfManagingCommenter)commenter).getBlockCommentRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            String commentText;
            PsiElement comment;
            if (!this.testSelectionForNonComments()) {
                return null;
            }
            commentedRange = this.getSelectedComments(text, prefix, suffix);
            if (commentedRange == null && (comment = this.findCommentAtCaret()) != null && (commentText = comment.getText()).startsWith(prefix) && commentText.endsWith(suffix)) {
                commentedRange = comment.getTextRange();
            }
        }
        return commentedRange;
    }

    @Nullable
    private TextRange getSelectedComments(CharSequence text, String prefix, String suffix) {
        TextRange commentedRange = null;
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            int selectionStart = selectionModel.getSelectionStart();
            selectionStart = CharArrayUtil.shiftForward((CharSequence)text, (int)selectionStart, (String)" \t\n");
            int selectionEnd = selectionModel.getSelectionEnd() - 1;
            if ((selectionEnd = CharArrayUtil.shiftBackward((CharSequence)text, (int)selectionEnd, (String)" \t\n") + 1) - selectionStart >= prefix.length() + suffix.length() && CharArrayUtil.regionMatches((CharSequence)text, (int)selectionStart, (CharSequence)prefix) && CharArrayUtil.regionMatches((CharSequence)text, (int)(selectionEnd - suffix.length()), (CharSequence)suffix)) {
                commentedRange = new TextRange(selectionStart, selectionEnd);
            }
        }
        return commentedRange;
    }

    @Nullable
    private static Commenter findCommenter(PsiFile file, Editor editor) {
        FileType fileType = file.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter();
        }
        Language lang = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)file.getProject());
        return CommentByBlockCommentHandler.getCommenter(file, editor, lang, lang);
    }

    @Nullable
    public static Commenter getCommenter(PsiFile file, Editor editor, Language lineStartLanguage, Language lineEndLanguage) {
        Language lang;
        FileViewProvider viewProvider = file.getViewProvider();
        for (MultipleLangCommentProvider provider : (MultipleLangCommentProvider[])MultipleLangCommentProvider.EP_NAME.getExtensions()) {
            if (!provider.canProcess(file, viewProvider)) continue;
            return provider.getLineCommenter(file, editor, lineStartLanguage, lineEndLanguage);
        }
        Language language = lang = lineStartLanguage == null || LanguageCommenters.INSTANCE.forLanguage(lineStartLanguage) == null ? file.getLanguage() : lineStartLanguage;
        if (viewProvider instanceof TemplateLanguageFileViewProvider && lang == ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage()) {
            lang = viewProvider.getBaseLanguage();
        }
        return (Commenter)LanguageCommenters.INSTANCE.forLanguage(lang);
    }

    @Nullable
    private PsiElement findCommentAtCaret() {
        PsiElement elt;
        SelectionModel selectionModel;
        TextRange range;
        int offset = this.myEditor.getCaretModel().getOffset();
        if (offset == (range = new TextRange((selectionModel = this.myEditor.getSelectionModel()).getSelectionStart(), selectionModel.getSelectionEnd())).getEndOffset()) {
            --offset;
        }
        if (offset <= range.getStartOffset()) {
            ++offset;
        }
        if ((elt = this.myFile.getViewProvider().findElementAt(offset)) == null) {
            return null;
        }
        PsiElement comment = PsiTreeUtil.getParentOfType((PsiElement)elt, PsiComment.class, (boolean)false);
        if (comment == null || selectionModel.hasSelection() && !range.contains(comment.getTextRange())) {
            return null;
        }
        return comment;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void commentRange(int startOffset, int endOffset, String commentPrefix, String commentSuffix, Commenter commenter) {
        CharSequence chars = this.myDocument.getCharsSequence();
        LogicalPosition caretPosition = this.myEditor.getCaretModel().getLogicalPosition();
        if (!(startOffset != 0 && chars.charAt(startOffset - 1) != '\n' && chars.charAt(startOffset - 1) != '\r' || endOffset != this.myDocument.getTextLength() && chars.charAt(endOffset - 1) != '\n' && chars.charAt(endOffset - 1) != '\r')) {
            String space;
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
            if (!settings.BLOCK_COMMENT_AT_FIRST_COLUMN) {
                int line1 = this.myEditor.offsetToLogicalPosition((int)startOffset).line;
                int line2 = this.myEditor.offsetToLogicalPosition((int)(endOffset - 1)).line;
                FileType fileType = this.myFile.getFileType();
                Indent minIndent = CommentUtil.getMinLineIndent(this.myProject, this.myDocument, line1, line2, fileType);
                if (minIndent == null) {
                    minIndent = codeStyleManager.zeroIndent();
                }
                space = codeStyleManager.fillIndent(minIndent, fileType);
            } else {
                space = "";
            }
            TextRange range = this.insertNestedComments(chars, startOffset, endOffset, space + commentPrefix + "\n", space + commentSuffix + "\n", commenter);
            this.myEditor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            LogicalPosition pos = new LogicalPosition(caretPosition.line + 1, caretPosition.column);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return;
        }
        TextRange range = this.insertNestedComments(chars, startOffset, endOffset, commentPrefix, commentSuffix, commenter);
        this.myEditor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        LogicalPosition pos = new LogicalPosition(caretPosition.line, caretPosition.column + commentPrefix.length());
        this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private int doBoundCommentingAndGetShift(int offset, String commented, int skipLength, String toInsert, boolean skipBrace, TextRange selection) {
        if (commented == null && (offset == selection.getStartOffset() || offset + (skipBrace ? skipLength : 0) == selection.getEndOffset())) {
            return 0;
        }
        if (commented == null) {
            this.myDocument.insertString(offset + (skipBrace ? skipLength : 0), (CharSequence)toInsert);
            return toInsert.length();
        }
        this.myDocument.replaceString(offset, offset + skipLength, (CharSequence)commented);
        return commented.length() - skipLength;
    }

    private TextRange insertNestedComments(CharSequence chars, int startOffset, int endOffset, String commentPrefix, String commentSuffix, Commenter commenter) {
        int prefixIndex;
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            return selfManagingCommenter.insertBlockComment(startOffset, endOffset, this.myDocument, this.mySelfManagedCommenterData);
        }
        String normalizedPrefix = commentPrefix.trim();
        String normalizedSuffix = commentSuffix.trim();
        IntArrayList nestedCommentPrefixes = new IntArrayList();
        IntArrayList nestedCommentSuffixes = new IntArrayList();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        for (int i = startOffset; i < endOffset; ++i) {
            if (CharArrayUtil.regionMatches((CharSequence)chars, (int)i, (CharSequence)normalizedPrefix)) {
                nestedCommentPrefixes.add(i);
                continue;
            }
            if (!CharArrayUtil.regionMatches((CharSequence)chars, (int)i, (CharSequence)normalizedSuffix)) continue;
            nestedCommentSuffixes.add(i);
        }
        int shift = 0;
        if (commentedSuffix != null || nestedCommentSuffixes.isEmpty() || nestedCommentSuffixes.get(nestedCommentSuffixes.size() - 1) + commentSuffix.length() != endOffset) {
            this.myDocument.insertString(endOffset, (CharSequence)commentSuffix);
            shift += commentSuffix.length();
        }
        int i = nestedCommentPrefixes.size() - 1;
        int j = nestedCommentSuffixes.size() - 1;
        TextRange selection = new TextRange(startOffset, endOffset);
        while (i >= 0 && j >= 0) {
            int suffixIndex;
            prefixIndex = nestedCommentPrefixes.get(i);
            if (prefixIndex > (suffixIndex = nestedCommentSuffixes.get(j))) {
                shift += this.doBoundCommentingAndGetShift(prefixIndex, commentedPrefix, normalizedPrefix.length(), commentSuffix, false, selection);
                --i;
                continue;
            }
            shift += this.doBoundCommentingAndGetShift(suffixIndex, commentedSuffix, normalizedSuffix.length(), commentPrefix, true, selection);
            --j;
        }
        while (i >= 0) {
            prefixIndex = nestedCommentPrefixes.get(i);
            shift += this.doBoundCommentingAndGetShift(prefixIndex, commentedPrefix, normalizedPrefix.length(), commentSuffix, false, selection);
            --i;
        }
        while (j >= 0) {
            int suffixIndex = nestedCommentSuffixes.get(j);
            shift += this.doBoundCommentingAndGetShift(suffixIndex, commentedSuffix, normalizedSuffix.length(), commentPrefix, true, selection);
            --j;
        }
        if (commentedPrefix != null || nestedCommentPrefixes.isEmpty() || nestedCommentPrefixes.get(0) != startOffset) {
            this.myDocument.insertString(startOffset, (CharSequence)commentPrefix);
            shift += commentPrefix.length();
        }
        return new TextRange(startOffset, endOffset + shift);
    }

    private static int getNearest(String text, String pattern, int position) {
        int result = text.indexOf(pattern, position);
        return result == -1 ? text.length() : result;
    }

    static void commentNestedComments(@NotNull Document document, TextRange range, Commenter commenter) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/CommentByBlockCommentHandler.commentNestedComments must not be null");
        }
        int offset = range.getStartOffset();
        IntArrayList toReplaceWithComments = new IntArrayList();
        IntArrayList prefixes = new IntArrayList();
        if (range.getLength() < 0) {
            return;
        }
        String text = ((Object)document.getCharsSequence().subSequence(range.getStartOffset(), range.getEndOffset())).toString();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        String commentPrefix = commenter.getBlockCommentPrefix();
        String commentSuffix = commenter.getBlockCommentSuffix();
        int nearestSuffix = CommentByBlockCommentHandler.getNearest(text, commentedSuffix, 0);
        int nearestPrefix = CommentByBlockCommentHandler.getNearest(text, commentedPrefix, 0);
        int level = 0;
        int lastSuffix = -1;
        int i = Math.min(nearestPrefix, nearestSuffix);
        while (i < text.length()) {
            if (i > nearestPrefix) {
                nearestPrefix = CommentByBlockCommentHandler.getNearest(text, commentedPrefix, i);
            } else if (i > nearestSuffix) {
                nearestSuffix = CommentByBlockCommentHandler.getNearest(text, commentedSuffix, i);
            } else if (i == nearestPrefix) {
                if (level <= 0) {
                    if (lastSuffix != -1) {
                        toReplaceWithComments.add(lastSuffix);
                    }
                    level = 1;
                    lastSuffix = -1;
                    toReplaceWithComments.add(i);
                    prefixes.add(i);
                } else {
                    ++level;
                }
                nearestPrefix = CommentByBlockCommentHandler.getNearest(text, commentedPrefix, nearestPrefix + 1);
            } else {
                lastSuffix = i;
                --level;
                nearestSuffix = CommentByBlockCommentHandler.getNearest(text, commentedSuffix, nearestSuffix + 1);
            }
            i = Math.min(nearestPrefix, nearestSuffix);
        }
        if (lastSuffix != -1) {
            toReplaceWithComments.add(lastSuffix);
        }
        int prefixIndex = prefixes.size() - 1;
        for (int i2 = toReplaceWithComments.size() - 1; i2 >= 0; --i2) {
            int position = toReplaceWithComments.get(i2);
            if (prefixIndex >= 0 && position == prefixes.get(prefixIndex)) {
                --prefixIndex;
                document.replaceString(offset + position, offset + position + commentedPrefix.length(), (CharSequence)commentPrefix);
                continue;
            }
            document.replaceString(offset + position, offset + position + commentedSuffix.length(), (CharSequence)commentSuffix);
        }
    }

    private TextRange expandRange(int delOffset1, int delOffset2) {
        int offset2;
        CharSequence chars = this.myDocument.getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(delOffset1 - 1), (String)" \t");
        if (!(offset1 >= 0 && chars.charAt(offset1) != '\n' && chars.charAt(offset1) != '\r' || (offset2 = CharArrayUtil.shiftForward((CharSequence)chars, (int)delOffset2, (String)" \t")) != this.myDocument.getTextLength() && chars.charAt(offset2) != '\r' && chars.charAt(offset2) != '\n')) {
            delOffset1 = offset1 + 1;
            if (offset2 < this.myDocument.getTextLength()) {
                delOffset2 = offset2 + 1;
                if (chars.charAt(offset2) == '\r' && offset2 + 1 < this.myDocument.getTextLength() && chars.charAt(offset2 + 1) == '\n') {
                    ++delOffset2;
                }
            }
        }
        return new TextRange(delOffset1, delOffset2);
    }

    private Pair<TextRange, TextRange> findCommentBlock(TextRange range, String commentPrefix, String commentSuffix) {
        CharSequence chars = this.myDocument.getCharsSequence();
        int startOffset = range.getStartOffset();
        boolean endsProperly = CharArrayUtil.regionMatches((CharSequence)chars, (int)(range.getEndOffset() - commentSuffix.length()), (CharSequence)commentSuffix);
        TextRange start = this.expandRange(startOffset, startOffset + commentPrefix.length());
        TextRange end = endsProperly ? this.expandRange(range.getEndOffset() - commentSuffix.length(), range.getEndOffset()) : new TextRange(range.getEndOffset(), range.getEndOffset());
        return new Pair((Object)start, (Object)end);
    }

    public void uncommentRange(TextRange range, String commentPrefix, String commentSuffix, Commenter commenter) {
        int start;
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            selfManagingCommenter.uncommentBlockComment(range.getStartOffset(), range.getEndOffset(), this.myDocument, this.mySelfManagedCommenterData);
            return;
        }
        String text = ((Object)this.myDocument.getCharsSequence().subSequence(range.getStartOffset(), range.getEndOffset())).toString();
        int startOffset = range.getStartOffset();
        ArrayList<Pair<TextRange, TextRange>> ranges = new ArrayList<Pair<TextRange, TextRange>>();
        int position = 0;
        while ((start = CommentByBlockCommentHandler.getNearest(text, commentPrefix, position)) != text.length()) {
            int end;
            position = start;
            position = end = CommentByBlockCommentHandler.getNearest(text, commentSuffix, position + commentPrefix.length()) + commentSuffix.length();
            Pair<TextRange, TextRange> pair = this.findCommentBlock(new TextRange(start + startOffset, end + startOffset), commentPrefix, commentSuffix);
            ranges.add(pair);
        }
        for (int i = ranges.size() - 1; i >= 0; --i) {
            Pair toDelete = (Pair)ranges.get(i);
            this.myDocument.deleteString(((TextRange)toDelete.first).getStartOffset(), ((TextRange)toDelete.first).getEndOffset());
            int shift = ((TextRange)toDelete.first).getEndOffset() - ((TextRange)toDelete.first).getStartOffset();
            this.myDocument.deleteString(((TextRange)toDelete.second).getStartOffset() - shift, ((TextRange)toDelete.second).getEndOffset() - shift);
            if (commenter.getCommentedBlockCommentPrefix() == null) continue;
            CommentByBlockCommentHandler.commentNestedComments(this.myDocument, new TextRange(((TextRange)toDelete.first).getEndOffset() - shift, ((TextRange)toDelete.second).getStartOffset() - shift), commenter);
        }
    }
}

