/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;

public class ReferenceSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiJavaCodeReferenceElement;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement endElement = e;
        while (endElement instanceof PsiJavaCodeReferenceElement && endElement.getNextSibling() != null) {
            endElement = endElement.getNextSibling();
        }
        if (!(endElement instanceof PsiJavaCodeReferenceElement || endElement.getPrevSibling() instanceof PsiReferenceExpression && endElement instanceof PsiExpressionList)) {
            endElement = endElement.getPrevSibling();
        }
        PsiElement element = e;
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        while (element instanceof PsiJavaCodeReferenceElement) {
            PsiElement firstChild = element.getFirstChild();
            PsiElement referenceName = ((PsiJavaCodeReferenceElement)element).getReferenceNameElement();
            if (referenceName != null) {
                PsiElement endReferenceName;
                result.addAll(ReferenceSelectioner.expandToWholeLine(editorText, new TextRange(referenceName.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset())));
                if (endElement instanceof PsiJavaCodeReferenceElement && (endReferenceName = ((PsiJavaCodeReferenceElement)endElement).getReferenceNameElement()) != null) {
                    result.addAll(ReferenceSelectioner.expandToWholeLine(editorText, new TextRange(referenceName.getTextRange().getStartOffset(), endReferenceName.getTextRange().getEndOffset())));
                }
            }
            if (firstChild == null) break;
            element = firstChild;
        }
        result.addAll(ReferenceSelectioner.expandToWholeLine(editorText, new TextRange(element.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset())));
        if (!(e.getParent() instanceof PsiJavaCodeReferenceElement) && (e.getNextSibling() instanceof PsiJavaToken || e.getNextSibling() instanceof PsiWhiteSpace || e.getNextSibling() instanceof PsiExpressionList)) {
            result.addAll(super.select(e, editorText, cursorOffset, editor));
        }
        return result;
    }
}

