/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.EnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.util.text.CharArrayUtil;

public class AfterSemicolonEnterProcessor
implements EnterProcessor {
    @Override
    public boolean doEnter(Editor editor, PsiElement psiElement, boolean isModified) {
        if (psiElement instanceof PsiExpressionStatement || psiElement instanceof PsiDeclarationStatement || psiElement instanceof PsiDoWhileStatement || psiElement instanceof PsiReturnStatement || psiElement instanceof PsiThrowStatement || psiElement instanceof PsiBreakStatement || psiElement instanceof PsiContinueStatement || psiElement instanceof PsiAssertStatement || psiElement instanceof PsiField || psiElement instanceof PsiImportStatementBase || psiElement instanceof PsiMethod && (((PsiMethod)psiElement).getContainingClass().isInterface() || ((PsiMethod)psiElement).hasModifierProperty("abstract") || ((PsiMethod)psiElement).hasModifierProperty("native"))) {
            CharSequence text;
            int commaOffset;
            int errorOffset = AfterSemicolonEnterProcessor.getErrorElementOffset(psiElement);
            int elementEndOffset = psiElement.getTextRange().getEndOffset();
            if (psiElement instanceof PsiEnumConstant && (commaOffset = CharArrayUtil.shiftForwardUntil((CharSequence)(text = editor.getDocument().getCharsSequence()), (int)elementEndOffset, (String)",")) < text.length()) {
                elementEndOffset = commaOffset + 1;
            }
            if (errorOffset >= 0 && errorOffset < elementEndOffset && (text = editor.getDocument().getCharsSequence()).charAt(errorOffset) == ' ' && text.charAt(errorOffset + 1) == ';') {
                ++errorOffset;
            }
            editor.getCaretModel().moveToOffset(errorOffset >= 0 ? errorOffset : elementEndOffset);
            return isModified;
        }
        return false;
    }

    private static int getErrorElementOffset(PsiElement elt) {
        final int[] offset = new int[]{-1};
        elt.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(PsiErrorElement element) {
                if (offset[0] == -1) {
                    offset[0] = element.getTextRange().getStartOffset();
                }
            }
        });
        return offset[0];
    }
}

