/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionServiceImpl
extends CompletionService {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.impl.CompletionServiceImpl");
    private Throwable myTrace = null;
    private CompletionProgressIndicator myCurrentCompletion;

    public static CompletionServiceImpl getCompletionService() {
        return (CompletionServiceImpl)CompletionService.getCompletionService();
    }

    public String getAdvertisementText() {
        CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        return completion == null ? null : completion.getLookup().getAdvertisementText();
    }

    public void setAdvertisementText(@Nullable String text) {
        CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (completion != null) {
            completion.getLookup().setAdvertisementText(text);
        }
    }

    public CompletionResultSet createResultSet(CompletionParameters parameters, Consumer<LookupElement> consumer, @NotNull CompletionContributor contributor) {
        if (contributor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CompletionServiceImpl.createResultSet must not be null");
        }
        PsiElement position = parameters.getPosition();
        String prefix = CompletionData.findPrefixStatic(position, parameters.getOffset());
        String textBeforePosition = parameters.getPosition().getContainingFile().getText().substring(0, parameters.getOffset());
        return new CompletionResultSetImpl(consumer, textBeforePosition, new CamelHumpMatcher(prefix), contributor);
    }

    public CompletionProgressIndicator getCurrentCompletion() {
        return this.myCurrentCompletion;
    }

    public void setCurrentCompletion(@Nullable CompletionProgressIndicator indicator) {
        if (indicator != null) {
            CompletionProgressIndicator oldCompletion = this.myCurrentCompletion;
            Throwable oldTrace = this.myTrace;
            this.myCurrentCompletion = indicator;
            this.myTrace = new Throwable();
            if (oldCompletion != null) {
                throw new RuntimeException("SHe's not dead yet!\nthis=" + indicator + "\ncurrent=" + oldCompletion + "\ntrace=" + StringUtil.getThrowableText((Throwable)oldTrace));
            }
        } else {
            this.myCurrentCompletion = null;
        }
    }

    public void correctCaseInsensitiveString(@NotNull LookupElement element, InsertionContext context) {
        String newLookupString;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CompletionServiceImpl.correctCaseInsensitiveString must not be null");
        }
        if (!element.isPrefixMatched()) {
            return;
        }
        String prefix = element.getPrefixMatcher().getPrefix();
        String oldLookupString = element.getLookupString();
        if (StringUtil.startsWithIgnoreCase((String)oldLookupString, (String)prefix) && !(newLookupString = CompletionServiceImpl.handleCaseInsensitiveVariant(prefix, oldLookupString)).equals(oldLookupString)) {
            Document document = context.getEditor().getDocument();
            document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)newLookupString);
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
        }
    }

    private static String handleCaseInsensitiveVariant(String prefix, @NotNull String lookupString) {
        if (lookupString == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CompletionServiceImpl.handleCaseInsensitiveVariant must not be null");
        }
        int length = prefix.length();
        if (length == 0) {
            return lookupString;
        }
        boolean isAllLower = true;
        boolean isAllUpper = true;
        boolean sameCase = true;
        for (int i = 0; i < length && (isAllLower || isAllUpper || sameCase); ++i) {
            char c = prefix.charAt(i);
            isAllLower = isAllLower && Character.isLowerCase(c);
            isAllUpper = isAllUpper && Character.isUpperCase(c);
            sameCase = sameCase && Character.isLowerCase(c) == Character.isLowerCase(lookupString.charAt(i));
        }
        if (sameCase) {
            return lookupString;
        }
        if (isAllLower) {
            return lookupString.toLowerCase();
        }
        if (isAllUpper) {
            return lookupString.toUpperCase();
        }
        return lookupString;
    }

    private static class CompletionResultSetImpl
    extends CompletionResultSet {
        private final String myTextBeforePosition;

        public CompletionResultSetImpl(Consumer<LookupElement> consumer, String textBeforePosition, PrefixMatcher prefixMatcher, CompletionContributor contributor) {
            super(prefixMatcher, consumer, contributor);
            this.myTextBeforePosition = textBeforePosition;
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl.withPrefixMatcher must not be null");
            }
            if (!this.myTextBeforePosition.endsWith(matcher.getPrefix())) {
                int len = this.myTextBeforePosition.length();
                String fragment = len > 100 ? this.myTextBeforePosition.substring(len - 100) : this.myTextBeforePosition;
                LOG.error("prefix should be some actual file string just before caret: " + matcher.getPrefix() + "\n text=" + fragment);
            }
            CompletionResultSetImpl completionResultSetImpl = new CompletionResultSetImpl(this.getConsumer(), this.myTextBeforePosition, matcher, this.myContributor){

                public void stopHere() {
                    super.stopHere();
                    CompletionResultSetImpl.this.stopHere();
                }
            };
            if (completionResultSetImpl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl.withPrefixMatcher must not return null");
            }
            return completionResultSetImpl;
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl.withPrefixMatcher must not be null");
            }
            CompletionResultSet completionResultSet = this.withPrefixMatcher(new CamelHumpMatcher(prefix));
            if (completionResultSet == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl.withPrefixMatcher must not return null");
            }
            return completionResultSet;
        }

        @NotNull
        public CompletionResultSet caseInsensitive() {
            CompletionResultSet completionResultSet = this.withPrefixMatcher(new CamelHumpMatcher(this.getPrefixMatcher().getPrefix(), false));
            if (completionResultSet == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl.caseInsensitive must not return null");
            }
            return completionResultSet;
        }
    }
}

