/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.BasicPermission;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import net.sourceforge.jnlp.DefaultLaunchHandler;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import netscape.javascript.JSObjectCreatePermission;
import sun.applet.JSObject;
import sun.applet.MethodOverloadResolver;
import sun.applet.PluginDebug;
import sun.applet.PluginObjectStore;
import sun.applet.PluginStreamHandler;
import sun.applet.Signature;

public class PluginAppletSecurityContext {
    private static Hashtable<ClassLoader, URL> classLoaders = new Hashtable();
    private static Hashtable<Integer, ClassLoader> instanceClassLoaders = new Hashtable();
    private PluginObjectStore store = PluginObjectStore.getInstance();
    private Throwable throwable = null;
    private ClassLoader liveconnectLoader = ClassLoader.getSystemClassLoader();
    int identifier = 0;
    public static PluginStreamHandler streamhandler;
    long startTime = 0L;

    public PluginAppletSecurityContext(int identifier) {
        this.identifier = identifier;
        if (System.getSecurityManager() == null) {
            JNLPRuntime.initialize((boolean)false);
            JNLPRuntime.setDefaultLaunchHandler((LaunchHandler)new DefaultLaunchHandler());
        }
        JNLPRuntime.disableExit();
        URL u = null;
        try {
            u = new URL("file://");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        classLoaders.put(this.liveconnectLoader, u);
    }

    private static <V> V parseCall(String s, ClassLoader cl, Class<V> c) {
        if (c == Integer.class) {
            return c.cast(new Integer(s));
        }
        if (c == String.class) {
            return c.cast(new String(s));
        }
        if (c == Signature.class) {
            return c.cast(new Signature(s, cl));
        }
        throw new RuntimeException("Unexpected call value.");
    }

    private Object parseArgs(String s, Class c) {
        if (c == Boolean.TYPE || c == Boolean.class) {
            return new Boolean(s);
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return new Byte(s);
        }
        if (c == Character.TYPE || c == Character.class) {
            String[] bytes = s.split("_");
            int low = Integer.parseInt(bytes[0]);
            int high = Integer.parseInt(bytes[1]);
            int full = high << 8 & 0xFF00 | low & 0xFF;
            return new Character((char)full);
        }
        if (c == Short.TYPE || c == Short.class) {
            return new Short(s);
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return new Integer(s);
        }
        if (c == Long.TYPE || c == Long.class) {
            return new Long(s);
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(s);
        }
        if (c == Double.TYPE || c == Double.class) {
            return new Double(s);
        }
        return this.store.getObject(new Integer(s));
    }

    public void associateSrc(ClassLoader cl, URL src) {
        PluginDebug.debug("Associating ", cl, " with ", src);
        classLoaders.put(cl, src);
    }

    public void associateInstance(Integer i, ClassLoader cl) {
        PluginDebug.debug("Associating ", cl, " with instance ", i);
        instanceClassLoaders.put(i, cl);
    }

    public static void setStreamhandler(PluginStreamHandler sh) {
        streamhandler = sh;
    }

    public static Map<String, String> getLoaderInfo() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (ClassLoader loader : classLoaders.keySet()) {
            map.put(loader.getClass().getName(), classLoaders.get(loader).toString());
        }
        return map;
    }

    public void handleMessage(int reference, String src, AccessControlContext callContext, String message) {
        block149: {
            this.startTime = new Date().getTime();
            try {
                if (message.startsWith("FindClass")) {
                    ClassLoader cl = null;
                    Class<?> c = null;
                    cl = this.liveconnectLoader;
                    String[] args = message.split(" ");
                    Integer instance = new Integer(args[1]);
                    String className = args[2].replace('/', '.');
                    PluginDebug.debug("Searching for class ", className, " in ", cl);
                    try {
                        c = cl.loadClass(className);
                        this.store.reference(c);
                        this.write(reference, "FindClass " + this.store.getIdentifier(c));
                    }
                    catch (ClassNotFoundException cnfe) {
                        cl = instanceClassLoaders.get(instance);
                        PluginDebug.debug("Not found. Looking in ", cl);
                        if (instance != 0 && cl != null) {
                            try {
                                c = cl.loadClass(className);
                                this.store.reference(c);
                                this.write(reference, "FindClass " + this.store.getIdentifier(c));
                            }
                            catch (ClassNotFoundException cnfe2) {
                                this.write(reference, "FindClass 0");
                            }
                            break block149;
                        }
                        this.write(reference, "FindClass 0");
                    }
                    break block149;
                }
                if (message.startsWith("GetStaticMethodID") || message.startsWith("GetMethodID")) {
                    String[] args = message.split(" ");
                    Integer classID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    String methodName = PluginAppletSecurityContext.parseCall(args[2], null, String.class);
                    Signature signature = PluginAppletSecurityContext.parseCall(args[3], ((Class)this.store.getObject(classID)).getClassLoader(), Signature.class);
                    Class[] a = signature.getClassArray();
                    Class<?> c = message.startsWith("GetStaticMethodID") || methodName.equals("<init>") || methodName.equals("<clinit>") ? (Class<?>)this.store.getObject(classID) : this.store.getObject(classID).getClass();
                    Method m = null;
                    Constructor<?> cs = null;
                    Executable o = null;
                    if (methodName.equals("<init>") || methodName.equals("<clinit>")) {
                        o = cs = c.getConstructor(signature.getClassArray());
                        this.store.reference(cs);
                    } else {
                        m = c.getMethod(methodName, signature.getClassArray());
                        o = m;
                        this.store.reference(m);
                    }
                    PluginDebug.debug(o, " has id ", this.store.getIdentifier(o));
                    this.write(reference, args[0] + " " + this.store.getIdentifier(o));
                } else if (message.startsWith("GetStaticFieldID") || message.startsWith("GetFieldID")) {
                    String[] args = message.split(" ");
                    Integer classID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer fieldID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    String fieldName = (String)this.store.getObject(fieldID);
                    Class c = (Class)this.store.getObject(classID);
                    PluginDebug.debug("GetStaticFieldID/GetFieldID got class=", c.getName());
                    Field f = null;
                    f = c.getField(fieldName);
                    this.store.reference(f);
                    this.write(reference, "GetStaticFieldID " + this.store.getIdentifier(f));
                } else if (message.startsWith("GetStaticField")) {
                    String[] args = message.split(" ");
                    String type = PluginAppletSecurityContext.parseCall(args[1], null, String.class);
                    Integer classID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer fieldID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    final Class c = (Class)this.store.getObject(classID);
                    final Field f = (Field)this.store.getObject(fieldID);
                    AccessControlContext acc = callContext != null ? callContext : this.getClosedAccessControlContext();
                    this.checkPermission(src, c, acc);
                    Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return f.get(c);
                            }
                            catch (Throwable t) {
                                return t;
                            }
                        }
                    }, acc);
                    if (ret instanceof Throwable) {
                        throw (Throwable)ret;
                    }
                    if (ret == null) {
                        this.write(reference, "GetStaticField literalreturn null");
                    } else if (f.getType() == Boolean.TYPE || f.getType() == Byte.TYPE || f.getType() == Short.TYPE || f.getType() == Integer.TYPE || f.getType() == Long.TYPE) {
                        this.write(reference, "GetStaticField literalreturn " + ret);
                    } else if (f.getType() == Float.TYPE || f.getType() == Double.TYPE) {
                        this.write(reference, "GetStaticField literalreturn " + String.format("%308.308e", ret));
                    } else if (f.getType() == Character.TYPE) {
                        this.write(reference, "GetStaticField literalreturn " + ((Character)ret).charValue());
                    } else {
                        this.store.reference(ret);
                        this.write(reference, "GetStaticField " + this.store.getIdentifier(ret));
                    }
                } else if (message.startsWith("GetValue")) {
                    String[] args = message.split(" ");
                    Integer index = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Object ret = this.store.getObject(index);
                    if (ret == null) {
                        this.write(reference, "GetValue literalreturn null");
                    } else if (ret.getClass() == Boolean.TYPE || ret.getClass() == Boolean.class || ret.getClass() == Byte.TYPE || ret.getClass() == Byte.class || ret.getClass() == Short.TYPE || ret.getClass() == Short.class || ret.getClass() == Integer.TYPE || ret.getClass() == Integer.class || ret.getClass() == Long.TYPE || ret.getClass() == Long.class) {
                        this.write(reference, "GetValue literalreturn " + ret);
                    } else if (ret.getClass() == Float.TYPE || ret.getClass() == Float.class || ret.getClass() == Double.TYPE || ret.getClass() == Double.class) {
                        this.write(reference, "GetValue literalreturn " + String.format("%308.308e", ret));
                    } else if (ret.getClass() == Character.TYPE || ret.getClass() == Character.class) {
                        this.write(reference, "GetValue literalreturn " + ((Character)ret).charValue());
                    } else {
                        this.store.reference(ret);
                        this.write(reference, "GetValue " + this.store.getIdentifier(ret));
                    }
                } else if (message.startsWith("SetStaticField") || message.startsWith("SetField")) {
                    String[] args = message.split(" ");
                    Integer classOrObjectID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer fieldID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    Object value = this.store.getObject(PluginAppletSecurityContext.parseCall(args[3], null, Integer.class));
                    final Object o = this.store.getObject(classOrObjectID);
                    final Field f = (Field)this.store.getObject(fieldID);
                    final Object fValue = MethodOverloadResolver.getCostAndCastedObject(value, f.getType())[1];
                    AccessControlContext acc = callContext != null ? callContext : this.getClosedAccessControlContext();
                    this.checkPermission(src, message.startsWith("SetStaticField") ? (Class<?>)o : o.getClass(), acc);
                    Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                f.set(o, fValue);
                            }
                            catch (Throwable t) {
                                return t;
                            }
                            return null;
                        }
                    }, acc);
                    if (ret instanceof Throwable) {
                        throw (Throwable)ret;
                    }
                    this.write(reference, "SetField");
                } else if (message.startsWith("GetObjectArrayElement")) {
                    String[] args = message.split(" ");
                    Integer arrayID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer index = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    Object ret = Array.get(this.store.getObject(arrayID), index);
                    Class<?> retClass = this.store.getObject(arrayID).getClass().getComponentType();
                    if (ret == null) {
                        this.write(reference, "GetObjectArrayElement literalreturn null");
                    } else if (retClass == Boolean.TYPE || retClass == Byte.TYPE || retClass == Short.TYPE || retClass == Integer.TYPE || retClass == Long.TYPE) {
                        this.write(reference, "GetObjectArrayElement literalreturn " + ret);
                    } else if (retClass == Float.TYPE || retClass == Double.TYPE) {
                        this.write(reference, "GetObjectArrayElement literalreturn " + String.format("%308.308e", ret));
                    } else if (retClass == Character.TYPE) {
                        this.write(reference, "GetObjectArrayElement literalreturn " + ((Character)ret).charValue());
                    } else {
                        this.store.reference(ret);
                        this.write(reference, "GetObjectArrayElement " + this.store.getIdentifier(ret));
                    }
                } else if (message.startsWith("SetObjectArrayElement")) {
                    String[] args = message.split(" ");
                    Integer arrayID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer index = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    Integer objectID = PluginAppletSecurityContext.parseCall(args[3], null, Integer.class);
                    Object value = this.store.getObject(objectID);
                    value = MethodOverloadResolver.getCostAndCastedObject(value, this.store.getObject(arrayID).getClass().getComponentType())[1];
                    Array.set(this.store.getObject(arrayID), index, value);
                    this.write(reference, "SetObjectArrayElement");
                } else if (message.startsWith("GetArrayLength")) {
                    String[] args = message.split(" ");
                    Integer arrayID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Object o = this.store.getObject(arrayID);
                    int len = 0;
                    len = Array.getLength(o);
                    this.write(reference, "GetArrayLength " + Array.getLength(o));
                } else if (message.startsWith("GetField")) {
                    String[] args = message.split(" ");
                    String type = PluginAppletSecurityContext.parseCall(args[1], null, String.class);
                    Integer objectID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer fieldID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    final Object o = this.store.getObject(objectID);
                    final Field f = (Field)this.store.getObject(fieldID);
                    AccessControlContext acc = callContext != null ? callContext : this.getClosedAccessControlContext();
                    this.checkPermission(src, o.getClass(), acc);
                    Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return f.get(o);
                            }
                            catch (Throwable t) {
                                return t;
                            }
                        }
                    }, acc);
                    if (ret instanceof Throwable) {
                        throw (Throwable)ret;
                    }
                    if (ret == null) {
                        this.write(reference, "GetField literalreturn null");
                    } else if (f.getType() == Boolean.TYPE || f.getType() == Byte.TYPE || f.getType() == Short.TYPE || f.getType() == Integer.TYPE || f.getType() == Long.TYPE) {
                        this.write(reference, "GetField literalreturn " + ret);
                    } else if (f.getType() == Float.TYPE || f.getType() == Double.TYPE) {
                        this.write(reference, "GetField literalreturn " + String.format("%308.308e", ret));
                    } else if (f.getType() == Character.TYPE) {
                        this.write(reference, "GetField literalreturn " + ((Character)ret).charValue());
                    } else {
                        this.store.reference(ret);
                        this.write(reference, "GetField " + this.store.getIdentifier(ret));
                    }
                } else if (message.startsWith("GetObjectClass")) {
                    int oid = Integer.parseInt(message.substring("GetObjectClass".length() + 1));
                    Class<?> c = this.store.getObject(oid).getClass();
                    this.store.reference(c);
                    this.write(reference, "GetObjectClass " + this.store.getIdentifier(c));
                } else if (message.startsWith("CallMethod") || message.startsWith("CallStaticMethod")) {
                    Class<?> c;
                    String[] args = message.split(" ");
                    Integer objectID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    String methodName = PluginAppletSecurityContext.parseCall(args[2], null, String.class);
                    Object o = null;
                    if (message.startsWith("CallMethod")) {
                        o = this.store.getObject(objectID);
                        c = o.getClass();
                    } else {
                        c = (Class<?>)this.store.getObject(objectID);
                    }
                    Object[] arguments = new Object[args.length - 1];
                    arguments[0] = c;
                    arguments[1] = methodName;
                    for (int i = 0; i < args.length - 3; ++i) {
                        arguments[i + 2] = this.store.getObject(PluginAppletSecurityContext.parseCall(args[3 + i], null, Integer.class));
                        PluginDebug.debug("GOT ARG: ", arguments[i + 2]);
                    }
                    Object[] matchingMethodAndArgs = MethodOverloadResolver.getMatchingMethod(arguments);
                    if (matchingMethodAndArgs == null) {
                        this.write(reference, "Error: No suitable method named " + methodName + " with matching args found");
                        return;
                    }
                    final Method m = (Method)matchingMethodAndArgs[0];
                    Object[] castedArgs = new Object[matchingMethodAndArgs.length - 1];
                    for (int i = 0; i < castedArgs.length; ++i) {
                        castedArgs[i] = matchingMethodAndArgs[i + 1];
                    }
                    String collapsedArgs = "";
                    for (Object arg : castedArgs) {
                        collapsedArgs = collapsedArgs + " " + arg;
                    }
                    PluginDebug.debug("Calling method ", m, " on object ", o, " (", c, ") with ", collapsedArgs);
                    AccessControlContext acc = callContext != null ? callContext : this.getClosedAccessControlContext();
                    this.checkPermission(src, c, acc);
                    final Object[] fArguments = castedArgs;
                    final Object callableObject = o;
                    m.setAccessible(true);
                    Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return m.invoke(callableObject, fArguments);
                            }
                            catch (Throwable t) {
                                return t;
                            }
                        }
                    }, acc);
                    if (ret instanceof Throwable) {
                        throw (Throwable)ret;
                    }
                    String retO = ret == null ? "null" : m.getReturnType().toString();
                    PluginDebug.debug("Calling ", m, " on ", o, " with ", collapsedArgs, " and that returned: ", ret, " of type ", retO);
                    if (m.getReturnType().equals(Void.class) || m.getReturnType().equals(Void.TYPE)) {
                        this.write(reference, "CallMethod literalreturn void");
                    } else if (ret == null) {
                        this.write(reference, "CallMethod literalreturn null");
                    } else if (m.getReturnType() == Boolean.TYPE || m.getReturnType() == Byte.TYPE || m.getReturnType() == Short.TYPE || m.getReturnType() == Integer.TYPE || m.getReturnType() == Long.TYPE) {
                        this.write(reference, "CallMethod literalreturn " + ret);
                    } else if (m.getReturnType() == Float.TYPE || m.getReturnType() == Double.TYPE) {
                        this.write(reference, "CallMethod literalreturn " + String.format("%308.308e", ret));
                    } else if (m.getReturnType() == Character.TYPE) {
                        this.write(reference, "CallMethod literalreturn " + ((Character)ret).charValue());
                    } else {
                        this.store.reference(ret);
                        this.write(reference, "CallMethod " + this.store.getIdentifier(ret));
                    }
                } else if (message.startsWith("GetSuperclass")) {
                    String[] args = message.split(" ");
                    Integer classID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Class c = null;
                    Class ret = null;
                    c = (Class)this.store.getObject(classID);
                    ret = c.getSuperclass();
                    this.store.reference(ret);
                    this.write(reference, "GetSuperclass " + this.store.getIdentifier(ret));
                } else if (message.startsWith("IsAssignableFrom")) {
                    String[] args = message.split(" ");
                    Integer classID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer superclassID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    boolean result = false;
                    Class clz = (Class)this.store.getObject(classID);
                    Class sup = (Class)this.store.getObject(superclassID);
                    result = sup.isAssignableFrom(clz);
                    this.write(reference, "IsAssignableFrom " + (result ? "1" : "0"));
                } else if (message.startsWith("IsInstanceOf")) {
                    String[] args = message.split(" ");
                    Integer objectID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer classID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    boolean result = false;
                    Object o = this.store.getObject(objectID);
                    Class c = (Class)this.store.getObject(classID);
                    result = c.isInstance(o);
                    this.write(reference, "IsInstanceOf " + (result ? "1" : "0"));
                } else if (message.startsWith("GetStringUTFLength")) {
                    String[] args = message.split(" ");
                    Integer stringID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    String o = null;
                    byte[] b = null;
                    o = (String)this.store.getObject(stringID);
                    b = o.getBytes("UTF-8");
                    this.write(reference, "GetStringUTFLength " + o.length());
                } else if (message.startsWith("GetStringLength")) {
                    String[] args = message.split(" ");
                    Integer stringID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    String o = null;
                    byte[] b = null;
                    o = (String)this.store.getObject(stringID);
                    b = o.getBytes("UTF-16LE");
                    this.write(reference, "GetStringLength " + o.length());
                } else if (message.startsWith("GetStringUTFChars")) {
                    String[] args = message.split(" ");
                    Integer stringID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    String o = null;
                    byte[] b = null;
                    StringBuffer buf = null;
                    o = (String)this.store.getObject(stringID);
                    b = o.getBytes("UTF-8");
                    buf = new StringBuffer(b.length * 2);
                    buf.append(b.length);
                    for (int i = 0; i < b.length; ++i) {
                        buf.append(" " + Integer.toString(b[i] & 0xFF, 16));
                    }
                    this.write(reference, "GetStringUTFChars " + buf);
                } else if (message.startsWith("GetStringChars")) {
                    String[] args = message.split(" ");
                    Integer stringID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    String o = null;
                    byte[] b = null;
                    StringBuffer buf = null;
                    o = (String)this.store.getObject(stringID);
                    b = o.getBytes("UTF-16LE");
                    buf = new StringBuffer(b.length * 2);
                    buf.append(b.length);
                    for (int i = 0; i < b.length; ++i) {
                        buf.append(" " + Integer.toString(b[i] & 0xFF, 16));
                    }
                    PluginDebug.debug("Java: GetStringChars: ", o);
                    PluginDebug.debug("  String BYTES: ", buf);
                    this.write(reference, "GetStringChars " + buf);
                } else if (message.startsWith("GetToStringValue")) {
                    String[] args = message.split(" ");
                    Integer objectID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    String o = null;
                    byte[] b = null;
                    StringBuffer buf = null;
                    o = this.store.getObject(objectID).toString();
                    b = o.getBytes("UTF-8");
                    buf = new StringBuffer(b.length * 2);
                    buf.append(b.length);
                    for (int i = 0; i < b.length; ++i) {
                        buf.append(" " + Integer.toString(b[i] & 0xFF, 16));
                    }
                    this.write(reference, "GetToStringValue " + buf);
                } else if (message.startsWith("NewArray")) {
                    String[] args = message.split(" ");
                    String type = PluginAppletSecurityContext.parseCall(args[1], null, String.class);
                    Integer length = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    Object newArray = null;
                    Class<Object> c = type.equals("bool") ? Boolean.class : (type.equals("double") ? Double.class : (type.equals("int") ? Integer.class : (type.equals("string") ? String.class : (PluginAppletSecurityContext.isInt(type) ? (Class<Object>)this.store.getObject(Integer.parseInt(type)) : JSObject.class))));
                    newArray = args.length > 3 ? Array.newInstance(c, length, PluginAppletSecurityContext.parseCall(args[3], null, Integer.class)) : Array.newInstance(c, (int)length);
                    this.store.reference(newArray);
                    this.write(reference, "NewArray " + this.store.getIdentifier(newArray));
                } else if (message.startsWith("HasMethod")) {
                    Method[] classMethods;
                    String[] args = message.split(" ");
                    Integer classNameID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer methodNameID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    Class c = (Class)this.store.getObject(classNameID);
                    String methodName = (String)this.store.getObject(methodNameID);
                    Method method = null;
                    for (Method m : classMethods = c.getMethods()) {
                        if (!m.getName().equals(methodName)) continue;
                        method = m;
                        break;
                    }
                    int hasMethod = method != null ? 1 : 0;
                    this.write(reference, "HasMethod " + hasMethod);
                } else if (message.startsWith("HasPackage")) {
                    String[] args = message.split(" ");
                    Integer instance = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer nameID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    String pkgName = (String)this.store.getObject(nameID);
                    Package pkg = Package.getPackage(pkgName);
                    int hasPkg = pkg != null ? 1 : 0;
                    this.write(reference, "HasPackage " + hasPkg);
                } else if (message.startsWith("HasField")) {
                    Field[] classFields;
                    String[] args = message.split(" ");
                    Integer classNameID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer fieldNameID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    Class c = (Class)this.store.getObject(classNameID);
                    String fieldName = (String)this.store.getObject(fieldNameID);
                    Field field = null;
                    for (Field f : classFields = c.getFields()) {
                        if (!f.getName().equals(fieldName)) continue;
                        field = f;
                        break;
                    }
                    int hasField = field != null ? 1 : 0;
                    this.write(reference, "HasField " + hasField);
                } else if (message.startsWith("NewObjectArray")) {
                    String[] args = message.split(" ");
                    Integer length = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer classID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    Integer objectID = PluginAppletSecurityContext.parseCall(args[3], null, Integer.class);
                    Object newArray = null;
                    newArray = Array.newInstance((Class)this.store.getObject(classID), (int)length);
                    Object[] array = (Object[])newArray;
                    for (int i = 0; i < array.length; ++i) {
                        array[i] = this.store.getObject(objectID);
                    }
                    this.store.reference(newArray);
                    this.write(reference, "NewObjectArray " + this.store.getIdentifier(newArray));
                } else if (message.startsWith("NewObjectWithConstructor")) {
                    String[] args = message.split(" ");
                    Integer classID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Integer methodID = PluginAppletSecurityContext.parseCall(args[2], null, Integer.class);
                    final Constructor m = (Constructor)this.store.getObject(methodID);
                    Class<?>[] argTypes = m.getParameterTypes();
                    Object[] arguments = new Object[argTypes.length];
                    for (int i = 0; i < argTypes.length; ++i) {
                        arguments[i] = this.parseArgs(args[3 + i], argTypes[i]);
                    }
                    final Object[] fArguments = arguments;
                    AccessControlContext acc = callContext != null ? callContext : this.getClosedAccessControlContext();
                    Class c = (Class)this.store.getObject(classID);
                    this.checkPermission(src, c, acc);
                    Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return m.newInstance(fArguments);
                            }
                            catch (Throwable t) {
                                return t;
                            }
                        }
                    }, acc);
                    if (ret instanceof Throwable) {
                        throw (Throwable)ret;
                    }
                    this.store.reference(ret);
                    this.write(reference, "NewObject " + this.store.getIdentifier(ret));
                } else if (message.startsWith("NewObject")) {
                    String[] args = message.split(" ");
                    Integer classID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Class c = (Class)this.store.getObject(classID);
                    Object[] arguments = new Object[args.length - 1];
                    arguments[0] = c;
                    for (int i = 0; i < args.length - 2; ++i) {
                        arguments[i + 1] = this.store.getObject(PluginAppletSecurityContext.parseCall(args[2 + i], null, Integer.class));
                        PluginDebug.debug("GOT ARG: ", arguments[i + 1]);
                    }
                    Object[] matchingConstructorAndArgs = MethodOverloadResolver.getMatchingConstructor(arguments);
                    if (matchingConstructorAndArgs == null) {
                        this.write(reference, "Error: No suitable constructor with matching args found");
                        return;
                    }
                    Object[] castedArgs = new Object[matchingConstructorAndArgs.length - 1];
                    for (int i = 0; i < castedArgs.length; ++i) {
                        castedArgs[i] = matchingConstructorAndArgs[i + 1];
                    }
                    final Constructor cons = (Constructor)matchingConstructorAndArgs[0];
                    final Object[] fArguments = castedArgs;
                    String collapsedArgs = "";
                    for (Object arg : fArguments) {
                        collapsedArgs = collapsedArgs + " " + arg.toString();
                    }
                    PluginDebug.debug("Calling constructor on class ", c, " with ", collapsedArgs);
                    AccessControlContext acc = callContext != null ? callContext : this.getClosedAccessControlContext();
                    this.checkPermission(src, c, acc);
                    Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            try {
                                return cons.newInstance(fArguments);
                            }
                            catch (Throwable t) {
                                return t;
                            }
                        }
                    }, acc);
                    if (ret instanceof Throwable) {
                        throw (Throwable)ret;
                    }
                    this.store.reference(ret);
                    this.write(reference, "NewObject " + this.store.getIdentifier(ret));
                } else if (message.startsWith("NewStringUTF")) {
                    PluginDebug.debug("MESSAGE: ", message);
                    String[] args = message.split(" ");
                    int length = new Integer(args[1]);
                    byte[] byteArray = new byte[length];
                    String ret = null;
                    int i = 0;
                    int j = 2;
                    while (i < length) {
                        int c = Integer.parseInt(args[j++], 16);
                        byteArray[i++] = (byte)c;
                    }
                    ret = new String(byteArray, "UTF-8");
                    PluginDebug.debug("NEWSTRINGUTF: ", ret);
                    this.store.reference(ret);
                    this.write(reference, "NewStringUTF " + this.store.getIdentifier(ret));
                } else if (message.startsWith("NewString")) {
                    PluginDebug.debug("MESSAGE: ", message);
                    String[] args = message.split(" ");
                    Integer strlength = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    int bytelength = 2 * strlength;
                    byte[] byteArray = new byte[bytelength];
                    String ret = null;
                    for (int i = 0; i < strlength; ++i) {
                        int c = PluginAppletSecurityContext.parseCall(args[2 + i], null, Integer.class);
                        PluginDebug.debug("char ", i, " ", c);
                        byteArray[2 * i] = (byte)(c & 0xFF);
                        byteArray[2 * i + 1] = (byte)(c >> 8 & 0xFF);
                    }
                    ret = new String(byteArray, 0, bytelength, "UTF-16LE");
                    PluginDebug.debug("NEWSTRING: ", ret);
                    this.store.reference(ret);
                    this.write(reference, "NewString " + this.store.getIdentifier(ret));
                } else if (message.startsWith("ExceptionOccurred")) {
                    PluginDebug.debug("EXCEPTION: ", this.throwable);
                    if (this.throwable != null) {
                        this.store.reference(this.throwable);
                    }
                    this.write(reference, "ExceptionOccurred " + this.store.getIdentifier(this.throwable));
                } else if (message.startsWith("ExceptionClear")) {
                    if (this.throwable != null && this.store.contains(this.throwable)) {
                        this.store.unreference(this.store.getIdentifier(this.throwable));
                    }
                    this.throwable = null;
                    this.write(reference, "ExceptionClear");
                } else if (message.startsWith("DeleteGlobalRef")) {
                    String[] args = message.split(" ");
                    Integer id = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    this.store.unreference(id);
                    this.write(reference, "DeleteGlobalRef");
                } else if (message.startsWith("DeleteLocalRef")) {
                    String[] args = message.split(" ");
                    Integer id = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    this.store.unreference(id);
                    this.write(reference, "DeleteLocalRef");
                } else if (message.startsWith("NewGlobalRef")) {
                    String[] args = message.split(" ");
                    Integer id = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    this.store.reference(this.store.getObject(id));
                    this.write(reference, "NewGlobalRef " + id);
                } else if (message.startsWith("GetClassName")) {
                    String[] args = message.split(" ");
                    Integer objectID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    Object o = this.store.getObject(objectID);
                    this.write(reference, "GetClassName " + o.getClass().getName());
                } else if (message.startsWith("GetClassID")) {
                    String[] args = message.split(" ");
                    Integer objectID = PluginAppletSecurityContext.parseCall(args[1], null, Integer.class);
                    this.store.reference(this.store.getObject(objectID).getClass());
                    this.write(reference, "GetClassID " + this.store.getIdentifier(this.store.getObject(objectID).getClass()));
                }
            }
            catch (Throwable t) {
                String msg;
                t.printStackTrace();
                String string = msg = t.getCause() != null ? t.getCause().getMessage() : t.getMessage();
                if (t instanceof AccessControlException || t.getCause() instanceof AccessControlException) {
                    msg = "LiveConnectPermissionNeeded " + msg;
                }
                this.write(reference, " Error " + msg);
                if (!message.startsWith("CallMethod") && !message.startsWith("CallStaticMethod")) break block149;
                this.throwable = t.getCause();
            }
        }
    }

    public void checkPermission(String jsSrc, Class target, AccessControlContext acc) throws AccessControlException {
    }

    private void write(int reference, String message) {
        PluginDebug.debug("appletviewer writing ", message);
        streamhandler.write("context " + this.identifier + " reference " + reference + " " + message);
    }

    public void prePopulateLCClasses() {
        this.prepopulateClass("netscape/javascript/JSObject");
        int classID = this.prepopulateClass("netscape/javascript/JSException");
        this.prepopulateMethod(classID, "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;I)");
        this.prepopulateMethod(classID, "<init>", "(ILjava/lang/Object;)");
        this.prepopulateField(classID, "lineno");
        this.prepopulateField(classID, "tokenIndex");
        this.prepopulateField(classID, "source");
        this.prepopulateField(classID, "filename");
        this.prepopulateField(classID, "wrappedExceptionType");
        this.prepopulateField(classID, "wrappedException");
        classID = this.prepopulateClass("netscape/javascript/JSUtil");
        this.prepopulateMethod(classID, "getStackTrace", "(Ljava/lang/Throwable;)");
        this.prepopulateClass("java/lang/Object");
        classID = this.prepopulateClass("java/lang/Class");
        this.prepopulateMethod(classID, "getMethods", "()");
        this.prepopulateMethod(classID, "getConstructors", "()");
        this.prepopulateMethod(classID, "getFields", "()");
        this.prepopulateMethod(classID, "getName", "()");
        this.prepopulateMethod(classID, "isArray", "()");
        this.prepopulateMethod(classID, "getComponentType", "()");
        this.prepopulateMethod(classID, "getModifiers", "()");
        classID = this.prepopulateClass("java/lang/reflect/Method");
        this.prepopulateMethod(classID, "getName", "()");
        this.prepopulateMethod(classID, "getParameterTypes", "()");
        this.prepopulateMethod(classID, "getReturnType", "()");
        this.prepopulateMethod(classID, "getModifiers", "()");
        classID = this.prepopulateClass("java/lang/reflect/Constructor");
        this.prepopulateMethod(classID, "getParameterTypes", "()");
        this.prepopulateMethod(classID, "getModifiers", "()");
        classID = this.prepopulateClass("java/lang/reflect/Field");
        this.prepopulateMethod(classID, "getName", "()");
        this.prepopulateMethod(classID, "getType", "()");
        this.prepopulateMethod(classID, "getModifiers", "()");
        classID = this.prepopulateClass("java/lang/reflect/Array");
        this.prepopulateMethod(classID, "newInstance", "(Ljava/lang/Class;I)");
        classID = this.prepopulateClass("java/lang/Throwable");
        this.prepopulateMethod(classID, "toString", "()");
        this.prepopulateMethod(classID, "getMessage", "()");
        classID = this.prepopulateClass("java/lang/System");
        this.prepopulateMethod(classID, "identityHashCode", "(Ljava/lang/Object;)");
        classID = this.prepopulateClass("java/lang/Boolean");
        this.prepopulateMethod(classID, "booleanValue", "()");
        this.prepopulateMethod(classID, "<init>", "(Z)");
        classID = this.prepopulateClass("java/lang/Double");
        this.prepopulateMethod(classID, "doubleValue", "()");
        this.prepopulateMethod(classID, "<init>", "(D)");
        classID = this.prepopulateClass("java/lang/Void");
        this.prepopulateField(classID, "TYPE");
        this.prepopulateClass("java/lang/String");
        this.prepopulateClass("java/applet/Applet");
    }

    private int prepopulateClass(String name) {
        name = name.replace('/', '.');
        ClassLoader cl = this.liveconnectLoader;
        Class<?> c = null;
        try {
            c = cl.loadClass(name);
            this.store.reference(c);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        return this.store.getIdentifier(c);
    }

    private int prepopulateMethod(int classID, String methodName, String signatureStr) {
        Signature signature = PluginAppletSecurityContext.parseCall(signatureStr, ((Class)this.store.getObject(classID)).getClassLoader(), Signature.class);
        Class[] a = signature.getClassArray();
        Class c = (Class)this.store.getObject(classID);
        Method m = null;
        Constructor cs = null;
        try {
            if (methodName.equals("<init>") || methodName.equals("<clinit>")) {
                cs = c.getConstructor(signature.getClassArray());
                this.store.reference(cs);
            } else {
                m = c.getMethod(methodName, signature.getClassArray());
                this.store.reference(m);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return this.store.getIdentifier(m);
    }

    private int prepopulateField(int classID, String fieldName) {
        Class c = (Class)this.store.getObject(classID);
        Field f = null;
        try {
            f = c.getField(fieldName);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.store.reference(f);
        return this.store.getIdentifier(f);
    }

    public void dumpStore() {
        this.store.dump();
    }

    public Object getObject(int identifier) {
        return this.store.getObject(identifier);
    }

    public int getIdentifier(Object o) {
        return this.store.getIdentifier(o);
    }

    public void store(Object o) {
        this.store.reference(o);
    }

    public AccessControlContext getClosedAccessControlContext() {
        Permissions p = new Permissions();
        ProtectionDomain pd = new ProtectionDomain(null, p);
        return new AccessControlContext(new ProtectionDomain[]{pd});
    }

    public AccessControlContext getAccessControlContext(String[] nsPrivilegeList, String src) {
        Permissions grantedPermissions = new Permissions();
        for (int i = 0; i < nsPrivilegeList.length; ++i) {
            String privilege = nsPrivilegeList[i];
            if (privilege.equals("UniversalBrowserRead")) {
                BrowserReadPermission bp = new BrowserReadPermission();
                grantedPermissions.add(bp);
                continue;
            }
            if (!privilege.equals("UniversalJavaPermission")) continue;
            AllPermission ap = new AllPermission();
            grantedPermissions.add(ap);
        }
        CodeSource cs = new CodeSource((URL)null, (Certificate[])null);
        if (src != null && src.length() > 0) {
            try {
                cs = new CodeSource(new URL(src + "/"), (Certificate[])null);
            }
            catch (MalformedURLException mfue) {
                // empty catch block
            }
            if (src.equals("[System]")) {
                grantedPermissions.add(new JSObjectCreatePermission());
            }
        } else {
            JSObjectCreatePermission perm = new JSObjectCreatePermission();
            grantedPermissions.add(perm);
        }
        ProtectionDomain pd = new ProtectionDomain(cs, grantedPermissions, null, null);
        return new AccessControlContext(new ProtectionDomain[]{pd});
    }

    private static final boolean isInt(Object o) {
        boolean isInt = false;
        try {
            Integer.parseInt((String)o);
            isInt = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isInt;
    }

    class BrowserReadPermission
    extends BasicPermission {
        public BrowserReadPermission() {
            super("browserRead");
        }
    }
}

