#!/bin/sh
echo 'name: transformers
version: 0.2.2.0
id: transformers-0.2.2.0-89265f646be3aed4f502cfc5eccd7c93

license: BSD3
copyright:
maintainer: Ross Paterson <ross@soi.city.ac.uk>
stability:
homepage:
package-url:
description: Haskell 98 part of a monad transformer library, inspired by the paper
             \"Functional Programming with Overloading and Higher-Order Polymorphism\",
             by Mark P Jones, in /Advanced School of Functional Programming/, 1995
             (<http://web.cecs.pdx.edu/~mpj/pubs/springschool.html>).
             .
             This part contains the monad transformer class, the concrete monad
             transformers, operations and liftings.  It can be used on its own
             in Haskell 98 code, or with the monad classes in the @monads-fd@ or
             @monads-tf@ packages, which automatically lift operations introduced
             by monad transformers through other transformers.
category: Control
author: Andy Gill, Ross Paterson
pkgpath: devel/hs-transformers
exposed: True
exposed-modules: Control.Monad.IO.Class Control.Monad.Trans.Class
                 Control.Monad.Trans.Cont Control.Monad.Trans.Error
                 Control.Monad.Trans.Identity Control.Monad.Trans.List
                 Control.Monad.Trans.Maybe Control.Monad.Trans.Reader
                 Control.Monad.Trans.RWS Control.Monad.Trans.RWS.Lazy
                 Control.Monad.Trans.RWS.Strict Control.Monad.Trans.State
                 Control.Monad.Trans.State.Lazy Control.Monad.Trans.State.Strict
                 Control.Monad.Trans.Writer Control.Monad.Trans.Writer.Lazy
                 Control.Monad.Trans.Writer.Strict Data.Functor.Compose
                 Data.Functor.Constant Data.Functor.Identity Data.Functor.Product
hidden-modules:
import-dirs: /usr/local/lib/ghc/transformers-0.2.2.0
library-dirs: /usr/local/lib/ghc/transformers-0.2.2.0
hs-libraries: HStransformers-0.2.2.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-ee15f259a627d341af7c80a17e8b0e66
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-transformers-0.2.2.0/html/transformers.haddock
haddock-html: /usr/local/share/doc/hs-transformers-0.2.2.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
