/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.locale.LocaleHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.util.Currency;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.ServiceLoader;

public class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private String currencySymbol;
    private char decimalSeparator;
    private char digit;
    private char exponential;
    private char groupingSeparator;
    private String infinity;
    private String intlCurrencySymbol;
    private char minusSign;
    private char monetarySeparator;
    private String NaN;
    private char patternSeparator;
    private char percent;
    private char perMill;
    private int serialVersionOnStream = 2;
    private char zeroDigit;
    private Locale locale;
    private transient Currency currency;
    private static final long serialVersionUID = 5772796243397350300L;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public DecimalFormatSymbols() {
        this(Locale.getDefault());
    }

    private String safeGetString(ResourceBundle bundle, String name, String def) {
        if (bundle != null) {
            try {
                return bundle.getString(name);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return def;
    }

    private char safeGetChar(ResourceBundle bundle, String name, char def) {
        String r = null;
        if (bundle != null) {
            try {
                r = bundle.getString(name);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if (r == null || r.length() < 1) {
            return def;
        }
        return r.charAt(0);
    }

    public DecimalFormatSymbols(Locale loc) {
        ResourceBundle res;
        try {
            res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", loc, ClassLoader.getSystemClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            res = null;
        }
        this.locale = loc;
        this.currency = Currency.getInstance("XXX");
        this.currencySymbol = "?";
        this.intlCurrencySymbol = "XXX";
        try {
            Currency localeCurrency = Currency.getInstance(loc);
            if (localeCurrency != null) {
                this.setCurrency(localeCurrency);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.decimalSeparator = this.safeGetChar(res, "decimalSeparator", '.');
        this.digit = this.safeGetChar(res, "digit", '#');
        this.exponential = this.safeGetChar(res, "exponential", 'E');
        this.groupingSeparator = this.safeGetChar(res, "groupingSeparator", ',');
        this.infinity = this.safeGetString(res, "infinity", "\u221e");
        try {
            this.monetarySeparator = this.safeGetChar(res, "monetarySeparator", '.');
        }
        catch (MissingResourceException missingResourceException) {
            this.monetarySeparator = this.decimalSeparator;
        }
        this.minusSign = this.safeGetChar(res, "minusSign", '-');
        this.NaN = this.safeGetString(res, "NaN", "\ufffd");
        this.patternSeparator = this.safeGetChar(res, "patternSeparator", ';');
        this.percent = this.safeGetChar(res, "percent", '%');
        this.perMill = this.safeGetChar(res, "perMill", '\u2030');
        this.zeroDigit = this.safeGetChar(res, "zeroDigit", '0');
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalFormatSymbols)) {
            return false;
        }
        DecimalFormatSymbols dfs = (DecimalFormatSymbols)obj;
        return this.currencySymbol.equals(dfs.currencySymbol) && this.decimalSeparator == dfs.decimalSeparator && this.digit == dfs.digit && this.exponential == dfs.exponential && this.groupingSeparator == dfs.groupingSeparator && this.infinity.equals(dfs.infinity) && this.intlCurrencySymbol.equals(dfs.intlCurrencySymbol) && this.minusSign == dfs.minusSign && this.monetarySeparator == dfs.monetarySeparator && this.NaN.equals(dfs.NaN) && this.patternSeparator == dfs.patternSeparator && this.percent == dfs.percent && this.perMill == dfs.perMill && this.zeroDigit == dfs.zeroDigit;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getDigit() {
        return this.digit;
    }

    char getExponential() {
        return this.exponential;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public String getNaN() {
        return this.NaN;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public char getPercent() {
        return this.percent;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public int hashCode() {
        return this.zeroDigit << 16 + this.groupingSeparator << 8 + this.decimalSeparator;
    }

    public void setCurrency(Currency currency) {
        this.intlCurrencySymbol = currency.getCurrencyCode();
        this.currencySymbol = currency.getSymbol(this.locale);
        this.currency = currency;
    }

    public void setCurrencySymbol(String currency) {
        this.currencySymbol = currency;
    }

    public void setDecimalSeparator(char decimalSep) {
        this.decimalSeparator = decimalSep;
    }

    public void setDigit(char digit) {
        this.digit = digit;
    }

    void setExponential(char exp) {
        this.exponential = exp;
    }

    public void setGroupingSeparator(char groupSep) {
        this.groupingSeparator = groupSep;
    }

    public void setInfinity(String infinity) {
        this.infinity = infinity;
    }

    public void setInternationalCurrencySymbol(String currencyCode) {
        this.intlCurrencySymbol = currencyCode;
        try {
            this.currency = Currency.getInstance(currencyCode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.currency = null;
        }
        if (this.currency != null) {
            this.setCurrencySymbol(this.currency.getSymbol(this.locale));
        }
    }

    public void setMinusSign(char minusSign) {
        this.minusSign = minusSign;
    }

    public void setMonetaryDecimalSeparator(char decimalSep) {
        this.monetarySeparator = decimalSep;
    }

    public void setNaN(String nan) {
        this.NaN = nan;
    }

    public void setPatternSeparator(char patternSep) {
        this.patternSeparator = patternSep;
    }

    public void setPercent(char percent) {
        this.percent = percent;
    }

    public void setPerMill(char perMill) {
        this.perMill = perMill;
    }

    public void setZeroDigit(char zeroDigit) {
        this.zeroDigit = zeroDigit;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        if (this.serialVersionOnStream < 2) {
            this.locale = Locale.getDefault();
        }
        this.serialVersionOnStream = 2;
    }

    public static final DecimalFormatSymbols getInstance() {
        return DecimalFormatSymbols.getInstance(Locale.getDefault());
    }

    /*
     * Unable to fully structure code
     */
    public static final DecimalFormatSymbols getInstance(Locale locale) {
        try {
            if (!locale.equals(Locale.ROOT)) {
                ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", locale, ClassLoader.getSystemClassLoader());
            }
            return new DecimalFormatSymbols(locale);
        }
        catch (MissingResourceException v0) {
            ** for (p : ServiceLoader.load(DecimalFormatSymbolsProvider.class))
        }
lbl-1000:
        // 1 sources

        {
            var6_6 = p.getAvailableLocales();
            var5_5 = var6_6.length;
            var4_4 = 0;
            while (var4_4 < var5_5) {
                loc = var6_6[var4_4];
                if (loc.equals(locale)) {
                    syms = p.getInstance(locale);
                    if (syms == null) continue block2;
                    return syms;
                }
                ++var4_4;
            }
            continue;
        }
lbl20:
        // 1 sources

        return DecimalFormatSymbols.getInstance(LocaleHelper.getFallbackLocale(locale));
    }
}

