/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.lang.CPStringBuilder;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedStringIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedString {
    private StringCharacterIterator sci;
    private AttributeRange[] attribs;

    public AttributedString(String str) {
        this.sci = new StringCharacterIterator(str);
        this.attribs = new AttributeRange[0];
    }

    public AttributedString(String str, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        this(str);
        this.attribs = new AttributeRange[1];
        this.attribs[0] = new AttributeRange(attributes, 0, str.length());
    }

    public AttributedString(AttributedCharacterIterator aci) {
        this(aci, aci.getBeginIndex(), aci.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator aci, int beginIndex, int endIndex) {
        this(aci, beginIndex, endIndex, null);
    }

    public AttributedString(AttributedCharacterIterator aci, int begin, int end, AttributedCharacterIterator.Attribute[] attributes) {
        if (begin < 0 || end < begin || end > aci.getEndIndex()) {
            throw new IllegalArgumentException("Bad index values");
        }
        CPStringBuilder sb = new CPStringBuilder("");
        Set<AttributedCharacterIterator.Attribute> allAttribs = aci.getAllAttributeKeys();
        if (attributes != null) {
            allAttribs.retainAll(Arrays.asList(attributes));
        }
        char c = aci.setIndex(begin);
        ArrayList<AttributeRange> accum = new ArrayList<AttributeRange>();
        do {
            sb.append(c);
            for (AttributedCharacterIterator.Attribute obj : allAttribs) {
                AttributedCharacterIterator.Attribute attrib;
                Object attribObj;
                if (!(obj instanceof AttributedCharacterIterator.Attribute) || (attribObj = aci.getAttribute(attrib = obj)) == null) continue;
                int rl = aci.getRunLimit(attrib);
                if (rl > end) {
                    rl = end;
                }
                rl -= begin;
                int rs = aci.getRunStart(attrib);
                if (rs < aci.getIndex() && aci.getIndex() != begin) continue;
                if ((rs -= begin) < 0) {
                    if (attribObj instanceof Annotation) continue;
                    rs = 0;
                }
                Hashtable<AttributedCharacterIterator.Attribute, Object> newMap = new Hashtable<AttributedCharacterIterator.Attribute, Object>();
                newMap.put(attrib, attribObj);
                accum.add(new AttributeRange(newMap, rs, rl));
            }
            c = aci.next();
        } while (aci.getIndex() < end);
        this.attribs = new AttributeRange[accum.size()];
        this.attribs = accum.toArray(this.attribs);
        this.sci = new StringCharacterIterator(sb.toString());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attrib, Object value) {
        this.addAttribute(attrib, value, 0, this.sci.getEndIndex());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attrib, Object value, int begin, int end) {
        if (attrib == null) {
            throw new IllegalArgumentException("null attribute");
        }
        if (end <= begin) {
            throw new IllegalArgumentException("Requires end > begin");
        }
        HashMap<AttributedCharacterIterator.Attribute, Object> hm = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        hm.put(attrib, value);
        this.addAttributes(hm, begin, end);
    }

    public void addAttributes(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes, int beginIndex, int endIndex) {
        if (attributes == null) {
            throw new NullPointerException("null attribute");
        }
        if (beginIndex < 0 || endIndex > this.sci.getEndIndex() || endIndex <= beginIndex) {
            throw new IllegalArgumentException("bad range");
        }
        AttributeRange[] new_list = new AttributeRange[this.attribs.length + 1];
        System.arraycopy(this.attribs, 0, new_list, 0, this.attribs.length);
        this.attribs = new_list;
        this.attribs[this.attribs.length - 1] = new AttributeRange(attributes, beginIndex, endIndex);
    }

    public AttributedCharacterIterator getIterator() {
        return new AttributedStringIterator(this.sci, this.attribs, 0, this.sci.getEndIndex(), null);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes) {
        return this.getIterator(attributes, 0, this.sci.getEndIndex());
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributes, int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.sci.getEndIndex() || endIndex < beginIndex) {
            throw new IllegalArgumentException("bad range");
        }
        return new AttributedStringIterator(this.sci, this.attribs, beginIndex, endIndex, attributes);
    }

    final class AttributeRange {
        Map attribs;
        int beginIndex;
        int endIndex;

        AttributeRange(Map attribs, int beginIndex, int endIndex) {
            this.attribs = attribs;
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }
    }
}

