/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.java.lang.management.BeanImpl;
import gnu.java.lang.management.VMMemoryMXBeanImpl;
import gnu.javax.management.ListenerData;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class MemoryMXBeanImpl
extends BeanImpl
implements MemoryMXBean,
NotificationEmitter {
    private List listeners = new ArrayList();
    private long notificationCount = 0L;
    public static CompositeType notifType;
    public static CompositeType usageType;

    static {
        try {
            CompositeType usageType = new CompositeType(MemoryUsage.class.getName(), "Describes the usage levels of a pool", new String[]{"init", "used", "committed", "max"}, new String[]{"Initial level", "Used level", "Committed level", "Maximum level"}, new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG});
            new CompositeType(MemoryNotificationInfo.class.getName(), "Provides the notification info on memory usage", new String[]{"poolName", "usage", "count"}, new String[]{"Name of the memory pool", "Usage level of the memory pool", "Number of times the threshold has been crossed"}, new OpenType[]{SimpleType.STRING, usageType, SimpleType.LONG});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Something went wrong in creating the composite data types.", e);
        }
    }

    public MemoryMXBeanImpl() throws NotCompliantMBeanException {
        super((Class)MemoryMXBean.class);
    }

    public void gc() {
        System.gc();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return VMMemoryMXBeanImpl.getHeapMemoryUsage();
    }

    public MemoryUsage getNonHeapMemoryUsage() {
        return VMMemoryMXBeanImpl.getNonHeapMemoryUsage();
    }

    public int getObjectPendingFinalizationCount() {
        return VMMemoryMXBeanImpl.getObjectPendingFinalizationCount();
    }

    public boolean isVerbose() {
        return VMMemoryMXBeanImpl.isVerbose();
    }

    public void setVerbose(boolean verbose) {
        this.checkControlPermissions();
        VMMemoryMXBeanImpl.setVerbose(verbose);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object passback) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener added to bean.");
        }
        this.listeners.add(new ListenerData(listener, filter, passback));
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"java.management.memory.collection.threshold.exceeded", "java.management.memory.threshold.exceeded"}, Notification.class.getName(), "Memory Usage Notifications")};
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Iterator it = this.listeners.iterator();
        boolean foundOne = false;
        while (it.hasNext()) {
            ListenerData data = (ListenerData)it.next();
            if (data.getListener() != listener) continue;
            it.remove();
            foundOne = true;
        }
        if (!foundOne) {
            throw new ListenerNotFoundException("The specified listener, " + listener + "is not registered with this bean.");
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object passback) throws ListenerNotFoundException {
        if (!this.listeners.remove(new ListenerData(listener, filter, passback))) {
            throw new ListenerNotFoundException("The specified listener, " + listener + " with filter " + filter + "and passback " + passback + ", is not registered with this bean.");
        }
    }

    void fireNotification(String type, String poolName, long init, long used, long committed, long max, long count) {
        CompositeDataSupport data;
        Notification notif = new Notification(type, this, this.notificationCount);
        MemoryUsage usage = new MemoryUsage(init, used, committed, max);
        try {
            data = new CompositeDataSupport(notifType, new String[]{"poolName", "usage", "count"}, new Object[]{poolName, usage, count});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Something went wrong in creating the composite data instance.", e);
        }
        notif.setUserData(data);
        for (ListenerData ldata : this.listeners) {
            NotificationFilter filter = ldata.getFilter();
            if (filter != null && !filter.isNotificationEnabled(notif)) continue;
            ldata.getListener().handleNotification(notif, ldata.getPassback());
        }
        ++this.notificationCount;
    }

    void fireThresholdExceededNotification(String poolName, long init, long used, long committed, long max, long count) {
        this.fireNotification("java.management.memory.threshold.exceeded", poolName, init, used, committed, max, count);
    }

    void fireCollectionThresholdExceededNotification(String poolName, long init, long used, long committed, long max, long count) {
        this.fireNotification("java.management.memory.collection.threshold.exceeded", poolName, init, used, committed, max, count);
    }
}

