/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.namespace.QName;

public abstract class Duration {
    public QName getXMLSchemaType() {
        int n = 0;
        n |= this.isSet(DatatypeConstants.YEARS) ? 32 : 0;
        n |= this.isSet(DatatypeConstants.MONTHS) ? 16 : 0;
        n |= this.isSet(DatatypeConstants.DAYS) ? 8 : 0;
        n |= this.isSet(DatatypeConstants.HOURS) ? 4 : 0;
        n |= this.isSet(DatatypeConstants.MINUTES) ? 2 : 0;
        switch (n |= this.isSet(DatatypeConstants.SECONDS) ? 1 : 0) {
            case 63: {
                return DatatypeConstants.DURATION;
            }
            case 15: {
                return DatatypeConstants.DURATION_DAYTIME;
            }
            case 48: {
                return DatatypeConstants.DURATION_YEARMONTH;
            }
        }
        throw new IllegalStateException();
    }

    public abstract int getSign();

    public int getYears() {
        Number number = this.getField(DatatypeConstants.YEARS);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public int getMonths() {
        Number number = this.getField(DatatypeConstants.MONTHS);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public int getDays() {
        Number number = this.getField(DatatypeConstants.DAYS);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public int getHours() {
        Number number = this.getField(DatatypeConstants.HOURS);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public int getMinutes() {
        Number number = this.getField(DatatypeConstants.MINUTES);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public int getSeconds() {
        Number number = this.getField(DatatypeConstants.SECONDS);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public long getTimeInMillis(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        long l = calendar2.getTimeInMillis();
        this.addTo(calendar2);
        long l2 = calendar2.getTimeInMillis();
        return l2 - l;
    }

    public long getTimeInMillis(Date date) {
        Date date2 = (Date)date.clone();
        long l = date2.getTime();
        this.addTo(date2);
        long l2 = date2.getTime();
        return l2 - l;
    }

    public abstract Number getField(DatatypeConstants.Field var1);

    public abstract boolean isSet(DatatypeConstants.Field var1);

    public abstract Duration add(Duration var1);

    public abstract void addTo(Calendar var1);

    public void addTo(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(date.getTime());
        this.addTo(gregorianCalendar);
        date.setTime(gregorianCalendar.getTimeInMillis());
    }

    public Duration subtract(Duration duration) {
        throw new UnsupportedOperationException();
    }

    public Duration multiply(int n) {
        return this.multiply(BigDecimal.valueOf(n));
    }

    public abstract Duration multiply(BigDecimal var1);

    public abstract Duration negate();

    public abstract Duration normalizeWith(Calendar var1);

    public abstract int compare(Duration var1);

    public boolean isLongerThan(Duration duration) {
        throw new UnsupportedOperationException();
    }

    public boolean isShorterThan(Duration duration) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        throw new UnsupportedOperationException();
    }

    public abstract int hashCode();

    public String toString() {
        throw new UnsupportedOperationException();
    }
}

