/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    static final long serialVersionUID = 3288129636638950196L;
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList;
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel;
    protected int selectionMode;
    protected TreePath leadPath;
    protected int leadIndex;
    protected int leadRow;

    private /* synthetic */ void finit$() {
        this.leadRow = -1;
    }

    public DefaultTreeSelectionModel() {
        this.finit$();
        this.setSelectionMode(4);
        this.listenerList = new EventListenerList();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTreeSelectionModel defaultTreeSelectionModel = (DefaultTreeSelectionModel)super.clone();
        defaultTreeSelectionModel.selection = (TreePath[])this.selection.clone();
        if (this.listSelectionModel != null) {
            defaultTreeSelectionModel.listSelectionModel = (DefaultListSelectionModel)this.listSelectionModel.clone();
        }
        return defaultTreeSelectionModel;
    }

    public String toString() {
        if (this.isSelectionEmpty()) {
            return "[selection empty]";
        }
        StringBuffer stringBuffer = new StringBuffer("selected rows: [");
        for (int i = 0; i < this.selection.length; ++i) {
            stringBuffer.append(this.getRow(this.selection[i]));
            stringBuffer.append(' ');
        }
        stringBuffer.append(", lead " + this.getLeadSelectionRow());
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
        this.insureRowContinuity();
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionPath(TreePath treePath) {
        TreeSelectionEvent treeSelectionEvent;
        TreePath[] treePathArray = this.selection;
        this.selection = new TreePath[]{treePath};
        TreePath treePath2 = this.leadPath;
        this.leadIndex = 0;
        this.leadRow = this.getRow(treePath);
        this.leadPath = treePath;
        if (treePathArray != null && treePathArray.length > 0) {
            TreePath[] treePathArray2 = new TreePath[treePathArray.length + 1];
            boolean[] blArray = new boolean[treePathArray2.length];
            blArray[0] = true;
            treePathArray2[0] = treePath;
            System.arraycopy(treePathArray, 0, treePathArray2, 1, treePathArray.length);
            treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray2, blArray, treePath2, treePath);
        } else {
            treeSelectionEvent = new TreeSelectionEvent((Object)this, treePath, true, treePath2, treePath);
        }
        this.fireValueChanged(treeSelectionEvent);
    }

    int getRow(TreePath treePath) {
        RowMapper rowMapper = this.getRowMapper();
        if (rowMapper instanceof AbstractLayoutCache) {
            AbstractLayoutCache abstractLayoutCache = (AbstractLayoutCache)rowMapper;
            return abstractLayoutCache.getRowForPath(treePath);
        }
        int[] nArray = rowMapper.getRowsForPaths(new TreePath[]{treePath});
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        this.insureUniqueness();
        this.clearSelection();
        this.addSelectionPaths(treePathArray);
    }

    public void addSelectionPath(TreePath treePath) {
        TreePath[] treePathArray;
        if (!this.isPathSelected(treePath)) {
            if (this.selectionMode == 1 || this.isSelectionEmpty() || !this.canPathBeAdded(treePath)) {
                this.setSelectionPath(treePath);
            } else {
                treePathArray = new TreePath[this.selection.length + 1];
                System.arraycopy(this.selection, 0, treePathArray, 0, this.selection.length);
                treePathArray[treePathArray.length - 1] = treePath;
                this.selection = new TreePath[treePathArray.length];
                System.arraycopy(treePathArray, 0, this.selection, 0, treePathArray.length);
            }
        }
        if (treePath != this.leadPath) {
            treePathArray = this.leadPath;
            this.leadPath = treePath;
            this.leadRow = this.getRow(treePath);
            this.leadIndex = this.selection.length - 1;
            this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, true, (TreePath)treePathArray, this.leadPath));
        }
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        this.insureUniqueness();
        if (treePathArray != null) {
            TreePath treePath = null;
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath[] treePathArray2;
                treePath = treePathArray[i];
                if (this.isPathSelected(treePath)) continue;
                if (this.isSelectionEmpty()) {
                    this.setSelectionPath(treePath);
                } else {
                    treePathArray2 = new TreePath[this.selection.length + 1];
                    System.arraycopy(this.selection, 0, treePathArray2, 0, this.selection.length);
                    treePathArray2[treePathArray2.length - 1] = treePath;
                    this.selection = new TreePath[treePathArray2.length];
                    System.arraycopy(treePathArray2, 0, this.selection, 0, treePathArray2.length);
                }
                treePathArray2 = this.leadPath;
                this.leadPath = treePathArray[treePathArray.length - 1];
                this.leadRow = this.getRow(this.leadPath);
                this.leadIndex = this.selection.length - 1;
                this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, true, (TreePath)treePathArray2, this.leadPath));
            }
            this.insureRowContinuity();
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        if (this.isSelectionEmpty()) {
            return;
        }
        int n = -1;
        if (this.isPathSelected(treePath)) {
            for (int i = 0; i < this.selection.length; ++i) {
                if (!this.selection[i].equals(treePath)) continue;
                n = i;
                break;
            }
            TreePath[] treePathArray = new TreePath[this.selection.length - 1];
            System.arraycopy(this.selection, 0, treePathArray, 0, n);
            System.arraycopy(this.selection, n + 1, treePathArray, n, this.selection.length - n - 1);
            this.selection = new TreePath[treePathArray.length];
            System.arraycopy(treePathArray, 0, this.selection, 0, treePathArray.length);
            TreePath treePath2 = this.leadPath;
            if (treePath != null && this.leadPath != null && treePath.equals(this.leadPath)) {
                this.leadPath = null;
            }
            this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, false, treePath2, this.leadPath));
            this.insureRowContinuity();
        }
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (this.isSelectionEmpty()) {
            return;
        }
        if (treePathArray != null) {
            int n = -1;
            TreePath treePath = null;
            TreePath treePath2 = this.leadPath;
            for (int i = 0; i < treePathArray.length; ++i) {
                treePath = treePathArray[i];
                if (!this.isPathSelected(treePath)) continue;
                for (int j = 0; j < this.selection.length; ++j) {
                    if (this.selection[i].equals(treePath)) {
                        n = j;
                        break;
                    }
                    if (this.leadPath == null || !this.leadPath.equals(treePath)) continue;
                    this.leadPath = null;
                }
                TreePath[] treePathArray2 = new TreePath[this.selection.length - 1];
                System.arraycopy(this.selection, 0, treePathArray2, 0, n);
                System.arraycopy(this.selection, n + 1, treePathArray2, n, this.selection.length - n - 1);
                this.selection = new TreePath[treePathArray2.length];
                System.arraycopy(treePathArray2, 0, this.selection, 0, treePathArray2.length);
                this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, false, treePath2, this.leadPath));
            }
            this.insureRowContinuity();
        }
    }

    public TreePath getSelectionPath() {
        if (this.selection == null || this.selection.length == 0) {
            return null;
        }
        return this.selection[0];
    }

    public TreePath[] getSelectionPaths() {
        return this.selection;
    }

    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    public boolean isPathSelected(TreePath treePath) {
        if (this.selection == null) {
            return false;
        }
        for (int i = 0; i < this.selection.length; ++i) {
            if (!this.selection[i].equals(treePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectionEmpty() {
        return this.selection == null || this.selection.length == 0;
    }

    public void clearSelection() {
        if (!this.isSelectionEmpty()) {
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, this.selection, new boolean[this.selection.length], this.leadPath, null);
            this.leadPath = null;
            this.selection = null;
            this.fireValueChanged(treeSelectionEvent);
        } else {
            this.leadPath = null;
            this.selection = null;
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener"), treeSelectionListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener"), treeSelectionListener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.getListeners(DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener"));
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeSelectionListener[] treeSelectionListenerArray = this.getTreeSelectionListeners();
        for (int i = 0; i < treeSelectionListenerArray.length; ++i) {
            treeSelectionListenerArray[i].valueChanged(treeSelectionEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public int[] getSelectionRows() {
        if (this.rowMapper == null) {
            return null;
        }
        return this.rowMapper.getRowsForPaths(this.selection);
    }

    public int getMinSelectionRow() {
        if (this.rowMapper == null || this.selection == null || this.selection.length == 0) {
            return -1;
        }
        int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.min(n, nArray[i]);
        }
        return n;
    }

    public int getMaxSelectionRow() {
        if (this.rowMapper == null || this.selection == null || this.selection.length == 0) {
            return -1;
        }
        int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.max(n, nArray[i]);
        }
        return n;
    }

    public boolean isRowSelected(int n) {
        if (this.isSelectionEmpty()) {
            return false;
        }
        RowMapper rowMapper = this.getRowMapper();
        if (rowMapper instanceof AbstractLayoutCache) {
            AbstractLayoutCache abstractLayoutCache = (AbstractLayoutCache)rowMapper;
            TreePath treePath = abstractLayoutCache.getPathForRow(n);
            return this.isPathSelected(treePath);
        }
        int[] nArray = rowMapper.getRowsForPaths(this.selection);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public void resetRowSelection() {
    }

    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void insureRowContinuity() {
        if (this.selection == null || this.selection.length < 2) {
            return;
        }
        if (this.selectionMode == 2) {
            if (this.rowMapper == null) {
                this.selectOne();
            } else {
                int n;
                int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
                Arrays.sort(nArray);
                for (n = 1; n < nArray.length && nArray[n - 1] == nArray[n] - 1; ++n) {
                }
                if (n < nArray.length) {
                    TreePath[] treePathArray = new TreePath[n];
                    for (int i = 0; i < treePathArray.length; ++i) {
                        treePathArray[n] = this.getPath(i);
                    }
                    this.setSelectionPaths(treePathArray);
                }
            }
        } else if (this.selectionMode == 1) {
            this.selectOne();
        }
    }

    private void selectOne() {
        if (this.leadIndex > 0 && this.leadIndex < this.selection.length) {
            this.setSelectionPath(this.selection[this.leadIndex]);
        } else {
            this.setSelectionPath(this.selection[this.selection.length - 1]);
        }
    }

    private TreePath getPath(int n) {
        if (this.rowMapper instanceof AbstractLayoutCache) {
            return ((AbstractLayoutCache)this.rowMapper).getPathForRow(n);
        }
        int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return this.selection[i];
        }
        throw new InternalError(n + " not in selection");
    }

    protected boolean arePathsContiguous(TreePath[] treePathArray) {
        if (this.rowMapper == null || treePathArray.length < 2) {
            return true;
        }
        int[] nArray = this.rowMapper.getRowsForPaths(treePathArray);
        Arrays.sort(nArray);
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i - 1] == nArray[i] - 1) continue;
            return false;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] treePathArray) {
        if (this.rowMapper == null || this.isSelectionEmpty() || this.selectionMode == 4) {
            return true;
        }
        TreePath[] treePathArray2 = new TreePath[treePathArray.length + this.selection.length];
        System.arraycopy(treePathArray, 0, treePathArray2, 0, treePathArray.length);
        System.arraycopy(this.selection, 0, treePathArray2, treePathArray.length, this.selection.length);
        return this.arePathsContiguous(treePathArray2);
    }

    private boolean canPathBeAdded(TreePath treePath) {
        if (this.rowMapper == null || this.isSelectionEmpty() || this.selectionMode == 4) {
            return true;
        }
        TreePath[] treePathArray = new TreePath[this.selection.length + 1];
        System.arraycopy(this.selection, 0, treePathArray, 0, this.selection.length);
        treePathArray[treePathArray.length - 1] = treePath;
        return this.arePathsContiguous(treePathArray);
    }

    protected boolean canPathsBeRemoved(TreePath[] treePathArray) {
        int n;
        if (this.rowMapper == null || this.isSelectionEmpty() || this.selectionMode == 4) {
            return true;
        }
        HashSet hashSet = new HashSet();
        for (n = 0; n < this.selection.length; ++n) {
            hashSet.add(this.selection[n]);
        }
        for (n = 0; n < treePathArray.length; ++n) {
            hashSet.remove(treePathArray[n]);
        }
        TreePath[] treePathArray2 = new TreePath[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        for (int i = 0; i < treePathArray2.length; ++i) {
            treePathArray2[i] = (TreePath)iterator.next();
        }
        return this.arePathsContiguous(treePathArray2);
    }

    protected void notifyPathChange(Vector vector, TreePath treePath) {
        TreePath[] treePathArray = new TreePath[vector.size()];
        for (int i = 0; i < treePathArray.length; ++i) {
            treePathArray[i] = (TreePath)vector.get(i);
        }
        boolean[] blArray = new boolean[treePathArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.isPathSelected(treePathArray[i]);
        }
        TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray, blArray, treePath, this.leadPath);
        this.fireValueChanged(treeSelectionEvent);
    }

    protected void updateLeadIndex() {
        if (this.isSelectionEmpty()) {
            this.leadIndex = -1;
            this.leadRow = -1;
        } else {
            this.leadRow = this.getRow(this.leadPath);
            for (int i = 0; i < this.selection.length; ++i) {
                if (!this.selection[i].equals(this.leadPath)) continue;
                this.leadIndex = i;
                break;
            }
            this.leadIndex = this.leadRow;
        }
    }

    protected void insureUniqueness() {
    }
}

