/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;

public class FormView
extends ComponentView
implements ActionListener {
    public static final String SUBMIT = UIManager.getString("FormView.submitButtonText");
    public static final String RESET = UIManager.getString("FormView.resetButtonText");

    public FormView(Element element) {
        super(element);
    }

    protected Component createComponent() {
        JComponent jComponent = null;
        Element element = this.getElement();
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object.equals(HTML.Tag.INPUT)) {
            AttributeSet attributeSet = element.getAttributes();
            String string = (String)attributeSet.getAttribute(HTML.Attribute.TYPE);
            String string2 = (String)attributeSet.getAttribute(HTML.Attribute.VALUE);
            if (string.equals("button")) {
                jComponent = new JButton(string2);
            } else if (string.equals("checkbox")) {
                jComponent = new JCheckBox(string2);
            } else if (string.equals("image")) {
                jComponent = new JButton(string2);
            } else if (string.equals("password")) {
                jComponent = new JPasswordField(string2);
            } else if (string.equals("radio")) {
                jComponent = new JRadioButton(string2);
            } else if (string.equals("reset")) {
                if (string2 == null || string2.equals("")) {
                    string2 = RESET;
                }
                jComponent = new JButton(string2);
            } else if (string.equals("submit")) {
                if (string2 == null || string2.equals("")) {
                    string2 = SUBMIT;
                }
                jComponent = new JButton(string2);
            } else if (string.equals("text")) {
                jComponent = new JTextField(string2);
            }
        }
        return jComponent;
    }

    public float getMaximumSpan(int n) {
        float f;
        if (n == 0) {
            f = this.getComponent().getMaximumSize().width;
        } else if (n == 1) {
            f = this.getComponent().getMaximumSize().height;
        } else {
            throw new IllegalArgumentException("Invalid axis parameter");
        }
        return f;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        AttributeSet attributeSet;
        String string;
        Element element = this.getElement();
        Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (object.equals(HTML.Tag.INPUT) && (string = (String)(attributeSet = element.getAttributes()).getAttribute(HTML.Attribute.TYPE)).equals("submit")) {
            this.submitData("");
        }
    }

    protected void submitData(String string) {
    }

    protected void imageSubmit(String string) {
    }

    String getImageData(Point point) {
        String string = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.NAME);
        String string2 = string == null || string.equals("") ? "x=" + point.x + "&y=" + point.y : string + ".x=" + point.x + "&" + string + ".y=" + point.y;
        return string2;
    }

    protected class MouseEventListener
    extends MouseAdapter {
        private /* synthetic */ FormView this$0;

        protected MouseEventListener(FormView formView) {
            this.this$0 = formView;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            String string = this.this$0.getImageData(mouseEvent.getPoint());
            this.this$0.imageSubmit(string);
        }
    }
}

