/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static final long serialVersionUID = 8042858831190784241L;
    public static final String DEFAULT_STYLE = "default";
    NamedStyle defaultStyle;
    static Hashtable sharedAttributeSets;
    static Hashtable sharedFonts;
    static StyleContext defaultStyleContext;
    static final int compressionThreshold = 9;
    private static Hashtable staticAttributeKeys;
    EventListenerList listenerList;
    Hashtable styleTable;

    private /* synthetic */ void finit$() {
        this.defaultStyle = new NamedStyle(this, DEFAULT_STYLE, null);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public StyleContext() {
        this.finit$();
        this.listenerList = new EventListenerList();
        this.styleTable = new Hashtable();
        this.styleTable.put(DEFAULT_STYLE, this.defaultStyle);
    }

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallAttributeSet(this, attributeSet);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new SimpleAttributeSet(attributeSet);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(StyleContext.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(StyleContext.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(StyleContext.class$("javax.swing.event.ChangeListener"));
    }

    public Style addStyle(String string, Style style) {
        NamedStyle namedStyle = new NamedStyle(this, string, style);
        if (string != null) {
            this.styleTable.put(string, namedStyle);
        }
        return namedStyle;
    }

    public void removeStyle(String string) {
        this.styleTable.remove(string);
    }

    public Style getStyle(String string) {
        return (Style)this.styleTable.get(string);
    }

    public Enumeration getStyleNames() {
        return this.styleTable.keys();
    }

    public Font getFont(AttributeSet attributeSet) {
        String string = StyleConstants.getFontFamily(attributeSet);
        int n = 0;
        if (StyleConstants.isBold(attributeSet)) {
            ++n;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n += 2;
        }
        int n2 = StyleConstants.getFontSize(attributeSet);
        return this.getFont(string, n, n2);
    }

    public Font getFont(String string, int n, int n2) {
        SimpleFontSpec simpleFontSpec = new SimpleFontSpec(string, n, n2);
        if (sharedFonts.containsKey(simpleFontSpec)) {
            return (Font)sharedFonts.get(simpleFontSpec);
        }
        Font font = new Font(string, n, n2);
        sharedFonts.put(simpleFontSpec, font);
        return font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Color getForeground(AttributeSet attributeSet) {
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground(AttributeSet attributeSet) {
        return StyleConstants.getBackground(attributeSet);
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    public static StyleContext getDefaultStyleContext() {
        return defaultStyleContext;
    }

    public AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (attributeSet instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attributeSet).addAttribute(object, object2);
            return attributeSet;
        }
        MutableAttributeSet mutableAttributeSet = this.createLargeAttributeSet(attributeSet);
        mutableAttributeSet.addAttribute(object, object2);
        if (mutableAttributeSet.getAttributeCount() >= this.getCompressionThreshold()) {
            return mutableAttributeSet;
        }
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(mutableAttributeSet);
        if (sharedAttributeSets.containsKey(smallAttributeSet)) {
            smallAttributeSet = (SmallAttributeSet)sharedAttributeSets.get(smallAttributeSet);
        } else {
            sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
        }
        return smallAttributeSet;
    }

    public AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attributeSet).addAttributes(attributeSet2);
            return attributeSet;
        }
        MutableAttributeSet mutableAttributeSet = this.createLargeAttributeSet(attributeSet);
        mutableAttributeSet.addAttributes(attributeSet2);
        if (mutableAttributeSet.getAttributeCount() >= this.getCompressionThreshold()) {
            return mutableAttributeSet;
        }
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(mutableAttributeSet);
        if (sharedAttributeSets.containsKey(smallAttributeSet)) {
            smallAttributeSet = (SmallAttributeSet)sharedAttributeSets.get(smallAttributeSet);
        } else {
            sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
        }
        return smallAttributeSet;
    }

    public AttributeSet getEmptySet() {
        AttributeSet attributeSet = this.createSmallAttributeSet(null);
        if (sharedAttributeSets.containsKey(attributeSet)) {
            attributeSet = (AttributeSet)sharedAttributeSets.get(attributeSet);
        } else {
            sharedAttributeSets.put(attributeSet, attributeSet);
        }
        return attributeSet;
    }

    public void reclaim(AttributeSet attributeSet) {
        if (sharedAttributeSets.containsKey(attributeSet)) {
            sharedAttributeSets.remove(attributeSet);
        }
    }

    public AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (attributeSet instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attributeSet).removeAttribute(object);
            if (attributeSet.getAttributeCount() < this.getCompressionThreshold()) {
                SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(attributeSet);
                if (!sharedAttributeSets.containsKey(smallAttributeSet)) {
                    sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
                }
                attributeSet = (AttributeSet)sharedAttributeSets.get(smallAttributeSet);
            }
            return attributeSet;
        }
        MutableAttributeSet mutableAttributeSet = this.createLargeAttributeSet(attributeSet);
        mutableAttributeSet.removeAttribute(object);
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(mutableAttributeSet);
        if (sharedAttributeSets.containsKey(smallAttributeSet)) {
            smallAttributeSet = (SmallAttributeSet)sharedAttributeSets.get(smallAttributeSet);
        } else {
            sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
        }
        return smallAttributeSet;
    }

    public AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        return this.removeAttributes(attributeSet, attributeSet2.getAttributeNames());
    }

    public AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration enumeration) {
        if (attributeSet instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attributeSet).removeAttributes(enumeration);
            if (attributeSet.getAttributeCount() < this.getCompressionThreshold()) {
                SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(attributeSet);
                if (!sharedAttributeSets.containsKey(smallAttributeSet)) {
                    sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
                }
                attributeSet = (AttributeSet)sharedAttributeSets.get(smallAttributeSet);
            }
            return attributeSet;
        }
        MutableAttributeSet mutableAttributeSet = this.createLargeAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(enumeration);
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(mutableAttributeSet);
        if (sharedAttributeSets.containsKey(smallAttributeSet)) {
            smallAttributeSet = (SmallAttributeSet)sharedAttributeSets.get(smallAttributeSet);
        } else {
            sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
        }
        return smallAttributeSet;
    }

    public static Object getStaticAttribute(Object object) {
        if (object == null) {
            return null;
        }
        return staticAttributeKeys.get(object);
    }

    public static Object getStaticAttributeKey(Object object) {
        return object.getClass().getName() + "." + object.toString();
    }

    public static void readAttributeSet(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        if (objectInputStream == null || mutableAttributeSet == null) {
            return;
        }
        Object object = objectInputStream.readObject();
        Object object2 = objectInputStream.readObject();
        while (object != null && object2 != null) {
            Object object3 = staticAttributeKeys.get(object);
            Object object4 = staticAttributeKeys.get(object2);
            if (object3 != null) {
                object = object3;
            }
            if (object4 != null) {
                object2 = object4;
            }
            mutableAttributeSet.addAttribute(object, object2);
            object = objectInputStream.readObject();
            object2 = objectInputStream.readObject();
        }
    }

    public static void writeAttributeSet(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = StyleContext.getStaticAttribute(object);
            Object object3 = object2 == null ? object : object2;
            objectOutputStream.writeObject(object3);
            objectOutputStream.writeObject(attributeSet.getAttribute(object));
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    public void readAttributes(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        StyleContext.readAttributeSet(objectInputStream, mutableAttributeSet);
    }

    public void writeAttributes(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        StyleContext.writeAttributeSet(objectOutputStream, attributeSet);
    }

    public static void registerStaticAttributeKey(Object object) {
        if (object != null) {
            staticAttributeKeys.put(object.getClass().getName() + "." + object.toString(), object);
        }
    }

    static {
        DEFAULT_STYLE = DEFAULT_STYLE;
        sharedAttributeSets = new Hashtable();
        sharedFonts = new Hashtable();
        defaultStyleContext = new StyleContext();
        staticAttributeKeys = new Hashtable();
    }

    private static class SimpleFontSpec {
        String family;
        int style;
        int size;

        public SimpleFontSpec(String string, int n, int n2) {
            this.family = string;
            this.style = n;
            this.size = n2;
        }

        public boolean equals(Object object) {
            return object != null && object instanceof SimpleFontSpec && ((SimpleFontSpec)object).family.equals(this.family) && ((SimpleFontSpec)object).style == this.style && ((SimpleFontSpec)object).size == this.size;
        }

        public int hashCode() {
            return this.family.hashCode() + this.style + this.size;
        }
    }

    public class SmallAttributeSet
    implements AttributeSet {
        private /* synthetic */ StyleContext this$0;
        final Object[] attrs;

        public SmallAttributeSet(StyleContext styleContext, AttributeSet attributeSet) {
            this.this$0 = styleContext;
            if (attributeSet == null) {
                this.attrs = new Object[0];
            } else {
                int n = attributeSet.getAttributeCount();
                int n2 = 0;
                this.attrs = new Object[n * 2];
                Enumeration enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    this.attrs[n2++] = object;
                    this.attrs[n2++] = attributeSet.getAttribute(object);
                }
            }
        }

        public SmallAttributeSet(StyleContext styleContext, Object[] objectArray) {
            this.this$0 = styleContext;
            if (objectArray == null) {
                this.attrs = new Object[0];
            } else {
                this.attrs = new Object[objectArray.length];
                System.arraycopy(objectArray, 0, this.attrs, 0, objectArray.length);
            }
        }

        public Object clone() {
            return new SmallAttributeSet(this.this$0, this.attrs);
        }

        public boolean containsAttribute(Object object, Object object2) {
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (!this.attrs[i].equals(object) || !this.attrs[i + 1].equals(object2)) continue;
                return true;
            }
            return false;
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object object2 = enumeration.nextElement();
                if (this.containsAttribute(object2, object = attributeSet.getAttribute(object2))) continue;
                return false;
            }
            return true;
        }

        public AttributeSet copyAttributes() {
            return (AttributeSet)this.clone();
        }

        public boolean equals(Object object) {
            return object instanceof AttributeSet && this.isEqual((AttributeSet)object);
        }

        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (!this.attrs[i].equals(object)) continue;
                return this.attrs[i + 1];
            }
            if (!object.equals(AttributeSet.ResolveAttribute) && (attributeSet = this.getResolveParent()) != null && attributeSet instanceof AttributeSet) {
                return attributeSet.getAttribute(object);
            }
            return null;
        }

        public int getAttributeCount() {
            return this.attrs.length / 2;
        }

        public Enumeration getAttributeNames() {
            return new Enumeration(this){
                private /* synthetic */ SmallAttributeSet this$1;
                int i;
                {
                    this.this$1 = smallAttributeSet;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.i = 0;
                }

                public boolean hasMoreElements() {
                    return this.i < this.this$1.attrs.length;
                }

                public Object nextElement() {
                    this.i += 2;
                    return this.this$1.attrs[this.i - 2];
                }
            };
        }

        public AttributeSet getResolveParent() {
            return (AttributeSet)this.getAttribute(AttributeSet.ResolveAttribute);
        }

        public int hashCode() {
            return Arrays.asList(this.attrs).hashCode();
        }

        public boolean isDefined(Object object) {
            for (int i = 0; i < this.attrs.length; i += 2) {
                if (!this.attrs[i].equals(object)) continue;
                return true;
            }
            return false;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[StyleContext.SmallattributeSet:");
            for (int i = 0; i < this.attrs.length - 1; ++i) {
                stringBuffer.append(" (");
                stringBuffer.append(this.attrs[i].toString());
                stringBuffer.append("=");
                stringBuffer.append(this.attrs[i + 1].toString());
                stringBuffer.append(")");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public class NamedStyle
    implements Serializable,
    Style {
        private /* synthetic */ StyleContext this$0;
        private static final long serialVersionUID = -6690628971806226374L;
        protected ChangeEvent changeEvent;
        protected EventListenerList listenerList;
        AttributeSet attributes;
        String name;

        public NamedStyle(StyleContext styleContext) {
            this.this$0 = styleContext;
            this(styleContext, null, null);
        }

        public NamedStyle(StyleContext styleContext, Style style) {
            this.this$0 = styleContext;
            this(styleContext, null, style);
        }

        public NamedStyle(StyleContext styleContext, String string, Style style) {
            this.this$0 = styleContext;
            this.name = string;
            this.attributes = styleContext.getEmptySet();
            this.changeEvent = new ChangeEvent(this);
            this.listenerList = new EventListenerList();
            this.setResolveParent(style);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
            this.fireStateChanged();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.listenerList.add(StyleContext.class$("javax.swing.event.ChangeListener"), changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.listenerList.remove(StyleContext.class$("javax.swing.event.ChangeListener"), changeListener);
        }

        public EventListener[] getListeners(Class clazz) {
            return this.listenerList.getListeners(clazz);
        }

        public ChangeListener[] getChangeListeners() {
            return (ChangeListener[])this.getListeners(StyleContext.class$("javax.swing.event.ChangeListener"));
        }

        protected void fireStateChanged() {
            ChangeListener[] changeListenerArray = this.getChangeListeners();
            for (int i = 0; i < changeListenerArray.length; ++i) {
                changeListenerArray[i].stateChanged(this.changeEvent);
            }
        }

        public void addAttribute(Object object, Object object2) {
            this.attributes = this.this$0.addAttribute(this.attributes, object, object2);
            this.fireStateChanged();
        }

        public void addAttributes(AttributeSet attributeSet) {
            this.attributes = this.this$0.addAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public void removeAttribute(Object object) {
            this.attributes = this.this$0.removeAttribute(this.attributes, object);
            this.fireStateChanged();
        }

        public void removeAttributes(AttributeSet attributeSet) {
            this.attributes = this.this$0.removeAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public void removeAttributes(Enumeration enumeration) {
            this.attributes = this.this$0.removeAttributes(this.attributes, enumeration);
            this.fireStateChanged();
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public void setResolveParent(AttributeSet attributeSet) {
            if (attributeSet != null) {
                this.attributes = this.this$0.addAttribute(this.attributes, AttributeSet.ResolveAttribute, attributeSet);
            }
            this.fireStateChanged();
        }

        public String toString() {
            return "[NamedStyle: name=" + this.name + ", attrs=" + this.attributes.toString() + "]";
        }
    }
}

