/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    static final FlowStrategy sharedStrategy = new FlowStrategy();
    protected int layoutSpan;
    protected View layoutPool;
    protected FlowStrategy strategy = sharedStrategy;
    private boolean layoutDirty = true;

    public FlowView(Element element, int n) {
        super(element, n);
    }

    public int getFlowAxis() {
        int n = this.getAxis();
        int n2 = n == 0 ? 1 : 0;
        return n2;
    }

    public int getFlowSpan(int n) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n) {
        return this.getLeftInset();
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this, this.getElement(), this.getAxis());
            this.layoutPool.setParent(this);
        }
    }

    protected void layout(int n, int n2) {
        int n3 = this.getFlowAxis();
        if (n3 == 0) {
            if (this.layoutSpan != n) {
                this.layoutChanged(1);
                this.layoutSpan = n;
            }
        } else if (this.layoutSpan != n2) {
            this.layoutChanged(0);
            this.layoutSpan = n2;
        }
        if (this.layoutDirty) {
            this.strategy.layout(this);
            this.layoutDirty = false;
        }
        if (this.getPreferredSpan(this.getAxis()) != (float)n2) {
            this.preferenceChanged(this, false, true);
        }
        super.layout(n, n2);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
        this.layoutDirty = true;
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.removeUpdate(documentEvent, shape, viewFactory);
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
        this.layoutDirty = true;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.changedUpdate(documentEvent, shape, viewFactory);
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
        this.layoutDirty = true;
    }

    protected int getViewIndexAtPosition(int n) {
        if (!this.isAllocationValid()) {
            this.layout(this.getWidth(), this.getHeight());
        }
        int n2 = this.getViewCount();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n4 > n || n5 <= n) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = sizeRequirements;
        if (sizeRequirements2 == null) {
            sizeRequirements2 = new SizeRequirements();
        }
        sizeRequirements2.minimum = (int)this.layoutPool.getMinimumSpan(n);
        sizeRequirements2.preferred = Math.max(sizeRequirements2.minimum, (int)this.layoutPool.getMinimumSpan(n));
        sizeRequirements2.maximum = Integer.MAX_VALUE;
        sizeRequirements2.alignment = 0.5f;
        return sizeRequirements2;
    }

    class LogicalView
    extends BoxView {
        private /* synthetic */ FlowView this$0;

        LogicalView(FlowView flowView, Element element, int n) {
            this.this$0 = flowView;
            super(element, n);
        }
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
        }

        protected View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        public void layout(FlowView flowView) {
            flowView.removeAll();
            Element element = flowView.getElement();
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            int n3 = 0;
            while (n >= 0 && n < n2) {
                View view = flowView.createRow();
                flowView.append(view);
                n = this.layoutRow(flowView, n3, n);
                ++n3;
            }
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            View view;
            View view2 = flowView.getView(n);
            int n3 = flowView.getFlowAxis();
            int n4 = flowView.getFlowSpan(n);
            int n5 = flowView.getFlowStart(n);
            int n6 = n2;
            View view3 = this.getLogicalView(flowView);
            if (n4 == 0) {
                n4 = Integer.MAX_VALUE;
            }
            while (n4 > 0 && view3.getViewIndex(n6, Position.Bias.Forward) != -1 && (view = this.createView(flowView, n6, n4, n)) != null) {
                int n7 = (int)view.getPreferredSpan(n3);
                int n8 = view.getBreakWeight(n3, n5, n4);
                view2.append(view);
                n6 += view.getEndOffset() - view.getStartOffset();
                n5 += n7;
                if ((n4 -= n7) >= 0 && n8 < 3000) continue;
                int n9 = flowView.getFlowStart(n3);
                int n10 = flowView.getFlowSpan(n3);
                this.adjustRow(flowView, n, n10, n9);
                int n11 = view2.getViewCount();
                if (n11 > 0) {
                    n6 = view2.getView(n11 - 1).getEndOffset();
                    break;
                }
                n6 = -1;
                break;
            }
            if (n6 != n2) {
                return n6;
            }
            return -1;
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            View view = this.getLogicalView(flowView);
            int n4 = view.getViewIndex(n, Position.Bias.Forward);
            View view2 = null;
            if (n4 >= 0 && (view2 = view.getView(n4)).getStartOffset() != n) {
                view2 = view2.createFragment(n, view2.getEndOffset());
            }
            return view2;
        }

        protected void adjustRow(FlowView flowView, int n, int n2, int n3) {
            View view;
            int n4 = flowView.getFlowAxis();
            View view2 = flowView.getView(n);
            int n5 = view2.getViewCount();
            int n6 = -1;
            int n7 = 0;
            int n8 = n3;
            int n9 = n2;
            int n10 = n3;
            int n11 = n2;
            for (int i = 0; i < n5; ++i) {
                view = view2.getView(i);
                int n12 = view.getBreakWeight(n4, n10, n11);
                if (n12 >= n7) {
                    n6 = i;
                    n8 = n10;
                    n9 = n11;
                    n7 = n12;
                }
                int n13 = (int)view.getPreferredSpan(n4);
                n10 += n13;
                n11 -= n13;
            }
            if (n6 > -1) {
                View view3 = view2.getView(n6);
                view = view3.breakView(n4, view3.getStartOffset(), n8, n9);
                view2.replace(n6, n5 - n6, new View[]{view});
            }
        }
    }
}

