/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.Serializable;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.metal.MetalSplitPaneUI;
import javax.swing.plaf.metal.MetalUtils;

class MetalSplitPaneDivider
extends BasicSplitPaneDivider {
    Color dark;
    Color light;
    JSplitPane splitPane;
    int orientation;

    public MetalSplitPaneDivider(MetalSplitPaneUI metalSplitPaneUI, Color color, Color color2) {
        super(metalSplitPaneUI);
        this.setLayout(new MetalDividerLayout(this));
        this.splitPane = ((BasicSplitPaneDivider)this).splitPane;
        this.orientation = ((BasicSplitPaneDivider)this).orientation;
        this.light = color;
        this.dark = color2;
    }

    public void paint(Graphics graphics) {
        Border border;
        Dimension dimension = this.getSize();
        if (this.splitPane.hasFocus()) {
            graphics.setColor(UIManager.getColor("SplitPane.dividerFocusColor"));
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if ((border = this.getBorder()) != null) {
            border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
        MetalUtils.fillMetalPattern(this.splitPane, graphics, 2, 2, dimension.width - 4, dimension.height - 4, this.light, this.dark);
        if (this.splitPane.isOneTouchExpandable()) {
            ((BasicArrowButton)this.rightButton).paint(graphics);
            ((BasicArrowButton)this.leftButton).paint(graphics);
        }
    }

    public class MetalDividerLayout
    implements LayoutManager {
        private /* synthetic */ MetalSplitPaneDivider this$0;
        BasicArrowButton rb;
        BasicArrowButton lb;

        public MetalDividerLayout(MetalSplitPaneDivider metalSplitPaneDivider) {
            this.this$0 = metalSplitPaneDivider;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (this.this$0.splitPane.isOneTouchExpandable()) {
                Serializable serializable;
                if (container.getComponentCount() == 2) {
                    serializable = container.getComponent(0);
                    Component component = container.getComponent(1);
                    if (serializable instanceof BasicArrowButton && component instanceof BasicArrowButton) {
                        this.lb = (BasicArrowButton)serializable;
                        this.rb = (BasicArrowButton)component;
                    }
                }
                if (this.rb != null && this.lb != null) {
                    serializable = this.this$0.getLocation();
                    this.lb.setSize(this.lb.getPreferredSize());
                    this.rb.setSize(this.rb.getPreferredSize());
                    this.lb.setLocation(((Point)serializable).x, ((Point)serializable).y);
                    if (this.this$0.orientation == 1) {
                        this.rb.setDirection(3);
                        this.lb.setDirection(7);
                        this.rb.setLocation(((Point)serializable).x, ((Point)serializable).y + this.lb.getHeight());
                    } else {
                        this.rb.setDirection(5);
                        this.lb.setDirection(1);
                        this.rb.setLocation(((Point)serializable).x + this.lb.getWidth(), ((Point)serializable).y);
                    }
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.this$0.getDividerSize();
            return new Dimension(n, n);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

