/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.SharedUIDefaults;

public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    static JFrame owner = new JFrame();
    private static Border nonRolloverBorder;
    private static Border rolloverBorder;
    protected String constraintBeforeFloating;
    int lastGoodOrientation;
    protected Color dockingBorderColor;
    protected Color dockingColor;
    protected MouseInputListener dockingListener;
    protected DragWindow dragWindow;
    protected Color floatingBorderColor;
    protected Color floatingColor;
    protected int focusedCompIndex;
    protected PropertyChangeListener propertyListener;
    protected JToolBar toolBar;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    private transient Window floatFrame;
    transient Container origParent;
    transient Hashtable borders;
    private transient WindowListener windowListener;
    transient Dimension cachedBounds;
    transient int cachedOrientation;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean canDock(Component component, Point point) {
        return this.areaOfClick(component, point) != -1;
    }

    private int areaOfClick(Component component, Point point) {
        Rectangle rectangle = component.getBounds();
        Dimension dimension = this.toolBar.getSize();
        int n = Math.min(dimension.width, dimension.height);
        if (!rectangle.contains(point)) {
            return -1;
        }
        if (point.y < n) {
            return 1;
        }
        if (point.y > rectangle.height - n) {
            return 5;
        }
        if (point.x < n) {
            return 7;
        }
        if (point.x > rectangle.width - n) {
            return 3;
        }
        return -1;
    }

    protected MouseInputListener createDockingListener() {
        return new DockingListener(this, this.toolBar);
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        return new DragWindow(this);
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        return null;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        return new ToolBarDialog(this);
    }

    protected WindowListener createFrameListener() {
        return new FrameListener(this);
    }

    protected Border createNonRolloverBorder() {
        Border border = UIManager.getBorder("ToolBar.nonrolloverBorder");
        if (border == null) {
            border = new CompoundBorder(new BasicBorders.ButtonBorder(UIManager.getColor("Button.shadow"), UIManager.getColor("Button.darkShadow"), UIManager.getColor("Button.light"), UIManager.getColor("Button.highlight")), BasicBorders.getMarginBorder());
        }
        return border;
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener(this);
    }

    protected Border createRolloverBorder() {
        Border border = UIManager.getBorder("ToolBar.rolloverBorder");
        if (border == null) {
            border = new CompoundBorder(new BasicBorders.ButtonBorder(UIManager.getColor("Button.shadow"), UIManager.getColor("Button.darkShadow"), UIManager.getColor("Button.light"), UIManager.getColor("Button.highlight")), BasicBorders.getMarginBorder());
        }
        return border;
    }

    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener(this);
    }

    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener(this);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicToolBarUI();
    }

    protected void dragTo(Point point, Point point2) {
        int n = this.areaOfClick(this.origParent, SwingUtilities.convertPoint(this.toolBar, point, this.origParent));
        if (n != -1) {
            this.dragWindow.setBorderColor(this.dockingBorderColor);
            this.dragWindow.setBackground(this.dockingColor);
        } else {
            this.dragWindow.setBorderColor(this.floatingBorderColor);
            this.dragWindow.setBackground(this.floatingColor);
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = n == 1 || n == 5 || n == -1;
        this.cachedOrientation = this.toolBar.getOrientation();
        this.cachedBounds = this.toolBar.getSize();
        if (this.cachedOrientation == 0 && bl || this.cachedOrientation == 1 && !bl) {
            n2 = this.cachedBounds.width;
            n3 = this.cachedBounds.height;
        } else {
            n2 = this.cachedBounds.height;
            n3 = this.cachedBounds.width;
        }
        Point point3 = this.dragWindow.getOffset();
        Insets insets = this.toolBar.getInsets();
        this.dragWindow.setBounds(point2.x + point.x - point3.x - (insets.left + insets.right) / 2, point2.y + point.y - point3.y - (insets.top + insets.bottom) / 2, n2, n3);
        if (!this.dragWindow.isVisible()) {
            this.dragWindow.show();
        }
    }

    protected void floatAt(Point point, Point point2) {
        String string;
        Container container;
        Point point3 = new Point(point);
        int n = this.areaOfClick(this.origParent, SwingUtilities.convertPoint(this.toolBar, point3, this.origParent));
        Container container2 = this.toolBar.getParent();
        container2.remove(this.toolBar);
        container2.doLayout();
        container2.repaint();
        if (n == -1) {
            container = ((RootPaneContainer)((Object)this.floatFrame)).getContentPane();
        } else {
            this.floatFrame.hide();
            container = this.origParent;
        }
        switch (n) {
            case 3: {
                string = "East";
                break;
            }
            case 1: {
                string = "North";
                break;
            }
            case 5: {
                string = "South";
                break;
            }
            case 7: {
                string = "West";
                break;
            }
            default: {
                string = "Center";
            }
        }
        int n2 = 0;
        if (n != -1 && (n == 3 || n == 7)) {
            n2 = 1;
        }
        if (n != -1) {
            this.constraintBeforeFloating = string;
            this.lastGoodOrientation = n2;
        }
        container.add((Component)this.toolBar, string);
        this.setFloating(n == -1, null);
        this.toolBar.setOrientation(n2);
        Insets insets = this.floatFrame.getInsets();
        Dimension dimension = this.toolBar.getPreferredSize();
        point3 = this.dragWindow.getOffset();
        this.setFloatingLocation(point.x + point2.x - point3.x - (insets.left + insets.right) / 2, point.y + point2.y - point3.y - (insets.top + insets.bottom) / 2);
        if (n == -1) {
            this.floatFrame.pack();
            this.floatFrame.setSize(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
            this.floatFrame.show();
        }
        container.invalidate();
        container.validate();
        container.repaint();
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected void installComponents() {
        this.floatFrame = (Window)((Object)this.createFloatingWindow(this.toolBar));
        this.dragWindow = this.createDragWindow(this.toolBar);
        nonRolloverBorder = this.createNonRolloverBorder();
        rolloverBorder = this.createRolloverBorder();
        this.borders = new Hashtable();
        this.setRolloverBorders(this.toolBar.isRollover());
        this.fillHashtable();
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)SharedUIDefaults.get("ToolBar.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, inputMap);
        SwingUtilities.replaceUIActionMap(this.toolBar, this.getActionMap());
    }

    private ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("ToolBar.actionMap");
        if (actionMap == null) {
            actionMap = this.createDefaultActions();
            UIManager.getLookAndFeelDefaults().put("ToolBar.actionMap", actionMap);
        }
        return actionMap;
    }

    private ActionMap createDefaultActions() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        ToolBarAction toolBarAction = new ToolBarAction();
        actionMapUIResource.put("navigateLeft", toolBarAction);
        actionMapUIResource.put("navigateRight", toolBarAction);
        actionMapUIResource.put("navigateUp", toolBarAction);
        actionMapUIResource.put("navigateDown", toolBarAction);
        return actionMapUIResource;
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        this.toolBar.addMouseListener(this.dockingListener);
        this.toolBar.addMouseMotionListener(this.dockingListener);
        this.propertyListener = this.createPropertyListener();
        this.toolBar.addPropertyChangeListener(this.propertyListener);
        this.toolBarContListener = this.createToolBarContListener();
        this.toolBar.addContainerListener(this.toolBarContListener);
        this.windowListener = this.createFrameListener();
        this.floatFrame.addWindowListener(this.windowListener);
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            int n = this.toolBar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.toolBar.getComponent(i).addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    protected void installNonRolloverBorders(JComponent jComponent) {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.setBorderToNonRollover(componentArray[i]);
        }
    }

    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.setBorderToNormal(componentArray[i]);
        }
    }

    protected void installRolloverBorders(JComponent jComponent) {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            this.setBorderToRollover(componentArray[i]);
        }
    }

    private void fillHashtable() {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JButton jButton;
            if (!(componentArray[i] instanceof JButton) || (jButton = (JButton)componentArray[i]).getBorder() == null) continue;
            this.borders.put(jButton, jButton.getBorder());
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JToolBar) {
            this.toolBar = (JToolBar)jComponent;
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.installKeyboardActions();
        }
    }

    public boolean isFloating() {
        return this.floatFrame.isVisible();
    }

    public boolean isRolloverBorders() {
        return this.toolBar.isRollover();
    }

    protected void navigateFocusedComp(int n) {
        int n2 = this.toolBar.getComponentCount();
        switch (n) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n3 = this.focusedCompIndex + 1;
                boolean bl = false;
                while (n3 != this.focusedCompIndex && !bl) {
                    Component component;
                    if (n3 >= n2) {
                        n3 = 0;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n3++)) == null || !component.isFocusable() || !component.isEnabled()) continue;
                    component.requestFocus();
                    bl = true;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n4 = this.focusedCompIndex - 1;
                boolean bl = false;
                while (n4 != this.focusedCompIndex && !bl) {
                    Component component;
                    if (n4 < 0) {
                        n4 = n2 - 1;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n4--)) == null || !component.isFocusable() || !component.isEnabled()) continue;
                    component.requestFocus();
                    bl = true;
                }
                break;
            }
        }
    }

    protected void setBorderToNonRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setRolloverEnabled(false);
            this.borders.put(abstractButton, abstractButton.getBorder());
            abstractButton.setBorder(nonRolloverBorder);
        }
    }

    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setRolloverEnabled(true);
            abstractButton.setBorder((Border)this.borders.remove(abstractButton));
        }
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setRolloverEnabled(false);
            this.borders.put(abstractButton, abstractButton.getBorder());
            abstractButton.setBorder(rolloverBorder);
        }
    }

    public void setDockingColor(Color color) {
        this.dockingColor = color;
    }

    public void setFloating(boolean bl, Point point) {
        this.floatFrame.setVisible(bl);
    }

    public void setFloatingColor(Color color) {
        this.floatingColor = color;
    }

    public void setFloatingLocation(int n, int n2) {
        this.floatFrame.setLocation(n, n2);
        this.floatFrame.invalidate();
        this.floatFrame.validate();
        this.floatFrame.repaint();
    }

    public void setOrientation(int n) {
        this.toolBar.setOrientation(n);
    }

    public void setRolloverBorders(boolean bl) {
        if (bl) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void uninstallComponents() {
        this.installNormalBorders(this.toolBar);
        this.borders = null;
        this.cachedBounds = null;
        this.floatFrame = null;
        this.dragWindow = null;
    }

    protected void uninstallDefaults() {
        this.toolBar.setBackground(null);
        this.toolBar.setForeground(null);
        this.toolBar.setFont(null);
        this.dockingBorderColor = null;
        this.dockingColor = null;
        this.floatingBorderColor = null;
        this.floatingColor = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
    }

    protected void uninstallListeners() {
        if (this.toolBarFocusListener != null) {
            int n = this.toolBar.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.toolBar.getComponent(i).removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
        this.floatFrame.removeWindowListener(this.windowListener);
        this.windowListener = null;
        this.toolBar.removeContainerListener(this.toolBarContListener);
        this.toolBarContListener = null;
        this.toolBar.removeMouseMotionListener(this.dockingListener);
        this.toolBar.removeMouseListener(this.dockingListener);
        this.dockingListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.toolBar = null;
    }

    private static class ToolBarBorder
    implements Border {
        private static final int offset = 10;
        private static final int regular = 2;

        public Insets getBorderInsets(Component component) {
            if (component instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)component;
                int n = jToolBar.getOrientation();
                if (!jToolBar.isFloatable()) {
                    return new Insets(2, 2, 2, 2);
                }
                if (n == 0) {
                    return new Insets(2, 10, 2, 2);
                }
                return new Insets(10, 2, 2, 2);
            }
            return new Insets(0, 0, 0, 0);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        private void paintBumps(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            int n6 = 2 * n5;
            int n7 = 4 * n5;
            int n8 = 0;
            for (int i = n; i < n3 + n; i += n6) {
                int n9;
                int n10 = n9 = n8++ % 2 == 0 ? n2 : n2 + 2 * n5;
                while (n9 < n4 + n2) {
                    graphics.fillRect(i, n9, n5, n5);
                    n9 += n7;
                }
            }
            graphics.setColor(color2);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)component;
                int n5 = jToolBar.getOrientation();
                if (n5 == 0) {
                    this.paintBumps(graphics, n, n2, 10, n4, 1, Color.WHITE);
                    this.paintBumps(graphics, n + 1, n2 + 1, 9, n4 - 1, 1, Color.GRAY);
                } else {
                    this.paintBumps(graphics, n, n2, n3, 10, 1, Color.WHITE);
                    this.paintBumps(graphics, n + 1, n2 + 1, n3 - 1, 9, 1, Color.GRAY);
                }
            }
        }

        ToolBarBorder() {
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        private /* synthetic */ BasicToolBarUI this$0;

        protected ToolBarFocusListener(BasicToolBarUI basicToolBarUI) {
            this.this$0 = basicToolBarUI;
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            this.this$0.focusedCompIndex = this.this$0.toolBar.getComponentIndex(component);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    private class ToolBarDialog
    extends JDialog
    implements UIResource {
        private /* synthetic */ BasicToolBarUI this$0;

        public ToolBarDialog(BasicToolBarUI basicToolBarUI) {
            this.this$0 = basicToolBarUI;
            this.setName(basicToolBarUI.toolBar.getName() != null ? basicToolBarUI.toolBar.getName() : "");
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        private /* synthetic */ BasicToolBarUI this$0;

        public void componentAdded(ContainerEvent containerEvent) {
            Component component;
            if (containerEvent.getChild() instanceof JButton && ((JComponent)(component = (JButton)containerEvent.getChild())).getBorder() != null) {
                this.this$0.borders.put(component, ((JComponent)component).getBorder());
            }
            if (this.this$0.isRolloverBorders()) {
                this.this$0.setBorderToRollover(containerEvent.getChild());
            } else {
                this.this$0.setBorderToNonRollover(containerEvent.getChild());
            }
            this.this$0.cachedBounds = this.this$0.toolBar.getPreferredSize();
            this.this$0.cachedOrientation = this.this$0.toolBar.getOrientation();
            component = containerEvent.getChild();
            if (this.this$0.toolBarFocusListener != null) {
                component.addFocusListener(this.this$0.toolBarFocusListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            this.this$0.setBorderToNormal(containerEvent.getChild());
            this.this$0.cachedBounds = this.this$0.toolBar.getPreferredSize();
            this.this$0.cachedOrientation = this.this$0.toolBar.getOrientation();
            Component component = containerEvent.getChild();
            if (this.this$0.toolBarFocusListener != null) {
                component.removeFocusListener(this.this$0.toolBarFocusListener);
            }
        }

        protected ToolBarContListener(BasicToolBarUI basicToolBarUI) {
            this.this$0 = basicToolBarUI;
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        private /* synthetic */ BasicToolBarUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("rollover") && this.this$0.toolBar != null) {
                this.this$0.setRolloverBorders(this.this$0.toolBar.isRollover());
            }
        }

        protected PropertyListener(BasicToolBarUI basicToolBarUI) {
            this.this$0 = basicToolBarUI;
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        private /* synthetic */ BasicToolBarUI this$0;

        public void windowClosing(WindowEvent windowEvent) {
            Container container = this.this$0.toolBar.getParent();
            container.remove(this.this$0.toolBar);
            if (this.this$0.origParent != null) {
                this.this$0.origParent.add((Component)this.this$0.toolBar, this.this$0.constraintBeforeFloating != null ? this.this$0.constraintBeforeFloating : "North");
                this.this$0.toolBar.setOrientation(this.this$0.lastGoodOrientation);
            }
            this.this$0.origParent.invalidate();
            this.this$0.origParent.validate();
            this.this$0.origParent.repaint();
        }

        protected FrameListener(BasicToolBarUI basicToolBarUI) {
            this.this$0 = basicToolBarUI;
        }
    }

    protected class DragWindow
    extends Window {
        private /* synthetic */ BasicToolBarUI this$0;
        private Color borderColor;
        private Point offset;

        DragWindow(BasicToolBarUI basicToolBarUI) {
            this.this$0 = basicToolBarUI;
            super(owner);
        }

        public Color getBorderColor() {
            if (this.borderColor == null) {
                return Color.BLACK;
            }
            return this.borderColor;
        }

        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        public Point getOffset() {
            return this.offset;
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            Rectangle rectangle = this.getBounds();
            graphics.setColor(this.getBorderColor());
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(color);
        }

        public void setBorderColor(Color color) {
            this.borderColor = color;
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        public void setOrientation(int n) {
            this.this$0.toolBar.setOrientation(n);
            if (this.this$0.dragWindow != null) {
                this.this$0.dragWindow.setOrientation(n);
            }
        }
    }

    public class DockingListener
    implements MouseInputListener {
        private /* synthetic */ BasicToolBarUI this$0;
        protected boolean isDragging;
        protected Point origin;
        protected JToolBar toolBar;

        public DockingListener(BasicToolBarUI basicToolBarUI, JToolBar jToolBar) {
            this.this$0 = basicToolBarUI;
            this.toolBar = jToolBar;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.isDragging) {
                this.this$0.dragTo(mouseEvent.getPoint(), this.origin);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.toolBar.isFloatable()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Insets insets = this.toolBar.getInsets();
            if (this.toolBar.getOrientation() == 0 ? mouseEvent.getX() > insets.left : mouseEvent.getY() > insets.top) {
                return;
            }
            this.origin = new Point(0, 0);
            if (this.toolBar.isShowing()) {
                SwingUtilities.convertPointToScreen(point, this.toolBar);
            }
            if (!(SwingUtilities.getAncestorOfClass(BasicToolBarUI.class$("java.awt.Window"), this.toolBar) instanceof UIResource)) {
                this.this$0.origParent = this.toolBar.getParent();
            }
            if (this.toolBar.isShowing()) {
                SwingUtilities.convertPointToScreen(this.origin, this.toolBar);
            }
            this.isDragging = true;
            if (this.this$0.dragWindow != null) {
                this.this$0.dragWindow.setOffset(new Point(this.this$0.cachedBounds.width / 2, this.this$0.cachedBounds.height / 2));
            }
            this.this$0.dragTo(mouseEvent.getPoint(), this.origin);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.isDragging || !this.toolBar.isFloatable()) {
                return;
            }
            this.isDragging = false;
            this.this$0.floatAt(mouseEvent.getPoint(), this.origin);
            this.this$0.dragWindow.hide();
        }
    }

    static class ToolBarAction
    extends AbstractAction {
        private static final /* synthetic */ boolean $assertionsDisabled;

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.getValue("__command__");
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            BasicToolBarUI basicToolBarUI = (BasicToolBarUI)jToolBar.getUI();
            if (object.equals("navigateRight")) {
                basicToolBarUI.navigateFocusedComp(3);
            } else if (object.equals("navigateLeft")) {
                basicToolBarUI.navigateFocusedComp(7);
            } else if (object.equals("navigateUp")) {
                basicToolBarUI.navigateFocusedComp(1);
            } else if (object.equals("navigateDown")) {
                basicToolBarUI.navigateFocusedComp(5);
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Shouldn't reach here");
            }
        }

        ToolBarAction() {
        }

        static {
            $assertionsDisabled = BasicToolBarUI.class$("javax.swing.plaf.basic.BasicToolBarUI$ToolBarAction").desiredAssertionStatus() ^ true;
        }
    }
}

