/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.NotImplementedException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicTableHeaderUI
extends TableHeaderUI {
    static int COLUMN_BOUNDARY_TOLERANCE = 3;
    protected JTableHeader header;
    protected MouseInputListener mouseInputListener = this.createMouseInputListener();
    protected CellRendererPane rendererPane;
    private Border cellBorder;
    private Cursor originalCursor;
    Rectangle draggingHeaderRect;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableHeaderUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler(this);
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.header, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        this.cellBorder = UIManager.getBorder("TableHeader.cellBorder");
    }

    protected void installKeyboardActions() throws NotImplementedException {
    }

    protected void installListeners() {
        this.header.addMouseListener(this.mouseInputListener);
        this.header.addMouseMotionListener(this.mouseInputListener);
    }

    public void installUI(JComponent jComponent) {
        this.header = (JTableHeader)jComponent;
        this.rendererPane = new CellRendererPane();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    protected void uninstallDefaults() {
        this.header.setBackground(null);
        this.header.setForeground(null);
        this.header.setFont(null);
    }

    protected void uninstallKeyboardActions() throws NotImplementedException {
    }

    protected void uninstallListeners() {
        this.header.removeMouseListener(this.mouseInputListener);
        this.header.removeMouseMotionListener(this.mouseInputListener);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        if (n == 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle2 = this.header.getHeaderRect(i);
            if (!rectangle2.intersects(rectangle)) continue;
            Rectangle rectangle3 = graphics.getClipBounds();
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer2 = tableColumn.getHeaderRenderer();
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = tableCellRenderer;
            }
            Object object = tableColumn.getHeaderValue();
            Component component = tableCellRenderer2.getTableCellRendererComponent(this.header.getTable(), object, false, false, -1, i);
            component.setFont(this.header.getFont());
            component.setBackground(this.header.getBackground());
            component.setForeground(this.header.getForeground());
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(this.cellBorder);
            }
            this.rendererPane.paintComponent(graphics, component, this.header, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        if (this.draggingHeaderRect != null) {
            graphics.setColor(this.header.getForeground());
            graphics.drawRect(this.draggingHeaderRect.x, this.draggingHeaderRect.y + 2, this.draggingHeaderRect.width - 1, this.draggingHeaderRect.height - 6);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        int n = tableColumnModel.getColumnCount();
        Dimension dimension = new Dimension(0, 0);
        int n2 = 0;
        if (this.header.getTable() != null && this.header.getTable().getIntercellSpacing() != null) {
            n2 = this.header.getTable().getIntercellSpacing().width;
        }
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer2 = tableColumn.getHeaderRenderer();
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = tableCellRenderer;
            }
            Object object = tableColumn.getHeaderValue();
            Component component = tableCellRenderer2.getTableCellRendererComponent(this.header.getTable(), object, false, false, -1, i);
            component.setFont(this.header.getFont());
            component.setBackground(this.header.getBackground());
            component.setForeground(this.header.getForeground());
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(this.cellBorder);
            }
            Dimension dimension2 = component.getPreferredSize();
            dimension.width += n2;
            dimension.height = Math.max(dimension2.height, dimension.height);
        }
        dimension.width = tableColumnModel.getTotalColumnWidth();
        return dimension;
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicTableHeaderUI this$0;
        boolean showingResizeCursor;
        int draggingFrom;
        int draggingColumnNumber;
        int prevPrefWidth;
        Timer timer;

        private /* synthetic */ void finit$() {
            this.draggingFrom = -1;
            this.prevPrefWidth = -1;
        }

        static BasicTableHeaderUI access$0(MouseInputHandler mouseInputHandler) {
            return mouseInputHandler.this$0;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            TableColumn tableColumn = this.this$0.header.getResizingColumn();
            if (tableColumn != null && this.this$0.header.getResizingAllowed()) {
                if (this.timer == null) {
                    this.timer = new Timer(1, new ActionListener(this){
                        private /* synthetic */ MouseInputHandler this$1;
                        {
                            this.this$1 = mouseInputHandler;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            MouseInputHandler.access$0((MouseInputHandler)this.this$1).header.getTable().doLayout();
                        }
                    });
                    this.timer.setRepeats(false);
                    this.timer.setCoalesce(true);
                }
                tableColumn.setPreferredWidth(this.prevPrefWidth + mouseEvent.getX() - this.draggingFrom);
                this.timer.restart();
            } else if (this.this$0.draggingHeaderRect != null && this.this$0.header.getReorderingAllowed()) {
                this.this$0.draggingHeaderRect.x = mouseEvent.getX() + this.draggingFrom;
                this.this$0.header.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 0 && this.this$0.header.getResizingAllowed()) {
                TableColumnModel tableColumnModel = this.this$0.header.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                if (n < 2) {
                    return;
                }
                boolean bl = false;
                int n2 = mouseEvent.getX();
                int n3 = n2 - COLUMN_BOUNDARY_TOLERANCE;
                int n4 = n2 + COLUMN_BOUNDARY_TOLERANCE;
                int n5 = 0;
                for (int i = 0; i < n - 1; ++i) {
                    if ((n5 += tableColumnModel.getColumn(i).getWidth()) < n3 || n5 > n4) continue;
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    bl = true;
                    this.draggingFrom = n2;
                    this.prevPrefWidth = tableColumn.getWidth();
                    this.this$0.header.setResizingColumn(tableColumn);
                    break;
                }
                if (bl != this.showingResizeCursor) {
                    if (bl) {
                        this.this$0.originalCursor = this.this$0.header.getCursor();
                        if (n5 < n2) {
                            this.this$0.header.setCursor(Cursor.getPredefinedCursor(10));
                        } else {
                            this.this$0.header.setCursor(Cursor.getPredefinedCursor(11));
                        }
                    } else {
                        this.this$0.header.setCursor(this.this$0.originalCursor);
                        this.this$0.header.setResizingColumn(null);
                    }
                    this.showingResizeCursor = bl;
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if (this.this$0.header.getResizingAllowed() && (object = this.this$0.header.getResizingColumn()) != null) {
                ((TableColumn)object).setPreferredWidth(((TableColumn)object).getWidth());
                return;
            }
            if (this.this$0.header.getReorderingAllowed()) {
                object = this.this$0.header.getColumnModel();
                int n = object.getColumnCount();
                if (n < 2) {
                    return;
                }
                boolean bl = false;
                int n2 = mouseEvent.getX();
                int n3 = 0;
                int n4 = -1;
                for (int i = 0; i < n; ++i) {
                    if ((n3 += object.getColumn(i).getWidth()) <= n2) continue;
                    n4 = i;
                    break;
                }
                if (n4 < 0) {
                    return;
                }
                TableColumn tableColumn = object.getColumn(n4);
                this.this$0.header.setDraggedColumn(tableColumn);
                this.draggingFrom = n3 - tableColumn.getWidth() - n2;
                this.this$0.draggingHeaderRect = new Rectangle(this.this$0.header.getHeaderRect(n4));
                this.draggingColumnNumber = n4;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.this$0.header.getResizingColumn() != null && this.this$0.header.getResizingAllowed()) {
                this.endResizing();
            }
            if (this.this$0.header.getDraggedColumn() != null && this.this$0.header.getReorderingAllowed()) {
                this.endDragging(mouseEvent);
            }
        }

        void endResizing() {
            TableColumnModel tableColumnModel = this.this$0.header.getColumnModel();
            int n = tableColumnModel.getColumnCount();
            if (n > 2) {
                for (int i = 0; i < n; ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    tableColumn.setPreferredWidth(tableColumn.getWidth());
                }
            }
            this.this$0.header.setResizingColumn(null);
            this.showingResizeCursor = false;
            if (this.timer != null) {
                this.timer.stop();
            }
            this.this$0.header.setCursor(this.this$0.originalCursor);
        }

        void endDragging(MouseEvent mouseEvent) {
            this.this$0.header.setDraggedColumn(null);
            this.this$0.draggingHeaderRect = null;
            TableColumnModel tableColumnModel = this.this$0.header.getColumnModel();
            int n = mouseEvent.getX();
            int n2 = 0;
            int n3 = tableColumnModel.getColumnCount() - 1;
            int n4 = tableColumnModel.getColumnCount();
            for (int i = 0; i < n4; ++i) {
                if ((n2 += tableColumnModel.getColumn(i).getWidth()) <= n) continue;
                n3 = i;
                break;
            }
            this.this$0.header.getTable().moveColumn(this.draggingColumnNumber, n3);
        }

        public MouseInputHandler(BasicTableHeaderUI basicTableHeaderUI) {
            this.this$0 = basicTableHeaderUI;
            this.finit$();
        }
    }
}

