/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    transient ScrollingButton incrButton;
    transient ScrollingButton decrButton;
    transient ScrollingViewport viewport;
    transient ScrollingPanel panel;
    transient int currentScrollLocation;
    transient int currentScrollOffset;
    protected Rectangle calcRect;
    protected Rectangle[] rects;
    protected Insets contentBorderInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets tabInsets;
    protected Color darkShadow;
    protected Color focus;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected int runCount;
    protected int selectedRun;
    protected int tabRunOverlay;
    protected int textIconGap;
    protected int[] tabRuns;
    boolean tabRunsDirty;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected FocusListener focusListener;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener tabChangeListener;
    protected JTabbedPane tabPane;
    transient LayoutManager layoutManager;
    transient Rectangle tabAreaRect;
    transient Rectangle contentRect;
    private int rolloverTab;
    private boolean tabsOpaque;
    private Component visibleComponent;
    private Color selectedColor;
    private Rectangle tempTextRect;
    private Rectangle tempIconRect;

    private /* synthetic */ void finit$() {
        this.tempTextRect = new Rectangle();
        this.tempIconRect = new Rectangle();
    }

    public BasicTabbedPaneUI() {
        this.finit$();
        this.rects = new Rectangle[0];
        this.tabRuns = new int[10];
    }

    ScrollingButton createIncreaseButton() {
        if (this.incrButton == null) {
            this.incrButton = new ScrollingButton(this, 1);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.incrButton.setDirection(3);
        } else {
            this.incrButton.setDirection(5);
        }
        return this.incrButton;
    }

    ScrollingButton createDecreaseButton() {
        if (this.decrButton == null) {
            this.decrButton = new ScrollingButton(this, 5);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.decrButton.setDirection(7);
        } else {
            this.decrButton.setDirection(1);
        }
        return this.decrButton;
    }

    Point findPointForIndex(int n) {
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getSelectedIndex();
        Insets insets = this.getSelectedTabPadInsets(n2);
        int n4 = 0;
        int n5 = 0;
        if (n2 == 1 || n2 == 3) {
            if (n > 0) {
                n4 += this.rects[n - 1].x + this.rects[n - 1].width;
                if (n > n3) {
                    n4 -= insets.left + insets.right;
                }
            }
        } else if (n > 0) {
            n5 += this.rects[n - 1].y + this.rects[n - 1].height;
            if (n > n3) {
                n5 -= insets.top + insets.bottom;
            }
        }
        Point point = new Point(n4, n5);
        return point;
    }

    final void scrollTab(int n, int n2) {
        if (n >= 0 && this.tabPane.isEnabledAt(n)) {
            switch (n2) {
                case 1: 
                case 3: {
                    int n3 = this.rects[n].x + this.rects[n].width - this.decrButton.getX() - this.currentScrollOffset;
                    if (n3 > 0) {
                        this.currentScrollOffset += n3;
                    } else {
                        n3 = this.rects[n].x - this.currentScrollOffset;
                        if (n3 < 0) {
                            this.currentScrollOffset = n == 0 ? 0 : (this.currentScrollOffset += n3);
                        }
                    }
                    this.currentScrollLocation = this.tabForCoordinate(this.tabPane, this.currentScrollOffset, this.rects[n].y);
                    break;
                }
                default: {
                    int n4 = this.rects[n].y + this.rects[n].height - this.decrButton.getY() - this.currentScrollOffset;
                    if (n4 > 0) {
                        this.currentScrollOffset += n4;
                    } else {
                        n4 = this.rects[n].y - this.currentScrollOffset;
                        if (n4 < 0) {
                            this.currentScrollOffset = n == 0 ? 0 : (this.currentScrollOffset += n4);
                        }
                    }
                    this.currentScrollLocation = this.tabForCoordinate(this.tabPane, this.rects[n].x, this.currentScrollOffset);
                }
            }
            this.updateViewPosition();
            this.updateButtons();
        }
    }

    final void updateButtons() {
        int n = this.tabPane.getTabCount();
        switch (this.tabPane.getTabPlacement()) {
            case 1: 
            case 3: {
                this.incrButton.setEnabled(this.currentScrollLocation + 1 < n && this.rects[n - 1].x + this.rects[n - 1].width - this.currentScrollOffset > this.decrButton.getX());
                break;
            }
            default: {
                this.incrButton.setEnabled(this.currentScrollLocation + 1 < n && this.rects[n - 1].y + this.rects[n - 1].height - this.currentScrollOffset > this.decrButton.getY());
            }
        }
        this.decrButton.setEnabled(this.currentScrollOffset > 0);
    }

    final void updateViewPosition() {
        Point point = this.viewport.getViewPosition();
        switch (this.tabPane.getTabPlacement()) {
            case 2: 
            case 4: {
                point.y = this.currentScrollOffset;
                break;
            }
            default: {
                point.x = this.currentScrollOffset;
            }
        }
        this.viewport.setViewPosition(point);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JTabbedPane) {
            this.tabPane = (JTabbedPane)jComponent;
            this.installComponents();
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
            this.layoutManager = this.createLayoutManager();
            this.tabPane.setLayout(this.layoutManager);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.layoutManager = null;
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new TabbedPaneLayout(this);
        }
        this.runCount = 1;
        this.tabRuns[0] = 0;
        this.incrButton = this.createIncreaseButton();
        this.incrButton.addMouseListener(this.mouseListener);
        this.decrButton = this.createDecreaseButton();
        this.decrButton.addMouseListener(this.mouseListener);
        this.decrButton.setEnabled(false);
        this.panel = new ScrollingPanel(this);
        this.panel.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.panel.addMouseListener(this.mouseListener);
        this.panel.addFocusListener(this.focusListener);
        this.viewport = new ScrollingViewport(this);
        this.viewport.setBackground(Color.LIGHT_GRAY);
        this.viewport.setView(this.panel);
        this.viewport.setLayout(null);
        this.tabPane.add(this.incrButton);
        this.tabPane.add(this.decrButton);
        this.tabPane.add(this.viewport);
        return new TabbedPaneScrollLayout(this);
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
        if (this.incrButton != null) {
            this.tabPane.remove(this.incrButton);
        }
        if (this.decrButton != null) {
            this.tabPane.remove(this.decrButton);
        }
        if (this.viewport != null) {
            this.tabPane.remove(this.viewport);
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.tabPane.setOpaque(false);
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.selectedColor = UIManager.getColor("TabbedPane.contentAreaColor");
        if (this.selectedColor == null) {
            this.selectedColor = UIManager.getColor("control");
        }
        this.calcRect = new Rectangle();
        this.tabRuns = new int[10];
        this.tabAreaRect = new Rectangle();
        this.contentRect = new Rectangle();
    }

    protected void uninstallDefaults() {
        this.calcRect = null;
        this.tabAreaRect = null;
        this.contentRect = null;
        this.tabRuns = null;
        this.tempIconRect = null;
        this.tempTextRect = null;
        this.contentBorderInsets = null;
        this.tabAreaInsets = null;
        this.selectedTabPadInsets = null;
        this.tabInsets = null;
        this.focus = null;
        this.darkShadow = null;
        this.shadow = null;
        this.lightHighlight = null;
        this.highlight = null;
        this.selectedColor = null;
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseListener();
        this.tabChangeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.tabPane.addMouseListener(this.mouseListener);
        this.tabPane.addChangeListener(this.tabChangeListener);
        this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        this.tabPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.tabPane.removeFocusListener(this.focusListener);
        this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
        this.tabPane.removeChangeListener(this.tabChangeListener);
        this.tabPane.removeMouseListener(this.mouseListener);
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.mouseListener);
        }
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.mouseListener);
        }
        if (this.panel != null) {
            this.panel.removeMouseListener(this.mouseListener);
            this.panel.removeFocusListener(this.focusListener);
        }
        this.focusListener = null;
        this.propertyChangeListener = null;
        this.tabChangeListener = null;
        this.mouseListener = null;
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)UIManager.get("TabbedPane.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        inputMap = (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, actionMap);
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.layoutManager.minimumLayoutSize(this.tabPane);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (this.tabPane.getTabCount() == 0) {
            return;
        }
        int n = this.tabPane.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        int n2 = this.tabPane.getTabPlacement();
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            graphics.setColor(this.highlight);
            graphics.fillRect(this.tabAreaRect.x, this.tabAreaRect.y, this.tabAreaRect.width, this.tabAreaRect.height);
            this.paintTabArea(graphics, n2, n);
        }
        this.paintContentBorder(graphics, n2, n);
    }

    protected void paintTabArea(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getTabCount();
        for (int i = this.runCount - 1; i >= 0; --i) {
            int n4 = this.tabRuns[i];
            int n5 = i == this.runCount - 1 ? this.tabRuns[0] : this.tabRuns[i + 1];
            int n6 = n5 != 0 ? n5 - 1 : n3 - 1;
            for (int j = n4; j <= n6; ++j) {
                if (j == n2) continue;
                this.paintTab(graphics, n, this.rects, j, this.tempIconRect, this.tempTextRect);
            }
        }
        if (n2 >= 0) {
            this.paintTab(graphics, n, this.rects, n2, this.tempIconRect, this.tempTextRect);
        }
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        boolean bl;
        Rectangle rectangle3 = rectangleArray[n2];
        boolean bl2 = bl = n2 == this.tabPane.getSelectedIndex();
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        }
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        FontMetrics fontMetrics = this.getFontMetrics();
        Icon icon = this.getIconForTab(n2);
        String string = this.tabPane.getTitleAt(n2);
        this.layoutLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, this.tabPane.getFont(), fontMetrics, n2, string, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    protected void layoutLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        SwingUtilities.layoutCompoundLabel(fontMetrics, string, icon, 0, 0, 0, 4, rectangle, rectangle2, rectangle3, this.textIconGap);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
    }

    protected void paintIcon(Graphics graphics, int n, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            view.paint(graphics, rectangle);
            return;
        }
        int n3 = fontMetrics.getAscent();
        int n4 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n2)) {
            Color color;
            Color color2 = this.tabPane.getForegroundAt(n2);
            if (bl && color2 instanceof UIResource && (color = UIManager.getColor("TabbedPane.selectionForeground")) != null) {
                color2 = color;
            }
            graphics.setColor(color2);
            if (n4 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y + n3);
            } else {
                graphics.drawString(string, rectangle.x, rectangle.y + n3);
            }
        } else {
            Color color = this.tabPane.getBackgroundAt(n2);
            graphics.setColor(color.brighter());
            if (n4 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x, rectangle.y + n3);
            } else {
                graphics.drawString(string, rectangle.x, rectangle.y + n3);
            }
            graphics.setColor(color.darker());
            if (n4 != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n4, rectangle.x + 1, rectangle.y + 1 + n3);
            } else {
                graphics.drawString(string, rectangle.x + 1, rectangle.y + 1 + n3);
            }
        }
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        switch (n) {
            default: {
                return 1;
            }
            case 2: {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            case 4: 
        }
        if (bl) {
            return 1;
        }
        return -1;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        switch (n) {
            default: {
                if (bl) {
                    return -1;
                }
                return 1;
            }
            case 3: {
                if (bl) {
                    return 1;
                }
                return -1;
            }
            case 2: 
            case 4: 
        }
        return 0;
    }

    protected void paintFocusIndicator(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.tabPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            Rectangle rectangle3 = rectangleArray[n2];
            graphics.setColor(this.focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 5;
                    n3 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n6, n5, n4, n3);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color = graphics.getColor();
        switch (n) {
            case 1: {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 1, n4 + 2);
                graphics.setColor(this.lightHighlight);
                graphics.drawLine(n3, n4 + 3, n3, n4 + n6);
                graphics.drawLine(n3 + 3, n4, n3 + n5 - 3, n4);
                graphics.drawLine(n3, n4 + 2, n3 + 2, n4);
                break;
            }
            case 2: {
                graphics.setColor(this.lightHighlight);
                graphics.drawLine(n3 + 3, n4, n3 + n5 - 1, n4);
                graphics.drawLine(n3 + 2, n4, n3, n4 + 2);
                graphics.drawLine(n3, n4 + 3, n3, n4 + n6 - 4);
                graphics.drawLine(n3, n4 + n6 - 3, n3 + 1, n4 + n6 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
                break;
            }
            case 3: {
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + 2, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3 + n5 - 1, n4 + n6 - 2, n3 + n5 - 3, n4 + n6);
                graphics.drawLine(n3 + 2, n4 + n6, n3 + n5 - 4, n4 + n6);
                graphics.setColor(this.lightHighlight);
                graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                graphics.drawLine(n3, n4 + n6 - 2, n3 + 1, n4 + n6 - 1);
                break;
            }
            case 4: {
                graphics.setColor(this.lightHighlight);
                graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 1, n4 + 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 3, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 4, n4 + n6 - 1);
                graphics.setColor(this.shadow);
                graphics.drawLine(n3 + n5 - 2, n4 + 2, n3 + n5 - 2, n4 + n6 - 3);
                graphics.drawLine(n3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 2);
            }
        }
        graphics.setColor(color);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color = graphics.getColor();
        if (bl) {
            graphics.setColor(this.selectedColor);
        } else {
            Color color2 = this.tabPane.getBackgroundAt(n2);
            if (color2 == null) {
                color2 = Color.LIGHT_GRAY;
            }
            graphics.setColor(color2);
        }
        switch (n) {
            case 1: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 1);
                break;
            }
            case 3: {
                graphics.fillRect(n3, n4, n5 - 1, n6 - 1);
                break;
            }
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 2);
                break;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 1, n6 - 2);
            }
        }
        graphics.setColor(color);
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n);
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.left - insets.right;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.tabPane.isOpaque()) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            graphics.setColor(color);
            graphics.fillRect(n5, n6, n7, n8);
        }
        this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
        this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        graphics.setColor(this.lightHighlight);
        int n7 = this.rects[n2].x - this.currentScrollOffset;
        int n8 = this.rects[n2].x + this.rects[n2].width - this.currentScrollOffset;
        if (n == 1 && n7 >= 0) {
            graphics.drawLine(n3, n4, n7, n4);
            graphics.drawLine(n8, n4, n3 + n5 - 1, n4);
            graphics.setColor(this.selectedColor);
            graphics.drawLine(n7, n4, n8 - 1, n4);
        } else {
            graphics.drawLine(n3, n4, n3 + n5, n4);
        }
        graphics.setColor(this.selectedColor);
        graphics.drawLine(n3, n4 + 1, n3 + n5 - 1, n4 + 1);
        graphics.drawLine(n3, n4 + 2, n3 + n5 - 1, n4 + 2);
        graphics.setColor(color);
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        graphics.setColor(this.lightHighlight);
        int n7 = this.rects[n2].y - this.currentScrollOffset;
        int n8 = this.rects[n2].y + this.rects[n2].height - this.currentScrollOffset;
        boolean bl = false;
        if (n == 2 && n7 >= 0) {
            graphics.drawLine(n3, n4, n3, n7);
            graphics.drawLine(n3, n8, n3, n4 + n6 - 1);
            graphics.setColor(this.selectedColor);
            graphics.drawLine(n3, n7, n3, n8 - 1);
        } else {
            graphics.drawLine(n3, n4, n3, n4 + n6 - 1);
        }
        graphics.setColor(this.selectedColor);
        graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + n6 - 4);
        graphics.setColor(color);
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        int n7 = this.rects[n2].x - this.currentScrollOffset;
        int n8 = this.rects[n2].x + this.rects[n2].width - this.currentScrollOffset;
        if (n == 3 && n7 >= 0) {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + 1, n4 + n6 - 2, n7, n4 + n6 - 2);
            graphics.drawLine(n8, n4 + n6 - 2, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, n7, n4 + n6 - 1);
            graphics.drawLine(n8, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            graphics.setColor(this.selectedColor);
            graphics.drawLine(n7, n4 + n6 - 1, n8 - 1, n4 + n6 - 1);
            graphics.drawLine(n7, n4 + n6 - 2, n8 - 1, n4 + n6 - 2);
        } else {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + 1, n4 + n6 - 2, n3 + n5 - 1, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        }
        graphics.setColor(this.selectedColor);
        graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 3);
        graphics.setColor(color);
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        Color color = graphics.getColor();
        int n7 = this.rects[n2].y - this.currentScrollOffset;
        int n8 = this.rects[n2].y + this.rects[n2].height - this.currentScrollOffset;
        boolean bl = false;
        if (n == 4 && n7 >= 0) {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n7);
            graphics.drawLine(n3 + n5 - 2, n8, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n7);
            graphics.drawLine(n3 + n5 - 1, n8, n3 + n5 - 1, n4 + n6 - 2);
            graphics.setColor(this.selectedColor);
            graphics.drawLine(n3 + n5 - 2, n7, n3 + n5 - 2, n8 - 1);
            graphics.drawLine(n3 + n5 - 1, n7, n3 + n5 - 1, n8 - 1);
        } else {
            graphics.setColor(this.shadow);
            graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + n6 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 2);
        }
        graphics.setColor(this.selectedColor);
        graphics.drawLine(n3 + n5 - 3, n4 + 1, n3 + n5 - 3, n4 + n6 - 4);
        graphics.setColor(color);
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        if (n >= this.rects.length) {
            this.layoutManager.layoutContainer(jTabbedPane);
        }
        return this.rects[n];
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        int n3 = this.tabPane.getTabCount();
        int n4 = this.tabPane.getSelectedIndex();
        for (int i = 0; i < n3; ++i) {
            if (!this.rects[i].contains(n, n2)) continue;
            n4 = i;
            break;
        }
        return n4;
    }

    protected Rectangle getTabBounds(int n, Rectangle rectangle) {
        rectangle.setBounds(this.getTabBounds(this.tabPane, n));
        return rectangle;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n) {
        if (this.rects.length < n) {
            Rectangle[] rectangleArray = this.rects;
            this.rects = new Rectangle[n];
            System.arraycopy(rectangleArray, 0, this.rects, 0, rectangleArray.length);
            for (int i = rectangleArray.length; i < this.rects.length; ++i) {
                this.rects[i] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        if (this.tabRuns == null) {
            this.tabRuns = new int[10];
        } else {
            int[] nArray = new int[this.tabRuns.length + 10];
            System.arraycopy(this.tabRuns, 0, nArray, 0, this.tabRuns.length);
            this.tabRuns = nArray;
        }
    }

    protected int getRunForTab(int n, int n2) {
        if (this.runCount == 1 && n2 < n && n2 >= 0) {
            return 0;
        }
        for (int i = 0; i < this.runCount; ++i) {
            int n3;
            int n4 = this.lastTabInRun(n, this.getPreviousTabRun(i)) + 1;
            if (n4 == n) {
                n4 = 0;
            }
            if ((n3 = this.lastTabInRun(n, i)) < n2 || n4 > n2) continue;
            return i;
        }
        return -1;
    }

    protected int lastTabInRun(int n, int n2) {
        int n3;
        if (this.runCount == 1) {
            n3 = n - 1;
        } else {
            int n4 = n2 == this.runCount - 1 ? 0 : n2 + 1;
            n3 = this.tabRuns[n4] == 0 ? n - 1 : this.tabRuns[n4] - 1;
        }
        return n3;
    }

    protected int getTabRunOverlay(int n) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n, int n2) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n, int n2) {
        return true;
    }

    protected boolean shouldRotateTabRuns(int n) {
        return true;
    }

    protected Icon getIconForTab(int n) {
        if (this.tabPane.isEnabledAt(n)) {
            return this.tabPane.getIconAt(n);
        }
        return this.tabPane.getDisabledIconAt(n);
    }

    protected View getTextViewForTab(int n) {
        return null;
    }

    protected int calculateTabHeight(int n, int n2, int n3) {
        int n4 = n3;
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        if (icon != null) {
            n4 = Math.max(n4, icon.getIconHeight());
        }
        return n4 += insets.top + insets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int n) {
        this.maxTabHeight = 0;
        FontMetrics fontMetrics = this.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            this.maxTabHeight = Math.max(this.calculateTabHeight(n, i, n2), this.maxTabHeight);
        }
        return this.maxTabHeight;
    }

    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        Icon icon = this.getIconForTab(n2);
        Insets insets = this.getTabInsets(n, n2);
        int n3 = 0;
        if (icon != null) {
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            this.layoutLabel(n, this.getFontMetrics(), n2, this.tabPane.getTitleAt(n2), icon, rectangle, rectangle2, rectangle3, n2 == this.tabPane.getSelectedIndex());
            n3 = rectangle3.union((Rectangle)rectangle2).width;
        } else {
            n3 = fontMetrics.stringWidth(this.tabPane.getTitleAt(n2));
        }
        return n3 += insets.left + insets.right;
    }

    protected int calculateMaxTabWidth(int n) {
        this.maxTabWidth = 0;
        FontMetrics fontMetrics = this.getFontMetrics();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            this.maxTabWidth = Math.max(this.calculateTabWidth(n, i, fontMetrics), this.maxTabWidth);
        }
        return this.maxTabWidth;
    }

    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = n2 * n3 - (n2 - 1) * this.tabRunOverlay;
        return n4 += insets.top + insets.bottom;
    }

    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        Insets insets = this.getTabAreaInsets(n);
        int n4 = n2 * n3 - (n2 - 1) * this.tabRunOverlay;
        return n4 += insets.left + insets.right;
    }

    protected Insets getTabInsets(int n, int n2) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, insets, n);
        return insets;
    }

    protected Insets getTabAreaInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, insets, n);
        return insets;
    }

    protected Insets getContentBorderInsets(int n) {
        Insets insets = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.contentBorderInsets, insets, n);
        return insets;
    }

    protected FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = this.tabPane.getFontMetrics(this.tabPane.getFont());
        return fontMetrics;
    }

    protected void navigateSelectedTab(int n) {
        int n2;
        int n3 = this.tabPane.getTabPlacement();
        if (n3 == 1 || n3 == 3) {
            if (n == 7) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (n == 3) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                n2 = this.getTabRunOffset(n3, this.tabPane.getTabCount(), this.tabPane.getSelectedIndex(), n3 == 1 ? n == 1 : n == 5);
                this.selectAdjacentRunTab(n3, this.tabPane.getSelectedIndex(), n2);
            }
        }
        if (n3 == 2 || n3 == 4) {
            if (n == 1) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (n == 5) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                n2 = this.getTabRunOffset(n3, this.tabPane.getTabCount(), this.tabPane.getSelectedIndex(), n3 == 2 ? n == 7 : n == 3);
                this.selectAdjacentRunTab(n3, this.tabPane.getSelectedIndex(), n2);
            }
        }
    }

    protected void selectNextTabInRun(int n) {
        n = this.getNextTabIndexInRun(this.tabPane.getTabCount(), n);
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollTab(n, this.tabPane.getTabPlacement());
        }
        this.tabPane.setSelectedIndex(n);
    }

    protected void selectPreviousTabInRun(int n) {
        n = this.getPreviousTabIndexInRun(this.tabPane.getTabCount(), n);
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollTab(n, this.tabPane.getTabPlacement());
        }
        this.tabPane.setSelectedIndex(n);
    }

    protected void selectNextTab(int n) {
        n = this.getNextTabIndex(n);
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollTab(n, this.tabPane.getTabPlacement());
        }
        this.tabPane.setSelectedIndex(n);
    }

    protected void selectPreviousTab(int n) {
        n = this.getPreviousTabIndex(n);
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            this.scrollTab(n, this.tabPane.getTabPlacement());
        }
        this.tabPane.setSelectedIndex(n);
    }

    protected void selectAdjacentRunTab(int n, int n2, int n3) {
        int n4 = this.rects[n2].x + this.rects[n2].width / 2;
        int n5 = this.rects[n2].y + this.rects[n2].height / 2;
        switch (n) {
            case 1: 
            case 3: {
                n5 += n3;
                break;
            }
            case 2: 
            case 4: {
                n4 += n3;
            }
        }
        int n6 = this.tabForCoordinate(this.tabPane, n4, n5);
        if (n6 != -1) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                this.scrollTab(n6, n);
            }
            this.tabPane.setSelectedIndex(n6);
        }
    }

    protected int getTabRunOffset(int n, int n2, int n3, boolean bl) {
        int n4 = this.getRunForTab(n2, n3);
        int n5 = bl ? this.getNextTabRun(n4) : this.getPreviousTabRun(n4);
        int n6 = n == 1 || n == 3 ? this.rects[this.lastTabInRun((int)n2, (int)n5)].y - this.rects[this.lastTabInRun((int)n2, (int)n4)].y : this.rects[this.lastTabInRun((int)n2, (int)n5)].x - this.rects[this.lastTabInRun((int)n2, (int)n4)].x;
        return n6;
    }

    protected int getPreviousTabIndex(int n) {
        if (--n < 0) {
            return this.tabPane.getTabCount() - 1;
        }
        return n;
    }

    protected int getNextTabIndex(int n) {
        if (++n == this.tabPane.getTabCount()) {
            return 0;
        }
        return n;
    }

    protected int getNextTabIndexInRun(int n, int n2) {
        int n3 = this.getNextTabIndex(n2);
        int n4 = this.getRunForTab(n, n2);
        if (n2 == this.lastTabInRun(n, n4)) {
            n3 = n4 > 0 ? this.lastTabInRun(n, this.getPreviousTabRun(n4)) + 1 : 0;
        }
        return n3;
    }

    protected int getPreviousTabIndexInRun(int n, int n2) {
        int n3;
        int n4 = this.getPreviousTabIndex(n2);
        if (n4 == this.lastTabInRun(n, this.getPreviousTabRun(n3 = this.getRunForTab(n, n2)))) {
            n4 = this.lastTabInRun(n, n3);
        }
        return n4;
    }

    protected int getPreviousTabRun(int n) {
        int n2;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((n2 = --n) < 0) {
            n2 = this.getTabRunCount(this.tabPane) - 1;
        }
        return n2;
    }

    protected int getNextTabRun(int n) {
        int n2;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((n2 = ++n) == this.getTabRunCount(this.tabPane)) {
            n2 = 0;
        }
        return n2;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.right = insets.right;
                insets2.bottom = insets.bottom;
                break;
            }
            case 2: {
                insets2.left = insets.top;
                insets2.top = insets.left;
                insets2.right = insets.bottom;
                insets2.bottom = insets.right;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.bottom = insets.top;
                insets2.left = insets.left;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
            }
        }
    }

    ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("TabbedPane.actionMap");
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.put("TabbedPane.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("navigatePageDown", new NavigatePageDownAction());
        actionMapUIResource.put("navigatePageUp", new NavigatePageUpAction());
        actionMapUIResource.put("navigateDown", new NavigateAction("navigateDown", 5));
        actionMapUIResource.put("navigateUp", new NavigateAction("navigateUp", 1));
        actionMapUIResource.put("navigateLeft", new NavigateAction("navigateLeft", 7));
        actionMapUIResource.put("navigateRight", new NavigateAction("navigateRight", 3));
        actionMapUIResource.put("requestFocusForVisibleComponent", new RequestFocusForVisibleComponentAction());
        actionMapUIResource.put("requestFocus", new RequestFocusAction());
        return actionMapUIResource;
    }

    protected void setRolloverTab(int n) {
        this.rolloverTab = n;
    }

    protected int getRolloverTab() {
        return this.rolloverTab;
    }

    private class ScrollingButton
    extends BasicArrowButton
    implements UIResource {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public ScrollingButton(BasicTabbedPaneUI basicTabbedPaneUI, int n) {
            this.this$0 = basicTabbedPaneUI;
            super(n);
        }
    }

    private class ScrollingViewport
    extends JViewport
    implements UIResource {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        ScrollingViewport(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    private class ScrollingPanel
    extends JPanel {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        static /* synthetic */ BasicTabbedPaneUI access$8(ScrollingPanel scrollingPanel, BasicTabbedPaneUI basicTabbedPaneUI) {
            scrollingPanel.this$0 = basicTabbedPaneUI;
            return scrollingPanel.this$0;
        }

        static BasicTabbedPaneUI access$0(ScrollingPanel scrollingPanel) {
            return scrollingPanel.this$0;
        }

        public void updateUI() {
            this.setUI(new ScrollingPanelUI(this));
        }

        ScrollingPanel(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }

        private class ScrollingPanelUI
        extends BasicPanelUI {
            private /* synthetic */ ScrollingPanel this$1;

            public void paint(Graphics graphics, JComponent jComponent) {
                int n = ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabPane.getTabPlacement();
                graphics.setColor(ScrollingPanel.access$0((ScrollingPanel)this.this$1).highlight);
                if (n == 1 || n == 3) {
                    graphics.fillRect(ScrollingPanel.access$0((ScrollingPanel)this.this$1).currentScrollOffset, 0, ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabAreaRect.width, ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabAreaRect.height);
                } else {
                    graphics.fillRect(0, ScrollingPanel.access$0((ScrollingPanel)this.this$1).currentScrollOffset, ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabAreaRect.width, ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabAreaRect.height);
                }
                this.this$1.this$0.paintTabArea(graphics, n, ScrollingPanel.access$0((ScrollingPanel)this.this$1).tabPane.getSelectedIndex());
            }

            ScrollingPanelUI(ScrollingPanel scrollingPanel) {
                this.this$1 = scrollingPanel;
            }
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            this.this$0.selectedRun = this.this$0.getRunForTab(this.this$0.tabPane.getTabCount(), this.this$0.tabPane.getSelectedIndex());
            if (this.this$0.tabPane.getTabLayoutPolicy() == 0) {
                this.this$0.tabPane.revalidate();
            }
            this.this$0.tabPane.repaint();
        }

        public TabSelectionHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public Dimension preferredLayoutSize(Container container) {
            return super.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container container) {
            return super.calculateSize(true);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(n, 0, 0);
            }
            int n3 = 1;
            int n4 = this.this$0.calculateMaxTabHeight(n);
            int n5 = this.this$0.calculateTabAreaHeight(n, n3, n4);
            return n5;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(n, 0, 0);
            }
            int n3 = 1;
            int n4 = this.this$0.calculateMaxTabWidth(n);
            int n5 = this.this$0.calculateTabAreaWidth(n, n3, n4);
            return n5;
        }

        protected void calculateTabRects(int n, int n2) {
            if (n2 == 0) {
                return;
            }
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            SwingUtilities.calculateInnerArea(this.this$0.tabPane, this.this$0.calcRect);
            Insets insets = this.this$0.getTabAreaInsets(n);
            Insets insets2 = this.this$0.tabPane.getInsets();
            if (n == 1 || n == 3) {
                int n3 = this.this$0.calculateMaxTabHeight(n);
                this.this$0.calcRect.width -= insets.left + insets.right;
                int n4 = 0;
                int n5 = insets.left + insets2.left;
                int n6 = insets2.top + insets.top;
                for (int i = 0; i < n2; ++i) {
                    n4 = this.this$0.calculateTabWidth(n, i, fontMetrics);
                    this.this$0.rects[i].setBounds(n5, n6, n4, n3);
                    n5 += n4;
                }
                this.this$0.tabAreaRect.width = this.this$0.tabPane.getWidth() - insets2.left - insets2.right;
                this.this$0.tabAreaRect.height = this.this$0.maxTabHeight + insets.top + insets.bottom;
                this.this$0.contentRect.width = this.this$0.tabAreaRect.width;
                this.this$0.contentRect.height = this.this$0.tabPane.getHeight() - insets2.top - insets2.bottom - this.this$0.tabAreaRect.height;
                this.this$0.contentRect.x = insets2.left;
                this.this$0.tabAreaRect.x = insets2.left;
                if (n == 3) {
                    this.this$0.contentRect.y = insets2.top;
                    this.this$0.tabAreaRect.y = this.this$0.contentRect.y + this.this$0.contentRect.height;
                } else {
                    this.this$0.tabAreaRect.y = insets2.top;
                    this.this$0.contentRect.y = this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height;
                }
            } else {
                int n7 = this.this$0.calculateMaxTabWidth(n);
                this.this$0.calcRect.height -= insets.top + insets.bottom;
                int n8 = 0;
                int n9 = insets.top + insets2.top;
                int n10 = fontMetrics.getHeight();
                int n11 = insets2.left + insets.left;
                for (int i = 0; i < n2; ++i) {
                    n8 = this.this$0.calculateTabHeight(n, i, n10);
                    this.this$0.rects[i].setBounds(n11, n9, n7, n8);
                    n9 += n8;
                }
                this.this$0.tabAreaRect.width = this.this$0.maxTabWidth + insets.left + insets.right;
                this.this$0.tabAreaRect.height = this.this$0.tabPane.getHeight() - insets2.top - insets2.bottom;
                this.this$0.tabAreaRect.y = insets2.top;
                this.this$0.contentRect.width = this.this$0.tabPane.getWidth() - insets2.left - insets2.right - this.this$0.tabAreaRect.width;
                this.this$0.contentRect.height = this.this$0.tabAreaRect.height;
                this.this$0.contentRect.y = insets2.top;
                if (n == 2) {
                    this.this$0.tabAreaRect.x = insets2.left;
                    this.this$0.contentRect.x = this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width;
                } else {
                    this.this$0.contentRect.x = insets2.left;
                    this.this$0.tabAreaRect.x = this.this$0.contentRect.x + this.this$0.contentRect.width;
                }
            }
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Dimension dimension2;
            super.layoutContainer(container);
            int n = this.this$0.tabPane.getTabCount();
            Object var3_3 = null;
            if (n == 0) {
                return;
            }
            int n2 = this.this$0.tabPane.getTabPlacement();
            if (n2 == 1 || n2 == 3) {
                if (this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width < this.this$0.rects[n - 1].x + this.this$0.rects[n - 1].width) {
                    dimension2 = this.this$0.incrButton.getPreferredSize();
                    dimension = this.this$0.decrButton.getPreferredSize();
                    if (n2 == 3) {
                        this.this$0.decrButton.setBounds(this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width - dimension2.width - dimension.width, this.this$0.tabAreaRect.y, dimension.width, dimension.height);
                        this.this$0.incrButton.setBounds(this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width - dimension2.width, this.this$0.tabAreaRect.y, dimension2.width, dimension2.height);
                    } else {
                        this.this$0.decrButton.setBounds(this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width - dimension2.width - dimension.width, this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height - dimension.height, dimension.width, dimension.height);
                        this.this$0.incrButton.setBounds(this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width - dimension2.width, this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height - dimension2.height, dimension2.width, dimension2.height);
                    }
                    this.this$0.tabAreaRect.width -= dimension.width + dimension2.width;
                    this.this$0.updateButtons();
                    this.this$0.incrButton.setVisible(true);
                    this.this$0.decrButton.setVisible(true);
                } else {
                    this.this$0.incrButton.setVisible(false);
                    this.this$0.decrButton.setVisible(false);
                    this.this$0.currentScrollOffset = 0;
                    this.this$0.currentScrollLocation = 0;
                }
            }
            if (n2 == 2 || n2 == 4) {
                if (this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height < this.this$0.rects[n - 1].y + this.this$0.rects[n - 1].height) {
                    dimension2 = this.this$0.incrButton.getPreferredSize();
                    dimension = this.this$0.decrButton.getPreferredSize();
                    if (n2 == 4) {
                        this.this$0.decrButton.setBounds(this.this$0.tabAreaRect.x, this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height - dimension2.height - dimension.height, dimension.width, dimension.height);
                        this.this$0.incrButton.setBounds(this.this$0.tabAreaRect.x, this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height - dimension2.height, dimension2.width, dimension2.height);
                    } else {
                        this.this$0.decrButton.setBounds(this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width - dimension.width, this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height - dimension2.height - dimension.height, dimension.width, dimension.height);
                        this.this$0.incrButton.setBounds(this.this$0.tabAreaRect.x + this.this$0.tabAreaRect.width - dimension2.width, this.this$0.tabAreaRect.y + this.this$0.tabAreaRect.height - dimension2.height, dimension2.width, dimension2.height);
                    }
                    this.this$0.tabAreaRect.height -= dimension.height + dimension2.height;
                    this.this$0.incrButton.setVisible(true);
                    this.this$0.decrButton.setVisible(true);
                } else {
                    this.this$0.incrButton.setVisible(false);
                    this.this$0.decrButton.setVisible(false);
                    this.this$0.currentScrollOffset = 0;
                    this.this$0.currentScrollLocation = 0;
                }
            }
            this.this$0.viewport.setBounds(this.this$0.tabAreaRect.x, this.this$0.tabAreaRect.y, this.this$0.tabAreaRect.width, this.this$0.tabAreaRect.height);
            this.this$0.updateViewPosition();
            this.this$0.viewport.repaint();
        }

        TabbedPaneScrollLayout(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
            super(basicTabbedPaneUI);
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void addLayoutComponent(String string, Component component) {
        }

        public void calculateLayoutInfo() {
            int n = this.this$0.tabPane.getTabCount();
            this.this$0.assureRectsCreated(n);
            this.calculateTabRects(this.this$0.tabPane.getTabPlacement(), n);
            this.this$0.tabRunsDirty = false;
        }

        protected Dimension calculateSize(boolean bl) {
            int n = this.this$0.tabPane.getTabPlacement();
            int n2 = 0;
            int n3 = 0;
            int n4 = this.this$0.tabPane.getTabCount();
            for (int i = 0; i < n4; ++i) {
                Dimension dimension;
                Component component = this.this$0.tabPane.getComponentAt(i);
                if (component == null) continue;
                Dimension dimension2 = dimension = bl ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension == null) continue;
                n3 = Math.max(n3, dimension.height);
                n2 = Math.max(n2, dimension.width);
            }
            Insets insets = this.this$0.getTabAreaInsets(n);
            if (n == 1 || n == 3) {
                n2 = Math.max(this.this$0.calculateMaxTabWidth(n), n2);
                n3 += this.preferredTabAreaHeight(n, n2 - insets.left - insets.right);
            } else {
                n3 = Math.max(this.this$0.calculateMaxTabHeight(n), n3);
                n2 += this.preferredTabAreaWidth(n, n3 - insets.top - insets.bottom);
            }
            Insets insets2 = this.this$0.tabPane.getInsets();
            return new Dimension(n2 + insets2.left + insets2.right, n3 + insets2.top + insets2.bottom);
        }

        protected void calculateTabRects(int n, int n2) {
            Rectangle rectangle;
            int n3;
            int n4;
            int n5;
            int n6;
            Insets insets = this.this$0.tabPane.getInsets();
            Insets insets2 = this.this$0.getTabAreaInsets(n);
            Dimension dimension = this.this$0.tabPane.getSize();
            switch (n) {
                case 2: {
                    this.this$0.maxTabWidth = this.this$0.calculateMaxTabWidth(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    this.this$0.maxTabWidth = this.this$0.calculateMaxTabWidth(n);
                    n6 = dimension.width - (insets.right + insets2.right) - this.this$0.maxTabWidth - 1;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    this.this$0.maxTabHeight = this.this$0.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = dimension.height - (insets.bottom + insets2.bottom) - this.this$0.maxTabHeight - 1;
                    n4 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    this.this$0.maxTabHeight = this.this$0.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.width - (insets.right + insets2.right);
                }
            }
            if (n2 == 0) {
                return;
            }
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            this.this$0.runCount = 0;
            this.this$0.selectedRun = -1;
            int n7 = this.this$0.tabPane.getSelectedIndex();
            if (n7 < 0) {
                n7 = 0;
            }
            if (n == 1 || n == 3) {
                for (n3 = 0; n3 < n2; ++n3) {
                    rectangle = this.this$0.rects[n3];
                    if (n3 > 0) {
                        rectangle.x = this.this$0.rects[n3 - 1].x + this.this$0.rects[n3 - 1].width;
                    } else {
                        this.this$0.tabRuns[0] = 0;
                        this.this$0.runCount = 1;
                        this.this$0.maxTabWidth = 0;
                        rectangle.x = n6;
                    }
                    rectangle.width = this.this$0.calculateTabWidth(n, n3, fontMetrics);
                    this.this$0.maxTabWidth = Math.max(this.this$0.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n4) {
                        if (this.this$0.runCount > this.this$0.tabRuns.length - 1) {
                            this.this$0.expandTabRunsArray();
                        }
                        this.this$0.tabRuns[this.this$0.runCount] = n3;
                        ++this.this$0.runCount;
                        rectangle.x = n6;
                    }
                    rectangle.y = n5;
                    rectangle.height = this.this$0.maxTabHeight;
                    if (n3 != n7) continue;
                    this.this$0.selectedRun = this.this$0.runCount - 1;
                }
            } else {
                for (n3 = 0; n3 < n2; ++n3) {
                    rectangle = this.this$0.rects[n3];
                    if (n3 > 0) {
                        rectangle.y = this.this$0.rects[n3 - 1].y + this.this$0.rects[n3 - 1].height;
                    } else {
                        this.this$0.tabRuns[0] = 0;
                        this.this$0.runCount = 1;
                        this.this$0.maxTabHeight = 0;
                        rectangle.y = n5;
                    }
                    rectangle.height = this.this$0.calculateTabHeight(n, n3, fontMetrics.getHeight());
                    this.this$0.maxTabHeight = Math.max(this.this$0.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n4) {
                        if (this.this$0.runCount > this.this$0.tabRuns.length - 1) {
                            this.this$0.expandTabRunsArray();
                        }
                        this.this$0.tabRuns[this.this$0.runCount] = n3;
                        ++this.this$0.runCount;
                        rectangle.y = n5;
                    }
                    rectangle.x = n6;
                    rectangle.width = this.this$0.maxTabWidth;
                    if (n3 != n7) continue;
                    this.this$0.selectedRun = this.this$0.runCount - 1;
                }
            }
            if (this.this$0.runCount > 1) {
                n3 = n == 1 || n == 3 ? n6 : n5;
                this.normalizeTabRuns(n, n2, n3, n4);
                this.this$0.selectedRun = this.this$0.getRunForTab(n2, n7);
                if (this.this$0.shouldRotateTabRuns(n)) {
                    this.rotateTabRuns(n, this.this$0.selectedRun);
                }
            }
            if (this.this$0.runCount == 1) {
                return;
            }
            n3 = this.this$0.getTabRunOverlay(n);
            for (int i = this.this$0.runCount - 1; i >= 0; --i) {
                int n8;
                int n9;
                int n10 = this.this$0.tabRuns[i];
                int n11 = i == this.this$0.runCount - 1 ? 0 : i + 1;
                int n12 = this.this$0.tabRuns[n11];
                int n13 = n9 = n12 != 0 ? n12 - 1 : n2 - 1;
                if (n == 1 || n == 3) {
                    for (n8 = n10; n8 <= n9; ++n8) {
                        rectangle = this.this$0.rects[n8];
                        rectangle.y = n5;
                        rectangle.x += this.this$0.getTabRunIndent(n, i);
                    }
                    if (this.this$0.shouldPadTabRun(n, i)) {
                        this.padTabRun(n, n10, n9, n4);
                    }
                    if (n == 3) {
                        n5 -= this.this$0.maxTabHeight - n3;
                        continue;
                    }
                    n5 += this.this$0.maxTabHeight - n3;
                    continue;
                }
                for (n8 = n10; n8 <= n9; ++n8) {
                    rectangle = this.this$0.rects[n8];
                    rectangle.x = n6;
                    rectangle.y += this.this$0.getTabRunIndent(n, i);
                }
                if (this.this$0.shouldPadTabRun(n, i)) {
                    this.padTabRun(n, n10, n9, n4);
                }
                if (n == 4) {
                    n6 -= this.this$0.maxTabWidth - n3;
                    continue;
                }
                n6 += this.this$0.maxTabWidth - n3;
            }
            this.padSelectedTab(n, n7);
        }

        public void layoutContainer(Container container) {
            int n;
            this.calculateLayoutInfo();
            int n2 = this.this$0.tabPane.getTabPlacement();
            Insets insets = this.this$0.tabPane.getInsets();
            int n3 = this.this$0.tabPane.getSelectedIndex();
            Component component = null;
            if (n3 >= 0) {
                component = this.this$0.tabPane.getComponentAt(n3);
            }
            if (component != null) {
                this.this$0.setVisibleComponent(component);
            }
            if ((n = this.this$0.tabPane.getComponentCount()) > 0) {
                int n4;
                int n5;
                int n6 = 0;
                int n7 = 0;
                switch (n2) {
                    case 2: {
                        n6 = this.this$0.calculateTabAreaWidth(n2, this.this$0.runCount, this.this$0.maxTabWidth);
                        n5 = n6 + insets.left + this.this$0.contentBorderInsets.left;
                        n4 = insets.top + this.this$0.contentBorderInsets.top;
                        break;
                    }
                    case 4: {
                        n6 = this.this$0.calculateTabAreaWidth(n2, this.this$0.runCount, this.this$0.maxTabWidth);
                        n5 = insets.left + this.this$0.contentBorderInsets.left;
                        n4 = insets.top + this.this$0.contentBorderInsets.top;
                        break;
                    }
                    case 3: {
                        n7 = this.this$0.calculateTabAreaHeight(n2, this.this$0.runCount, this.this$0.maxTabHeight);
                        n5 = insets.left + this.this$0.contentBorderInsets.left;
                        n4 = insets.top + this.this$0.contentBorderInsets.top;
                        break;
                    }
                    default: {
                        n7 = this.this$0.calculateTabAreaHeight(n2, this.this$0.runCount, this.this$0.maxTabHeight);
                        n5 = insets.left + this.this$0.contentBorderInsets.left;
                        n4 = n7 + insets.top + this.this$0.contentBorderInsets.top;
                    }
                }
                Rectangle rectangle = this.this$0.tabPane.getBounds();
                int n8 = rectangle.width - n6 - insets.left - insets.right - this.this$0.contentBorderInsets.left - this.this$0.contentBorderInsets.right;
                int n9 = rectangle.height - n7 - insets.top - insets.bottom - this.this$0.contentBorderInsets.top - this.this$0.contentBorderInsets.bottom;
                for (int i = 0; i < n; ++i) {
                    Component component2 = this.this$0.tabPane.getComponent(i);
                    component2.setBounds(n5, n4, n8, n9);
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        protected void normalizeTabRuns(int n, int n2, int n3, int n4) {
            Insets insets = this.this$0.getTabAreaInsets(n);
            if (n == 1 || n == 3) {
                for (int i = 1; i < this.this$0.runCount; ++i) {
                    Rectangle rectangle = this.this$0.rects[this.this$0.lastTabInRun(n2, i)];
                    Rectangle rectangle2 = this.this$0.rects[this.this$0.lastTabInRun(n2, this.this$0.getNextTabRun(i))];
                    int n5 = rectangle.x + rectangle.width;
                    int n6 = rectangle2.x + rectangle2.width;
                    int n7 = n5 - n6;
                    int n8 = n5 - rectangle.width - (n6 + rectangle.width);
                    while (Math.abs(n8) < Math.abs(n7) && n6 + rectangle.width < n4) {
                        int n9 = i;
                        this.this$0.tabRuns[n9] = this.this$0.tabRuns[n9] - 1;
                        rectangle = this.this$0.rects[this.this$0.lastTabInRun(n2, i)];
                        n7 = (n5 -= rectangle.width) - (n6 += rectangle.width);
                        n8 = n5 - rectangle.width - (n6 + rectangle.width);
                    }
                    int n10 = this.this$0.tabRuns[i];
                    int n11 = this.this$0.lastTabInRun(n2, i);
                    int n12 = n3;
                    for (int j = n10; j <= n11; ++j) {
                        this.this$0.rects[j].x = n12;
                        n12 += this.this$0.rects[j].width;
                    }
                }
            } else {
                for (int i = 1; i < this.this$0.runCount; ++i) {
                    Rectangle rectangle = this.this$0.rects[this.this$0.lastTabInRun(n2, i)];
                    Rectangle rectangle3 = this.this$0.rects[this.this$0.lastTabInRun(n2, this.this$0.getNextTabRun(i))];
                    int n13 = rectangle.y + rectangle.height;
                    int n14 = rectangle3.y + rectangle3.height;
                    int n15 = n13 - n14;
                    int n16 = n13 - rectangle.height - (n14 + rectangle.height);
                    while (Math.abs(n16) < Math.abs(n15) && n14 + rectangle.height < n4) {
                        int n17 = i;
                        this.this$0.tabRuns[n17] = this.this$0.tabRuns[n17] - 1;
                        rectangle = this.this$0.rects[this.this$0.lastTabInRun(n2, i)];
                        n15 = (n13 -= rectangle.height) - (n14 += rectangle.height);
                        n16 = n13 - rectangle.height - (n14 + rectangle.height);
                    }
                    int n18 = this.this$0.tabRuns[i];
                    int n19 = this.this$0.lastTabInRun(n2, i);
                    int n20 = n3;
                    for (int j = n18; j <= n19; ++j) {
                        this.this$0.rects[j].y = n20;
                        n20 += this.this$0.rects[j].height;
                    }
                }
            }
        }

        protected void padSelectedTab(int n, int n2) {
            Insets insets = this.this$0.getSelectedTabPadInsets(n);
            this.this$0.rects[n2].x -= insets.left;
            this.this$0.rects[n2].y -= insets.top;
            this.this$0.rects[n2].width += insets.left + insets.right;
            this.this$0.rects[n2].height += insets.top + insets.bottom;
        }

        protected void padTabRun(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                int n5 = this.this$0.rects[n3].x + this.this$0.rects[n3].width;
                int n6 = n4 - n5;
                int n7 = n3 - n2 + 1;
                int n8 = n6 / n7;
                int n9 = this.this$0.rects[n2].x;
                for (int i = n2; i <= n3; ++i) {
                    this.this$0.rects[i].x = n9;
                    this.this$0.rects[i].width += n8;
                    n9 += this.this$0.rects[i].width;
                    if (i != n3 || this.this$0.rects[i].x + this.this$0.rects[i].width == n4) continue;
                    this.this$0.rects[i].width = n4 - this.this$0.rects[i].x;
                }
            } else {
                int n10 = this.this$0.rects[n3].y + this.this$0.rects[n3].height;
                int n11 = n4 - n10;
                int n12 = n3 - n2 + 1;
                int n13 = n11 / n12;
                int n14 = this.this$0.rects[n2].y;
                for (int i = n2; i <= n3; ++i) {
                    this.this$0.rects[i].y = n14;
                    this.this$0.rects[i].height += n13;
                    n14 += this.this$0.rects[i].height;
                    if (i != n3 || this.this$0.rects[i].y + this.this$0.rects[i].height == n4) continue;
                    this.this$0.rects[i].height = n4 - this.this$0.rects[i].y;
                }
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        protected int preferredTabAreaHeight(int n, int n2) {
            int n3;
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(n, 0, 0);
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            Insets insets = this.this$0.getTabAreaInsets(n);
            Insets insets2 = this.this$0.tabPane.getInsets();
            n2 -= insets.left + insets.right + insets2.left + insets2.right;
            for (n3 = 0; n3 < this.this$0.tabPane.getTabCount(); ++n3) {
                n6 = this.this$0.calculateTabWidth(n, n3, fontMetrics);
                if (n5 + n6 > n2) {
                    n5 = n6;
                    ++n4;
                    continue;
                }
                n5 += n6;
            }
            n3 = this.this$0.calculateMaxTabHeight(n);
            int n7 = this.this$0.calculateTabAreaHeight(n, ++n4, n3);
            return n7;
        }

        protected int preferredTabAreaWidth(int n, int n2) {
            int n3;
            if (this.this$0.tabPane.getTabCount() == 0) {
                return this.this$0.calculateTabAreaHeight(n, 0, 0);
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            FontMetrics fontMetrics = this.this$0.getFontMetrics();
            Insets insets = this.this$0.getTabAreaInsets(n);
            Insets insets2 = this.this$0.tabPane.getInsets();
            n2 -= insets.top + insets.bottom + insets2.top + insets2.bottom;
            int n7 = fontMetrics.getHeight();
            for (n3 = 0; n3 < this.this$0.tabPane.getTabCount(); ++n3) {
                n6 = this.this$0.calculateTabHeight(n, n3, n7);
                if (n5 + n6 > n2) {
                    n5 = n6;
                    ++n4;
                    continue;
                }
                n5 += n6;
            }
            n3 = this.this$0.calculateMaxTabWidth(n);
            int n8 = this.this$0.calculateTabAreaWidth(n, ++n4, n3);
            return n8;
        }

        protected void rotateTabRuns(int n, int n2) {
            if (this.this$0.runCount == 1 || n2 == 0 || n2 == -1) {
                return;
            }
            int[] nArray = new int[this.this$0.tabRuns.length];
            int n3 = n2;
            int n4 = 0;
            do {
                nArray[n4] = this.this$0.tabRuns[n3];
                n3 = this.this$0.getNextTabRun(n3);
            } while (++n4 < this.this$0.runCount);
            this.this$0.tabRuns = nArray;
            this.this$0.selectedRun = 1;
        }

        public void removeLayoutComponent(Component component) {
        }

        public TabbedPaneLayout(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("tabLayoutPolicy")) {
                this.this$0.currentScrollOffset = 0;
                this.this$0.currentScrollLocation = 0;
                this.this$0.layoutManager = this.this$0.createLayoutManager();
                this.this$0.tabPane.setLayout(this.this$0.layoutManager);
            } else if (propertyChangeEvent.getPropertyName().equals("tabPlacement") && this.this$0.tabPane.getTabLayoutPolicy() == 1) {
                this.this$0.incrButton = this.this$0.createIncreaseButton();
                this.this$0.decrButton = this.this$0.createDecreaseButton();
            }
            this.this$0.tabPane.revalidate();
            this.this$0.tabPane.repaint();
        }

        public PropertyChangeHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            int n = this.this$0.tabPane.getTabPlacement();
            if (object == this.this$0.incrButton) {
                if (!this.this$0.incrButton.isEnabled()) {
                    return;
                }
                ++this.this$0.currentScrollLocation;
                switch (n) {
                    case 1: 
                    case 3: {
                        this.this$0.currentScrollOffset = this.this$0.getTabAreaInsets((int)n).left;
                        for (int i = 0; i < this.this$0.currentScrollLocation; ++i) {
                            this.this$0.currentScrollOffset += this.this$0.rects[i].width;
                        }
                        break;
                    }
                    default: {
                        this.this$0.currentScrollOffset = this.this$0.getTabAreaInsets((int)n).top;
                        for (int i = 0; i < this.this$0.currentScrollLocation; ++i) {
                            this.this$0.currentScrollOffset += this.this$0.rects[i].height;
                        }
                    }
                }
                this.this$0.updateViewPosition();
                this.this$0.updateButtons();
                this.this$0.tabPane.repaint();
            } else if (object == this.this$0.decrButton) {
                if (!this.this$0.decrButton.isEnabled()) {
                    return;
                }
                if (this.this$0.currentScrollLocation > 0) {
                    --this.this$0.currentScrollLocation;
                }
                this.this$0.currentScrollOffset = 0;
                switch (n) {
                    case 1: 
                    case 3: {
                        if (this.this$0.currentScrollLocation > 0) {
                            this.this$0.currentScrollOffset = this.this$0.getTabAreaInsets((int)n).left;
                        }
                        for (int i = 0; i < this.this$0.currentScrollLocation; ++i) {
                            this.this$0.currentScrollOffset += this.this$0.rects[i].width;
                        }
                        break;
                    }
                    default: {
                        if (this.this$0.currentScrollLocation > 0) {
                            this.this$0.currentScrollOffset = this.this$0.getTabAreaInsets((int)n).top;
                        }
                        for (int i = 0; i < this.this$0.currentScrollLocation; ++i) {
                            this.this$0.currentScrollOffset += this.this$0.rects[i].height;
                        }
                    }
                }
                this.this$0.updateViewPosition();
                this.this$0.updateButtons();
                this.this$0.tabPane.repaint();
            } else if (this.this$0.tabPane.isEnabled()) {
                int n2 = this.this$0.tabForCoordinate(this.this$0.tabPane, mouseEvent.getX(), mouseEvent.getY());
                if (this.this$0.tabPane.getTabLayoutPolicy() == 1 && object == this.this$0.panel) {
                    this.this$0.scrollTab(n2, n);
                }
                this.this$0.tabPane.setSelectedIndex(n2);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            int n = this.this$0.tabForCoordinate(this.this$0.tabPane, mouseEvent.getX(), mouseEvent.getY());
            this.this$0.setRolloverTab(n);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.this$0.setRolloverTab(-1);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.this$0.tabForCoordinate(this.this$0.tabPane, mouseEvent.getX(), mouseEvent.getY());
            this.this$0.setRolloverTab(n);
        }

        public MouseHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        private /* synthetic */ BasicTabbedPaneUI this$0;

        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == this.this$0.panel) {
                this.this$0.tabPane.requestFocus();
            } else if (object == this.this$0.tabPane) {
                this.this$0.tabPane.repaint();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getOppositeComponent() == this.this$0.tabPane.getSelectedComponent()) {
                this.this$0.tabPane.requestFocus();
            } else if (focusEvent.getSource() == this.this$0.tabPane) {
                this.this$0.tabPane.repaint();
            }
        }

        public FocusHandler(BasicTabbedPaneUI basicTabbedPaneUI) {
            this.this$0 = basicTabbedPaneUI;
        }
    }

    static class RequestFocusForVisibleComponentAction
    extends AbstractAction {
        public RequestFocusForVisibleComponentAction() {
            super("requestFocusForVisibleComponent");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            jTabbedPane.getSelectedComponent().requestFocus();
        }
    }

    static class RequestFocusAction
    extends AbstractAction {
        public RequestFocusAction() {
            super("requestFocus");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((JTabbedPane)actionEvent.getSource()).requestFocus();
        }
    }

    static class NavigatePageUpAction
    extends AbstractAction {
        public NavigatePageUpAction() {
            super("navigatePageUp");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getSelectedIndex();
            if (n < 0) {
                n = 0;
            }
            basicTabbedPaneUI.selectPreviousTabInRun(n);
        }
    }

    static class NavigatePageDownAction
    extends AbstractAction {
        public NavigatePageDownAction() {
            super("navigatePageDown");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            int n = jTabbedPane.getSelectedIndex();
            if (n < 0) {
                n = 0;
            }
            basicTabbedPaneUI.selectNextTabInRun(n);
        }
    }

    static class NavigateAction
    extends AbstractAction {
        int direction;

        NavigateAction(String string, int n) {
            super(string);
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
            basicTabbedPaneUI.navigateSelectedTab(this.direction);
        }
    }
}

