/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;

public class BasicListUI
extends ListUI {
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    protected FocusListener focusListener;
    protected ListDataListener listDataListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseInputListener mouseInputListener;
    protected PropertyChangeListener propertyChangeListener;
    protected JList list;
    protected int cellHeight;
    protected int cellWidth;
    protected int[] cellHeights;
    protected int updateLayoutStateNeeded = 1;
    protected CellRendererPane rendererPane = new CellRendererPane();
    ListAction action;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicListUI();
    }

    protected int getRowHeight(int n) {
        int n2 = this.cellHeights == null ? this.cellHeight : (n < 0 || n >= this.cellHeights.length ? -1 : this.cellHeights[n]);
        return n2;
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        if (jList != this.list || this.cellWidth == -1) {
            return null;
        }
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        Point point = this.indexToLocation(this.list, n3);
        int n5 = this.cellWidth;
        if (jList.getLayoutOrientation() == 0) {
            n5 = jList.getWidth();
        }
        Rectangle rectangle = new Rectangle(point.x, point.y, n5, this.getCellHeight(n3));
        for (int i = n3 + 1; i <= n4; ++i) {
            Point point2 = this.indexToLocation(this.list, i);
            rectangle = SwingUtilities.computeUnion(point2.x, point2.y, n5, this.getCellHeight(i), rectangle);
        }
        return rectangle;
    }

    private int getCellHeight(int n) {
        int n2 = this.cellHeight;
        if (n2 <= 0) {
            if (this.list.getLayoutOrientation() == 0) {
                n2 = this.getRowHeight(n);
            } else {
                for (int i = 0; i < this.cellHeights.length; ++i) {
                    n2 = Math.max(n2, this.cellHeights[i]);
                }
            }
        }
        return n2;
    }

    protected int convertRowToY(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = this.getRowHeight(i);
            if (n3 == -1) {
                return -1;
            }
            n2 += n3;
        }
        return n2;
    }

    protected int convertYToRow(int n) {
        if (this.list.getModel().getSize() == 0) {
            return -1;
        }
        if (n < 0) {
            return this.list.getModel().getSize() - 1;
        }
        this.maybeUpdateLayoutState();
        int n2 = this.list.getModel().getSize() - 1;
        if (this.cellHeight > 0) {
            n2 = Math.min(n / this.cellHeight, n2);
        } else {
            int n3 = 0;
            for (int i = 0; i < this.cellHeights.length; ++i) {
                if (n >= (n3 += this.cellHeights[i])) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    protected void updateLayoutState() {
        Serializable serializable;
        int n;
        int n2 = this.list.getModel().getSize();
        this.cellHeight = -1;
        this.cellWidth = -1;
        if (this.cellHeights == null || this.cellHeights.length != n2) {
            this.cellHeights = new int[n2];
        }
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        int n3 = this.list.getFixedCellHeight();
        if (n3 > 0) {
            this.cellHeight = n3;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            for (n = 0; n < n2; ++n) {
                Component component = listCellRenderer.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(n), n, this.list.isSelectedIndex(n), this.list.getSelectionModel().getAnchorSelectionIndex() == n);
                serializable = component.getPreferredSize();
                this.cellHeights[n] = ((Dimension)serializable).height;
            }
        }
        n = this.list.getFixedCellWidth();
        if (n > 0) {
            this.cellWidth = n;
        } else {
            for (int i = 0; i < n2; ++i) {
                serializable = listCellRenderer.getListCellRendererComponent(this.list, this.list.getModel().getElementAt(i), i, this.list.isSelectedIndex(i), this.list.getSelectionModel().getAnchorSelectionIndex() == i);
                Dimension dimension = ((Component)serializable).getPreferredSize();
                this.cellWidth = Math.max(this.cellWidth, dimension.width);
            }
        }
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        this.list.setOpaque(true);
    }

    protected void uninstallDefaults() {
        this.list.setForeground(null);
        this.list.setBackground(null);
        this.list.setSelectionForeground(null);
        this.list.setSelectionBackground(null);
    }

    protected void installListeners() {
        if (this.focusListener == null) {
            this.focusListener = this.createFocusListener();
        }
        this.list.addFocusListener(this.focusListener);
        if (this.listDataListener == null) {
            this.listDataListener = this.createListDataListener();
        }
        this.list.getModel().addListDataListener(this.listDataListener);
        if (this.listSelectionListener == null) {
            this.listSelectionListener = this.createListSelectionListener();
        }
        this.list.addListSelectionListener(this.listSelectionListener);
        if (this.mouseInputListener == null) {
            this.mouseInputListener = this.createMouseInputListener();
        }
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.list.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.list.removeFocusListener(this.focusListener);
        this.list.getModel().removeListDataListener(this.listDataListener);
        this.list.removeListSelectionListener(this.listSelectionListener);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)UIManager.get("List.focusInputMap");
        SwingUtilities.replaceUIInputMap(this.list, 0, inputMap);
        ActionMap actionMap = (ActionMap)UIManager.get("List.actionMap");
        if (actionMap == null) {
            actionMap = new ActionMapUIResource();
            ListAction listAction = new ListAction(this, "selectPreviousRow");
            actionMap.put("selectPreviousRow", listAction);
            listAction = new ListAction(this, "selectNextRow");
            actionMap.put("selectNextRow", listAction);
            listAction = new ListAction(this, "selectPreviousRowExtendSelection");
            actionMap.put("selectPreviousRowExtendSelection", listAction);
            listAction = new ListAction(this, "selectNextRowExtendSelection");
            actionMap.put("selectNextRowExtendSelection", listAction);
            listAction = new ListAction(this, "selectPreviousColumn");
            actionMap.put("selectPreviousColumn", listAction);
            listAction = new ListAction(this, "selectNextColumn");
            actionMap.put("selectNextColumn", listAction);
            listAction = new ListAction(this, "selectPreviousColumnExtendSelection");
            actionMap.put("selectPreviousColumnExtendSelection", listAction);
            listAction = new ListAction(this, "selectNextColumnExtendSelection");
            actionMap.put("selectNextColumnExtendSelection", listAction);
            listAction = new ListAction(this, "selectFirstRow");
            actionMap.put("selectFirstRow", listAction);
            listAction = new ListAction(this, "selectLastRow");
            actionMap.put("selectLastRow", listAction);
            listAction = new ListAction(this, "selectFirstRowExtendSelection");
            actionMap.put("selectFirstRowExtendSelection", listAction);
            listAction = new ListAction(this, "selectLastRowExtendSelection");
            actionMap.put("selectLastRowExtendSelection", listAction);
            listAction = new ListAction(this, "scrollUp");
            actionMap.put("scrollUp", listAction);
            listAction = new ListAction(this, "scrollUpExtendSelection");
            actionMap.put("scrollUpExtendSelection", listAction);
            listAction = new ListAction(this, "scrollDown");
            actionMap.put("scrollDown", listAction);
            listAction = new ListAction(this, "scrollDownExtendSelection");
            actionMap.put("scrollDownExtendSelection", listAction);
            listAction = new ListAction(this, "selectAll");
            actionMap.put("selectAll", listAction);
            listAction = new ListAction(this, "clearSelection");
            actionMap.put("clearSelection", listAction);
            actionMap.put("copy", TransferHandler.getCopyAction());
            actionMap.put("cut", TransferHandler.getCutAction());
            actionMap.put("paste", TransferHandler.getPasteAction());
            UIManager.put("List.actionMap", actionMap);
        }
        SwingUtilities.replaceUIActionMap(this.list, actionMap);
    }

    protected void uninstallKeyboardActions() {
        InputMap inputMap = SwingUtilities.getUIInputMap(this.list, 0);
        if (inputMap instanceof UIResource) {
            SwingUtilities.replaceUIInputMap(this.list, 0, null);
        }
        if (SwingUtilities.getUIActionMap(this.list) instanceof UIResource) {
            SwingUtilities.replaceUIActionMap(this.list, null);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.list = (JList)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.maybeUpdateLayoutState();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.list = null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n;
        int n2;
        int n3;
        this.maybeUpdateLayoutState();
        int n4 = this.list.getModel().getSize();
        int n5 = this.list.getVisibleRowCount();
        int n6 = this.list.getLayoutOrientation();
        int n7 = this.cellHeight;
        if (n7 <= 0) {
            for (n3 = 0; n3 < this.cellHeights.length; ++n3) {
                n7 = Math.max(n7, this.cellHeights[n3]);
            }
        }
        if (n6 == 2) {
            if (n5 > 0) {
                double d = n4;
                n3 = (int)Math.ceil(d / (double)n5);
                int n8 = (int)Math.ceil(d / (double)n3);
                n2 = n7 * n8;
                n = this.cellWidth * n3;
            } else {
                n3 = Math.min(1, this.list.getWidth() / this.cellWidth);
                n2 = n4 / n3 * n7;
                n = n3 * this.cellWidth;
            }
        } else if (n6 == 1) {
            n2 = n5 > 0 ? n5 * n7 : Math.max(this.list.getHeight(), n7);
            n3 = n2 / n7;
            n = this.cellWidth * n3;
        } else {
            n = this.list.getFixedCellWidth() > 0 ? this.list.getFixedCellWidth() : this.cellWidth;
            n2 = this.list.getFixedCellHeight() > 0 ? this.list.getFixedCellHeight() * n4 : n7 * n4;
        }
        Insets insets = this.list.getInsets();
        Dimension dimension = new Dimension(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        return dimension;
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        boolean bl = this.list.isSelectedIndex(n);
        boolean bl2 = this.list.getLeadSelectionIndex() == n && this.list.hasFocus();
        Component component = listCellRenderer.getListCellRendererComponent(this.list, listModel.getElementAt(n), n, bl, bl2);
        this.rendererPane.paintComponent(graphics, component, this.list, rectangle);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.list.getModel().getSize();
        if (n == 0) {
            return;
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        ListModel listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        int n2 = listSelectionModel.getLeadSelectionIndex();
        Rectangle rectangle = graphics.getClipBounds();
        int n3 = this.locationToIndex(this.list, new Point(rectangle.x, rectangle.y));
        int n4 = this.locationToIndex(this.list, new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        for (int i = n3; i <= n4; ++i) {
            Rectangle rectangle2 = this.getCellBounds(this.list, i, i);
            if (rectangle2 == null || !rectangle2.intersects(rectangle)) continue;
            this.paintCell(graphics, i, rectangle2, listCellRenderer, listModel, listSelectionModel, n2);
        }
    }

    public int locationToIndex(JList jList, Point point) {
        int n = this.list.getLayoutOrientation();
        int n2 = -1;
        switch (n) {
            case 0: {
                n2 = this.convertYToRow(point.y);
                break;
            }
            case 2: {
                int n3 = this.getCellHeight(0);
                int n4 = this.list.getHeight() / n3;
                int n5 = -1;
                int n6 = this.list.getModel().getSize();
                n5 = n6 / n4 + 1;
                int n7 = n6 / n5 + 1;
                int n8 = Math.min(point.x / this.cellWidth, n5 - 1);
                int n9 = Math.min(point.y / n3, n7);
                n2 = n8 + n9 * n5;
                break;
            }
            case 1: {
                int n10 = this.getCellHeight(0);
                int n11 = this.list.getHeight() / n10;
                int n12 = this.list.getModel().getSize();
                int n13 = n12 / n11 + 1;
                int n14 = Math.min(point.x / this.cellWidth, n13 - 1);
                int n15 = Math.min(point.y / n10, n11);
                n2 = n15 + n14 * n11;
            }
        }
        return n2;
    }

    public Point indexToLocation(JList jList, int n) {
        int n2 = this.list.getLayoutOrientation();
        Point point = null;
        switch (n2) {
            case 0: {
                point = new Point(0, this.convertRowToY(n));
                break;
            }
            case 2: {
                int n3 = this.getCellHeight(0);
                int n4 = this.list.getHeight() / n3;
                int n5 = -1;
                int n6 = this.list.getModel().getSize();
                n5 = n6 / n4 + 1;
                int n7 = n % n5;
                int n8 = n / n5;
                int n9 = n7 * this.cellWidth;
                int n10 = n8 * n3;
                point = new Point(n9, n10);
                break;
            }
            case 1: {
                int n11 = this.getCellHeight(0);
                int n12 = this.list.getHeight() / n11;
                if (n12 > 0) {
                    int n13 = n % n12;
                    int n14 = n / n12;
                    int n15 = n14 * this.cellWidth;
                    int n16 = n13 * n11;
                    point = new Point(n15, n16);
                    break;
                }
                point = new Point(0, this.convertRowToY(n));
            }
        }
        return point;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler(this);
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler(this);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected void selectNextIndex() {
        int n = this.list.getSelectionModel().getLeadSelectionIndex();
        if (n < this.list.getModel().getSize() - 1) {
            this.list.setSelectedIndex(++n);
        }
        this.list.ensureIndexIsVisible(n);
    }

    protected void selectPreviousIndex() {
        int n = this.list.getSelectionModel().getLeadSelectionIndex();
        if (n > 0) {
            this.list.setSelectedIndex(--n);
        }
        this.list.ensureIndexIsVisible(n);
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicListUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                ListModel listModel;
                if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getOldValue() instanceof ListModel) {
                    listModel = (ListModel)propertyChangeEvent.getOldValue();
                    listModel.removeListDataListener(this.this$0.listDataListener);
                }
                if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() instanceof ListModel) {
                    listModel = (ListModel)propertyChangeEvent.getNewValue();
                    listModel.addListDataListener(this.this$0.listDataListener);
                }
                this.this$0.updateLayoutStateNeeded |= 1;
            } else if (propertyChangeEvent.getPropertyName().equals("selectionModel")) {
                this.this$0.updateLayoutStateNeeded |= 2;
            } else if (propertyChangeEvent.getPropertyName().equals("font")) {
                this.this$0.updateLayoutStateNeeded |= 4;
            } else if (propertyChangeEvent.getPropertyName().equals("fixedCellWidth")) {
                this.this$0.updateLayoutStateNeeded |= 8;
            } else if (propertyChangeEvent.getPropertyName().equals("fixedCellHeight")) {
                this.this$0.updateLayoutStateNeeded |= 0x10;
            } else if (propertyChangeEvent.getPropertyName().equals("prototypeCellValue")) {
                this.this$0.updateLayoutStateNeeded |= 0x20;
            } else if (propertyChangeEvent.getPropertyName().equals("cellRenderer")) {
                this.this$0.updateLayoutStateNeeded |= 0x40;
            }
        }

        public PropertyChangeHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicListUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.this$0.locationToIndex(this.this$0.list, point);
            if (n == -1) {
                return;
            }
            if (mouseEvent.isShiftDown()) {
                if (this.this$0.list.getSelectionMode() == 0) {
                    this.this$0.list.setSelectedIndex(n);
                } else if (this.this$0.list.getSelectionMode() == 1) {
                    this.this$0.list.setSelectionInterval(this.this$0.list.getAnchorSelectionIndex(), n);
                } else if (this.this$0.list.isSelectedIndex(this.this$0.list.getAnchorSelectionIndex())) {
                    this.this$0.list.getSelectionModel().setLeadSelectionIndex(n);
                } else {
                    this.this$0.list.addSelectionInterval(this.this$0.list.getAnchorSelectionIndex(), n);
                }
            } else if (mouseEvent.isControlDown()) {
                if (this.this$0.list.getSelectionMode() == 0) {
                    this.this$0.list.setSelectedIndex(n);
                } else if (this.this$0.list.isSelectedIndex(n)) {
                    this.this$0.list.removeSelectionInterval(n, n);
                } else {
                    this.this$0.list.addSelectionInterval(n, n);
                }
            } else {
                this.this$0.list.setSelectedIndex(n);
            }
            this.this$0.list.ensureIndexIsVisible(this.this$0.list.getLeadSelectionIndex());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.this$0.list.requestFocusInWindow();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.this$0.locationToIndex(this.this$0.list, point);
            if (n == -1) {
                return;
            }
            if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                this.this$0.list.setSelectedIndex(n);
            }
            this.this$0.list.ensureIndexIsVisible(this.this$0.list.getLeadSelectionIndex());
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public MouseInputHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    private class ListAction
    extends AbstractAction {
        private /* synthetic */ BasicListUI this$0;

        ListAction(BasicListUI basicListUI, String string) {
            this.this$0 = basicListUI;
            this.putValue("ActionCommandKey", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.this$0.list.getLeadSelectionIndex();
            int n2 = this.this$0.list.getModel().getSize() - 1;
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this.this$0.list.getSelectionModel();
            String string = actionEvent.getActionCommand();
            if (n2 == -1) {
                return;
            }
            if (string.equals("selectNextRow")) {
                this.this$0.selectNextIndex();
            } else if (string.equals("selectPreviousRow")) {
                this.this$0.selectPreviousIndex();
            } else if (string.equals("clearSelection")) {
                this.this$0.list.clearSelection();
            } else if (string.equals("selectAll")) {
                this.this$0.list.setSelectionInterval(0, n2);
                this.this$0.list.addSelectionInterval(n, n);
            } else if (string.equals("selectLastRow")) {
                this.this$0.list.setSelectedIndex(this.this$0.list.getModel().getSize() - 1);
            } else if (string.equals("selectLastRowChangeLead")) {
                defaultListSelectionModel.moveLeadSelectionIndex(this.this$0.list.getModel().getSize() - 1);
            } else if (string.equals("scrollDownExtendSelection")) {
                int n3 = n == this.this$0.list.getLastVisibleIndex() ? Math.min(n2, n + (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getLastVisibleIndex();
                defaultListSelectionModel.setLeadSelectionIndex(n3);
            } else if (string.equals("scrollDownChangeLead")) {
                int n4 = n == this.this$0.list.getLastVisibleIndex() ? Math.min(n2, n + (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getLastVisibleIndex();
                defaultListSelectionModel.moveLeadSelectionIndex(n4);
            } else if (string.equals("scrollUpExtendSelection")) {
                int n5 = n == this.this$0.list.getFirstVisibleIndex() ? Math.max(0, n - (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getFirstVisibleIndex();
                defaultListSelectionModel.setLeadSelectionIndex(n5);
            } else if (string.equals("scrollUpChangeLead")) {
                int n6 = n == this.this$0.list.getFirstVisibleIndex() ? Math.max(0, n - (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getFirstVisibleIndex();
                defaultListSelectionModel.moveLeadSelectionIndex(n6);
            } else if (string.equals("selectNextRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.min(n + 1, n2));
            } else if (string.equals("selectFirstRow")) {
                this.this$0.list.setSelectedIndex(0);
            } else if (string.equals("selectFirstRowChangeLead")) {
                defaultListSelectionModel.moveLeadSelectionIndex(0);
            } else if (string.equals("selectFirstRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(0);
            } else if (string.equals("selectPreviousRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(Math.max(0, n - 1));
            } else if (string.equals("scrollUp")) {
                int n7 = n == this.this$0.list.getFirstVisibleIndex() ? Math.max(0, n - (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getFirstVisibleIndex();
                this.this$0.list.setSelectedIndex(n7);
            } else if (string.equals("selectLastRowExtendSelection")) {
                defaultListSelectionModel.setLeadSelectionIndex(this.this$0.list.getModel().getSize() - 1);
            } else if (string.equals("scrollDown")) {
                int n8 = n == this.this$0.list.getLastVisibleIndex() ? Math.min(n2, n + (this.this$0.list.getLastVisibleIndex() - this.this$0.list.getFirstVisibleIndex() + 1)) : this.this$0.list.getLastVisibleIndex();
                this.this$0.list.setSelectedIndex(n8);
            } else if (string.equals("selectNextRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    this.this$0.selectNextIndex();
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.min(n2, n + 1));
                }
            } else if (string.equals("selectPreviousRowChangeLead")) {
                if (defaultListSelectionModel.getSelectionMode() != 2) {
                    this.this$0.selectPreviousIndex();
                } else {
                    defaultListSelectionModel.moveLeadSelectionIndex(Math.max(0, n - 1));
                }
            } else if (string.equals("addToSelection")) {
                this.this$0.list.addSelectionInterval(n, n);
            } else if (string.equals("extendTo")) {
                defaultListSelectionModel.setSelectionInterval(defaultListSelectionModel.getAnchorSelectionIndex(), n);
            } else if (string.equals("toggleAndAnchor")) {
                if (!this.this$0.list.isSelectedIndex(n)) {
                    this.this$0.list.addSelectionInterval(n, n);
                } else {
                    this.this$0.list.removeSelectionInterval(n, n);
                }
                defaultListSelectionModel.setAnchorSelectionIndex(n);
            }
            this.this$0.list.ensureIndexIsVisible(this.this$0.list.getLeadSelectionIndex());
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        private /* synthetic */ BasicListUI this$0;

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            int n2 = listSelectionEvent.getFirstIndex();
            Rectangle rectangle = this.this$0.getCellBounds(this.this$0.list, n2, n = listSelectionEvent.getLastIndex());
            if (rectangle != null) {
                this.this$0.list.repaint(rectangle);
            }
        }

        public ListSelectionHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicListUI this$0;

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.this$0.updateLayoutStateNeeded |= 1;
            this.this$0.list.revalidate();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.this$0.updateLayoutStateNeeded |= 1;
            this.this$0.list.revalidate();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.this$0.updateLayoutStateNeeded |= 1;
            this.this$0.list.revalidate();
        }

        public ListDataHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicListUI this$0;

        public void focusGained(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        protected void repaintCellFocus() {
        }

        public FocusHandler(BasicListUI basicListUI) {
            this.this$0 = basicListUI;
        }
    }
}

