/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InternalFrameUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.basic.BasicLookAndFeel;

public class BasicInternalFrameUI
extends InternalFrameUI {
    protected MouseInputAdapter borderListener;
    protected ComponentListener componentListener;
    protected MouseInputListener glassPaneDispatcher;
    protected PropertyChangeListener propertyChangeListener;
    private transient BasicInternalFrameListener internalFrameListener;
    protected JComponent eastPane;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected KeyStroke openMenuKey;
    protected BasicInternalFrameTitlePane titlePane;
    protected JInternalFrame frame;
    protected LayoutManager internalFrameLayout;
    private transient JDesktopPane desktopPane;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BasicInternalFrameUI(JInternalFrame jInternalFrame) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JInternalFrame) {
            this.frame = (JInternalFrame)jComponent;
            this.installDefaults();
            this.installListeners();
            this.installComponents();
            this.installKeyboardActions();
            if (!this.frame.isSelected()) {
                this.frame.getGlassPane().setVisible(true);
            }
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.frame.getRootPane().getGlassPane().setVisible(false);
        this.frame = null;
    }

    protected void installDefaults() {
        this.internalFrameLayout = this.createLayoutManager();
        this.frame.setLayout(this.internalFrameLayout);
        LookAndFeel.installBorder(this.frame, "InternalFrame.border");
        this.frame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        Container container = this.frame.getContentPane();
        if (container != null && container.getBackground() instanceof UIResource) {
            container.setBackground(null);
        }
    }

    protected void installKeyboardActions() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("showSystemMenu", new ShowSystemMenuAction(this));
        BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
        ActionMap actionMap = basicLookAndFeel.getAudioActionMap();
        actionMapUIResource.setParent(actionMap);
        SwingUtilities.replaceUIActionMap(this.frame, actionMapUIResource);
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
    }

    protected void installListeners() {
        this.glassPaneDispatcher = this.createGlassPaneDispatcher();
        this.createInternalFrameListener();
        this.borderListener = this.createBorderListener(this.frame);
        this.componentListener = this.createComponentListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addMouseListener(this.borderListener);
        this.frame.addMouseMotionListener(this.borderListener);
        this.frame.addInternalFrameListener(this.internalFrameListener);
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
        this.frame.getRootPane().getGlassPane().addMouseListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().addMouseMotionListener(this.glassPaneDispatcher);
    }

    protected void uninstallDefaults() {
        this.frame.setBorder(null);
        this.frame.setLayout(null);
        this.internalFrameLayout = null;
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
    }

    protected void uninstallListeners() {
        if (this.desktopPane != null) {
            this.desktopPane.removeComponentListener(this.componentListener);
        }
        this.frame.getRootPane().getGlassPane().removeMouseMotionListener(this.glassPaneDispatcher);
        this.frame.getRootPane().getGlassPane().removeMouseListener(this.glassPaneDispatcher);
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.frame.removeInternalFrameListener(this.internalFrameListener);
        this.frame.removeMouseMotionListener(this.borderListener);
        this.frame.removeMouseListener(this.borderListener);
        this.propertyChangeListener = null;
        this.componentListener = null;
        this.borderListener = null;
        this.internalFrameListener = null;
        this.glassPaneDispatcher = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.frame, null);
        SwingUtilities.replaceUIInputMap(this.frame, 2, null);
    }

    protected LayoutManager createLayoutManager() {
        return new InternalFrameLayout(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new InternalFramePropertyChangeListener(this);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = null;
        LayoutManager layoutManager = this.frame.getLayout();
        dimension = this.frame == jComponent && layoutManager != null ? layoutManager.preferredLayoutSize(this.frame) : new Dimension(100, 100);
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = null;
        LayoutManager layoutManager = this.frame.getLayout();
        dimension = this.frame == jComponent && layoutManager != null ? layoutManager.minimumLayoutSize(this.frame) : new Dimension(0, 0);
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = null;
        LayoutManager layoutManager = this.frame.getLayout();
        dimension = this.frame == jComponent && layoutManager != null && layoutManager instanceof LayoutManager2 ? ((LayoutManager2)layoutManager).maximumLayoutSize(this.frame) : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        return dimension;
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this.frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.installMouseHandlers(jComponent2);
            this.frame.add(jComponent2);
        }
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
        jComponent.removeMouseListener(this.borderListener);
        jComponent.removeMouseMotionListener(this.borderListener);
    }

    protected void installMouseHandlers(JComponent jComponent) {
        jComponent.addMouseListener(this.borderListener);
        jComponent.addMouseMotionListener(this.borderListener);
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new BasicInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    protected JComponent createWestPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createSouthPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected MouseInputAdapter createBorderListener(JInternalFrame jInternalFrame) {
        return new BorderListener(this);
    }

    protected void createInternalFrameListener() {
        this.internalFrameListener = new BasicInternalFrameListener(this);
    }

    protected final boolean isKeyBindingRegistered() {
        return false;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
    }

    public final boolean isKeyBindingActive() {
        return false;
    }

    protected final void setKeyBindingActive(boolean bl) {
    }

    protected void setupMenuOpenKey() {
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public void setNorthPane(JComponent jComponent) {
        this.replacePane(this.northPane, jComponent);
        this.northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public void setSouthPane(JComponent jComponent) {
        this.replacePane(this.southPane, jComponent);
        this.southPane = jComponent;
    }

    public void setEastPane(JComponent jComponent) {
        this.replacePane(this.eastPane, jComponent);
        this.eastPane = jComponent;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public void setWestPane(JComponent jComponent) {
        this.replacePane(this.westPane, jComponent);
        this.westPane = jComponent;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    protected DesktopManager getDesktopManager() {
        DesktopManager desktopManager = null;
        JDesktopPane jDesktopPane = this.frame.getDesktopPane();
        if (jDesktopPane != null) {
            desktopManager = this.frame.getDesktopPane().getDesktopManager();
        }
        if (desktopManager == null) {
            desktopManager = this.createDesktopManager();
        }
        return desktopManager;
    }

    protected DesktopManager createDesktopManager() {
        return new DefaultDesktopManager();
    }

    protected void closeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().closeFrame(jInternalFrame);
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().maximizeFrame(jInternalFrame);
    }

    protected void minimizeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().minimizeFrame(jInternalFrame);
    }

    protected void iconifyFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().iconifyFrame(jInternalFrame);
    }

    protected void deiconifyFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deiconifyFrame(jInternalFrame);
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().activateFrame(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deactivateFrame(jInternalFrame);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler(this);
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher(this);
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.this$0.titlePane != null) {
                this.this$0.titlePane.showSystemMenu();
            }
        }

        ShowSystemMenuAction(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private /* synthetic */ BasicInternalFrameUI this$0;
        static final int bSize = 5;
        static final int cornerSize = 10;

        public boolean isBorderOpaque() {
            return true;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(5, 5, 5, 5);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            Rectangle rectangle = this.this$0.frame.getBounds();
            Color color2 = component.getBackground();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, 5, rectangle.height);
            graphics.fillRect(0, 0, rectangle.width, 5);
            graphics.fillRect(0, rectangle.height - 5, rectangle.width, 5);
            graphics.fillRect(rectangle.width - 5, 0, 5, rectangle.height);
            boolean bl = false;
            int n5 = 5;
            int n6 = rectangle.width - 5;
            int n7 = rectangle.width;
            boolean bl2 = false;
            int n8 = 5;
            int n9 = rectangle.height - 5;
            int n10 = rectangle.height;
            graphics.setColor(Color.GRAY);
            graphics.fillRect(0, 0, 5, n10);
            graphics.fillRect(0, 0, n7, 5);
            graphics.fillRect(0, n9, rectangle.width, 5);
            graphics.fillRect(n6, 0, 5, rectangle.height);
            graphics.fill3DRect(0, 10, 5, rectangle.height - 20, false);
            graphics.fill3DRect(10, 0, rectangle.width - 20, 5, false);
            graphics.fill3DRect(10, rectangle.height - 5, rectangle.width - 20, 5, false);
            graphics.fill3DRect(rectangle.width - 5, 10, 5, rectangle.height - 20, false);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }

        InternalFrameBorder(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    public class InternalFramePropertyChangeListener
    implements PropertyChangeListener {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("maximum")) {
                if (this.this$0.frame.isMaximum()) {
                    this.this$0.maximizeFrame(this.this$0.frame);
                } else {
                    this.this$0.minimizeFrame(this.this$0.frame);
                }
            } else if (string.equals("icon")) {
                if (this.this$0.frame.isIcon()) {
                    this.this$0.iconifyFrame(this.this$0.frame);
                } else {
                    this.this$0.deiconifyFrame(this.this$0.frame);
                }
            } else if (string.equals("selected")) {
                Component component = this.this$0.frame.getGlassPane();
                if (this.this$0.frame.isSelected()) {
                    this.this$0.activateFrame(this.this$0.frame);
                    component.setVisible(false);
                } else {
                    this.this$0.deactivateFrame(this.this$0.frame);
                    component.setVisible(true);
                }
            } else if (string.equals("rootPane") || string.equals("glassPane")) {
                Component component;
                Component component2 = (Component)propertyChangeEvent.getOldValue();
                if (component2 != null) {
                    component2.removeMouseListener(this.this$0.glassPaneDispatcher);
                    component2.removeMouseMotionListener(this.this$0.glassPaneDispatcher);
                }
                if ((component = (Component)propertyChangeEvent.getNewValue()) != null) {
                    component.addMouseListener(this.this$0.glassPaneDispatcher);
                    component.addMouseMotionListener(this.this$0.glassPaneDispatcher);
                }
                this.this$0.frame.revalidate();
            } else if (string.equals("closed") && propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                this.this$0.closeFrame(this.this$0.frame);
            }
        }

        public InternalFramePropertyChangeListener(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private /* synthetic */ BasicInternalFrameUI this$0;
        private transient Component mouseEventTarget;
        private Component dragTarget;
        private boolean isDragging;
        private static final /* synthetic */ boolean $assertionsDisabled;

        public void mouseEntered(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.this$0.borderListener != null) {
                this.this$0.borderListener.mousePressed(mouseEvent);
            }
            this.handleEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.handleEvent(mouseEvent);
        }

        private void handleEvent(MouseEvent mouseEvent) {
            Component component;
            for (component = this.this$0.frame.getLayeredPane().findComponentAt(mouseEvent.getX(), mouseEvent.getY()); component != null && component.getMouseListeners().length == 0 && component.getMouseMotionListeners().length == 0 && component.getMouseWheelListeners().length == 0; component = component.getParent()) {
            }
            if (component != null) {
                int n = mouseEvent.getID();
                switch (n) {
                    case 504: {
                        if (this.isDragging && !this.this$0.frame.isSelected()) break;
                        this.mouseEventTarget = component;
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 505: {
                        if (this.isDragging && !this.this$0.frame.isSelected()) break;
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 501: {
                        this.mouseEventTarget = component;
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        this.dragTarget = component;
                        break;
                    }
                    case 502: {
                        if (this.isDragging) {
                            this.redispatch(n, mouseEvent, this.dragTarget);
                            this.isDragging = false;
                            break;
                        }
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 500: {
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 503: {
                        if (component != this.mouseEventTarget) {
                            this.redispatch(505, mouseEvent, this.mouseEventTarget);
                            this.mouseEventTarget = component;
                            this.redispatch(504, mouseEvent, this.mouseEventTarget);
                        }
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 506: {
                        if (!this.isDragging) {
                            this.isDragging = true;
                        }
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    case 507: {
                        this.redispatch(n, mouseEvent, this.mouseEventTarget);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)"Must not reach here");
                        }
                        break;
                    }
                }
            }
        }

        private void redispatch(int n, MouseEvent mouseEvent, Component component) {
            Point point = SwingUtilities.convertPoint(this.this$0.frame.getLayeredPane(), mouseEvent.getX(), mouseEvent.getY(), component);
            MouseEvent mouseEvent2 = new MouseEvent(component, n, mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            component.dispatchEvent(mouseEvent2);
        }

        protected GlassPaneDispatcher(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }

        static {
            $assertionsDisabled = BasicInternalFrameUI.class$("javax.swing.plaf.basic.BasicInternalFrameUI$GlassPaneDispatcher").desiredAssertionStatus() ^ true;
        }
    }

    public class InternalFrameLayout
    implements LayoutManager {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Dimension dimension2;
            Dimension dimension3 = this.this$0.frame.getSize();
            Insets insets = this.this$0.frame.getInsets();
            dimension3.width -= insets.left + insets.right;
            dimension3.height -= insets.top + insets.bottom;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.this$0.northPane != null) {
                dimension2 = this.this$0.northPane.getPreferredSize();
                n = Math.min(dimension2.height, dimension3.height);
                this.this$0.northPane.setBounds(insets.left, insets.top, dimension3.width, n);
            }
            if (this.this$0.southPane != null) {
                dimension2 = this.this$0.southPane.getPreferredSize();
                n2 = Math.min(dimension2.height, dimension3.height - n);
                this.this$0.southPane.setBounds(insets.left, insets.top + dimension3.height - n2, dimension3.width, n2);
            }
            int n5 = dimension3.height - n2 - n;
            if (this.this$0.westPane != null) {
                dimension = this.this$0.westPane.getPreferredSize();
                n4 = Math.min(dimension3.width, dimension.width);
                this.this$0.westPane.setBounds(insets.left, insets.top + n, n4, n5);
            }
            if (this.this$0.eastPane != null) {
                dimension = this.this$0.eastPane.getPreferredSize();
                n3 = Math.min(dimension.width, dimension3.width - n4);
                this.this$0.eastPane.setBounds(insets.left + dimension3.width - n3, insets.top + n, n3, n5);
            }
            int n6 = dimension3.width - n4 - n3;
            this.this$0.frame.getRootPane().setBounds(insets.left + n4, insets.top + n, n6, n5);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.getSize(container, true);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.getSize(container, false);
        }

        private Dimension getSize(Container container, boolean bl) {
            Dimension dimension;
            Insets insets = this.this$0.frame.getInsets();
            Dimension dimension2 = this.this$0.frame.getContentPane().getPreferredSize();
            if (bl) {
                dimension2.height = 0;
                dimension2.width = 0;
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (this.this$0.northPane != null && (dimension = this.this$0.northPane.getPreferredSize()) != null) {
                n = dimension.width;
                n2 = dimension.height;
            }
            if (this.this$0.southPane != null && (dimension = this.this$0.southPane.getPreferredSize()) != null) {
                n3 = dimension.width;
                n4 = dimension.height;
            }
            if (this.this$0.eastPane != null && (dimension = this.this$0.eastPane.getPreferredSize()) != null) {
                n3 = dimension.width;
                n4 = dimension.height;
            }
            if (this.this$0.westPane != null && (dimension = this.this$0.westPane.getPreferredSize()) != null) {
                n7 = dimension.width;
                n8 = dimension.height;
            }
            int n9 = Math.max(n3, n);
            n9 = Math.max(n9, dimension2.width + n5 + n7);
            int n10 = Math.max(n6, n8);
            n10 = Math.max(n10, dimension2.height);
            n10 += n2 + n4;
            return new Dimension(n9 += insets.left + insets.right, n10 += insets.top + insets.bottom);
        }

        public void removeLayoutComponent(Component component) {
        }

        public InternalFrameLayout(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    protected class ComponentHandler
    implements ComponentListener {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (this.this$0.frame.isMaximum()) {
                JDesktopPane jDesktopPane = (JDesktopPane)componentEvent.getSource();
                Insets insets = jDesktopPane.getInsets();
                Rectangle rectangle = jDesktopPane.getBounds();
                this.this$0.frame.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
                this.this$0.frame.revalidate();
                this.this$0.frame.repaint();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        protected ComponentHandler(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        private /* synthetic */ BasicInternalFrameUI this$0;
        transient int showingCursor;
        protected final int RESIZE_NONE;
        private transient int xOffset;
        private transient int yOffset;
        private transient int direction;
        private transient Rectangle cacheRect;

        private /* synthetic */ void finit$() {
            this.RESIZE_NONE = 0;
            this.direction = -1;
            this.cacheRect = new Rectangle();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == this.this$0.titlePane && mouseEvent.getClickCount() == 2) {
                try {
                    if (this.this$0.frame.isMaximizable() && !this.this$0.frame.isMaximum()) {
                        this.this$0.frame.setMaximum(true);
                    } else if (this.this$0.frame.isMaximum()) {
                        this.this$0.frame.setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.frame.isMaximum()) {
                return;
            }
            DesktopManager desktopManager = this.this$0.getDesktopManager();
            Rectangle rectangle = this.this$0.frame.getBounds();
            Dimension dimension = this.this$0.frame.getMinimumSize();
            if (dimension == null) {
                dimension = new Dimension(0, 0);
            }
            Insets insets = this.this$0.frame.getInsets();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.getSource() == this.this$0.frame && this.this$0.frame.isResizable()) {
                switch (this.direction) {
                    case 8: {
                        this.cacheRect.setBounds(rectangle.x, Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), rectangle.width, rectangle.height - n2);
                        break;
                    }
                    case 7: {
                        this.cacheRect.setBounds(rectangle.x, Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), n + 1, rectangle.height - n2);
                        break;
                    }
                    case 11: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, n + 1, rectangle.height);
                        break;
                    }
                    case 5: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, n + 1, n2 + 1);
                        break;
                    }
                    case 9: {
                        this.cacheRect.setBounds(rectangle.x, rectangle.y, rectangle.width, n2 + 1);
                        break;
                    }
                    case 4: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), rectangle.y, rectangle.width - n, n2 + 1);
                        break;
                    }
                    case 10: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), rectangle.y, rectangle.width - n, rectangle.height);
                        break;
                    }
                    case 6: {
                        this.cacheRect.setBounds(Math.min(rectangle.x + n, rectangle.x + rectangle.width - dimension.width), Math.min(rectangle.y + n2, rectangle.y + rectangle.height - dimension.height), rectangle.width - n, rectangle.height - n2);
                    }
                }
                desktopManager.resizeFrame(this.this$0.frame, this.cacheRect.x, this.cacheRect.y, Math.max(dimension.width, this.cacheRect.width), Math.max(dimension.height, this.cacheRect.height));
                this.setCursor(mouseEvent);
            } else if (mouseEvent.getSource() == this.this$0.titlePane) {
                Rectangle rectangle2 = this.this$0.frame.getBounds();
                this.this$0.frame.putClientProperty("bufferedDragging", Boolean.TRUE);
                desktopManager.dragFrame(this.this$0.frame, mouseEvent.getX() - this.xOffset + rectangle.x, mouseEvent.getY() - this.yOffset + rectangle.y);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.showingCursor != 0) {
                this.this$0.frame.setCursor(Cursor.getDefaultCursor());
                this.showingCursor = 0;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.showingCursor != 0 && mouseEvent.getSource() != this.this$0.frame) {
                this.this$0.frame.setCursor(Cursor.getDefaultCursor());
                this.showingCursor = 0;
            } else if (mouseEvent.getSource() == this.this$0.frame && this.this$0.frame.isResizable()) {
                this.setCursor(mouseEvent);
            }
        }

        void setCursor(MouseEvent mouseEvent) {
            int n = this.sectionOfClick(mouseEvent.getX(), mouseEvent.getY());
            if (n != this.showingCursor) {
                Cursor cursor = Cursor.getPredefinedCursor(n);
                this.this$0.frame.setCursor(cursor);
                this.showingCursor = n;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.this$0.activateFrame(this.this$0.frame);
            DesktopManager desktopManager = this.this$0.getDesktopManager();
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Insets insets = this.this$0.frame.getInsets();
            if (mouseEvent.getSource() == this.this$0.frame && this.this$0.frame.isResizable()) {
                this.direction = this.sectionOfClick(n, n2);
                desktopManager.beginResizingFrame(this.this$0.frame, this.direction);
            } else if (mouseEvent.getSource() == this.this$0.titlePane) {
                Rectangle rectangle = this.this$0.titlePane.getBounds();
                this.xOffset = mouseEvent.getX() - rectangle.x + insets.left;
                this.yOffset = mouseEvent.getY() - rectangle.y + insets.top;
                desktopManager.beginDraggingFrame(this.this$0.frame);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DesktopManager desktopManager = this.this$0.getDesktopManager();
            this.xOffset = 0;
            this.yOffset = 0;
            if (mouseEvent.getSource() == this.this$0.frame && this.this$0.frame.isResizable()) {
                desktopManager.endResizingFrame(this.this$0.frame);
            } else if (mouseEvent.getSource() == this.this$0.titlePane) {
                desktopManager.endDraggingFrame(this.this$0.frame);
                this.this$0.frame.putClientProperty("bufferedDragging", null);
            }
            this.setCursor(mouseEvent);
        }

        private int sectionOfClick(int n, int n2) {
            Rectangle rectangle = this.this$0.frame.getBounds();
            int n3 = 10;
            if (n < n3 && n2 < n3) {
                return 6;
            }
            if (n > rectangle.width - n3 && n2 < n3) {
                return 7;
            }
            if (n > rectangle.width - n3 && n2 > rectangle.height - n3) {
                return 5;
            }
            if (n < n3 && n2 > rectangle.height - n3) {
                return 4;
            }
            if (n2 < n3) {
                return 8;
            }
            if (n < n3) {
                return 10;
            }
            if (n2 > rectangle.height - n3) {
                return 9;
            }
            if (n > rectangle.width - n3) {
                return 11;
            }
            return 0;
        }

        protected BorderListener(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
            this.finit$();
        }
    }

    protected class BasicInternalFrameListener
    implements InternalFrameListener {
        private /* synthetic */ BasicInternalFrameUI this$0;

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            this.this$0.frame.getGlassPane().setVisible(false);
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            this.this$0.frame.getGlassPane().setVisible(true);
        }

        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
        }

        public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
        }

        protected BasicInternalFrameListener(BasicInternalFrameUI basicInternalFrameUI) {
            this.this$0 = basicInternalFrameUI;
        }
    }
}

