/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopIconUI;

public class BasicDesktopIconUI
extends DesktopIconUI {
    private static final int iconSize = 16;
    private static final int iconWidth = 160;
    private static final int iconHeight = 35;
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JInternalFrame frame;
    private transient MouseInputListener mouseHandler;
    transient BoundButton button;
    private transient PropertyChangeListener propertyHandler;
    static Icon defaultIcon = new InternalFrameDefaultMenuIcon();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopIconUI();
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JInternalFrame.JDesktopIcon) {
            this.desktopIcon = (JInternalFrame.JDesktopIcon)jComponent;
            this.desktopIcon.setLayout(new BorderLayout());
            this.frame = this.desktopIcon.getInternalFrame();
            this.installDefaults();
            this.installComponents();
            this.installListeners();
            this.desktopIcon.setOpaque(true);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.desktopIcon.setOpaque(false);
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.frame = null;
        this.desktopIcon.setLayout(null);
        this.desktopIcon = null;
    }

    protected void installComponents() {
        this.button = new BoundButton(this, this.frame.getTitle());
        this.button.setHorizontalAlignment(2);
        this.button.setHorizontalTextPosition(11);
        Icon icon = this.frame.getFrameIcon();
        if (icon == null) {
            icon = defaultIcon;
        }
        this.button.setIcon(icon);
        this.desktopIcon.add((Component)this.button, 0);
    }

    protected void uninstallComponents() {
        this.desktopIcon.remove(this.button);
        this.button = null;
    }

    protected void installListeners() {
        this.mouseHandler = this.createMouseInputListener();
        this.desktopIcon.addMouseMotionListener(this.mouseHandler);
        this.desktopIcon.addMouseListener(this.mouseHandler);
        this.propertyHandler = new PropertyChangeListener(this){
            private /* synthetic */ BasicDesktopIconUI this$0;
            {
                this.this$0 = basicDesktopIconUI;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("title")) {
                    this.this$0.button.setText(this.this$0.desktopIcon.getInternalFrame().getTitle());
                } else if (propertyChangeEvent.getPropertyName().equals("frameIcon")) {
                    Icon icon = this.this$0.desktopIcon.getInternalFrame().getFrameIcon();
                    if (icon == null) {
                        icon = defaultIcon;
                    }
                    this.this$0.button.setIcon(icon);
                }
                this.this$0.desktopIcon.revalidate();
                this.this$0.desktopIcon.repaint();
            }
        };
        this.frame.addPropertyChangeListener(this.propertyHandler);
        this.button.addActionListener(new ActionListener(this){
            private /* synthetic */ BasicDesktopIconUI this$0;
            {
                this.this$0 = basicDesktopIconUI;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.deiconize();
            }
        });
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyHandler);
        this.propertyHandler = null;
        this.desktopIcon.removeMouseMotionListener(this.mouseHandler);
        this.desktopIcon.removeMouseListener(this.mouseHandler);
    }

    protected void installDefaults() {
        this.desktopIcon.setBorder(new DesktopIconBorder(this));
    }

    protected void uninstallDefaults() {
        this.desktopIcon.setBorder(null);
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler(this);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(160, 35);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Insets getInsets(JComponent jComponent) {
        return jComponent.getInsets();
    }

    public void deiconize() {
        try {
            this.frame.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private class BoundButton
    extends JButton {
        private /* synthetic */ BasicDesktopIconUI this$0;

        public BoundButton(BasicDesktopIconUI basicDesktopIconUI, String string) {
            this.this$0 = basicDesktopIconUI;
            super(string);
        }

        public Dimension getPreferredSize() {
            Insets insets = this.this$0.desktopIcon.getInsets();
            return new Dimension(160 - insets.left - insets.right, 35 - insets.top - insets.bottom);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    static class InternalFrameDefaultMenuIcon
    implements Icon {
        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            graphics.setColor(Color.BLUE);
            graphics.fillRect(0, 0, 16, 6);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 5, 16, 13);
            graphics.setColor(Color.GRAY);
            graphics.drawRect(0, 0, 16, 16);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        InternalFrameDefaultMenuIcon() {
        }
    }

    private class DesktopIconBorder
    implements Border {
        private /* synthetic */ BasicDesktopIconUI this$0;
        int left;
        int top;
        int right;
        int bottom;

        private /* synthetic */ void finit$() {
            this.left = 10;
            this.right = this.top = 4;
            this.bottom = this.top;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(this.top, this.left, this.bottom, this.right);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.translate(n, n2);
            Color color = graphics.getColor();
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.fillRect(0, 0, this.left, n4);
            graphics.fillRect(0, 0, n3, this.top);
            graphics.fillRect(0, n4 - this.bottom, n3, this.bottom);
            graphics.fillRect(n3 - this.right, 0, this.right, n4);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            int n5 = n4 / 4;
            int n6 = this.left / 2;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(n6, n5, 2, 2);
            graphics.fillRect(n6, n5 * 2, 2, 2);
            graphics.fillRect(n6, n5 * 3, 2, 2);
            graphics.setColor(color);
            graphics.translate(-n, -n2);
        }

        DesktopIconBorder(BasicDesktopIconUI basicDesktopIconUI) {
            this.this$0 = basicDesktopIconUI;
            this.finit$();
        }
    }

    public class MouseInputHandler
    extends MouseInputAdapter {
        private /* synthetic */ BasicDesktopIconUI this$0;
        private transient int xOffset;
        private transient int yOffset;
        private transient JDesktopPane pane;

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle = this.this$0.desktopIcon.getBounds();
            this.moveAndRepaint(this.this$0.desktopIcon, rectangle.x + mouseEvent.getX() - this.xOffset, rectangle.y + mouseEvent.getY() - this.yOffset, rectangle.width, rectangle.height);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.xOffset = mouseEvent.getX();
            this.yOffset = mouseEvent.getY();
            this.pane = this.this$0.frame.getDesktopPane();
            if (this.pane != null) {
                this.pane.getDesktopManager().beginDraggingFrame(this.this$0.desktopIcon);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.pane != null) {
                this.pane.getDesktopManager().endDraggingFrame(this.this$0.desktopIcon);
            }
            this.xOffset = 0;
            this.yOffset = 0;
        }

        public void moveAndRepaint(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (this.pane != null) {
                this.pane.getDesktopManager().dragFrame(jComponent, n, n2);
            } else {
                this.this$0.desktopIcon.setBounds(n, n2, n3, n4);
            }
        }

        public MouseInputHandler(BasicDesktopIconUI basicDesktopIconUI) {
            this.this$0 = basicDesktopIconUI;
        }
    }
}

