/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TitledBorder
extends AbstractBorder {
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;
    protected static final int TEXT_SPACING = 2;
    static final long serialVersionUID = 8012999415147721601L;
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;

    public TitledBorder(String string) {
        this(null, string, 4, 2, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public TitledBorder(Border border, String string) {
        this(border, string, 4, 2, null, null);
    }

    public TitledBorder(Border border, String string, int n, int n2) {
        this(border, string, n, n2, null, null);
    }

    public TitledBorder(Border border, String string, int n, int n2, Font font) {
        this(border, string, n, n2, font, null);
    }

    public TitledBorder(Border border, String string, int n, int n2, Font font, Color color) {
        this.border = border;
        this.title = string;
        this.setTitleJustification(n);
        this.setTitlePosition(n2);
        this.titleFont = font;
        this.titleColor = color;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n + 2, n2 + 2, n3 - 4, n4 - 4);
        Point point = new Point();
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Font font2 = this.getFont(component);
        graphics.setFont(font2);
        FontMetrics fontMetrics = component.getFontMetrics(font2);
        this.layoutBorderWithTitle(component, fontMetrics, rectangle, point);
        this.paintBorderWithTitle(component, graphics, n, n2, n3, n4, rectangle, point, fontMetrics);
        graphics.setColor(this.getTitleColor());
        graphics.drawString(this.getTitle(), point.x, point.y);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    private void layoutBorderWithTitle(Component component, FontMetrics fontMetrics, Rectangle rectangle, Point point) {
        Border border = this.getBorder();
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.stringWidth(this.getTitle());
        Insets insets = border == null ? new Insets(0, 0, 0, 0) : border.getBorderInsets(component);
        int n5 = this.getTitlePosition();
        switch (n5) {
            case 4: {
                point.y = rectangle.y + rectangle.height - insets.bottom - n2 - 2;
                break;
            }
            case 5: {
                rectangle.height -= n / 2;
                point.y = rectangle.y + rectangle.height - n2 + (n3 + n2 - insets.bottom) / 2;
                break;
            }
            case 6: {
                rectangle.height -= n;
                point.y = rectangle.y + rectangle.height + n3 + 2;
                break;
            }
            case 1: {
                int n6 = n3 + n2 + Math.max(2, 4) - 2;
                rectangle.y += n6;
                rectangle.height -= n6;
                point.y = rectangle.y - (n2 + 2);
                break;
            }
            case 3: {
                point.y = rectangle.y + insets.top + n3 + 2;
                break;
            }
            default: {
                int n7 = Math.max(0, n3 / 2 + 2 - 2);
                rectangle.y += n7;
                rectangle.height -= n7;
                point.y = rectangle.y - n2 + (insets.top + n3 + n2) / 2;
            }
        }
        int n8 = this.getTitleJustification();
        if (component.getComponentOrientation().isLeftToRight()) {
            if (n8 == 4 || n8 == 0) {
                n8 = 1;
            } else if (n8 == 5) {
                n8 = 3;
            }
        } else if (n8 == 4 || n8 == 0) {
            n8 = 3;
        } else if (n8 == 5) {
            n8 = 1;
        }
        switch (n8) {
            case 2: {
                point.x = rectangle.x + (rectangle.width - n4) / 2;
                break;
            }
            case 3: {
                point.x = rectangle.x + rectangle.width - n4 - 5 - insets.right;
                break;
            }
            default: {
                point.x = rectangle.x + 5 + insets.left;
            }
        }
    }

    private void paintBorderWithTitle(Component component, Graphics graphics, int n, int n2, int n3, int n4, Rectangle rectangle, Point point, FontMetrics fontMetrics) {
        Border border = this.getBorder();
        int n5 = fontMetrics.getDescent();
        int n6 = fontMetrics.getAscent();
        int n7 = fontMetrics.stringWidth(this.getTitle());
        if (border != null) {
            if ((this.titlePosition == 2 || this.titlePosition == 0) && rectangle.y > point.y - n6 || this.titlePosition == 5 && rectangle.y + rectangle.height < point.y + n5) {
                Rectangle rectangle2 = new Rectangle();
                Rectangle rectangle3 = graphics.getClipBounds();
                rectangle2.setBounds(rectangle3);
                SwingUtilities.computeIntersection(n, n2, point.x - n - 1, n4, rectangle2);
                if (!rectangle2.isEmpty()) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle2.setBounds(rectangle3);
                SwingUtilities.computeIntersection(point.x + n7 + 1, n2, n + n3 - (point.x + n7 + 1), n4, rectangle2);
                if (!rectangle2.isEmpty()) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (this.titlePosition == 2 || this.titlePosition == 0) {
                    rectangle2.setBounds(rectangle3);
                    SwingUtilities.computeIntersection(point.x - 1, point.y + n5, n7 + 2, n2 + n4 - point.y - n5, rectangle2);
                    if (!rectangle2.isEmpty()) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else {
                    rectangle2.setBounds(rectangle3);
                    SwingUtilities.computeIntersection(point.x - 1, n2, n7 + 2, point.y - n5 - n2, rectangle2);
                    if (!rectangle2.isEmpty()) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                graphics.setClip(rectangle3);
            } else {
                border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        Object object;
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                object = (AbstractBorder)border;
                ((AbstractBorder)object).getBorderInsets(component, insets);
            } else {
                object = border.getBorderInsets(component);
                insets.top = ((Insets)object).top;
                insets.bottom = ((Insets)object).bottom;
                insets.left = ((Insets)object).left;
                insets.right = ((Insets)object).right;
            }
        } else {
            insets.top = 0;
            insets.bottom = 0;
            insets.left = 0;
            insets.right = 0;
        }
        insets.top += 4;
        insets.bottom += 4;
        insets.left += 4;
        insets.right += 4;
        object = this.getTitle();
        if (component != null && object != null && !((String)object).equals("")) {
            Font font = this.getFont(component);
            FontMetrics fontMetrics = component.getFontMetrics(font);
            int n = fontMetrics.getAscent();
            int n2 = fontMetrics.getDescent();
            int n3 = fontMetrics.getHeight();
            switch (this.getTitlePosition()) {
                case 4: {
                    insets.bottom += n + n2 + 2;
                    break;
                }
                case 5: {
                    insets.bottom += n + n2;
                    break;
                }
                case 6: {
                    insets.bottom += n3;
                    break;
                }
                case 1: {
                    insets.top += n + n2 + Math.max(2, 4) - 2;
                    break;
                }
                case 3: {
                    insets.top += n + n2 + 2;
                    break;
                }
                default: {
                    insets.top += n + n2;
                }
            }
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        if (this.border != null) {
            return this.border;
        }
        return UIManager.getBorder("TitledBorder.border");
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        if (this.titleFont != null) {
            return this.titleFont;
        }
        return UIManager.getFont("TitledBorder.font");
    }

    public Color getTitleColor() {
        if (this.titleColor != null) {
            return this.titleColor;
        }
        return UIManager.getColor("TitledBorder.titleColor");
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int n) {
        if (n < 0 || n > 6) {
            throw new IllegalArgumentException(n + " is not a valid title position.");
        }
        this.titlePosition = n;
    }

    public void setTitleJustification(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(n + " is not a valid title justification.");
        }
        this.titleJustification = n;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Dimension getMinimumSize(Component component) {
        Insets insets = this.getBorderInsets(component);
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        Font font = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        int n = fontMetrics.stringWidth(this.getTitle());
        switch (this.getTitlePosition()) {
            case 1: 
            case 6: {
                dimension.width = Math.max(dimension.width, n);
                break;
            }
            default: {
                dimension.width += n;
            }
        }
        return dimension;
    }

    protected Font getFont(Component component) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }
}

