/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JLayeredPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 5534920399324590459L;
    public static final String LAYER_PROPERTY = "layeredContainerLayer";
    public static final Integer FRAME_CONTENT_LAYER;
    public static final Integer DEFAULT_LAYER;
    public static final Integer PALETTE_LAYER;
    public static final Integer MODAL_LAYER;
    public static final Integer POPUP_LAYER;
    public static final Integer DRAG_LAYER;
    private Hashtable componentToLayer = new Hashtable();

    public JLayeredPane() {
        this.setLayout(null);
    }

    public int getLayer(Component component) {
        Integer n;
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            n = (Integer)jComponent.getClientProperty(LAYER_PROPERTY);
        } else {
            n = (Integer)this.componentToLayer.get(component);
        }
        if (n == null) {
            n = DEFAULT_LAYER;
        }
        return n;
    }

    public static int getLayer(JComponent jComponent) {
        Integer n = (Integer)jComponent.getClientProperty(LAYER_PROPERTY);
        if (n == null) {
            n = DEFAULT_LAYER;
        }
        return n;
    }

    public static JLayeredPane getLayeredPaneAbove(Component component) {
        JLayeredPane jLayeredPane = (JLayeredPane)SwingUtilities.getAncestorOfClass(JLayeredPane.class$("javax.swing.JLayeredPane"), component);
        return jLayeredPane;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int highestLayer() {
        int n;
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            n = 0;
        } else {
            n = Integer.MIN_VALUE;
            for (int i = 0; i < componentArray.length; ++i) {
                n = Math.max(n, this.getLayer(componentArray[i]));
            }
        }
        return n;
    }

    public int lowestLayer() {
        int n;
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            n = 0;
        } else {
            n = Integer.MAX_VALUE;
            for (int i = 0; i < componentArray.length; ++i) {
                n = Math.max(n, this.getLayer(componentArray[i]));
            }
        }
        return n;
    }

    public void moveToFront(Component component) {
        this.setPosition(component, 0);
    }

    public void moveToBack(Component component) {
        this.setPosition(component, -1);
    }

    public int getPosition(Component component) {
        int n = -1;
        int n2 = this.getIndexOf(component);
        if (n2 >= 0) {
            n = 0;
            int n3 = this.getLayer(component);
            for (int i = n2 - 1; i >= 0 && n3 == this.getLayer(this.getComponent(i)); --i) {
                ++n;
            }
        }
        return n;
    }

    public void setPosition(Component component, int n) {
        this.setLayer(component, this.getLayer(component), n);
    }

    public Component[] getComponentsInLayer(int n) {
        Component[] componentArray = new Component[this.getComponentCountInLayer(n)];
        Component[] componentArray2 = this.getComponents();
        int n2 = 0;
        for (int i = 0; i < componentArray2.length; ++i) {
            if (n != this.getLayer(componentArray2[i])) continue;
            componentArray[n2] = componentArray2[i];
            ++n2;
        }
        return componentArray;
    }

    public int getComponentCountInLayer(int n) {
        Component[] componentArray = this.getComponents();
        int n2 = 0;
        for (int i = componentArray.length - 1; i >= 0; --i) {
            if (this.getLayer(componentArray[i]) != n) continue;
            ++n2;
        }
        return n2;
    }

    protected Hashtable getComponentToLayer() {
        return this.componentToLayer;
    }

    public int getIndexOf(Component component) {
        return this.getComponentZOrder(component);
    }

    protected Integer getObjectForLayer(int n) {
        switch (n) {
            case -30000: {
                return FRAME_CONTENT_LAYER;
            }
            case 0: {
                return DEFAULT_LAYER;
            }
            case 100: {
                return PALETTE_LAYER;
            }
            case 200: {
                return MODAL_LAYER;
            }
            case 300: {
                return POPUP_LAYER;
            }
            case 400: {
                return DRAG_LAYER;
            }
        }
        return new Integer(n);
    }

    protected int insertIndexForLayer(int n, int n2) {
        return this.insertIndexForLayer(null, n, n2);
    }

    private int insertIndexForLayer(Component component, int n, int n2) {
        int n3;
        int n4;
        ArrayList arrayList = new ArrayList();
        int n5 = this.getComponentCount();
        for (n4 = 0; n4 < n5; ++n4) {
            Component component2 = this.getComponent(n4);
            if (component2 == component) continue;
            arrayList.add(component2);
        }
        n5 = arrayList.size();
        n4 = -1;
        int n6 = -1;
        for (n3 = 0; n3 < n5; ++n3) {
            int n7 = this.getLayer((Component)arrayList.get(n3));
            if (n4 == -1 && n7 == n) {
                n4 = n3;
            }
            if (n7 >= n) continue;
            if (n3 == 0) {
                n4 = 0;
                n6 = 0;
                break;
            }
            n6 = n3;
            break;
        }
        if (n4 == -1 && n6 == -1) {
            n3 = n5;
        } else {
            if (n4 != -1 && n6 == -1) {
                n6 = n5;
            }
            if (n4 == -1 && n6 != -1) {
                n4 = n6;
            }
            n3 = n2 == -1 ? n6 : (n2 > -1 && n4 + n2 <= n6 ? n4 + n2 : n6);
        }
        return n3;
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        if (!(component instanceof JComponent)) {
            this.componentToLayer.remove(component);
        }
        super.remove(n);
    }

    public void removeAll() {
        this.componentToLayer.clear();
        super.removeAll();
    }

    public void setLayer(Component component, int n) {
        this.setLayer(component, n, -1);
    }

    public void setLayer(Component component, int n, int n2) {
        Integer n3 = this.getObjectForLayer(n);
        if (n != this.getLayer(component) || n2 != this.getPosition(component)) {
            Container container;
            if (component instanceof JComponent) {
                container = (JComponent)component;
                container.putClientProperty(LAYER_PROPERTY, n3);
            } else {
                this.componentToLayer.put(component, n3);
            }
            container = component.getParent();
            if (container == this) {
                int n4 = this.insertIndexForLayer(component, n, n2);
                this.setComponentZOrder(component, n4);
            }
        }
        this.repaint(component.getX(), component.getY(), component.getWidth(), component.getHeight());
    }

    protected void addImpl(Component component, Object object, int n) {
        int n2;
        if (object != null && object instanceof Integer) {
            n2 = (Integer)object;
            this.setLayer(component, n2);
        } else {
            n2 = this.getLayer(component);
        }
        int n3 = this.insertIndexForLayer(n2, n);
        super.addImpl(component, object, n3);
        component.validate();
        component.repaint();
    }

    public static void putLayer(JComponent jComponent, int n) {
        jComponent.putClientProperty(LAYER_PROPERTY, new Integer(n));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLayeredPane(this);
        }
        return this.accessibleContext;
    }

    public void paint(Graphics graphics) {
        if (this.isOpaque()) {
            Color color = graphics.getColor();
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
        super.paint(graphics);
    }

    public boolean isOptimizedDrawingEnabled() {
        int n = this.getComponentCount();
        boolean bl = true;
        block0: for (int i = 0; i < n; ++i) {
            Rectangle rectangle;
            Component component = this.getComponent(i);
            if (!component.isVisible() || (rectangle = component.getBounds()).isEmpty()) continue;
            for (int j = i + 1; j < n; ++j) {
                Rectangle rectangle2;
                Component component2 = this.getComponent(j);
                if (!component2.isVisible() || (rectangle2 = component2.getBounds()).isEmpty()) continue;
                if (rectangle.intersects(rectangle2)) {
                    bl = false;
                    continue block0;
                }
                if (!bl) continue block0;
            }
        }
        return bl;
    }

    static {
        LAYER_PROPERTY = LAYER_PROPERTY;
        FRAME_CONTENT_LAYER = new Integer(-30000);
        DEFAULT_LAYER = new Integer(0);
        PALETTE_LAYER = new Integer(100);
        MODAL_LAYER = new Integer(200);
        POPUP_LAYER = new Integer(300);
        DRAG_LAYER = new Integer(400);
    }

    protected class AccessibleJLayeredPane
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JLayeredPane this$0;

        protected AccessibleJLayeredPane(JLayeredPane jLayeredPane) {
            this.this$0 = jLayeredPane;
            super(jLayeredPane);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LAYERED_PANE;
        }
    }
}

