/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private int lengthLength;

    private /* synthetic */ void finit$() {
        this.lengthLength = 0;
    }

    public MetaMessage() {
        super(new byte[4]);
        this.finit$();
        this.data[0] = -1;
        this.data[1] = 0;
        this.data[2] = 1;
        this.data[3] = 0;
        this.lengthLength = 1;
    }

    protected MetaMessage(byte[] byArray) {
        super(byArray);
        this.finit$();
        int n = 2;
        this.lengthLength = 1;
        while ((byArray[n++] & 0x80) > 0) {
            ++this.lengthLength;
        }
    }

    public void setMessage(int n, byte[] byArray, int n2) throws InvalidMidiDataException {
        if (n > 127) {
            throw new InvalidMidiDataException("Meta type 0x" + Integer.toHexString(n) + " must be less than 128");
        }
        this.lengthLength = 0;
        int n3 = n2;
        do {
            ++this.lengthLength;
        } while ((n3 >>= 7) > 0);
        this.length = 2 + this.lengthLength + n2;
        this.data = new byte[this.length];
        this.data[0] = -1;
        this.data[1] = (byte)n;
        long l = (long)n2 & (long)127;
        while ((n2 >>= 7) > 0) {
            l <<= 8;
            l |= (long)(n2 & 0x7F | 0x80);
        }
        int n4 = 2;
        while (true) {
            this.data[n4++] = (byte)l;
            if ((l & (long)128) == 0L) break;
            l >>= 8;
        }
        System.arraycopy(byArray, 0, this.data, n4, n2);
    }

    public int getType() {
        return this.data[1];
    }

    public byte[] getData() {
        int n = this.length - 2 - this.lengthLength;
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, 2 + this.lengthLength, byArray, 0, n);
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        return new MetaMessage(byArray);
    }
}

