/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.security.auth.Destroyable;

public final class X500PrivateCredential
implements Destroyable {
    private PrivateKey key;
    private X509Certificate certificate;
    private String alias;

    public X500PrivateCredential(X509Certificate x509Certificate, PrivateKey privateKey) {
        if (x509Certificate == null || privateKey == null) {
            throw new IllegalArgumentException();
        }
        this.certificate = x509Certificate;
        this.key = privateKey;
    }

    public X500PrivateCredential(X509Certificate x509Certificate, PrivateKey privateKey, String string) {
        this(x509Certificate, privateKey);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.alias = string;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.key;
    }

    public String getAlias() {
        return this.alias;
    }

    public void destroy() {
        this.certificate = null;
        this.key = null;
        this.alias = null;
    }

    public boolean isDestroyed() {
        return this.certificate == null && this.key == null;
    }
}

