/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import gnu.java.security.action.GetSecurityPropertyAction;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class LoginContext {
    private static final String OTHER = "other";
    private final String name;
    private final CallbackHandler cbHandler;
    private final Subject subject;
    private final AppConfigurationEntry[] entries;
    private final LoginModule[] modules;
    private final Map sharedState;

    public LoginContext(String string) throws LoginException {
        this(string, new Subject(), LoginContext.defaultHandler());
    }

    public LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this(string, new Subject(), callbackHandler);
    }

    public LoginContext(String string, Subject subject) throws LoginException {
        this(string, subject, LoginContext.defaultHandler());
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(string, subject, callbackHandler, null);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        AppConfigurationEntry[] appConfigurationEntryArray;
        this.name = string;
        this.subject = subject;
        this.cbHandler = callbackHandler;
        if (configuration == null) {
            configuration = Configuration.getConfig();
        }
        if ((appConfigurationEntryArray = configuration.getAppConfigurationEntry(string)) == null) {
            appConfigurationEntryArray = configuration.getAppConfigurationEntry(OTHER);
        }
        if (appConfigurationEntryArray == null) {
            throw new LoginException("no configured modules for application " + string);
        }
        this.entries = appConfigurationEntryArray;
        this.modules = new LoginModule[appConfigurationEntryArray.length];
        this.sharedState = new HashMap();
        for (int i = 0; i < appConfigurationEntryArray.length; ++i) {
            this.modules[i] = this.lookupModule(appConfigurationEntryArray[i], subject, this.sharedState);
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void login() throws LoginException {
        int n;
        boolean bl = false;
        for (n = 0; n < this.modules.length; ++n) {
            try {
                boolean bl2 = this.modules[n].login();
                if (!bl2) {
                    if (this.entries[n].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                        throw new LoginException("REQUISITE module " + this.entries[n].getLoginModuleName() + " failed");
                    }
                    if (this.entries[n].getControlFlag() != AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) continue;
                    bl = true;
                    continue;
                }
                if (this.entries[n].getControlFlag() != AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) continue;
                break;
            }
            catch (LoginException loginException) {
                if (this.entries[n].getControlFlag() != AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) continue;
                for (int i = 0; i < this.modules.length; ++i) {
                    this.modules[n].abort();
                }
                throw loginException;
            }
        }
        if (bl) {
            throw new LoginException("not all REQUIRED modules succeeded");
        }
        for (n = 0; n < this.modules.length; ++n) {
            this.modules[n].commit();
        }
    }

    public void logout() throws LoginException {
        for (int i = 0; i < this.modules.length; ++i) {
            this.modules[i].logout();
        }
    }

    private static CallbackHandler defaultHandler() {
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction("auth.login.defaultCallbackHandler");
        String string = (String)AccessController.doPrivileged(getSecurityPropertyAction);
        if (string != null) {
            try {
                return (CallbackHandler)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
        }
        return null;
    }

    private LoginModule lookupModule(AppConfigurationEntry appConfigurationEntry, Subject subject, Map map) throws LoginException {
        Object object;
        LoginModule loginModule = null;
        Exception exception = null;
        try {
            object = Thread.currentThread().getContextClassLoader();
            Class clazz = Class.forName(appConfigurationEntry.getLoginModuleName(), true, (ClassLoader)object);
            loginModule = (LoginModule)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (ClassCastException classCastException) {
            exception = classCastException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            exception = instantiationException;
        }
        if (exception != null) {
            object = new LoginException("could not load module " + appConfigurationEntry.getLoginModuleName());
            ((Throwable)object).initCause(exception);
            throw object;
        }
        loginModule.initialize(subject, this.cbHandler, map, appConfigurationEntry.getOptions());
        return loginModule;
    }
}

