/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class FileCacheImageInputStream
extends ImageInputStreamImpl {
    private InputStream stream;
    private File cacheDir;

    public FileCacheImageInputStream(InputStream inputStream, File file) throws IOException {
        this.stream = inputStream;
        this.cacheDir = file;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
    }

    private void checkStreamClosed() throws IOException {
        if (this.stream == null) {
            throw new IOException("stream closed");
        }
    }

    public boolean isCached() {
        return true;
    }

    public boolean isCachedFile() {
        return true;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public int read() throws IOException {
        this.checkStreamClosed();
        this.setBitOffset(0);
        return this.stream.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkStreamClosed();
        this.setBitOffset(0);
        return this.stream.read(byArray, n, n2);
    }
}

