/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.jpeg;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGQTable;

public class JPEGImageWriteParam
extends ImageWriteParam {
    private JPEGQTable[] qTables;
    private JPEGHuffmanTable[] DCHuffmanTables;
    private JPEGHuffmanTable[] ACHuffmanTables;
    private boolean optimize;
    private String[] compressionQualityDescriptions;
    private float[] compressionQualityValues;
    private ResourceBundle messages;

    public JPEGImageWriteParam(Locale locale) {
        super(locale);
        this.messages = ResourceBundle.getBundle("javax/imageio/plugins/jpeg/MessagesBundle", locale);
        this.canWriteTiles = false;
        this.canWriteProgressive = true;
        this.progressiveMode = 0;
        this.canWriteCompressed = true;
        this.compressionTypes = new String[]{this.messages.getString("compression.types.jpeg")};
        this.compressionType = this.compressionTypes[0];
        this.compressionQuality = 0.75f;
    }

    public void unsetCompression() {
        this.compressionQuality = 0.75f;
    }

    public boolean isCompressionLossless() {
        return false;
    }

    public String[] getCompressionQualityDescriptions() {
        super.getCompressionQualityDescriptions();
        if (this.compressionQualityDescriptions == null) {
            this.compressionQualityDescriptions = new String[]{this.messages.getString("compression.minimum"), this.messages.getString("compression.default"), this.messages.getString("compression.maximum")};
        }
        return this.compressionQualityDescriptions;
    }

    public float[] getCompressionQualityValues() {
        super.getCompressionQualityValues();
        if (this.compressionQualityValues == null) {
            this.compressionQualityValues = new float[]{0.05f, 0.75f, 0.95f};
        }
        return this.compressionQualityValues;
    }

    public boolean areTablesSet() {
        return this.qTables != null;
    }

    public void setEncodeTables(JPEGQTable[] jPEGQTableArray, JPEGHuffmanTable[] jPEGHuffmanTableArray, JPEGHuffmanTable[] jPEGHuffmanTableArray2) {
        if (jPEGQTableArray == null || jPEGHuffmanTableArray == null || jPEGHuffmanTableArray2 == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (jPEGQTableArray.length > 4 || jPEGHuffmanTableArray.length > 4 || jPEGHuffmanTableArray2.length > 4) {
            throw new IllegalArgumentException("argument has too many elements");
        }
        if (jPEGHuffmanTableArray.length != jPEGHuffmanTableArray2.length) {
            throw new IllegalArgumentException("Huffman table arrays differ in length");
        }
        this.qTables = (JPEGQTable[])jPEGQTableArray.clone();
        this.DCHuffmanTables = (JPEGHuffmanTable[])jPEGHuffmanTableArray.clone();
        this.ACHuffmanTables = (JPEGHuffmanTable[])jPEGHuffmanTableArray2.clone();
    }

    public void unsetEncodeTables() {
        this.qTables = null;
        this.DCHuffmanTables = null;
        this.ACHuffmanTables = null;
    }

    public JPEGQTable[] getQTables() {
        if (this.qTables == null) {
            return this.qTables;
        }
        return (JPEGQTable[])this.qTables.clone();
    }

    public JPEGHuffmanTable[] getDCHuffmanTables() {
        if (this.DCHuffmanTables == null) {
            return this.DCHuffmanTables;
        }
        return (JPEGHuffmanTable[])this.DCHuffmanTables.clone();
    }

    public JPEGHuffmanTable[] getACHuffmanTables() {
        if (this.ACHuffmanTables == null) {
            return this.ACHuffmanTables;
        }
        return (JPEGHuffmanTable[])this.ACHuffmanTables.clone();
    }

    public void setOptimizeHuffmanTables(boolean bl) {
        this.optimize = bl;
    }

    public boolean getOptimizeHuffmanTables() {
        return this.optimize;
    }
}

