/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.StringTokenizer;

public final class UUID
implements Serializable,
Comparable {
    private static final long serialVersionUID = -4856846361193249489L;
    private long mostSigBits;
    private long leastSigBits;
    private static transient Random r = new Random();

    public UUID(long l, long l2) {
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public int clockSequence() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a type 1 UUID");
        }
        return (int)((this.leastSigBits & 0x3FFF000000000000L) >> 48);
    }

    public int compareTo(Object object) {
        return this.compareTo((UUID)object);
    }

    public int compareTo(UUID uUID) {
        if (this.mostSigBits < uUID.mostSigBits) {
            return -1;
        }
        if (this.mostSigBits > uUID.mostSigBits) {
            return 1;
        }
        if (this.leastSigBits < uUID.leastSigBits) {
            return -1;
        }
        if (this.leastSigBits > uUID.mostSigBits) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UUID)) {
            return false;
        }
        return ((UUID)object).mostSigBits == this.mostSigBits && ((UUID)object).leastSigBits == this.leastSigBits;
    }

    public static UUID fromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "-");
        if (stringTokenizer.countTokens() < 5) {
            throw new IllegalArgumentException("Incorrect UUID string representation:" + string);
        }
        long l = Long.parseLong(stringTokenizer.nextToken(), 16) << 32;
        l |= Long.parseLong(stringTokenizer.nextToken(), 16) << 16;
        long l2 = Long.parseLong(stringTokenizer.nextToken(), 16) << 48;
        return new UUID(l |= Long.parseLong(stringTokenizer.nextToken(), 16), l2 |= Long.parseLong(stringTokenizer.nextToken(), 16));
    }

    public String toString() {
        return this.padHex((this.mostSigBits & 0xFFFFFFFF00000000L) >> 32 & 0xFFFFFFFFL, 8) + "-" + this.padHex((this.mostSigBits & 0xFFFF0000L) >> 16, 4) + "-" + this.padHex(this.mostSigBits & 0xFFFFL, 4) + "-" + this.padHex((this.leastSigBits & 0xFFFF000000000000L) >> 48 & 0xFFFFL, 4) + "-" + this.padHex(this.leastSigBits & 0xFFFFFFFFFFFFL, 12);
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int hashCode() {
        int n = (int)this.leastSigBits;
        int n2 = (int)((this.leastSigBits & 0xFFFFFFFF00000000L) >> 32);
        int n3 = (int)this.mostSigBits;
        int n4 = (int)((this.mostSigBits & 0xFFFFFFFF00000000L) >> 32);
        return n ^ n2 ^ (n3 ^ n4);
    }

    public static UUID nameUUIDFromBytes(byte[] byArray) {
        byte[] byArray2;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray2 = messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("No MD5 algorithm available.");
        }
        long l = ((long)byArray2[0] & (long)255) << 56 | ((long)byArray2[1] & (long)255) << 48 | ((long)byArray2[2] & (long)255) << 40 | ((long)byArray2[3] & (long)255) << 32 | ((long)byArray2[4] & (long)255) << 24 | ((long)byArray2[5] & (long)255) << 16 | ((long)byArray2[6] & (long)255) << 8 | (long)byArray2[7] & (long)255;
        long l2 = ((long)byArray2[8] & (long)255) << 56 | ((long)byArray2[9] & (long)255) << 48 | ((long)byArray2[10] & (long)255) << 40 | ((long)byArray2[11] & (long)255) << 32 | ((long)byArray2[12] & (long)255) << 24 | ((long)byArray2[13] & (long)255) << 16 | ((long)byArray2[14] & (long)255) << 8 | (long)byArray2[15] & (long)255;
        l2 &= 0x3FFFFFFFFFFFFFFFL;
        l &= 0xFFFFFFFFFFFF0FFFL;
        return new UUID(l |= (long)12288, l2 |= Long.MIN_VALUE);
    }

    public long node() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a type 1 UUID");
        }
        return this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    public long timestamp() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a type 1 UUID");
        }
        long l = (this.mostSigBits & 0xFFFFFFFF00000000L) >> 32;
        l |= (this.mostSigBits & 0xFFFF0000L) << 16;
        long l2 = this.mostSigBits & (long)4095;
        return l |= l2 << 48;
    }

    public static UUID randomUUID() {
        long l = r.nextLong();
        long l2 = r.nextLong();
        l &= 0x3FFFFFFFFFFFFFFFL;
        l2 &= 0xFFFFFFFFFFFF0FFFL;
        return new UUID(l2 |= (long)16384, l |= Long.MIN_VALUE);
    }

    private String padHex(long l, int n) {
        String string = Long.toHexString(l);
        while (string.length() < n) {
            string = "0" + string;
        }
        return string;
    }

    public int variant() {
        int n = (int)((this.leastSigBits & 0xE000000000000000L) >> 61);
        if ((n & 4) == 0) {
            return 0;
        }
        if ((n & 2) == 0) {
            return 2;
        }
        return n;
    }

    public int version() {
        return (int)((this.mostSigBits & 0xF000L) >> 12);
    }
}

