/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;

public abstract class Signer
extends Identity {
    private static final long serialVersionUID = -1763464102261361480L;
    private PrivateKey privateKey;

    private /* synthetic */ void finit$() {
        this.privateKey = null;
    }

    protected Signer() {
        this.finit$();
    }

    public Signer(String string) {
        super(string);
        this.finit$();
    }

    public Signer(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
        this.finit$();
    }

    public PrivateKey getPrivateKey() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("getSignerPrivateKey");
        }
        return this.privateKey;
    }

    public final void setKeyPair(KeyPair keyPair) throws InvalidParameterException, KeyException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("setSignerKeyPair");
        }
        try {
            if (keyPair.getPublic() == null) {
                throw new InvalidParameterException();
            }
            this.setPublicKey(keyPair.getPublic());
        }
        catch (KeyManagementException keyManagementException) {
            throw new KeyException();
        }
        if (keyPair.getPrivate() == null) {
            throw new InvalidParameterException();
        }
        this.privateKey = keyPair.getPrivate();
    }

    public String toString() {
        return this.getName() + ": " + this.privateKey;
    }
}

