/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.SystemProperties;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;

public class ProtectionDomain {
    private CodeSource code_source;
    private PermissionCollection perms;
    private ClassLoader classloader;
    private Principal[] principals;
    private boolean staticBinding;

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection) {
        this(codeSource, permissionCollection, null, null, true);
    }

    public ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray) {
        this(codeSource, permissionCollection, classLoader, principalArray, false);
    }

    private ProtectionDomain(CodeSource codeSource, PermissionCollection permissionCollection, ClassLoader classLoader, Principal[] principalArray, boolean bl) {
        this.code_source = codeSource;
        if (permissionCollection != null) {
            this.perms = permissionCollection;
            this.perms.setReadOnly();
        }
        this.classloader = classLoader;
        this.principals = principalArray != null ? (Principal[])principalArray.clone() : new Principal[]{};
        this.staticBinding = bl;
    }

    public final CodeSource getCodeSource() {
        return this.code_source;
    }

    public final ClassLoader getClassLoader() {
        return this.classloader;
    }

    public final Principal[] getPrincipals() {
        return (Principal[])this.principals.clone();
    }

    public final PermissionCollection getPermissions() {
        return this.perms;
    }

    public boolean implies(Permission permission) {
        if (this.staticBinding) {
            if (this.perms != null) {
                return this.perms.implies(permission);
            }
            return false;
        }
        return Policy.getCurrentPolicy().implies(this, permission);
    }

    public String toString() {
        String string = SystemProperties.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("ProtectionDomain (").append(string);
        if (this.code_source == null) {
            stringBuffer.append("CodeSource:null");
        } else {
            stringBuffer.append(this.code_source);
        }
        stringBuffer.append(string);
        if (this.classloader == null) {
            stringBuffer.append("ClassLoader:null");
        } else {
            stringBuffer.append(this.classloader);
        }
        stringBuffer.append(string);
        stringBuffer.append("Principals:");
        if (this.principals != null && this.principals.length > 0) {
            stringBuffer.append("[");
            for (int i = 0; i < this.principals.length; ++i) {
                Principal principal = this.principals[i];
                stringBuffer.append("'").append(principal.getName()).append("' of type ").append(principal.getClass().getName());
                if (i >= this.principals.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append("none");
        }
        stringBuffer.append(string);
        if (!this.staticBinding) {
            if (Policy.isLoaded()) {
                stringBuffer.append(Policy.getCurrentPolicy().getPermissions(this));
            } else {
                stringBuffer.append(this.perms);
            }
        } else {
            stringBuffer.append(this.perms);
        }
        return stringBuffer.append(string).append(")").append(string).toString();
    }
}

