/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import gnu.java.nio.SelectorProviderImpl;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;

public abstract class SelectorProvider {
    private static SelectorProvider systemDefaultProvider;

    protected SelectorProvider() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("selectorProvider"));
        }
    }

    public abstract DatagramChannel openDatagramChannel() throws IOException;

    public abstract Pipe openPipe() throws IOException;

    public abstract AbstractSelector openSelector() throws IOException;

    public abstract ServerSocketChannel openServerSocketChannel() throws IOException;

    public abstract SocketChannel openSocketChannel() throws IOException;

    public static synchronized SelectorProvider provider() {
        if (systemDefaultProvider == null) {
            String string = System.getProperty("java.nio.channels.spi.SelectorProvider");
            if (string == null || string.equals("")) {
                systemDefaultProvider = new SelectorProviderImpl();
            } else {
                try {
                    systemDefaultProvider = (SelectorProvider)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    System.err.println("Could not instantiate class: " + string);
                    systemDefaultProvider = new SelectorProviderImpl();
                }
            }
        }
        return systemDefaultProvider;
    }
}

