/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    private static final long serialVersionUID = -7183698231559129828L;
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('B');
    public static final int SIZE = 8;
    private static Byte[] byteCache = new Byte[256];
    private final byte value;

    public Byte(byte by) {
        this.value = by;
    }

    public Byte(String string) {
        this.value = Byte.parseByte(string, 10);
    }

    public static String toString(byte by) {
        return String.valueOf(by);
    }

    public static byte parseByte(String string) {
        return Byte.parseByte(string, 10);
    }

    public static byte parseByte(String string, int n) {
        int n2 = Integer.parseInt(string, n, false);
        if ((byte)n2 != n2) {
            throw new NumberFormatException();
        }
        return (byte)n2;
    }

    public static Byte valueOf(String string, int n) {
        return new Byte(Byte.parseByte(string, n));
    }

    public static Byte valueOf(String string) {
        return new Byte(Byte.parseByte(string, 10));
    }

    public static Byte valueOf(byte by) {
        Byte[] byteArray = byteCache;
        synchronized (byteArray) {
            try {
                if (byteCache[by - -128] == null) {
                    Byte.byteCache[by - -128] = new Byte(by);
                }
                Byte by2 = byteCache[by - -128];
                Object var3_3 = null;
                return by2;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public static Byte decode(String string) {
        int n = Integer.parseInt(string, 10, true);
        if ((byte)n != n) {
            throw new NumberFormatException();
        }
        return new Byte((byte)n);
    }

    public byte byteValue() {
        return this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Byte && this.value == ((Byte)object).value;
    }

    public int compareTo(Byte by) {
        return this.value - by.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Byte)object);
    }
}

