/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.CharsetToBytesAdaptor;
import gnu.gcj.convert.UnicodeToBytes;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class OutputStreamWriter
extends Writer {
    BufferedOutputStream out;
    UnicodeToBytes converter;
    private char[] work;
    private int wcount;

    private OutputStreamWriter(OutputStream outputStream, UnicodeToBytes unicodeToBytes) {
        this.out = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 250);
        this.lock = outputStream;
        this.converter = unicodeToBytes;
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, UnicodeToBytes.getEncoder(string));
    }

    public OutputStreamWriter(OutputStream outputStream) {
        this(outputStream, UnicodeToBytes.getDefaultEncoder());
    }

    public OutputStreamWriter(OutputStream outputStream, Charset charset) {
        this(outputStream, new CharsetToBytesAdaptor(charset));
    }

    public OutputStreamWriter(OutputStream outputStream, CharsetEncoder charsetEncoder) {
        this(outputStream, new CharsetToBytesAdaptor(charsetEncoder));
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out != null) {
                    this.converter.setFinished();
                    this.flush();
                    this.out.close();
                    this.out = null;
                }
                this.work = null;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public String getEncoding() {
        if (this.out != null) {
            return this.converter.getName();
        }
        return null;
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.work == null) {
                    this.work = new char[100];
                }
                this.writeChars(this.work, 0, this.wcount);
                this.wcount = 0;
                this.out.flush();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wcount > 0) {
                    this.writeChars(this.work, 0, this.wcount);
                    this.wcount = 0;
                }
                this.writeChars(cArray, n, n2);
            }
            finally {
                Object var5_5 = null;
            }
            return;
        }
    }

    private void writeChars(char[] cArray, int n, int n2) throws IOException {
        int n3;
        do {
            if (this.out.count + n2 >= this.out.buf.length) {
                this.out.flush();
                if (this.out.count != 0) {
                    throw new IOException("unable to flush output byte buffer");
                }
            }
            this.converter.setOutput(this.out.buf, this.out.count);
            n3 = this.converter.write(cArray, n, n2);
            this.out.count = this.converter.count;
            if (n3 == 0 && this.out.count == this.converter.count) {
                this.out.flush();
                if (this.out.count != 0) {
                    throw new IOException("unable to flush output byte buffer");
                }
            }
            n += n3;
        } while ((n2 -= n3) > 0 || this.converter.havePendingBytes());
    }

    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.work == null) {
                    this.work = new char[100];
                }
                int n3 = this.work.length;
                while (n2 > 0) {
                    int n4 = n2;
                    if (this.wcount + n4 > n3) {
                        if (2 * this.wcount > n3) {
                            this.writeChars(this.work, 0, this.wcount);
                            this.wcount = 0;
                        }
                        if (this.wcount + n4 > n3) {
                            n4 = n3 - this.wcount;
                        }
                    }
                    string.getChars(n, n + n4, this.work, this.wcount);
                    n += n4;
                    n2 -= n4;
                    this.wcount += n4;
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }

    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                if (this.work == null) {
                    this.work = new char[100];
                }
                if (this.wcount >= this.work.length) {
                    this.writeChars(this.work, 0, this.wcount);
                    this.wcount = 0;
                }
                this.work[this.wcount++] = (char)n;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }
}

