/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public abstract class RoundRectangle2D
extends RectangularShape {
    public abstract double getArcHeight();

    public abstract double getArcWidth();

    public abstract void setRoundRect(double var1, double var3, double var5, double var7, double var9, double var11);

    protected RoundRectangle2D() {
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getWidth();
        if (d < d3 || d >= d3 + d4) {
            return false;
        }
        double d5 = this.getY();
        double d6 = this.getHeight();
        if (d2 < d5 || d2 >= d5 + d6) {
            return false;
        }
        double d7 = Math.min(Math.abs(d5 - d2), Math.abs(d5 + d6 - d2));
        double d8 = Math.min(Math.abs(d3 - d), Math.abs(d3 + d4 - d));
        double d9 = this.getArcWidth() / 2.0;
        double d10 = this.getArcHeight() / 2.0;
        if (d8 > d9 || d7 > d10) {
            return true;
        }
        d7 = (d10 - d7) / d10;
        double d11 = d8 = (d9 - d8) / d9;
        double d12 = d7;
        return d11 * d11 + d12 * d12 <= 1.0;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4) && this.contains(d + d3, d2);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        double d = this.getX();
        double d2 = this.getY();
        double d3 = d + this.getWidth();
        double d4 = d2 + this.getHeight();
        double d5 = this.getArcWidth();
        double d6 = this.getArcHeight();
        return new PathIterator(this, d6, d5, d4, d3, d2, d, affineTransform){
            private /* synthetic */ RoundRectangle2D this$0;
            private /* synthetic */ double val$archeight;
            private /* synthetic */ double val$arcwidth;
            private /* synthetic */ double val$maxy;
            private /* synthetic */ double val$maxx;
            private /* synthetic */ double val$miny;
            private /* synthetic */ double val$minx;
            private /* synthetic */ AffineTransform val$at;
            private int current;
            private PathIterator corner;
            private Arc2D arc;
            private double[] temp;
            {
                this.this$0 = roundRectangle2D;
                this.finit$(d, d2, d3, d4, d5, d6, affineTransform);
            }

            private /* synthetic */ void finit$(double d, double d2, double d3, double d4, double d5, double d6, AffineTransform affineTransform) {
                this.val$at = affineTransform;
                this.val$minx = d6;
                this.val$miny = d5;
                this.val$maxx = d4;
                this.val$maxy = d3;
                this.val$arcwidth = d2;
                this.val$archeight = d;
                this.current = 0;
                this.arc = new Arc2D.Double();
                this.temp = new double[2];
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.current > 9;
            }

            private void getPoint(int n) {
                switch (n) {
                    case 0: 
                    case 8: {
                        this.temp[0] = this.val$maxx;
                        this.temp[1] = this.val$miny + this.val$archeight;
                        break;
                    }
                    case 7: {
                        this.temp[0] = this.val$maxx;
                        this.temp[1] = this.val$maxy - this.val$archeight;
                        break;
                    }
                    case 6: {
                        this.temp[0] = this.val$maxx - this.val$arcwidth;
                        this.temp[1] = this.val$maxy;
                        break;
                    }
                    case 5: {
                        this.temp[0] = this.val$minx + this.val$arcwidth;
                        this.temp[1] = this.val$maxy;
                        break;
                    }
                    case 4: {
                        this.temp[0] = this.val$minx;
                        this.temp[1] = this.val$maxy - this.val$archeight;
                        break;
                    }
                    case 3: {
                        this.temp[0] = this.val$minx;
                        this.temp[1] = this.val$miny + this.val$archeight;
                        break;
                    }
                    case 2: {
                        this.temp[0] = this.val$minx + this.val$arcwidth;
                        this.temp[1] = this.val$miny;
                        break;
                    }
                    case 1: {
                        this.temp[0] = this.val$maxx - this.val$arcwidth;
                        this.temp[1] = this.val$miny;
                    }
                }
            }

            public void next() {
                if (this.current >= 8) {
                    ++this.current;
                } else if (this.corner != null) {
                    this.corner.next();
                    if (this.corner.isDone()) {
                        this.corner = null;
                        ++this.current;
                    }
                } else {
                    this.getPoint(this.current);
                    double d = this.temp[0];
                    double d2 = this.temp[1];
                    this.getPoint(this.current + 1);
                    Rectangle2D.Double double_ = new Rectangle2D.Double(Math.min(d, this.temp[0]), Math.min(d2, this.temp[1]), Math.abs(d - this.temp[0]), Math.abs(d2 - this.temp[1]));
                    this.arc.setArc(double_, (double)(this.current >> 1) * 90.0, 90.0, 0);
                    this.corner = this.arc.getPathIterator(this.val$at);
                }
            }

            public int currentSegment(float[] fArray) {
                if (this.corner != null) {
                    int n = this.corner.currentSegment(fArray);
                    if (n == 0) {
                        n = 1;
                    }
                    return n;
                }
                if (this.current >= 9) {
                    if (this.current == 9) {
                        return 4;
                    }
                    throw new NoSuchElementException("rect iterator out of bounds");
                }
                this.getPoint(this.current);
                fArray[0] = (float)this.temp[0];
                fArray[1] = (float)this.temp[1];
                if (this.val$at != null) {
                    this.val$at.transform(fArray, 0, fArray, 0, 1);
                }
                if (this.current == 0) {
                    return 0;
                }
                return 1;
            }

            public int currentSegment(double[] dArray) {
                if (this.corner != null) {
                    int n = this.corner.currentSegment(dArray);
                    if (n == 0) {
                        n = 1;
                    }
                    return n;
                }
                if (this.current >= 9) {
                    if (this.current == 9) {
                        return 4;
                    }
                    throw new NoSuchElementException("rect iterator out of bounds");
                }
                this.getPoint(this.current);
                dArray[0] = this.temp[0];
                dArray[1] = this.temp[1];
                if (this.val$at != null) {
                    this.val$at.transform(dArray, 0, dArray, 0, 1);
                }
                if (this.current == 0) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) || this.contains(d, d2 + d4) || this.contains(d + d3, d2 + d4) || this.contains(d + d3, d2);
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.setRoundRect(d, d2, d3, d4, this.getArcWidth(), this.getArcHeight());
    }

    public void setRoundRect(RoundRectangle2D roundRectangle2D) {
        this.setRoundRect(roundRectangle2D.getX(), roundRectangle2D.getY(), roundRectangle2D.getWidth(), roundRectangle2D.getHeight(), roundRectangle2D.getArcWidth(), roundRectangle2D.getArcHeight());
    }

    public static class Float
    extends RoundRectangle2D {
        public float archeight;
        public float arcwidth;
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRoundRect(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
            this.arcwidth = f5;
            this.archeight = f6;
        }

        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
            this.arcwidth = (float)d5;
            this.archeight = (float)d6;
        }
    }

    public static class Double
    extends RoundRectangle2D {
        public double archeight;
        public double arcwidth;
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }

        public double getArcHeight() {
            return this.archeight;
        }

        public double getArcWidth() {
            return this.arcwidth;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRoundRect(double d, double d2, double d3, double d4, double d5, double d6) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.arcwidth = d5;
            this.archeight = d6;
        }
    }
}

