/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class AffineTransform
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1330973210523860834L;
    public static final int TYPE_IDENTITY = 0;
    public static final int TYPE_TRANSLATION = 1;
    public static final int TYPE_UNIFORM_SCALE = 2;
    public static final int TYPE_GENERAL_SCALE = 4;
    public static final int TYPE_MASK_SCALE = 6;
    public static final int TYPE_FLIP = 64;
    public static final int TYPE_QUADRANT_ROTATION = 8;
    public static final int TYPE_GENERAL_ROTATION = 16;
    public static final int TYPE_MASK_ROTATION = 24;
    public static final int TYPE_GENERAL_TRANSFORM = 32;
    private double m00;
    private double m10;
    private double m01;
    private double m11;
    private double m02;
    private double m12;
    private transient int type;

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(AffineTransform affineTransform) {
        this.setTransform(affineTransform);
    }

    public AffineTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m00 = f;
        this.m10 = f2;
        this.m01 = f3;
        this.m11 = f4;
        this.m02 = f5;
        this.m12 = f6;
        this.updateType();
    }

    public AffineTransform(float[] fArray) {
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m01 = fArray[2];
        this.m11 = fArray[3];
        if (fArray.length >= 6) {
            this.m02 = fArray[4];
            this.m12 = fArray[5];
        }
        this.updateType();
    }

    public AffineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.updateType();
    }

    public AffineTransform(double[] dArray) {
        this.m00 = dArray[0];
        this.m10 = dArray[1];
        this.m01 = dArray[2];
        this.m11 = dArray[3];
        if (dArray.length >= 6) {
            this.m02 = dArray[4];
            this.m12 = dArray[5];
        }
        this.updateType();
    }

    public static AffineTransform getTranslateInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.m02 = d;
        affineTransform.m12 = d2;
        affineTransform.type = d == 0.0 && d2 == 0.0 ? 2 : 1;
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d, double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d2, d3);
        affineTransform.rotate(d);
        affineTransform.translate(-d2, -d3);
        return affineTransform;
    }

    public static AffineTransform getScaleInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(d, d2);
        return affineTransform;
    }

    public static AffineTransform getShearInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToShear(d, d2);
        return affineTransform;
    }

    public int getType() {
        return this.type;
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    public void getMatrix(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m10;
        dArray[2] = this.m01;
        dArray[3] = this.m11;
        if (dArray.length >= 6) {
            dArray[4] = this.m02;
            dArray[5] = this.m12;
        }
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void translate(double d, double d2) {
        this.m02 += d * this.m00 + d2 * this.m01;
        this.m12 += d * this.m10 + d2 * this.m11;
        this.updateType();
    }

    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.m00 * d2 + this.m01 * d3;
        double d5 = this.m00 * -d3 + this.m01 * d2;
        double d6 = this.m10 * d2 + this.m11 * d3;
        double d7 = this.m10 * -d3 + this.m11 * d2;
        this.m00 = d4;
        this.m01 = d5;
        this.m10 = d6;
        this.m11 = d7;
        this.updateType();
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(d2, d3);
        this.rotate(d);
        this.translate(-d2, -d3);
    }

    public void scale(double d, double d2) {
        this.m00 *= d;
        this.m01 *= d2;
        this.m10 *= d;
        this.m11 *= d2;
        this.updateType();
    }

    public void shear(double d, double d2) {
        double d3 = this.m00 + d2 * this.m01;
        double d4 = this.m01 + d * this.m00;
        double d5 = this.m10 + d2 * this.m11;
        double d6 = this.m11 + d * this.m10;
        this.m00 = d3;
        this.m01 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.updateType();
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.type = 0;
    }

    public void setToTranslation(double d, double d2) {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m02 = d;
        this.m12 = d2;
        this.type = d == 0.0 && d2 == 0.0 ? 2 : 1;
    }

    public void setToRotation(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = -d3;
        this.m02 = 0.0;
        this.m10 = d3;
        this.m11 = d2;
        this.m12 = 0.0;
        this.type = d2 == 1.0 ? 0 : (d2 == 0.0 || d2 == -1.0 ? 8 : 16);
    }

    public void setToRotation(double d, double d2, double d3) {
        double d4 = Math.cos(d);
        double d5 = Math.sin(d);
        this.m00 = d4;
        this.m01 = -d5;
        this.m02 = d2 - d2 * d4 + d3 * d5;
        this.m10 = d5;
        this.m11 = d4;
        this.m12 = d3 - d2 * d5 - d3 * d4;
        this.updateType();
    }

    public void setToScale(double d, double d2) {
        this.m00 = d;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m11 = d2;
        this.type = d != d2 ? 4 : (d == 1.0 ? 0 : 2);
    }

    public void setToShear(double d, double d2) {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m01 = d;
        this.m10 = d2;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.updateType();
    }

    public void setTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.m00;
        this.m01 = affineTransform.m01;
        this.m02 = affineTransform.m02;
        this.m10 = affineTransform.m10;
        this.m11 = affineTransform.m11;
        this.m12 = affineTransform.m12;
        this.type = affineTransform.type;
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.updateType();
    }

    public void concatenate(AffineTransform affineTransform) {
        double d = this.m00 * affineTransform.m00 + this.m01 * affineTransform.m10;
        double d2 = this.m00 * affineTransform.m01 + this.m01 * affineTransform.m11;
        double d3 = this.m00 * affineTransform.m02 + this.m01 * affineTransform.m12 + this.m02;
        double d4 = this.m10 * affineTransform.m00 + this.m11 * affineTransform.m10;
        double d5 = this.m10 * affineTransform.m01 + this.m11 * affineTransform.m11;
        double d6 = this.m10 * affineTransform.m02 + this.m11 * affineTransform.m12 + this.m12;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.updateType();
    }

    public void preConcatenate(AffineTransform affineTransform) {
        double d = affineTransform.m00 * this.m00 + affineTransform.m01 * this.m10;
        double d2 = affineTransform.m00 * this.m01 + affineTransform.m01 * this.m11;
        double d3 = affineTransform.m00 * this.m02 + affineTransform.m01 * this.m12 + affineTransform.m02;
        double d4 = affineTransform.m10 * this.m00 + affineTransform.m11 * this.m10;
        double d5 = affineTransform.m10 * this.m01 + affineTransform.m11 * this.m11;
        double d6 = affineTransform.m10 * this.m02 + affineTransform.m11 * this.m12 + affineTransform.m12;
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.updateType();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        double d = this.getDeterminant();
        if (d == 0.0) {
            throw new NoninvertibleTransformException("can't invert transform");
        }
        double d2 = this.m11 / d;
        double d3 = -this.m10 / d;
        double d4 = -this.m01 / d;
        double d5 = this.m00 / d;
        double d6 = (this.m01 * this.m12 - this.m02 * this.m11) / d;
        double d7 = (-this.m00 * this.m12 + this.m10 * this.m02) / d;
        return new AffineTransform(d2, d3, d4, d5, d6, d7);
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = this.m00 * d + this.m01 * d2 + this.m02;
        double d4 = this.m10 * d + this.m11 * d2 + this.m12;
        point2D2.setLocation(d3, d4);
        return point2D2;
    }

    public void transform(Point2D[] point2DArray, int n, Point2D[] point2DArray2, int n2, int n3) {
        while (--n3 >= 0) {
            point2DArray2[n2] = this.transform(point2DArray[n++], point2DArray2[n2++]);
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray == fArray2 && n2 > n && n3 > 1 && n + 2 * n3 > n2) {
            float[] fArray3 = new float[2 * n3];
            System.arraycopy(fArray, n, fArray3, 0, 2 * n3);
            fArray = fArray3;
        }
        while (--n3 >= 0) {
            float f = fArray[n++];
            float f2 = fArray[n++];
            fArray2[n2++] = (float)(this.m00 * (double)f + this.m01 * (double)f2 + this.m02);
            fArray2[n2++] = (float)(this.m10 * (double)f + this.m11 * (double)f2 + this.m12);
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray == dArray2 && n2 > n && n3 > 1 && n + 2 * n3 > n2) {
            double[] dArray3 = new double[2 * n3];
            System.arraycopy(dArray, n, dArray3, 0, 2 * n3);
            dArray = dArray3;
        }
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            dArray2[n2++] = this.m00 * d + this.m01 * d2 + this.m02;
            dArray2[n2++] = this.m10 * d + this.m11 * d2 + this.m12;
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        while (--n3 >= 0) {
            float f = fArray[n++];
            float f2 = fArray[n++];
            dArray[n2++] = this.m00 * (double)f + this.m01 * (double)f2 + this.m02;
            dArray[n2++] = this.m10 * (double)f + this.m11 * (double)f2 + this.m12;
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            fArray[n2++] = (float)(this.m00 * d + this.m01 * d2 + this.m02);
            fArray[n2++] = (float)(this.m10 * d + this.m11 * d2 + this.m12);
        }
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        return this.createInverse().transform(point2D, point2D2);
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws NoninvertibleTransformException {
        this.createInverse().transform(dArray, n, dArray2, n2, n3);
    }

    public Point2D deltaTransform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = this.m00 * d + this.m01 * d2;
        double d4 = this.m10 * d + this.m11 * d2;
        point2D2.setLocation(d3, d4);
        return point2D2;
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray == dArray2 && n2 > n && n3 > 1 && n + 2 * n3 > n2) {
            double[] dArray3 = new double[2 * n3];
            System.arraycopy(dArray, n, dArray3, 0, 2 * n3);
            dArray = dArray3;
        }
        while (--n3 >= 0) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            dArray2[n2++] = this.m00 * d + this.m01 * d2;
            dArray2[n2++] = this.m10 * d + this.m11 * d2;
        }
    }

    public Shape createTransformedShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        GeneralPath generalPath = new GeneralPath(shape);
        generalPath.transform(this);
        return generalPath;
    }

    public String toString() {
        return "AffineTransform[[" + this.m00 + ", " + this.m01 + ", " + this.m02 + "], [" + this.m10 + ", " + this.m11 + ", " + this.m12 + "]]";
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.m00);
        l = l * (long)31 + Double.doubleToLongBits(this.m10);
        l = l * (long)31 + Double.doubleToLongBits(this.m01);
        l = l * (long)31 + Double.doubleToLongBits(this.m11);
        l = l * (long)31 + Double.doubleToLongBits(this.m02);
        l = l * (long)31 + Double.doubleToLongBits(this.m12);
        return (int)(l >> 32) ^ (int)l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AffineTransform)) {
            return false;
        }
        AffineTransform affineTransform = (AffineTransform)object;
        return this.m00 == affineTransform.m00 && this.m01 == affineTransform.m01 && this.m02 == affineTransform.m02 && this.m10 == affineTransform.m10 && this.m11 == affineTransform.m11 && this.m12 == affineTransform.m12;
    }

    private void updateType() {
        double d = this.getDeterminant();
        if (d == 0.0) {
            this.type = 32;
            return;
        }
        if (this.m01 == 0.0 && this.m10 == 0.0) {
            this.type = this.m00 == this.m11 ? (this.m00 == 1.0 ? 0 : 2) : 4;
            if (this.m02 != 0.0 || this.m12 != 0.0) {
                this.type |= 1;
            }
        } else if (this.m00 == this.m11 && this.m01 == -this.m10) {
            int n = this.type = this.m00 == 0.0 ? 8 : 16;
            if (d != 1.0) {
                this.type |= 2;
            }
            if (this.m02 != 0.0 || this.m12 != 0.0) {
                this.type |= 1;
            }
        } else {
            this.type = 32;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updateType();
    }
}

