/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import gnu.java.awt.EventModifier;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;

public class KeyEvent
extends InputEvent {
    private static final long serialVersionUID = -2352130953028126954L;
    public static final int KEY_FIRST = 400;
    public static final int KEY_LAST = 402;
    public static final int KEY_TYPED = 400;
    public static final int KEY_PRESSED = 401;
    public static final int KEY_RELEASED = 402;
    public static final int VK_ENTER = 10;
    public static final int VK_BACK_SPACE = 8;
    public static final int VK_TAB = 9;
    public static final int VK_CANCEL = 3;
    public static final int VK_CLEAR = 12;
    public static final int VK_SHIFT = 16;
    public static final int VK_CONTROL = 17;
    public static final int VK_ALT = 18;
    public static final int VK_PAUSE = 19;
    public static final int VK_CAPS_LOCK = 20;
    public static final int VK_ESCAPE = 27;
    public static final int VK_SPACE = 32;
    public static final int VK_PAGE_UP = 33;
    public static final int VK_PAGE_DOWN = 34;
    public static final int VK_END = 35;
    public static final int VK_HOME = 36;
    public static final int VK_LEFT = 37;
    public static final int VK_UP = 38;
    public static final int VK_RIGHT = 39;
    public static final int VK_DOWN = 40;
    public static final int VK_COMMA = 44;
    public static final int VK_MINUS = 45;
    public static final int VK_PERIOD = 46;
    public static final int VK_SLASH = 47;
    public static final int VK_0 = 48;
    public static final int VK_1 = 49;
    public static final int VK_2 = 50;
    public static final int VK_3 = 51;
    public static final int VK_4 = 52;
    public static final int VK_5 = 53;
    public static final int VK_6 = 54;
    public static final int VK_7 = 55;
    public static final int VK_8 = 56;
    public static final int VK_9 = 57;
    public static final int VK_SEMICOLON = 59;
    public static final int VK_EQUALS = 61;
    public static final int VK_A = 65;
    public static final int VK_B = 66;
    public static final int VK_C = 67;
    public static final int VK_D = 68;
    public static final int VK_E = 69;
    public static final int VK_F = 70;
    public static final int VK_G = 71;
    public static final int VK_H = 72;
    public static final int VK_I = 73;
    public static final int VK_J = 74;
    public static final int VK_K = 75;
    public static final int VK_L = 76;
    public static final int VK_M = 77;
    public static final int VK_N = 78;
    public static final int VK_O = 79;
    public static final int VK_P = 80;
    public static final int VK_Q = 81;
    public static final int VK_R = 82;
    public static final int VK_S = 83;
    public static final int VK_T = 84;
    public static final int VK_U = 85;
    public static final int VK_V = 86;
    public static final int VK_W = 87;
    public static final int VK_X = 88;
    public static final int VK_Y = 89;
    public static final int VK_Z = 90;
    public static final int VK_OPEN_BRACKET = 91;
    public static final int VK_BACK_SLASH = 92;
    public static final int VK_CLOSE_BRACKET = 93;
    public static final int VK_NUMPAD0 = 96;
    public static final int VK_NUMPAD1 = 97;
    public static final int VK_NUMPAD2 = 98;
    public static final int VK_NUMPAD3 = 99;
    public static final int VK_NUMPAD4 = 100;
    public static final int VK_NUMPAD5 = 101;
    public static final int VK_NUMPAD6 = 102;
    public static final int VK_NUMPAD7 = 103;
    public static final int VK_NUMPAD8 = 104;
    public static final int VK_NUMPAD9 = 105;
    public static final int VK_MULTIPLY = 106;
    public static final int VK_ADD = 107;
    public static final int VK_SEPARATER = 108;
    public static final int VK_SEPARATOR = 108;
    public static final int VK_SUBTRACT = 109;
    public static final int VK_DECIMAL = 110;
    public static final int VK_DIVIDE = 111;
    public static final int VK_DELETE = 127;
    public static final int VK_NUM_LOCK = 144;
    public static final int VK_SCROLL_LOCK = 145;
    public static final int VK_F1 = 112;
    public static final int VK_F2 = 113;
    public static final int VK_F3 = 114;
    public static final int VK_F4 = 115;
    public static final int VK_F5 = 116;
    public static final int VK_F6 = 117;
    public static final int VK_F7 = 118;
    public static final int VK_F8 = 119;
    public static final int VK_F9 = 120;
    public static final int VK_F10 = 121;
    public static final int VK_F11 = 122;
    public static final int VK_F12 = 123;
    public static final int VK_F13 = 61440;
    public static final int VK_F14 = 61441;
    public static final int VK_F15 = 61442;
    public static final int VK_F16 = 61443;
    public static final int VK_F17 = 61444;
    public static final int VK_F18 = 61445;
    public static final int VK_F19 = 61446;
    public static final int VK_F20 = 61447;
    public static final int VK_F21 = 61448;
    public static final int VK_F22 = 61449;
    public static final int VK_F23 = 61450;
    public static final int VK_F24 = 61451;
    public static final int VK_PRINTSCREEN = 154;
    public static final int VK_INSERT = 155;
    public static final int VK_HELP = 156;
    public static final int VK_META = 157;
    public static final int VK_BACK_QUOTE = 192;
    public static final int VK_QUOTE = 222;
    public static final int VK_KP_UP = 224;
    public static final int VK_KP_DOWN = 225;
    public static final int VK_KP_LEFT = 226;
    public static final int VK_KP_RIGHT = 227;
    public static final int VK_DEAD_GRAVE = 128;
    public static final int VK_DEAD_ACUTE = 129;
    public static final int VK_DEAD_CIRCUMFLEX = 130;
    public static final int VK_DEAD_TILDE = 131;
    public static final int VK_DEAD_MACRON = 132;
    public static final int VK_DEAD_BREVE = 133;
    public static final int VK_DEAD_ABOVEDOT = 134;
    public static final int VK_DEAD_DIAERESIS = 135;
    public static final int VK_DEAD_ABOVERING = 136;
    public static final int VK_DEAD_DOUBLEACUTE = 137;
    public static final int VK_DEAD_CARON = 138;
    public static final int VK_DEAD_CEDILLA = 139;
    public static final int VK_DEAD_OGONEK = 140;
    public static final int VK_DEAD_IOTA = 141;
    public static final int VK_DEAD_VOICED_SOUND = 142;
    public static final int VK_DEAD_SEMIVOICED_SOUND = 143;
    public static final int VK_AMPERSAND = 150;
    public static final int VK_ASTERISK = 151;
    public static final int VK_QUOTEDBL = 152;
    public static final int VK_LESS = 153;
    public static final int VK_GREATER = 160;
    public static final int VK_BRACELEFT = 161;
    public static final int VK_BRACERIGHT = 162;
    public static final int VK_AT = 512;
    public static final int VK_COLON = 513;
    public static final int VK_CIRCUMFLEX = 514;
    public static final int VK_DOLLAR = 515;
    public static final int VK_EURO_SIGN = 516;
    public static final int VK_EXCLAMATION_MARK = 517;
    public static final int VK_INVERTED_EXCLAMATION_MARK = 518;
    public static final int VK_LEFT_PARENTHESIS = 519;
    public static final int VK_NUMBER_SIGN = 520;
    public static final int VK_PLUS = 521;
    public static final int VK_RIGHT_PARENTHESIS = 522;
    public static final int VK_UNDERSCORE = 523;
    public static final int VK_FINAL = 24;
    public static final int VK_CONVERT = 28;
    public static final int VK_NONCONVERT = 29;
    public static final int VK_ACCEPT = 30;
    public static final int VK_MODECHANGE = 31;
    public static final int VK_KANA = 21;
    public static final int VK_KANJI = 25;
    public static final int VK_ALPHANUMERIC = 240;
    public static final int VK_KATAKANA = 241;
    public static final int VK_HIRAGANA = 242;
    public static final int VK_FULL_WIDTH = 243;
    public static final int VK_HALF_WIDTH = 244;
    public static final int VK_ROMAN_CHARACTERS = 245;
    public static final int VK_ALL_CANDIDATES = 256;
    public static final int VK_PREVIOUS_CANDIDATE = 257;
    public static final int VK_CODE_INPUT = 258;
    public static final int VK_JAPANESE_KATAKANA = 259;
    public static final int VK_JAPANESE_HIRAGANA = 260;
    public static final int VK_JAPANESE_ROMAN = 261;
    public static final int VK_KANA_LOCK = 262;
    public static final int VK_INPUT_METHOD_ON_OFF = 263;
    public static final int VK_CUT = 65489;
    public static final int VK_COPY = 65485;
    public static final int VK_PASTE = 65487;
    public static final int VK_UNDO = 65483;
    public static final int VK_AGAIN = 65481;
    public static final int VK_FIND = 65488;
    public static final int VK_PROPS = 65482;
    public static final int VK_STOP = 65480;
    public static final int VK_COMPOSE = 65312;
    public static final int VK_ALT_GRAPH = 65406;
    public static final int VK_BEGIN = 65368;
    public static final int VK_CONTEXT_MENU = 525;
    public static final int VK_WINDOWS = 524;
    public static final int VK_UNDEFINED = 0;
    public static final char CHAR_UNDEFINED = '\uffff';
    public static final int KEY_LOCATION_UNKNOWN = 0;
    public static final int KEY_LOCATION_STANDARD = 1;
    public static final int KEY_LOCATION_LEFT = 2;
    public static final int KEY_LOCATION_RIGHT = 3;
    public static final int KEY_LOCATION_NUMPAD = 4;
    private int keyCode;
    private char keyChar;
    private final int keyLocation;
    private boolean isProxyActive;

    public KeyEvent(Component component, int n, long l, int n2, int n3, char c, int n4) {
        super(component, n, l, n2);
        this.keyCode = n3;
        this.keyChar = c;
        this.keyLocation = n4;
        if (n == 400 && (n3 != 0 || c == '\uffff') || n4 < 0 || n4 > 4) {
            throw new IllegalArgumentException();
        }
    }

    public KeyEvent(Component component, int n, long l, int n2, int n3, char c) {
        this(component, n, l, n2, n3, c, 0);
    }

    public KeyEvent(Component component, int n, long l, int n2, int n3) {
        this(component, n, l, n2, n3, '\u0000', 0);
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int n) {
        this.keyCode = n;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public void setKeyChar(char c) {
        this.keyChar = c;
    }

    public void setModifiers(int n) {
        this.modifiers = EventModifier.extend(n);
    }

    public int getKeyLocation() {
        return this.keyLocation;
    }

    public static String getKeyText(int n) {
        switch (n) {
            case 3: {
                return "Cancel";
            }
            case 8: {
                return "Backspace";
            }
            case 9: {
                return "Tab";
            }
            case 10: {
                return "Enter";
            }
            case 12: {
                return "Clear";
            }
            case 16: {
                return "Shift";
            }
            case 17: {
                return "Ctrl";
            }
            case 18: {
                return "Alt";
            }
            case 19: {
                return "Pause";
            }
            case 20: {
                return "Caps Lock";
            }
            case 21: {
                return "Kana";
            }
            case 24: {
                return "Final";
            }
            case 25: {
                return "Kanji";
            }
            case 27: {
                return "Escape";
            }
            case 28: {
                return "Convert";
            }
            case 29: {
                return "No Convert";
            }
            case 30: {
                return "Accept";
            }
            case 31: {
                return "Mode Change";
            }
            case 32: {
                return "Space";
            }
            case 33: {
                return "Page Up";
            }
            case 34: {
                return "Page Down";
            }
            case 35: {
                return "End";
            }
            case 36: {
                return "Home";
            }
            case 37: 
            case 226: {
                return "Left";
            }
            case 38: 
            case 224: {
                return "Up";
            }
            case 39: 
            case 227: {
                return "Right";
            }
            case 40: 
            case 225: {
                return "Down";
            }
            case 45: {
                return "Minus";
            }
            case 106: {
                return "NumPad *";
            }
            case 107: {
                return "NumPad +";
            }
            case 108: {
                return "NumPad ,";
            }
            case 109: {
                return "NumPad -";
            }
            case 110: {
                return "NumPad .";
            }
            case 111: {
                return "NumPad /";
            }
            case 127: {
                return "Delete";
            }
            case 128: {
                return "Dead Grave";
            }
            case 129: {
                return "Dead Acute";
            }
            case 130: {
                return "Dead Circumflex";
            }
            case 131: {
                return "Dead Tilde";
            }
            case 132: {
                return "Dead Macron";
            }
            case 133: {
                return "Dead Breve";
            }
            case 134: {
                return "Dead Above Dot";
            }
            case 135: {
                return "Dead Diaeresis";
            }
            case 136: {
                return "Dead Above Ring";
            }
            case 137: {
                return "Dead Double Acute";
            }
            case 138: {
                return "Dead Caron";
            }
            case 139: {
                return "Dead Cedilla";
            }
            case 140: {
                return "Dead Ogonek";
            }
            case 141: {
                return "Dead Iota";
            }
            case 142: {
                return "Dead Voiced Sound";
            }
            case 143: {
                return "Dead Semivoiced Sound";
            }
            case 144: {
                return "Num Lock";
            }
            case 145: {
                return "Scroll Lock";
            }
            case 150: {
                return "Ampersand";
            }
            case 151: {
                return "Asterisk";
            }
            case 152: {
                return "Double Quote";
            }
            case 153: {
                return "Less";
            }
            case 154: {
                return "Print Screen";
            }
            case 155: {
                return "Insert";
            }
            case 156: {
                return "Help";
            }
            case 157: {
                return "Meta";
            }
            case 160: {
                return "Greater";
            }
            case 161: {
                return "Left Brace";
            }
            case 162: {
                return "Right Brace";
            }
            case 192: {
                return "Back Quote";
            }
            case 222: {
                return "Quote";
            }
            case 240: {
                return "Alphanumeric";
            }
            case 241: {
                return "Katakana";
            }
            case 242: {
                return "Hiragana";
            }
            case 243: {
                return "Full-Width";
            }
            case 244: {
                return "Half-Width";
            }
            case 245: {
                return "Roman Characters";
            }
            case 256: {
                return "All Candidates";
            }
            case 257: {
                return "Previous Candidate";
            }
            case 258: {
                return "Code Input";
            }
            case 259: {
                return "Japanese Katakana";
            }
            case 260: {
                return "Japanese Hiragana";
            }
            case 261: {
                return "Japanese Roman";
            }
            case 262: {
                return "Kana Lock";
            }
            case 263: {
                return "Input Method On/Off";
            }
            case 512: {
                return "At";
            }
            case 513: {
                return "Colon";
            }
            case 514: {
                return "Circumflex";
            }
            case 515: {
                return "Dollar";
            }
            case 516: {
                return "Euro";
            }
            case 517: {
                return "Exclamation Mark";
            }
            case 518: {
                return "Inverted Exclamation Mark";
            }
            case 519: {
                return "Left Parenthesis";
            }
            case 520: {
                return "Number Sign";
            }
            case 521: {
                return "Plus";
            }
            case 522: {
                return "Right Parenthesis";
            }
            case 523: {
                return "Underscore";
            }
            case 65312: {
                return "Compose";
            }
            case 65406: {
                return "Alt Graph";
            }
            case 65480: {
                return "Stop";
            }
            case 65481: {
                return "Again";
            }
            case 65482: {
                return "Props";
            }
            case 65483: {
                return "Undo";
            }
            case 65485: {
                return "Copy";
            }
            case 65487: {
                return "Paste";
            }
            case 65488: {
                return "Find";
            }
            case 65489: {
                return "Cut";
            }
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                return "" + (char)n;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return "NumPad-" + (n - 96);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return "F" + (n - 111);
            }
            case 61440: 
            case 61441: 
            case 61442: 
            case 61443: 
            case 61444: 
            case 61445: 
            case 61446: 
            case 61447: 
            case 61448: 
            case 61449: 
            case 61450: 
            case 61451: {
                return "F" + (n - 61427);
            }
        }
        return "Unknown keyCode: 0x" + (n < 0 ? "-" : "") + Integer.toHexString(Math.abs(n));
    }

    public static String getKeyModifiersText(int n) {
        return InputEvent.getModifiersExText(EventModifier.extend(n & 0x3F));
    }

    public boolean isActionKey() {
        switch (this.keyCode) {
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 144: 
            case 145: 
            case 154: 
            case 155: 
            case 156: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 61440: 
            case 61441: 
            case 61442: 
            case 61443: 
            case 61444: 
            case 61445: 
            case 61446: 
            case 61447: 
            case 61448: 
            case 61449: 
            case 61450: 
            case 61451: 
            case 65480: 
            case 65481: 
            case 65482: 
            case 65483: 
            case 65485: 
            case 65487: 
            case 65488: 
            case 65489: {
                return true;
            }
        }
        return false;
    }

    public String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.id) {
            case 401: {
                stringBuffer.append("KEY_PRESSED");
                break;
            }
            case 402: {
                stringBuffer.append("KEY_RELEASED");
                break;
            }
            case 400: {
                stringBuffer.append("KEY_TYPED");
                break;
            }
            default: {
                stringBuffer.append("unknown type");
            }
        }
        stringBuffer.append(",keyCode=").append(this.keyCode);
        stringBuffer.append(",keyText=").append(KeyEvent.getKeyText(this.keyCode));
        stringBuffer.append(",keyChar=");
        if (this.isActionKey() || this.keyCode == 16 || this.keyCode == 17 || this.keyCode == 18) {
            stringBuffer.append("Undefined keyChar");
        } else if (this.keyChar == '\b' || this.keyChar == '\t' || this.keyChar == '\n' || this.keyChar == '\u001b' || this.keyChar == '\u007f') {
            stringBuffer.append(KeyEvent.getKeyText(this.keyChar));
        } else {
            stringBuffer.append("'").append(this.keyChar).append("'");
        }
        if ((this.modifiers & 0x27C0) != 0) {
            stringBuffer.append(",modifiers=").append(InputEvent.getModifiersExText(this.modifiers & 0x27C0));
        }
        if (this.modifiers != 0) {
            stringBuffer.append(",extModifiers=").append(InputEvent.getModifiersExText(this.modifiers));
        }
        stringBuffer.append(",keyLocation=KEY_LOCATION_");
        switch (this.keyLocation) {
            case 0: {
                stringBuffer.append("UNKNOWN");
                break;
            }
            case 1: {
                stringBuffer.append("STANDARD");
                break;
            }
            case 2: {
                stringBuffer.append("LEFT");
                break;
            }
            case 3: {
                stringBuffer.append("RIGHT");
                break;
            }
            case 4: {
                stringBuffer.append("NUMPAD");
            }
        }
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.modifiersEx = EventModifier.extend(this.modifiers) & 0x3FC0;
    }
}

