/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

public class List
extends Component
implements ItemSelectable,
Accessible {
    private static transient long next_list_number;
    private static final long serialVersionUID = -3304312411574666869L;
    private Vector items;
    private boolean multipleMode;
    private int rows;
    private int[] selected;
    private int visibleIndex;
    private ItemListener item_listeners;
    private ActionListener action_listeners;

    private /* synthetic */ void finit$() {
        this.items = new Vector();
    }

    public List() {
        this(4, false);
    }

    public List(int n) {
        this(n, false);
    }

    public List(int n, boolean bl) {
        this.finit$();
        this.rows = n == 0 ? 4 : n;
        this.multipleMode = bl;
        this.selected = new int[0];
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public synchronized String[] getItems() {
        Object[] objectArray = new String[this.getItemCount()];
        this.items.copyInto(objectArray);
        return objectArray;
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public void setMultipleSelections(boolean bl) {
        this.multipleMode = bl;
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.setMultipleMode(bl);
        }
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getRows());
    }

    public Dimension minimumSize() {
        return this.minimumSize(this.getRows());
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            return listPeer.minimumSize(n);
        }
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getRows());
    }

    public Dimension preferredSize() {
        return this.preferredSize(this.getRows());
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension preferredSize(int n) {
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            return listPeer.preferredSize(n);
        }
        return this.getSize();
    }

    public void add(String string) {
        this.add(string, -1);
    }

    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public void addItem(String string, int n) {
        if (n == -1 || n >= this.items.size()) {
            this.items.addElement(string);
        } else {
            this.items.insertElementAt(string, n);
        }
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.add(string, n);
        }
    }

    public void delItem(int n) throws IllegalArgumentException {
        this.items.removeElementAt(n);
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.delItems(n, n);
        }
    }

    public void remove(int n) throws IllegalArgumentException {
        this.delItem(n);
    }

    public synchronized void delItems(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n >= this.items.size()) {
            throw new IllegalArgumentException("Bad list start index value: " + n);
        }
        if (n < 0 || n >= this.items.size()) {
            throw new IllegalArgumentException("Bad list start index value: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("Start is greater than end!");
        }
        for (int i = n2; i >= n; --i) {
            this.items.removeElementAt(i);
        }
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            listPeer.delItems(n, n2);
        }
    }

    public synchronized void remove(String string) throws IllegalArgumentException {
        int n = this.items.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("List element to delete not found");
        }
        this.remove(n);
    }

    public synchronized void removeAll() {
        this.clear();
    }

    public void clear() {
        this.items.clear();
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.removeAll();
        }
    }

    public synchronized void replaceItem(String string, int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.items.size()) {
            throw new ArrayIndexOutOfBoundsException("Bad list index: " + n);
        }
        this.items.insertElementAt(string, n + 1);
        this.items.removeElementAt(n);
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            listPeer.add(string, n + 1);
            listPeer.delItems(n, n);
        }
    }

    public synchronized int getSelectedIndex() {
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            this.selected = listPeer.getSelectedIndexes();
        }
        if (this.selected == null || this.selected.length != 1) {
            return -1;
        }
        return this.selected[0];
    }

    public synchronized int[] getSelectedIndexes() {
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            this.selected = listPeer.getSelectedIndexes();
        }
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return (String)this.items.elementAt(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[nArray.length];
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)this.items.elementAt(nArray[i]);
            }
        }
        return stringArray;
    }

    public synchronized Object[] getSelectedObjects() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[nArray.length];
        if (objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.items.elementAt(nArray[i]);
            }
        }
        return objectArray;
    }

    public boolean isIndexSelected(int n) {
        return this.isSelected(n);
    }

    public boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    public synchronized void makeVisible(int n) throws IllegalArgumentException {
        this.visibleIndex = n;
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            listPeer.makeVisible(n);
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void select(int n) {
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.select(n);
        }
    }

    public synchronized void deselect(int n) {
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.deselect(n);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createList(this);
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, actionListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, itemListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(actionEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(itemEvent);
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 701 && aWTEvent.id >= 701 && (this.item_listeners != null || (this.eventMask & (long)512) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id <= 1001 && aWTEvent.id >= 1001 && (this.action_listeners != null || (this.eventMask & (long)128) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    protected String paramString() {
        return "multiple=" + this.multipleMode + ",rows=" + this.rows + super.paramString();
    }

    public EventListener[] getListeners(Class clazz) {
        if (clazz == List.class$("java.awt.event.ActionListener")) {
            return AWTEventMulticaster.getListeners(this.action_listeners, clazz);
        }
        if (clazz == List.class$("java.awt.event.ItemListener")) {
            return AWTEventMulticaster.getListeners(this.item_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(List.class$("java.awt.event.ActionListener"));
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(List.class$("java.awt.event.ItemListener"));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTList(this);
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "list" + List.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_list_number++;
    }

    protected class AccessibleAWTList
    extends Component.AccessibleAWTComponent
    implements AccessibleSelection,
    ItemListener,
    ActionListener {
        private /* synthetic */ List this$0;
        private static final long serialVersionUID = 7924617370136012829L;

        static List access$0(AccessibleAWTList accessibleAWTList) {
            return accessibleAWTList.this$0;
        }

        public AccessibleAWTList(List list2) {
            this.this$0 = list2;
            super(list2);
            list2.addItemListener(this);
            list2.addActionListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (this.this$0.isMultipleMode()) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public int getAccessibleChildrenCount() {
            return this.this$0.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n >= this.this$0.getItemCount()) {
                return null;
            }
            return new AccessibleAWTListChild(this, this.this$0, n);
        }

        public int getAccessibleSelectionCount() {
            return this.this$0.getSelectedIndexes().length;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            int[] nArray = this.this$0.getSelectedIndexes();
            if (n >= nArray.length) {
                return null;
            }
            return new AccessibleAWTListChild(this, this.this$0, nArray[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return this.this$0.isIndexSelected(n);
        }

        public void addAccessibleSelection(int n) {
            this.this$0.select(n);
        }

        public void removeAccessibleSelection(int n) {
            this.this$0.deselect(n);
        }

        public void clearAccessibleSelection() {
            for (int i = 0; i < this.this$0.getItemCount(); ++i) {
                this.this$0.deselect(i);
            }
        }

        public void selectAllAccessibleSelection() {
            if (this.this$0.isMultipleMode()) {
                for (int i = 0; i < this.this$0.getItemCount(); ++i) {
                    this.this$0.select(i);
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        protected class AccessibleAWTListChild
        extends Component.AccessibleAWTComponent
        implements Accessible {
            private /* synthetic */ AccessibleAWTList this$1;
            private static final long serialVersionUID = 4412022926028300317L;
            private List parent;
            private int indexInParent;

            public AccessibleAWTListChild(AccessibleAWTList accessibleAWTList, List list2, int n) {
                this.this$1 = accessibleAWTList;
                super(AccessibleAWTList.access$0(accessibleAWTList));
                this.parent = list2;
                this.indexInParent = n;
                if (list2 == null) {
                    this.indexInParent = -1;
                }
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
                if (this.parent.isIndexSelected(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                return accessibleStateSet;
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }
        }
    }
}

