/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class PrinterDialog
extends JDialog
implements ActionListener {
    private JButton ok_bt;
    private JButton cancel_bt;
    private GeneralPanel general_panel;
    private PageSetupPanel pagesetup_panel;
    private AppearancePanel appearance_panel;
    private PrintService[] services;
    private PrintService defaultService;
    private PrintService selectedService;
    private DocFlavor flavor;
    private PrintRequestAttributeSet attributes;
    private boolean onlyPageDialog;
    private PrintRequestAttributeSet atts;
    private static final ResourceBundle messages = ResourceBundle.getBundle("gnu/javax/print/PrinterDialog");

    static /* synthetic */ DocFlavor access$4(PrinterDialog printerDialog, DocFlavor docFlavor) {
        printerDialog.flavor = docFlavor;
        return printerDialog.flavor;
    }

    static /* synthetic */ PrintRequestAttributeSet access$1(PrinterDialog printerDialog, PrintRequestAttributeSet printRequestAttributeSet) {
        printerDialog.atts = printRequestAttributeSet;
        return printerDialog.atts;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private PrinterDialog(GraphicsConfiguration graphicsConfiguration, PrintService[] printServiceArray, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet, boolean bl, String string) throws HeadlessException {
        super((Frame)null, string, true, graphicsConfiguration);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        if (docFlavor != null) {
            ArrayList arrayList = new ArrayList(printServiceArray.length);
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (!printServiceArray[i].isDocFlavorSupported(docFlavor)) continue;
                arrayList.add(printServiceArray[i]);
            }
            if (printService != null && !arrayList.contains(printService)) {
                printService = (PrintService)arrayList.get(0);
            }
            Object[] objectArray = new PrintService[arrayList.size()];
            this.services = (PrintService[])arrayList.toArray(objectArray);
        } else {
            this.services = printServiceArray;
        }
        this.defaultService = printService == null ? printServiceArray[0] : printService;
        this.selectedService = this.defaultService;
        this.flavor = docFlavor;
        this.attributes = printRequestAttributeSet;
        this.atts = new HashPrintRequestAttributeSet(printRequestAttributeSet);
        this.onlyPageDialog = bl;
        this.initUI(bl);
        this.pack();
        this.updateAll();
    }

    public PrinterDialog(GraphicsConfiguration graphicsConfiguration, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        this(graphicsConfiguration, new PrintService[]{printService}, printService, docFlavor, printRequestAttributeSet, true, PrinterDialog.getLocalizedString("title.pagedialog"));
    }

    public PrinterDialog(GraphicsConfiguration graphicsConfiguration, PrintService[] printServiceArray, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) throws HeadlessException {
        this(graphicsConfiguration, printServiceArray, printService, docFlavor, printRequestAttributeSet, false, PrinterDialog.getLocalizedString("title.printdialog"));
    }

    private void initUI(boolean bl) {
        JPanel jPanel = new JPanel();
        if (bl) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            this.pagesetup_panel = new PageSetupPanel(this);
            jPanel2.add((Component)this.pagesetup_panel, "Center");
            this.ok_bt = new JButton(PrinterDialog.getLocalizedString("bt.OK"));
            this.ok_bt.addActionListener(this);
            this.cancel_bt = new JButton(PrinterDialog.getLocalizedString("bt.cancel"));
            this.cancel_bt.addActionListener(this);
            this.getContentPane().add((Component)jPanel2, "Center");
        } else {
            this.general_panel = new GeneralPanel(this);
            this.pagesetup_panel = new PageSetupPanel(this);
            this.appearance_panel = new AppearancePanel(this);
            JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.ok_bt = new JButton(PrinterDialog.getLocalizedString("bt.print"));
            this.ok_bt.addActionListener(this);
            this.cancel_bt = new JButton(PrinterDialog.getLocalizedString("bt.cancel"));
            this.cancel_bt.addActionListener(this);
            jTabbedPane.addTab(PrinterDialog.getLocalizedString("tab.general"), this.general_panel);
            jTabbedPane.addTab(PrinterDialog.getLocalizedString("tab.pagesetup"), this.pagesetup_panel);
            jTabbedPane.addTab(PrinterDialog.getLocalizedString("tab.appearance"), this.appearance_panel);
            this.getContentPane().add((Component)jTabbedPane, "Center");
        }
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.ok_bt);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.cancel_bt);
        this.getContentPane().add((Component)jPanel, "Last");
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    public PrintService getSelectedPrintService() {
        return this.selectedService;
    }

    protected void setSelectedPrintService(PrintService printService) {
        this.selectedService = printService;
    }

    protected PrintService[] getPrintServices() {
        return this.services;
    }

    void updateAll() {
        this.pagesetup_panel.update();
        if (!this.onlyPageDialog) {
            this.general_panel.update();
            this.appearance_panel.update();
        }
    }

    boolean categorySupported(Class clazz) {
        return this.getSelectedPrintService().isAttributeCategorySupported(clazz);
    }

    Object defaultValue(Class clazz) {
        return this.getSelectedPrintService().getDefaultAttributeValue(clazz);
    }

    Attribute attribute(Class clazz) {
        return this.atts.get(clazz);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok_bt) {
            this.setVisible(false);
            this.attributes.addAll(this.atts);
            this.dispose();
        } else {
            this.setVisible(false);
            this.selectedService = null;
            this.dispose();
        }
    }

    static final String getLocalizedString(String string) {
        return messages.getString(string);
    }

    final class AppearancePanel
    extends JPanel {
        private /* synthetic */ PrinterDialog this$0;
        private Quality quality_panel;
        private JobAttributes jobAttr_panel;
        private SidesPanel sides_panel;
        private Color chromaticy_panel;

        static /* synthetic */ PrinterDialog access$2(AppearancePanel appearancePanel, PrinterDialog printerDialog) {
            appearancePanel.this$0 = printerDialog;
            return appearancePanel.this$0;
        }

        static PrinterDialog access$0(AppearancePanel appearancePanel) {
            return appearancePanel.this$0;
        }

        public AppearancePanel(PrinterDialog printerDialog) {
            this.this$0 = printerDialog;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.quality_panel = new Quality(this);
            this.jobAttr_panel = new JobAttributes(this);
            this.sides_panel = new SidesPanel(this);
            this.chromaticy_panel = new Color(this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jPanel.add(this.chromaticy_panel);
            jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel.add(this.quality_panel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 2));
            jPanel2.add(this.sides_panel);
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel2.add(this.jobAttr_panel);
            this.setLayout(new BoxLayout(this, 3));
            this.add(jPanel);
            this.add(Box.createRigidArea(new Dimension(0, 12)));
            this.add(jPanel2);
        }

        void update() {
            this.quality_panel.updateForSelectedService();
            this.jobAttr_panel.updateForSelectedService();
            this.sides_panel.updateForSelectedService();
            this.chromaticy_panel.updateForSelectedService();
        }

        final class Color
        extends JPanel
        implements ActionListener {
            private /* synthetic */ AppearancePanel this$1;
            private JRadioButton bw = new JRadioButton(PrinterDialog.getLocalizedString("rbt.blackwhite"));
            private JRadioButton color;

            Color(AppearancePanel appearancePanel) {
                this.this$1 = appearancePanel;
                this.bw.addActionListener(this);
                this.color = new JRadioButton(PrinterDialog.getLocalizedString("rbt.color"));
                this.color.addActionListener(this);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.bw);
                buttonGroup.add(this.color);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.color")));
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.bw, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.color, gridBagConstraints);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.bw) {
                    AppearancePanel.access$0(this.this$1).atts.add(Chromaticity.MONOCHROME);
                } else {
                    AppearancePanel.access$0(this.this$1).atts.add(Chromaticity.COLOR);
                }
            }

            void updateForSelectedService() {
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.Chromaticity"))) {
                    this.bw.setEnabled(true);
                    this.color.setEnabled(true);
                    Object object = this.this$1.this$0.defaultValue(PrinterDialog.class$("javax.print.attribute.standard.Chromaticity"));
                    Attribute attribute = this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.Chromaticity"));
                    if (attribute != null) {
                        if (attribute.equals(Chromaticity.MONOCHROME)) {
                            this.bw.setSelected(true);
                        } else {
                            this.color.setSelected(true);
                        }
                    } else if (object.equals(Chromaticity.MONOCHROME)) {
                        this.bw.setSelected(true);
                    } else {
                        this.color.setSelected(true);
                    }
                } else {
                    this.bw.setEnabled(false);
                    this.color.setEnabled(false);
                }
            }
        }

        final class SidesPanel
        extends JPanel
        implements ActionListener {
            private /* synthetic */ AppearancePanel this$1;
            private JRadioButton oneside = new JRadioButton(PrinterDialog.getLocalizedString("rbt.onesided"));
            private JRadioButton calendar;
            private JRadioButton duplex;

            SidesPanel(AppearancePanel appearancePanel) {
                this.this$1 = appearancePanel;
                this.oneside.addActionListener(this);
                this.calendar = new JRadioButton(PrinterDialog.getLocalizedString("rbt.calendar"));
                this.calendar.addActionListener(this);
                this.duplex = new JRadioButton(PrinterDialog.getLocalizedString("rbt.duplex"));
                this.duplex.addActionListener(this);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.oneside);
                buttonGroup.add(this.calendar);
                buttonGroup.add(this.duplex);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.sides")));
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.oneside, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.calendar, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                this.add((Component)this.duplex, gridBagConstraints);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.calendar) {
                    AppearancePanel.access$0(this.this$1).atts.add(Sides.TWO_SIDED_SHORT_EDGE);
                } else if (actionEvent.getSource() == this.oneside) {
                    AppearancePanel.access$0(this.this$1).atts.add(Sides.ONE_SIDED);
                } else {
                    AppearancePanel.access$0(this.this$1).atts.add(Sides.TWO_SIDED_LONG_EDGE);
                }
            }

            void updateForSelectedService() {
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.Sides"))) {
                    this.oneside.setEnabled(true);
                    this.calendar.setEnabled(true);
                    this.duplex.setEnabled(true);
                    Object object = this.this$1.this$0.defaultValue(PrinterDialog.class$("javax.print.attribute.standard.Sides"));
                    Attribute attribute = this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.Sides"));
                    if (attribute != null) {
                        if (attribute.equals(Sides.TWO_SIDED_SHORT_EDGE)) {
                            this.calendar.setSelected(true);
                        } else if (attribute.equals(Sides.ONE_SIDED)) {
                            this.oneside.setSelected(true);
                        } else {
                            this.duplex.setSelected(true);
                        }
                    } else if (object.equals(Sides.TWO_SIDED_SHORT_EDGE)) {
                        this.calendar.setSelected(true);
                    } else if (object.equals(Sides.ONE_SIDED)) {
                        this.oneside.setSelected(true);
                    } else {
                        this.duplex.setSelected(true);
                    }
                } else {
                    this.oneside.setEnabled(false);
                    this.calendar.setEnabled(false);
                    this.duplex.setEnabled(false);
                }
            }
        }

        final class JobAttributes
        extends JPanel
        implements ActionListener,
        ChangeListener,
        FocusListener {
            private /* synthetic */ AppearancePanel this$1;
            private JLabel jobname = new JLabel(PrinterDialog.getLocalizedString("lb.jobname"));
            private JLabel username = new JLabel(PrinterDialog.getLocalizedString("lb.username"));
            private JLabel priority_lb = new JLabel(PrinterDialog.getLocalizedString("lb.priority"));
            private JTextField jobname_tf;
            private JTextField username_tf;
            private JCheckBox cover = new JCheckBox(PrinterDialog.getLocalizedString("cb.cover"));
            private JSpinner priority;
            private SpinnerNumberModel model;

            JobAttributes(AppearancePanel appearancePanel) {
                this.this$1 = appearancePanel;
                this.cover.addActionListener(this);
                this.model = new SpinnerNumberModel(1, 1, 100, 1);
                this.priority = new JSpinner(this.model);
                this.priority.addChangeListener(this);
                this.jobname_tf = new JTextField();
                this.jobname_tf.addFocusListener(this);
                this.username_tf = new JTextField();
                this.username_tf.addFocusListener(this);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.jobattributes")));
                gridBagConstraints.insets = new Insets(10, 5, 10, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.cover, gridBagConstraints);
                gridBagConstraints.anchor = 22;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 2.0;
                this.add((Component)this.priority_lb, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 0.5;
                this.add((Component)this.priority, gridBagConstraints);
                gridBagConstraints.anchor = 22;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.jobname, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                this.add((Component)this.username, gridBagConstraints);
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.weightx = 1.5;
                this.add((Component)this.jobname_tf, gridBagConstraints);
                gridBagConstraints.insets = new Insets(10, 5, 15, 5);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                this.add((Component)this.username_tf, gridBagConstraints);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.cover.isSelected()) {
                    AppearancePanel.access$0(this.this$1).atts.add(JobSheets.STANDARD);
                } else {
                    AppearancePanel.access$0(this.this$1).atts.add(JobSheets.NONE);
                }
            }

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)this.priority.getValue();
                AppearancePanel.access$0(this.this$1).atts.add(new JobPriority(n));
            }

            public void focusGained(FocusEvent focusEvent) {
                this.updateTextfields(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                this.updateTextfields(focusEvent);
            }

            private void updateTextfields(FocusEvent focusEvent) {
                if (focusEvent.getSource() == this.jobname_tf) {
                    AppearancePanel.access$0(this.this$1).atts.add(new JobName(this.jobname_tf.getText(), null));
                } else {
                    AppearancePanel.access$0(this.this$1).atts.add(new RequestingUserName(this.username_tf.getText(), null));
                }
            }

            void updateForSelectedService() {
                Object object;
                Attribute attribute;
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.JobPriority"))) {
                    attribute = (JobPriority)this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.JobPriority"));
                    object = (JobPriority)this.this$1.this$0.defaultValue(PrinterDialog.class$("javax.print.attribute.standard.JobPriority"));
                    this.priority.setEnabled(true);
                    if (attribute != null) {
                        this.model.setValue(new Integer(((IntegerSyntax)((Object)attribute)).getValue()));
                    } else {
                        this.model.setValue(new Integer(((IntegerSyntax)object).getValue()));
                    }
                } else {
                    this.priority.setEnabled(false);
                }
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.RequestingUserName"))) {
                    attribute = this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.RequestingUserName"));
                    object = this.this$1.this$0.defaultValue(PrinterDialog.class$("javax.print.attribute.standard.RequestingUserName"));
                    this.username.setEnabled(true);
                    if (attribute != null) {
                        this.username_tf.setText(attribute.toString());
                    } else {
                        this.username_tf.setText(object.toString());
                    }
                } else {
                    this.username.setEnabled(false);
                }
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.JobName"))) {
                    attribute = this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.JobName"));
                    object = this.this$1.this$0.defaultValue(PrinterDialog.class$("javax.print.attribute.standard.JobName"));
                    this.jobname.setEnabled(true);
                    if (attribute != null) {
                        this.jobname_tf.setText(attribute.toString());
                    } else {
                        this.jobname_tf.setText(object.toString());
                    }
                } else {
                    this.jobname.setEnabled(false);
                }
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.JobSheets"))) {
                    attribute = this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.JobSheets"));
                    object = this.this$1.this$0.defaultValue(PrinterDialog.class$("javax.print.attribute.standard.JobSheets"));
                    this.cover.setEnabled(true);
                    if (attribute != null) {
                        if (attribute.equals(JobSheets.NONE)) {
                            this.cover.setSelected(false);
                        } else {
                            this.cover.setSelected(true);
                        }
                    } else if (object.equals(JobSheets.NONE)) {
                        this.cover.setSelected(false);
                    } else {
                        this.cover.setSelected(true);
                    }
                } else {
                    this.cover.setEnabled(false);
                }
            }
        }

        final class Quality
        extends JPanel
        implements ActionListener {
            private /* synthetic */ AppearancePanel this$1;
            private JRadioButton low = new JRadioButton(PrinterDialog.getLocalizedString("rbt.low"));
            private JRadioButton normal;
            private JRadioButton high;
            private ButtonGroup group;

            Quality(AppearancePanel appearancePanel) {
                this.this$1 = appearancePanel;
                this.low.addActionListener(this);
                this.normal = new JRadioButton(PrinterDialog.getLocalizedString("rbt.normal"));
                this.normal.addActionListener(this);
                this.high = new JRadioButton(PrinterDialog.getLocalizedString("rbt.high"));
                this.high.addActionListener(this);
                this.group = new ButtonGroup();
                this.group.add(this.low);
                this.group.add(this.normal);
                this.group.add(this.high);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.quality")));
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.low, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.normal, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                this.add((Component)this.high, gridBagConstraints);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.low) {
                    AppearancePanel.access$0(this.this$1).atts.add(PrintQuality.DRAFT);
                } else if (actionEvent.getSource() == this.normal) {
                    AppearancePanel.access$0(this.this$1).atts.add(PrintQuality.NORMAL);
                } else {
                    AppearancePanel.access$0(this.this$1).atts.add(PrintQuality.HIGH);
                }
            }

            void updateForSelectedService() {
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.PrintQuality"))) {
                    this.low.setEnabled(true);
                    this.normal.setEnabled(true);
                    this.high.setEnabled(true);
                    Object object = this.this$1.this$0.defaultValue(PrinterDialog.class$("javax.print.attribute.standard.PrintQuality"));
                    Attribute attribute = this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.PrintQuality"));
                    if (attribute != null) {
                        if (attribute.equals(PrintQuality.DRAFT)) {
                            this.low.setSelected(true);
                        } else if (attribute.equals(PrintQuality.NORMAL)) {
                            this.normal.setSelected(true);
                        } else {
                            this.high.setSelected(true);
                        }
                    } else if (object.equals(PrintQuality.DRAFT)) {
                        this.low.setSelected(true);
                    } else if (object.equals(PrintQuality.NORMAL)) {
                        this.normal.setSelected(true);
                    } else {
                        this.high.setSelected(true);
                    }
                } else {
                    this.low.setEnabled(false);
                    this.normal.setEnabled(false);
                    this.high.setEnabled(false);
                }
            }
        }
    }

    final class PageSetupPanel
    extends JPanel {
        private /* synthetic */ PrinterDialog this$0;
        private MediaTypes media_panel;
        private Orientation orientation_panel;
        private Margins margins_panel;

        static /* synthetic */ PrinterDialog access$3(PageSetupPanel pageSetupPanel, PrinterDialog printerDialog) {
            pageSetupPanel.this$0 = printerDialog;
            return pageSetupPanel.this$0;
        }

        static PrinterDialog access$0(PageSetupPanel pageSetupPanel) {
            return pageSetupPanel.this$0;
        }

        public PageSetupPanel(PrinterDialog printerDialog) {
            this.this$0 = printerDialog;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.media_panel = new MediaTypes(this);
            this.orientation_panel = new Orientation(this);
            this.margins_panel = new Margins(this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jPanel.add(this.orientation_panel);
            jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel.add(this.margins_panel);
            this.setLayout(new BoxLayout(this, 3));
            this.add(this.media_panel);
            this.add(Box.createRigidArea(new Dimension(0, 12)));
            this.add(jPanel);
        }

        void update() {
            this.media_panel.updateForSelectedService();
            this.orientation_panel.updateForSelectedService();
            this.margins_panel.updateForSelectedService();
        }

        final class Margins
        extends JPanel
        implements FocusListener {
            private /* synthetic */ PageSetupPanel this$1;
            private JLabel left = new JLabel(PrinterDialog.getLocalizedString("lb.left"));
            private JLabel right = new JLabel(PrinterDialog.getLocalizedString("lb.right"));
            private JLabel top = new JLabel(PrinterDialog.getLocalizedString("lb.top"));
            private JLabel bottom = new JLabel(PrinterDialog.getLocalizedString("lb.bottom"));
            private JTextField left_tf = new JTextField(7);
            private JTextField right_tf;
            private JTextField top_tf;
            private JTextField bottom_tf;

            Margins(PageSetupPanel pageSetupPanel) {
                this.this$1 = pageSetupPanel;
                this.left_tf.addFocusListener(this);
                this.right_tf = new JTextField(7);
                this.right_tf.addFocusListener(this);
                this.top_tf = new JTextField(7);
                this.top_tf.addFocusListener(this);
                this.bottom_tf = new JTextField(7);
                this.bottom_tf.addFocusListener(this);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.margins")));
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.left, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.right, gridBagConstraints);
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.left_tf, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.right_tf, gridBagConstraints);
                gridBagConstraints.insets = new Insets(10, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                this.add((Component)this.top, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                this.add((Component)this.bottom, gridBagConstraints);
                gridBagConstraints.insets = new Insets(0, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                this.add((Component)this.top_tf, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                this.add((Component)this.bottom_tf, gridBagConstraints);
            }

            public void focusGained(FocusEvent focusEvent) {
                this.updateMargins();
            }

            public void focusLost(FocusEvent focusEvent) {
                this.updateMargins();
            }

            private void updateMargins() {
            }

            void updateForSelectedService() {
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.MediaPrintableArea"))) {
                    this.left.setEnabled(true);
                    this.right.setEnabled(true);
                    this.top.setEnabled(true);
                    this.bottom.setEnabled(true);
                    this.left_tf.setEnabled(true);
                    this.right_tf.setEnabled(true);
                    this.top_tf.setEnabled(true);
                    this.bottom_tf.setEnabled(true);
                } else {
                    this.left.setEnabled(false);
                    this.right.setEnabled(false);
                    this.top.setEnabled(false);
                    this.bottom.setEnabled(false);
                    this.left_tf.setEnabled(false);
                    this.right_tf.setEnabled(false);
                    this.top_tf.setEnabled(false);
                    this.bottom_tf.setEnabled(false);
                }
            }
        }

        final class MediaTypes
        extends JPanel
        implements ActionListener {
            private /* synthetic */ PageSetupPanel this$1;
            private JLabel size_lb = new JLabel(PrinterDialog.getLocalizedString("lb.size"));
            private JLabel source_lb = new JLabel(PrinterDialog.getLocalizedString("lb.source"));
            private JComboBox size = new JComboBox();
            private JComboBox source;

            MediaTypes(PageSetupPanel pageSetupPanel) {
                this.this$1 = pageSetupPanel;
                this.size.setEditable(false);
                this.size.addActionListener(this);
                this.source = new JComboBox();
                this.source.setEditable(false);
                this.size.addActionListener(this);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.medias")));
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.anchor = 22;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.size_lb, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.source_lb, gridBagConstraints);
                gridBagConstraints.anchor = 21;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.5;
                this.add((Component)this.size, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.weightx = 1.5;
                this.add((Component)this.source, gridBagConstraints);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (actionEvent.getSource() == this.size && (object = this.size.getSelectedItem()) instanceof Media) {
                    PageSetupPanel.access$0(this.this$1).atts.add((Media)object);
                }
            }

            void updateForSelectedService() {
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.Media"))) {
                    Media[] mediaArray = (Media[])this.this$1.this$0.getSelectedPrintService().getSupportedAttributeValues(PrinterDialog.class$("javax.print.attribute.standard.Media"), PageSetupPanel.access$0(this.this$1).flavor, null);
                    this.size.removeAllItems();
                    if (mediaArray.length == 0) {
                        this.size.addItem(PrinterDialog.getLocalizedString("lb.automatically"));
                    } else {
                        for (int i = 0; i < mediaArray.length; ++i) {
                            this.size.addItem(mediaArray[i]);
                        }
                    }
                    Media media = (Media)this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.Media"));
                    if (media != null) {
                        this.size.setSelectedItem(media);
                    }
                    this.source.removeAllItems();
                    this.source.addItem(PrinterDialog.getLocalizedString("lb.automatically"));
                } else {
                    this.size.removeAllItems();
                    this.source.removeAllItems();
                    this.size.addItem(PrinterDialog.getLocalizedString("lb.automatically"));
                    this.source.addItem(PrinterDialog.getLocalizedString("lb.automatically"));
                }
            }
        }

        final class Orientation
        extends JPanel
        implements ActionListener {
            private /* synthetic */ PageSetupPanel this$1;
            private JRadioButton portrait = new JRadioButton(PrinterDialog.getLocalizedString("rbt.portrait"));
            private JRadioButton landscape;
            private JRadioButton rev_portrait;
            private JRadioButton rev_landscape;

            Orientation(PageSetupPanel pageSetupPanel) {
                this.this$1 = pageSetupPanel;
                this.portrait.addActionListener(this);
                this.landscape = new JRadioButton(PrinterDialog.getLocalizedString("rbt.landscape"));
                this.landscape.addActionListener(this);
                this.rev_portrait = new JRadioButton(PrinterDialog.getLocalizedString("rbt.revportrait"));
                this.rev_portrait.addActionListener(this);
                this.rev_landscape = new JRadioButton(PrinterDialog.getLocalizedString("rbt.revlandscape"));
                this.rev_landscape.addActionListener(this);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.portrait);
                buttonGroup.add(this.landscape);
                buttonGroup.add(this.rev_portrait);
                buttonGroup.add(this.rev_landscape);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.orientation")));
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.portrait, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.landscape, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                this.add((Component)this.rev_portrait, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                this.add((Component)this.rev_landscape, gridBagConstraints);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == this.portrait) {
                    PageSetupPanel.access$0(this.this$1).atts.add(OrientationRequested.PORTRAIT);
                } else if (actionEvent.getSource() == this.landscape) {
                    PageSetupPanel.access$0(this.this$1).atts.add(OrientationRequested.LANDSCAPE);
                } else if (actionEvent.getSource() == this.rev_portrait) {
                    PageSetupPanel.access$0(this.this$1).atts.add(OrientationRequested.REVERSE_PORTRAIT);
                } else {
                    PageSetupPanel.access$0(this.this$1).atts.add(OrientationRequested.REVERSE_LANDSCAPE);
                }
            }

            void updateForSelectedService() {
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.OrientationRequested"))) {
                    this.portrait.setEnabled(true);
                    this.landscape.setEnabled(true);
                    this.rev_landscape.setEnabled(true);
                    this.rev_portrait.setEnabled(true);
                    Attribute attribute = this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.OrientationRequested"));
                    if (attribute != null) {
                        if (attribute.equals(OrientationRequested.LANDSCAPE)) {
                            this.landscape.setSelected(true);
                        } else if (attribute.equals(OrientationRequested.PORTRAIT)) {
                            this.portrait.setSelected(true);
                        } else if (attribute.equals(OrientationRequested.REVERSE_PORTRAIT)) {
                            this.rev_portrait.setSelected(true);
                        } else {
                            this.rev_landscape.setSelected(true);
                        }
                    } else {
                        Object object = this.this$1.this$0.defaultValue(PrinterDialog.class$("javax.print.attribute.standard.OrientationRequested"));
                        if (object.equals(OrientationRequested.LANDSCAPE)) {
                            this.landscape.setSelected(true);
                        } else if (object.equals(OrientationRequested.PORTRAIT)) {
                            this.portrait.setSelected(true);
                        } else if (object.equals(OrientationRequested.REVERSE_PORTRAIT)) {
                            this.rev_portrait.setSelected(true);
                        } else {
                            this.rev_landscape.setSelected(true);
                        }
                    }
                } else {
                    this.portrait.setEnabled(false);
                    this.landscape.setEnabled(false);
                    this.rev_landscape.setEnabled(false);
                    this.rev_portrait.setEnabled(false);
                }
            }
        }
    }

    final class GeneralPanel
    extends JPanel {
        private /* synthetic */ PrinterDialog this$0;
        private PrintServices printserv_panel;
        private PrintRange printrange_panel;
        private CopiesAndSorted copies;

        static /* synthetic */ PrinterDialog access$5(GeneralPanel generalPanel, PrinterDialog printerDialog) {
            generalPanel.this$0 = printerDialog;
            return generalPanel.this$0;
        }

        static PrinterDialog access$0(GeneralPanel generalPanel) {
            return generalPanel.this$0;
        }

        public GeneralPanel(PrinterDialog printerDialog) {
            this.this$0 = printerDialog;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.printserv_panel = new PrintServices(this);
            this.printrange_panel = new PrintRange(this);
            this.copies = new CopiesAndSorted(this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jPanel.add(this.printrange_panel);
            jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel.add(this.copies);
            this.setLayout(new BoxLayout(this, 3));
            this.add(this.printserv_panel);
            this.add(Box.createRigidArea(new Dimension(0, 12)));
            this.add(jPanel);
        }

        void update() {
            this.printserv_panel.updateForSelectedService();
            this.printrange_panel.updateForSelectedService();
            this.copies.updateForSelectedService();
        }

        final class PrintServices
        extends JPanel
        implements ActionListener {
            private /* synthetic */ GeneralPanel this$1;
            private JLabel name = new JLabel(PrinterDialog.getLocalizedString("lb.name"));
            private JLabel status = new JLabel(PrinterDialog.getLocalizedString("lb.status"));
            private JLabel typ = new JLabel(PrinterDialog.getLocalizedString("lb.typ"));
            private JLabel info = new JLabel(PrinterDialog.getLocalizedString("lb.info"));
            private JLabel statusValue;
            private JLabel typValue = new JLabel();
            private JLabel infoValue = new JLabel();
            private JButton attributes;
            private JComboBox services_cob;
            private JCheckBox fileRedirection_cb;

            PrintServices(GeneralPanel generalPanel) {
                this.this$1 = generalPanel;
                this.statusValue = new JLabel();
                this.attributes = new JButton(PrinterDialog.getLocalizedString("bt.attributes"));
                this.attributes.setEnabled(false);
                this.attributes.setActionCommand("ATTRIBUTES");
                this.attributes.addActionListener(this);
                this.services_cob = new JComboBox(generalPanel.this$0.getPrintServices());
                this.services_cob.setActionCommand("SERVICE");
                this.services_cob.addActionListener(this);
                this.fileRedirection_cb = new JCheckBox(PrinterDialog.getLocalizedString("cb.output"));
                this.fileRedirection_cb.setEnabled(false);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.printservice")));
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.anchor = 22;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.name, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.status, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                this.add((Component)this.typ, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                this.add((Component)this.info, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.weightx = 1.0;
                this.add((Component)this.fileRedirection_cb, gridBagConstraints);
                gridBagConstraints.anchor = 21;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.5;
                this.add((Component)this.services_cob, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.weightx = 1.0;
                this.add((Component)this.statusValue, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.weightx = 1.0;
                this.add((Component)this.typValue, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.weightx = 1.0;
                this.add((Component)this.infoValue, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.5;
                this.add((Component)this.attributes, gridBagConstraints);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("SERVICE")) {
                    this.this$1.this$0.setSelectedPrintService((PrintService)this.services_cob.getSelectedItem());
                    this.this$1.this$0.updateAll();
                } else if (actionEvent.getActionCommand().equals("ATTRIBUTES")) {
                    // empty if block
                }
            }

            void updateForSelectedService() {
                PrinterMakeAndModel printerMakeAndModel = (PrinterMakeAndModel)this.this$1.this$0.getSelectedPrintService().getAttribute(PrinterDialog.class$("javax.print.attribute.standard.PrinterMakeAndModel"));
                this.typValue.setText(printerMakeAndModel == null ? "" : printerMakeAndModel.getValue());
                PrinterInfo printerInfo = (PrinterInfo)this.this$1.this$0.getSelectedPrintService().getAttribute(PrinterDialog.class$("javax.print.attribute.standard.PrinterInfo"));
                this.infoValue.setText(printerInfo == null ? "" : printerInfo.getValue());
                PrinterIsAcceptingJobs printerIsAcceptingJobs = (PrinterIsAcceptingJobs)this.this$1.this$0.getSelectedPrintService().getAttribute(PrinterDialog.class$("javax.print.attribute.standard.PrinterIsAcceptingJobs"));
                PrinterState printerState = (PrinterState)this.this$1.this$0.getSelectedPrintService().getAttribute(PrinterDialog.class$("javax.print.attribute.standard.PrinterState"));
                String string = printerState.toString();
                if (printerIsAcceptingJobs == PrinterIsAcceptingJobs.ACCEPTING_JOBS) {
                    string = string + new StringBuffer(" - ").append(PrinterDialog.getLocalizedString("lb.acceptingjobs"));
                } else if (printerIsAcceptingJobs == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
                    string = string + new StringBuffer(" - ").append(PrinterDialog.getLocalizedString("lb.notacceptingjobs"));
                }
                this.statusValue.setText(string);
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.Destination"))) {
                    this.fileRedirection_cb.setEnabled(false);
                }
            }
        }

        final class PrintRange
        extends JPanel
        implements ActionListener,
        FocusListener {
            private /* synthetic */ GeneralPanel this$1;
            private JLabel to = new JLabel(PrinterDialog.getLocalizedString("lb.to"));
            private JRadioButton all_rb;
            private JRadioButton pages_rb;
            private JTextField from_tf;
            private JTextField to_tf;

            PrintRange(GeneralPanel generalPanel) {
                this.this$1 = generalPanel;
                this.to.setEnabled(false);
                this.all_rb = new JRadioButton(PrinterDialog.getLocalizedString("rbt.all"));
                this.all_rb.setSelected(true);
                this.all_rb.setActionCommand("ALL");
                this.all_rb.addActionListener(this);
                this.pages_rb = new JRadioButton(PrinterDialog.getLocalizedString("rbt.pages"));
                this.pages_rb.setActionCommand("PAGES");
                this.pages_rb.setEnabled(false);
                this.pages_rb.addActionListener(this);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.all_rb);
                buttonGroup.add(this.pages_rb);
                this.from_tf = new JTextField("1", 4);
                this.from_tf.setEnabled(false);
                this.from_tf.addFocusListener(this);
                this.to_tf = new JTextField("1", 4);
                this.to_tf.setEnabled(false);
                this.to_tf.addFocusListener(this);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.printrange")));
                gridBagConstraints.insets = new Insets(15, 5, 5, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.all_rb, gridBagConstraints);
                gridBagConstraints.insets = new Insets(5, 5, 15, 5);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.pages_rb, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.from_tf, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.to, gridBagConstraints);
                gridBagConstraints.insets = new Insets(5, 5, 15, 15);
                gridBagConstraints.gridx = 3;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.to_tf, gridBagConstraints);
            }

            public void focusGained(FocusEvent focusEvent) {
                this.updatePageRanges();
            }

            public void focusLost(FocusEvent focusEvent) {
                this.updatePageRanges();
            }

            private void updatePageRanges() {
                int n;
                int n2 = Integer.parseInt(this.from_tf.getText());
                if (n2 > (n = Integer.parseInt(this.to_tf.getText()))) {
                    n = n2;
                    this.to_tf.setText("" + n2);
                }
                PageRanges pageRanges = new PageRanges(n2, n);
                GeneralPanel.access$0(this.this$1).atts.add(pageRanges);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ALL")) {
                    this.from_tf.setEnabled(false);
                    this.to.setEnabled(false);
                    this.to_tf.setEnabled(false);
                    GeneralPanel.access$0(this.this$1).atts.add(new PageRanges(1, Integer.MAX_VALUE));
                } else {
                    this.from_tf.setEnabled(true);
                    this.to.setEnabled(true);
                    this.to_tf.setEnabled(true);
                    this.all_rb.setSelected(false);
                }
            }

            void updateForSelectedService() {
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.PageRanges"))) {
                    this.pages_rb.setEnabled(true);
                    PageRanges pageRanges = (PageRanges)this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.PageRanges"));
                    if (pageRanges != null) {
                        this.from_tf.setEnabled(true);
                        this.to.setEnabled(true);
                        this.to_tf.setEnabled(true);
                        this.all_rb.setSelected(false);
                        this.pages_rb.setSelected(true);
                        int[][] nArray = pageRanges.getMembers();
                        this.from_tf.setText("" + nArray[0][0]);
                        this.to_tf.setText("" + nArray[0][1]);
                    }
                } else {
                    this.from_tf.setEnabled(false);
                    this.to.setEnabled(false);
                    this.to_tf.setEnabled(false);
                    this.all_rb.setSelected(true);
                }
            }
        }

        final class CopiesAndSorted
        extends JPanel
        implements ChangeListener,
        ActionListener {
            private /* synthetic */ GeneralPanel this$1;
            private JCheckBox sort;
            private JSpinner copies;
            private JLabel copies_lb = new JLabel(PrinterDialog.getLocalizedString("lb.copies"));
            private SpinnerNumberModel copiesModel;

            CopiesAndSorted(GeneralPanel generalPanel) {
                this.this$1 = generalPanel;
                this.sort = new JCheckBox(PrinterDialog.getLocalizedString("cb.sort"));
                this.sort.addActionListener(this);
                this.copiesModel = new SpinnerNumberModel(1, 1, 9999, 1);
                this.copies = new JSpinner(this.copiesModel);
                this.copies.addChangeListener(this);
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                this.setLayout(gridBagLayout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.copies")));
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.copies_lb, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 0;
                this.add((Component)this.copies, gridBagConstraints);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                this.add((Component)this.sort, gridBagConstraints);
            }

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (Integer)this.copies.getValue();
                GeneralPanel.access$0(this.this$1).atts.add(new Copies(n));
                if (n > 1 && this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.SheetCollate"))) {
                    this.sort.setEnabled(true);
                } else {
                    this.sort.setEnabled(false);
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (this.sort.isSelected()) {
                    GeneralPanel.access$0(this.this$1).atts.add(SheetCollate.COLLATED);
                }
            }

            void updateForSelectedService() {
                if (this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.Copies"))) {
                    this.copies.setEnabled(true);
                    this.copies_lb.setEnabled(true);
                    Copies copies = (Copies)this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.Copies"));
                    if (copies != null) {
                        this.copiesModel.setValue(new Integer(copies.getValue()));
                    }
                    if ((Integer)this.copiesModel.getValue() > 1 && this.this$1.this$0.categorySupported(PrinterDialog.class$("javax.print.attribute.standard.SheetCollate"))) {
                        this.sort.setEnabled(true);
                        Attribute attribute = this.this$1.this$0.attribute(PrinterDialog.class$("javax.print.attribute.standard.SheetCollate"));
                        if (attribute != null && attribute.equals(SheetCollate.COLLATED)) {
                            this.sort.setSelected(true);
                        }
                    } else {
                        this.sort.setEnabled(false);
                    }
                } else {
                    this.copies.setEnabled(false);
                    this.copies_lb.setEnabled(false);
                }
            }
        }
    }
}

