/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

final class Util {
    static final String HEX = "0123456789abcdef";

    private Util() {
    }

    static byte[] toByteArray(String string) {
        string = string.toLowerCase();
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(Character.digit(string.charAt(n++), 16) << 4) | (byte)Character.digit(string.charAt(n++), 16);
        }
        return byArray;
    }

    static String toHexString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(HEX.charAt(byArray[i + n] >>> 4 & 0xF));
            stringBuffer.append(HEX.charAt(byArray[i + n] & 0xF));
        }
        return stringBuffer.toString();
    }

    static String toHexString(byte[] byArray) {
        return Util.toHexString(byArray, 0, byArray.length);
    }

    static String toHexString(byte[] byArray, int n, int n2, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(HEX.charAt(byArray[i + n] >>> 4 & 0xF));
            stringBuffer.append(HEX.charAt(byArray[i + n] & 0xF));
            if (i >= n2 - 1) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String toHexString(byte[] byArray, char c) {
        return Util.toHexString(byArray, 0, byArray.length, c);
    }

    static String hexDump(byte[] byArray, int n, int n2, String string) {
        String string2 = Util.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; i += 16) {
            int n3;
            if (string != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(Util.formatInt(i + n, 16, 8));
            stringBuffer.append("  ");
            String string3 = Util.toHexString(byArray, i + n, Math.min(16, n2 - i), ' ');
            stringBuffer.append(string3);
            for (n3 = 56 - (56 - string3.length()); n3 < 56; ++n3) {
                stringBuffer.append(" ");
            }
            for (n3 = 0; n3 < Math.min(16, n2 - i); ++n3) {
                if ((byArray[i + n + n3] & 0xFF) < 32 || (byArray[i + n + n3] & 0xFF) > 126) {
                    stringBuffer.append('.');
                    continue;
                }
                stringBuffer.append((char)((char)byArray[i + n + n3] & 0xFF));
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    static String hexDump(byte[] byArray, int n, int n2) {
        return Util.hexDump(byArray, n, n2, "");
    }

    static String hexDump(byte[] byArray, String string) {
        return Util.hexDump(byArray, 0, byArray.length, string);
    }

    static String hexDump(byte[] byArray) {
        return Util.hexDump(byArray, 0, byArray.length);
    }

    static String formatInt(int n, int n2, int n3) {
        String string = Integer.toString(n, n2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n3 - string.length(); ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static byte[] trim(byte[] byArray, int n) {
        return Util.trim(byArray, 0, n);
    }

    static byte[] trim(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > byArray.length) {
            throw new IndexOutOfBoundsException("max=" + byArray.length + " off=" + n + " len=" + n2);
        }
        if (n == 0 && n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(n2, byArray.length - n));
        return byArray2;
    }

    static byte[] trim(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0 && !bigInteger.equals(BigInteger.ZERO)) {
            return Util.trim(byArray, 1, byArray.length - 1);
        }
        return byArray;
    }

    static int unixTime() {
        return (int)(System.currentTimeMillis() / (long)1000);
    }

    static Object[] transform(Object[] objectArray, Class clazz, String string, Object[] objectArray2) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        int n;
        if (objectArray2 == null) {
            objectArray2 = new Object[]{};
        }
        Object[] objectArray3 = (Object[])Array.newInstance(clazz, objectArray.length);
        Class[] classArray = new Class[objectArray2.length];
        for (n = 0; n < objectArray2.length; ++n) {
            classArray[n] = objectArray2[n].getClass();
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] == null) {
                objectArray3[n] = null;
                continue;
            }
            Class clazz2 = objectArray[n].getClass();
            Method method = clazz2.getMethod(string, classArray);
            Object object = method.invoke(objectArray[n], objectArray2);
            if (!clazz.isAssignableFrom(object.getClass())) {
                throw new ClassCastException();
            }
            objectArray3[n] = object;
        }
        return objectArray3;
    }

    static String getProperty(String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(null, string){
            private /* synthetic */ Util this$0;
            private /* synthetic */ String val$name;
            {
                this.this$0 = util;
                this.finit$(string);
            }

            private /* synthetic */ void finit$(String string) {
                this.val$name = string;
            }

            public Object run() {
                return System.getProperty(this.val$name);
            }
        });
    }

    static String getSecurityProperty(String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(null, string){
            private /* synthetic */ Util this$0;
            private /* synthetic */ String val$name;
            {
                this.this$0 = util;
                this.finit$(string);
            }

            private /* synthetic */ void finit$(String string) {
                this.val$name = string;
            }

            public Object run() {
                return Security.getProperty(this.val$name);
            }
        });
    }
}

