/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.SSLServerSocket;
import gnu.javax.net.ssl.provider.SessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    private final SessionContext sessions;
    private final X509KeyManager keyManager;
    private final X509TrustManager trustManager;
    private final SRPTrustManager srpTrustManager;
    private final SecureRandom random;

    SSLServerSocketFactory(X509TrustManager x509TrustManager, SRPTrustManager sRPTrustManager, X509KeyManager x509KeyManager, SecureRandom secureRandom, SessionContext sessionContext) {
        this.trustManager = x509TrustManager;
        this.srpTrustManager = sRPTrustManager;
        this.keyManager = x509KeyManager;
        this.random = secureRandom;
        this.sessions = sessionContext;
    }

    public String[] getDefaultCipherSuites() {
        return this.getSupportedCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket sSLServerSocket = new SSLServerSocket();
        this.setup(sSLServerSocket);
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        SSLServerSocket sSLServerSocket = new SSLServerSocket(n);
        this.setup(sSLServerSocket);
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        SSLServerSocket sSLServerSocket = new SSLServerSocket(n, n2);
        this.setup(sSLServerSocket);
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket = new SSLServerSocket(n, n2, inetAddress);
        this.setup(sSLServerSocket);
        return sSLServerSocket;
    }

    private void setup(SSLServerSocket sSLServerSocket) {
        sSLServerSocket.setSessionContext(this.sessions);
        sSLServerSocket.setKeyManager(this.keyManager);
        sSLServerSocket.setTrustManager(this.trustManager);
        sSLServerSocket.setSRPTrustManager(this.srpTrustManager);
        sSLServerSocket.setRandom(this.random);
    }
}

