/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;

public class PNGPhys
extends PNGChunk {
    long x;
    long y;
    double ratio;
    boolean usesRatio;

    protected PNGPhys(int n, byte[] byArray, int n2) throws PNGException {
        super(n, byArray, n2);
        if (byArray.length < 9) {
            throw new PNGException("Unexpected size of pHYS chunk.");
        }
        this.x = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        this.y = (byArray[4] & 0xFF) << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        if (byArray[8] == 0) {
            this.ratio = (double)this.x / (double)this.y;
            this.usesRatio = true;
        }
    }

    public PNGPhys(double d) {
        super(1883789683);
        this.ratio = d;
        this.usesRatio = true;
        if (d < 1.0) {
            this.y = -1;
            this.x = (long)(4.294967295E9 * d);
        } else {
            this.x = -1;
            this.y = (long)(4.294967295E9 * d);
        }
        this.makeData();
    }

    public PNGPhys(int n, int n2) {
        super(1883789683);
        this.usesRatio = false;
        this.x = n;
        this.y = n2;
        this.makeData();
    }

    private void makeData() {
        this.data = new byte[9];
        byte[] byArray = PNGChunk.getInt((int)this.x);
        byte[] byArray2 = PNGChunk.getInt((int)this.y);
        this.data[0] = byArray[0];
        this.data[1] = byArray[1];
        this.data[2] = byArray[2];
        this.data[3] = byArray[3];
        this.data[4] = byArray2[0];
        this.data[5] = byArray2[1];
        this.data[6] = byArray2[2];
        this.data[7] = byArray2[3];
        this.data[7] = this.usesRatio ? 0 : -1;
    }

    public String toString() {
        String string = "PNG Physical pixel size chunk.";
        if (this.usesRatio) {
            return string + " Aspect ratio (x/y): " + this.ratio;
        }
        return string + " " + this.x + " by " + this.y + " pixels per meter. (x, y).";
    }
}

