/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.hash.MD5;
import gnu.java.security.util.Util;
import gnu.javax.crypto.mac.BaseMac;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public class HMac
extends BaseMac
implements Cloneable {
    public static final String USE_WITH_PKCS5_V2 = "gnu.crypto.hmac.pkcs5";
    private static final byte IPAD_BYTE = 54;
    private static final byte OPAD_BYTE = 92;
    private static Boolean valid;
    protected int macSize;
    protected int blockSize;
    protected IMessageDigest ipadHash;
    protected IMessageDigest opadHash;
    protected byte[] ipad;

    protected HMac(IMessageDigest iMessageDigest) {
        super("hmac-" + iMessageDigest.name(), iMessageDigest);
        this.blockSize = iMessageDigest.blockSize();
        this.macSize = iMessageDigest.hashSize();
        this.opadHash = null;
        this.ipadHash = null;
    }

    public Object clone() throws CloneNotSupportedException {
        HMac hMac = (HMac)super.clone();
        if (this.ipadHash != null) {
            hMac.ipadHash = (IMessageDigest)this.ipadHash.clone();
        }
        if (this.opadHash != null) {
            hMac.opadHash = (IMessageDigest)this.opadHash.clone();
        }
        if (this.ipad != null) {
            hMac.ipad = (byte[])this.ipad.clone();
        }
        return hMac;
    }

    public void init(Map map) throws InvalidKeyException, IllegalStateException {
        int n;
        Integer n2 = (Integer)map.get("gnu.crypto.mac.truncated.size");
        int n3 = this.truncatedSize = n2 == null ? this.macSize : n2;
        if (this.truncatedSize < this.macSize / 2) {
            throw new IllegalArgumentException("Truncated size too small");
        }
        if (this.truncatedSize < 10) {
            throw new IllegalArgumentException("Truncated size less than 80 bits");
        }
        byte[] byArray = (byte[])map.get("gnu.crypto.mac.key.material");
        if (byArray == null) {
            if (this.ipadHash == null) {
                throw new InvalidKeyException("Null key");
            }
            this.underlyingHash = (IMessageDigest)this.ipadHash.clone();
            return;
        }
        Boolean bl = (Boolean)map.get(USE_WITH_PKCS5_V2);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        if (byArray.length < this.macSize && !bl.booleanValue()) {
            throw new InvalidKeyException("Key too short");
        }
        if (byArray.length > this.blockSize) {
            this.underlyingHash.update(byArray, 0, byArray.length);
            byArray = this.underlyingHash.digest();
        }
        if (byArray.length < this.blockSize) {
            n = byArray.length > this.blockSize ? this.blockSize : byArray.length;
            byte[] byArray2 = new byte[this.blockSize];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        this.underlyingHash.reset();
        this.opadHash = (IMessageDigest)this.underlyingHash.clone();
        if (this.ipad == null) {
            this.ipad = new byte[this.blockSize];
        }
        for (n = 0; n < this.blockSize; ++n) {
            this.ipad[n] = byArray[n] ^ 0x36;
        }
        for (n = 0; n < this.blockSize; ++n) {
            this.opadHash.update((byte)(byArray[n] ^ 0x5C));
        }
        this.underlyingHash.update(this.ipad, 0, this.blockSize);
        this.ipadHash = (IMessageDigest)this.underlyingHash.clone();
        byArray = null;
    }

    public void reset() {
        super.reset();
        if (this.ipad != null) {
            this.underlyingHash.update(this.ipad, 0, this.blockSize);
            this.ipadHash = (IMessageDigest)this.underlyingHash.clone();
        }
    }

    public byte[] digest() {
        if (this.ipadHash == null) {
            throw new IllegalStateException("HMAC not initialised");
        }
        byte[] byArray = this.underlyingHash.digest();
        this.underlyingHash = (IMessageDigest)this.opadHash.clone();
        this.underlyingHash.update(byArray, 0, this.macSize);
        byArray = this.underlyingHash.digest();
        if (this.truncatedSize == this.macSize) {
            return byArray;
        }
        byte[] byArray2 = new byte[this.truncatedSize];
        System.arraycopy(byArray, 0, byArray2, 0, this.truncatedSize);
        return byArray2;
    }

    public boolean selfTest() {
        if (valid == null) {
            try {
                HMac hMac = new HMac(new MD5());
                String string = "9294727A3638BB1C13F48EF8158BFC9D";
                String string2 = "56BE34521D144C88DBB8C733F0E8B3F6";
                byte[] byArray = new byte[]{11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11};
                byte[] byArray2 = new byte[]{-86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86, -86};
                byte[] byArray3 = new byte[50];
                int n = 0;
                while (n < 50) {
                    byArray3[n++] = -35;
                }
                HashMap hashMap = new HashMap();
                hashMap.put("gnu.crypto.mac.key.material", byArray);
                hMac.init(hashMap);
                hMac.update("Hi There".getBytes("ASCII"), 0, 8);
                if (!string.equals(Util.toString(hMac.digest()))) {
                    valid = Boolean.FALSE;
                }
                hashMap.put("gnu.crypto.mac.key.material", byArray2);
                hMac.init(hashMap);
                hMac.update(byArray3, 0, 50);
                if (!string2.equals(Util.toString(hMac.digest()))) {
                    valid = Boolean.FALSE;
                }
                valid = Boolean.TRUE;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                valid = Boolean.FALSE;
            }
        }
        return valid;
    }
}

