/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.util.PRNG;
import java.io.ByteArrayOutputStream;
import java.security.interfaces.RSAKey;
import java.util.Random;

public class EME_PKCS1_V1_5 {
    private int k;
    private ByteArrayOutputStream baos;
    private PRNG prng;

    private /* synthetic */ void finit$() {
        this.baos = new ByteArrayOutputStream();
        this.prng = PRNG.getInstance();
    }

    private EME_PKCS1_V1_5(int n) {
        this.finit$();
        this.k = n;
    }

    public static final EME_PKCS1_V1_5 getInstance(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("k must be a positive integer");
        }
        return new EME_PKCS1_V1_5(n);
    }

    public static final EME_PKCS1_V1_5 getInstance(RSAKey rSAKey) {
        int n = rSAKey.getModulus().bitLength();
        int n2 = (n + 7) / 8;
        return EME_PKCS1_V1_5.getInstance(n2);
    }

    public byte[] encode(byte[] byArray) {
        byte[] byArray2 = new byte[this.k - byArray.length - 3];
        this.prng.nextBytes(byArray2);
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] != 0) continue;
            byArray2[i] = 1;
        }
        return this.assembleEM(byArray2, byArray);
    }

    public byte[] encode(byte[] byArray, IRandom iRandom) {
        byte[] byArray2 = new byte[this.k - byArray.length - 3];
        try {
            iRandom.nextBytes(byArray2, 0, byArray2.length);
            int n = 0;
            while (n < byArray2.length) {
                if (byArray2[n] == 0) {
                    System.arraycopy(byArray2, n + 1, byArray2, n, byArray2.length - n - 1);
                    iRandom.nextBytes(byArray2, byArray2.length - 1, 1);
                    continue;
                }
                ++n;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException("encode(): " + String.valueOf(illegalStateException));
        }
        catch (LimitReachedException limitReachedException) {
            throw new RuntimeException("encode(): " + String.valueOf(limitReachedException));
        }
        return this.assembleEM(byArray2, byArray);
    }

    public byte[] encode(byte[] byArray, Random random) {
        byte[] byArray2 = new byte[this.k - byArray.length - 3];
        random.nextBytes(byArray2);
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] == 0) {
                System.arraycopy(byArray2, n + 1, byArray2, n, byArray2.length - n - 1);
                byArray2[byArray2.length - 1] = (byte)random.nextInt();
                continue;
            }
            ++n;
        }
        return this.assembleEM(byArray2, byArray);
    }

    public byte[] decode(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        if (n2 != this.k) {
            throw new IllegalArgumentException("decryption error");
        }
        if (byArray[0] != 0) {
            throw new IllegalArgumentException("decryption error");
        }
        if (byArray[1] != 2) {
            throw new IllegalArgumentException("decryption error");
        }
        for (n = 2; n < n2 && byArray[n] != 0; ++n) {
        }
        if (n >= n2 || n < 11) {
            throw new IllegalArgumentException("decryption error");
        }
        byte[] byArray2 = new byte[n2 - ++n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private byte[] assembleEM(byte[] byArray, byte[] byArray2) {
        this.baos.reset();
        this.baos.write(0);
        this.baos.write(2);
        this.baos.write(byArray, 0, byArray.length);
        this.baos.write(0);
        this.baos.write(byArray2, 0, byArray2.length);
        byte[] byArray3 = this.baos.toByteArray();
        this.baos.reset();
        return byArray3;
    }
}

