/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.prng;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import java.util.Map;

public abstract class BasePRNG
implements IRandom {
    protected String name;
    protected boolean initialised;
    protected byte[] buffer;
    protected int ndx;

    protected BasePRNG(String string) {
        this.name = string;
        this.initialised = false;
        this.buffer = new byte[0];
    }

    public String name() {
        return this.name;
    }

    public void init(Map map) {
        this.setup(map);
        this.ndx = 0;
        this.initialised = true;
    }

    public byte nextByte() throws IllegalStateException, LimitReachedException {
        if (!this.initialised) {
            throw new IllegalStateException();
        }
        return this.nextByteInternal();
    }

    public void nextBytes(byte[] byArray) throws IllegalStateException, LimitReachedException {
        this.nextBytes(byArray, 0, byArray.length);
    }

    public void nextBytes(byte[] byArray, int n, int n2) throws IllegalStateException, LimitReachedException {
        if (!this.initialised) {
            throw new IllegalStateException("not initialized");
        }
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("offset=" + n + " length=" + n2 + " limit=" + byArray.length);
        }
        if (this.ndx >= this.buffer.length) {
            this.fillBlock();
            this.ndx = 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Math.min(this.buffer.length - this.ndx, n2 - n3);
            System.arraycopy(this.buffer, this.ndx, byArray, n + n3, n4);
            n3 += n4;
            this.ndx += n4;
            if (this.ndx < this.buffer.length) continue;
            this.fillBlock();
            this.ndx = 0;
        }
    }

    public void addRandomByte(byte by) {
        throw new UnsupportedOperationException("random state is non-modifiable");
    }

    public void addRandomBytes(byte[] byArray) {
        this.addRandomBytes(byArray, 0, byArray.length);
    }

    public void addRandomBytes(byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException("random state is non-modifiable");
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    private byte nextByteInternal() throws LimitReachedException {
        if (this.ndx >= this.buffer.length) {
            this.fillBlock();
            this.ndx = 0;
        }
        return this.buffer[this.ndx++];
    }

    public Object clone() throws CloneNotSupportedException {
        BasePRNG basePRNG = (BasePRNG)super.clone();
        if (this.buffer != null) {
            basePRNG.buffer = (byte[])this.buffer.clone();
        }
        return basePRNG;
    }

    public abstract void setup(Map var1);

    public abstract void fillBlock() throws LimitReachedException;
}

