/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Enumeration;

public final class Engine {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static final int MAX_ALIASES = 5;
    private static final Object[] NO_ARGS;

    private Engine() {
    }

    public static Object getInstance(String string, String string2, Provider provider) throws InvocationTargetException, NoSuchAlgorithmException {
        return Engine.getInstance(string, string2, provider, NO_ARGS);
    }

    public static Object getInstance(String string, String string2, Provider provider, Object[] objectArray) throws InvocationTargetException, NoSuchAlgorithmException {
        if (string != null) {
            string = string.trim();
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || provider == null || objectArray == null) {
            throw new IllegalArgumentException();
        }
        Enumeration enumeration = provider.propertyNames();
        int n = 0;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            String string3;
            String string4 = (String)enumeration.nextElement();
            if (string4.equalsIgnoreCase(string + "." + string2)) {
                string2 = string4.substring(string.length() + 1);
                bl = true;
                break;
            }
            if (!string4.equalsIgnoreCase(ALG_ALIAS + string + "." + string2) || string2.equalsIgnoreCase(string3 = provider.getProperty(string4))) continue;
            string2 = string3;
            if (n++ > 5) {
                throw new NoSuchAlgorithmException("too many aliases");
            }
            enumeration = provider.propertyNames();
        }
        if (!bl) {
            throw new NoSuchAlgorithmException(string2);
        }
        Class clazz = null;
        ClassLoader classLoader = provider.getClass().getClassLoader();
        Constructor constructor = null;
        String string5 = string2;
        try {
            clazz = classLoader != null ? classLoader.loadClass(provider.getProperty(string + "." + string2)) : Class.forName(provider.getProperty(string + "." + string2));
            constructor = Engine.getCompatibleConstructor(clazz, objectArray);
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            string5 = "class not found: " + string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            string5 = "illegal access: " + illegalAccessException.getMessage();
        }
        catch (InstantiationException instantiationException) {
            string5 = "instantiation exception: " + instantiationException.getMessage();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            string5 = "exception in initializer: " + exceptionInInitializerError.getMessage();
        }
        catch (SecurityException securityException) {
            string5 = "security exception: " + securityException.getMessage();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string5 = "no appropriate constructor found";
        }
        throw new NoSuchAlgorithmException(string5);
    }

    private static Constructor getCompatibleConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException {
        Constructor[] constructorArray = clazz.getConstructors();
        block0: for (int i = 0; i < constructorArray.length; ++i) {
            Class[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != objectArray.length) continue;
            for (int j = 0; j < classArray.length; ++j) {
                if (objectArray[j] != null && !classArray[j].isAssignableFrom(objectArray[j].getClass())) continue block0;
            }
            return constructorArray[i];
        }
        throw new NoSuchMethodException();
    }

    static {
        ALG_ALIAS = ALG_ALIAS;
        NO_ARGS = new Object[0];
    }
}

